* Program ....: MEMOCFG.Prg
* Author .....: Brad Choate
* Date .......: 8/4/1990
* Purpose ....: Shows how to "reconfigure" ANY key in a MEMOEDIT() .AND.
* ............: also demonstrates how to make a MEMOEDIT() look like a big
* ............: GET field.

crlf      = CHR(13)+CHR(10)
field1    = "Field Info 1"
field2    = "Field 2"
field3    = 56.23
field4    = CTOD("07/21/72")
testmemo  = "This is a test."+crlf+"This is only a test.  Please remain calm."

mfield1   = field1
mfield2   = field2
mfield3   = field3
mfield4   = field4
mtestmemo = testmemo

CLEAR SCREEN
SET SCOREBOARD OFF

@  0, 0 say "Test Editing Session:"
@  1, 0 say "Hit Esc to abort, CTRL+W to save..."
@  5, 1 say "Field 1:"
@  6, 1 say "Field 2:"
@  7, 1 say "Field 3:"
@  8, 1 say "Field 4:"
@ 10, 4 say "Memo:"

mcexit    = .F.
DO WHILE !mcexit
   mcexit    = .T.
   @  5,10 GET mfield1 PICTURE "@!"
   @  6,10 GET mfield2 PICTURE "@X"
   @  7,10 GET mfield3 PICTURE "9999.99"
   @  8,10 GET mfield4 PICTURE "99/99/99"

   SETCOLOR("n/w")
   * this makes the MEMO look like a GET field.

   MEMOEDIT(mtestmemo,10,10,17,60,.F.,.F.)
   SETCOLOR("")

   SET KEY 24 TO fakedown
   * necessary to exit last GET and enter MEMO.

   READ

   SET KEY 24 TO
   IF LASTKEY()=27 .OR. LASTKEY()=23
      * if any exit key was pressed,
      * skip the MEMOEDIT() "GET"
      EXIT
   ENDIF
   _recfgkey = 0

   SET KEY 5 TO refigkey
   * set UP ARROW for reconfiguration

   SETCOLOR("n/w")
   mtestmemo=MEMOEDIT(mtestmemo,10,10,17,60,.T.,"memoctrl")
   SETCOLOR("")
   SET KEY 5 TO
   IF !mcexit                         && if we are to loop, then position
      KEYBOARD REPLICATE(CHR(13),3)   && user on the get field right above
   ENDIF                              && the memofield ...
ENDDO

IF LASTKEY()#27
   field1    = mfield1
   field2    = mfield2
   field3    = mfield3
   field4    = mfield4
   testmemo  = mtestmemo
ENDIF

CLEAR SCREEN

@  0, 0 SAY "And the results are..."

@  5, 1 say "Field 1:"
@  6, 1 say "Field 2:"
@  7, 1 say "Field 3:"
@  8, 1 say "Field 4:"
@ 10, 4 say "Memo:"

@  5,10 SAY field1 PICTURE "@!"
@  6,10 SAY field2 PICTURE "@X"
@  7,10 SAY field3 PICTURE "9999.99"
@  8,10 SAY field4 PICTURE "99/99/99"

MEMOEDIT(testmemo,10,10,17,60,.F.,.F.)

@ 20, 0 say ""

RETURN

***************************************************************************

PROCEDURE refigkey
*  sets the reconfigure key variable for checking in the MEMOEDIT() UDF

_recfgkey = LASTKEY()
KEYBOARD CHR(23)
RETURN

***************************************************************************

PROCEDURE fakedown
*  makes the ARROW DOWN key act like an Enter so we can get into the
*  MEMO field using the arrow keys.

KEYBOARD CHR(13)
RETURN

***************************************************************************

FUNCTION memoctrl

PARAMETERS mcmode, mcline, mccol

mckey     = LASTKEY()
mcretval  = 0

IF _recfgkey#0
   DO CASE
   CASE _recfgkey=5
      @ 23, 0 SAY "You hit an `unconfigurable' re-configured key!"
      IF mcline = 1
         mcexit    = .F.
         RETURN(23)
      ENDIF
   *** other CASEs can be added to reconfigure several keys at once.
   ENDCASE
   mcretval  = _recfgkey
   _recfgkey = 0
ELSE
   @ 23, 0 CLEAR
ENDIF
@ 24, 0 SAY "Inkey Value: "+STR(IIF(mcretval#0,mcretval,mckey),3)

RETURN(mcretval)

* EOF: MEMOCFG.Prg
