*:*********************************************************************
*:
*:        Program: MEMODEMO.PRG
*:
*:         System: Memoedit Functions Demonstration
*:         Author: Don Caton
*:      Copyright (c) 1990, DC MicroSystems, Inc.
*:  Last modified: 01/17/90      0:06
*:
*:  Procs & Fncts: UDF
*:
*:          Calls: ME_MAXCHAR()   (function  in ME_FUNC.OBJ)
*:               : ME_INITBUF()   (function  in ME_FUNC.OBJ)
*:               : UDF            (procedure in MEMODEMO.PRG, called from MemoEdit())
*:
*:      Documented 01/17/90 at 04:16                SNAP!  version 4.00
*:*********************************************************************
CLEAR
SET SCOREBOARD OFF
memo = "This is a sample memo."
initbufr = 0
maxmemo = 0
noenter = .F.
@ 0,0 SAY "Memoedit Functions Demonstration"
@ 1,0 TO 1,31
@ 3,0 SAY "Initial memoedit buffer size:" GET initbufr PICTURE "99999"
@ 3,COL() SAY " bytes"
@ 5,10 SAY "Enter 0 to allow MEMOEDIT() to allocate its default buffer"
@ 6,10 SAY "size of 512 bytes + the length of the memo to be edited."
@ 9,0 SAY "Limit memo to:" GET maxmemo PICTURE "99999" RANGE 0, 65535
@ 9,COL() SAY " characters"
@ 11,10 SAY "Enter 0 to allow MEMOEDIT()'s maximum memo size (65535)."
@ 12,10 SAY "If you linked this demo with ME_DEMO.OBJ, this value is"
@ 13,10 SAY "limited to a maximum of 500."
READ
IF LASTKEY() = 27
   CLEAR
   QUIT
ENDIF
me_maxchar(maxmemo)       && set maximum memo length
me_initbuf(initbufr)      && set initial memoedit buffer size
CLEAR
@ 0,0 TO 10,79
SET COLOR TO n/w
@ 0,1 CLEAR TO 0,78
@ 0,1 SAY " Row:       Column:       Memo Size:       Overwrite  ^W-Save   Esc-Exit "
SET COLOR TO w/n
@ 14,0 TO 14,79
@ 15,8 SAY "Maximum memo length:"
@ 15,29 SAY me_maxchar() PICTURE "@b 99999"
@ 16,8 SAY "Current buffer size:"
@ 17,8 SAY "Character at cursor:"
@ 18,8 SAY "Total lines in memo:"
@ 19,3 SAY "Row offset within window:"
@ 20,0 SAY "Column offset within window"
@ 21,0 SAY "Cursor position within memo:"
memo = MEMOEDIT(MEMO,2,2,9,77,.T.,"udf",100)
@ 12,0 CLEAR TO 12,79
SET COLOR TO w+/n
@ 12,0 SAY "Memoedit returned " + LTRIM(STR(LEN(memo))) + " bytes."
@ 23,0
SET COLOR TO
QUIT

*!*********************************************************************
*!
*!      Procedure: UDF
*!
*!      Called by: MEMODEMO.PRG
*!
*!          Calls: ME_LEN()       (function  in ME_FUNC.OBJ)
*!               : ME_MAXCHAR()   (function  in ME_FUNC.OBJ)
*!               : ME_MOREUP()    (function  in ME_FUNC.OBJ)
*!               : ME_MOREDN()    (function  in ME_FUNC.OBJ)
*!               : ME_MORELE()    (function  in ME_FUNC.OBJ)
*!               : ME_MORERI()    (function  in ME_FUNC.OBJ)
*!               : ME_BUFSIZE()   (function  in ME_FUNC.OBJ)
*!               : ME_CURCHAR()   (function  in ME_FUNC.OBJ)
*!               : ME_LINES()     (function  in ME_FUNC.OBJ)
*!               : ME_ROFFSET()   (function  in ME_FUNC.OBJ)
*!               : ME_COFFSET()   (function  in ME_FUNC.OBJ)
*!               : ME_CURPOS()    (function  in ME_FUNC.OBJ)
*!               : ME_UPDATED()   (function  in ME_FUNC.OBJ)
*!
*!*********************************************************************
FUNCTION udf
PARAMETERS status, line, col
keypress = LASTKEY()
memolen = me_len()
maximum = me_maxchar()
ret_val = 0
DO CASE
CASE status = 0            && idle
   @ 2,0 TO 9,0
   @ 10,1 TO 10,78
   SET COLOR TO w+/n
   @ 2,0 SAY IIF(me_moreup(),CHR(30),"")
   @ 9,0 SAY IIF(me_moredn(),CHR(31),"")
   @ 10,1 SAY IIF(me_morele(),CHR(17),"")
   @ 10,78 SAY IIF(me_moreri(),CHR(16),"")
   IF memolen = maximum
      @ 12,0 SAY "You have reached the maximum limit of " + LTRIM(STR(maximum)) + " characters             "
   ELSEIF (memolen / maximum) > .75
      @ 12,0 SAY "Warning - you are approaching the maximum limit of " + LTRIM(STR(maximum)) + " characters"
   ELSE
      @ 12,0 CLEAR TO 12,79
   ENDIF
   SET COLOR TO n/w
   @ 0,7 SAY line PICTURE "@b 9999"
   @ 0,22 SAY col PICTURE "@b 9999"
   @ 0,40 SAY me_len() PICTURE "@b 9999"
   SET COLOR TO w/n
   @ 16,29 SAY me_bufsize() PICTURE "@b 99999"
   @ 17,29 SAY me_curchar()
   @ 18,29 SAY me_lines() PICTURE "@b 99999"
   @ 19,29 SAY me_roffset() PICTURE "@b 99999"
   @ 20,29 SAY me_coffset() PICTURE "@b 99999"
   @ 21,29 SAY me_curpos() PICTURE "@b 99999"
CASE status = 1 .OR. status = 2
   DO CASE
   CASE keypress = 22       && insert key
      SET COLOR TO n/w
      @ 0,47 SAY IIF(READINSERT(),"Overwrite","Insert   ")
      *                    ^----------^----------^
      * must be reversed since insert mode is not toggled until after udf returns
      SET COLOR TO w/n
   CASE keypress = 280      && ALT-O (overflow)
      * any keystroke that would lengthen the memo string past the limit set by
      * me_maxchar() will cause the keystroke to be replaced with an ALT-O
      ?? CHR(7)
      CLEAR TYPEAHEAD   && kill repetetive beeping
   CASE keypress = 27
      savescrn = SAVESCREEN(12,0,12,79)
      SET COLOR TO w+/n
      x = "R"
      @ 12,0 CLEAR TO 12,79
      IF me_updated()       && .T. if memo was altered
         @ 12,5 SAY "Warning - changes made will be lost. Exit or resume editing? (e/r): "
      ELSE
         @ 12,24 SAY "Exit or resume editing (e/r): "
      ENDIF
      @ 12,COL() GET x PICTURE "!" VALID x $ "ER"
      READ
      IF x = "R"
         ret_val = 32
         RESTSCREEN(12,0,12,79,savescrn)
      ENDIF
      SET COLOR TO w/n
   CASE keypress = 23
      savescrn = SAVESCREEN(12,0,12,79)
      SET COLOR TO w+/n
      x = "R"
      @ 12,0 CLEAR TO 12,79
      @ 12,20 SAY "Save and exit or resume editing (s/r):" GET x PICTURE "!" VALID x $"SR"
      READ
      IF x = "R"
         ret_val = 32
         RESTSCREEN(12,0,12,79,savescrn)
      ENDIF
      SET COLOR TO w/n
   ENDCASE
ENDCASE
RETURN ret_val

*: EOF: MEMODEMO.PRG
