*** For Clipper
******************************************************************************
* Program..........: ME3.PRG                                                 *
* Author...........: Bruce B. Wilson (Probe Computer Systems) (404) 933-5377 *
* Original source..: Memo editor by Bill Osolinski                           *
* Purpose..........: This routine utilizes the memoedit() function along     *
*                    with a udf to edit text files.                          *
* Date Created.....: 05/23/89                                                *
* Last Update......: 07/25/89                                                *
******************************************************************************

********************************************************************
* Note: top, left, bottom, right parameters position edit window   *
*       If not passed, window defaults to entire screen            *
*       Be sure not to include commas if calling from command line *
********************************************************************

parameters top, left, bottom, right

**********************************
* Initialize working environment *
**********************************

save screen to init       && save initial screen
old_color = setcolor()    && save current color
set color to              && reset color for monochrome screens
set confirm on            && require carriage return on gets
set cursor on             && make sure cursor is on
set key 28 to             && disable help
set exact  on             && used in search functions
set escape on             && make sure user can terminate reads
set scoreboard off        && utilize top row of screen

*******************************
* Initialize editor variables *
*******************************

if pcount() <> 4                              && check for four parameters
   store 0 to top, left, bottom, right        && if not there, initialize
else
   top = val(top)                             && if there, they are string!
   left = val(left)                           && so make them numeric
   bottom = val(bottom)
   right = val(right)
endif
if top >= bottom -1 .or. left >= right -6 .or.;   && error check params
            top < 0 .or. top > 21 .or.;        && if in error, reset to default
           left < 0 .or. left > 79 .or.;
         bottom < 0 .or. bottom > 23 .or.;
          right < 0 .or. right > 79
   top    = 0                 && top row of editor box
   left   = 0                 && left column of editor box
   bottom = 23                && bottom row of editor box
   right  = 79                && right column of editor box
endif
filename = space(8)           && name of current file being edited
text_str = ""                 && holds file in string form
line_length = right - left -2 && length of editor line passed to memoedit()
tab_size = 4                  && length of tab (default) passed to memoedit()
start_row = 1                 && starting row number of file to be displayed
start_col = 0                 && starting col number of file to be displayed
rel_row = 0                   && row to place cursor relative to editor box
rel_col = 0                   && col to place cursor relative to editor box
word_wrap = .T.               && flags word wrap on/off (default is on)
scrl_on = .F.                 && flags scroll on/off (default is off)
ed_key = 0                    && number of memoedit() terminating key
help_str = loadhelp()         && load help screens into string
date_row = 0                  && row to display date at (independent)
date_col = 61                 && col to display date at (independent)
finished = .F.                && flags when user wants to quit editing

do while !finished            && main loop of editor

   ***********************************
   * clear and repaint editor screen *
   ***********************************

   if iscolor()
      set color to w+/n
      @ top,left clear to bottom,right
      @ top,left to bottom,right
      set color to w/n
      @ date_row,date_col say date()
      @ 24,0
      set color to w+/g
      @ 24,64 say "F1-Help Esc-Exit"
      set color to w+/b,w+/g
   else
      @ top,left clear to bottom,right
      @ top,left to bottom,right
      @ date_row,date_col say date()
      @ 24,0
      @ 24,64 say "F1-Help Esc-Exit"
   endif

   ****************************
   * edit file via memoedit() *
   ****************************

   text_str = memoedit(text_str, top +1, left +1, bottom -1, right -1,;
                       .T., "edfunc", line_length, tab_size,;
                        start_row, start_col, rel_row, rel_col)

   ***********************************************************
   * Process memoedit() terminating key returned from edfunc *
   * note: editing was terminated by the user                *
   *       or command not possible inside of memoedit()      *
   ***********************************************************

   do case
     case ed_key = -1 .or. ed_key = 23 .or. ed_key = 27
       do save_file                       && F2, Ctrl-W, Esc save with exit
       @ 24,0  clear to 24,62             && ask user to exit or not
       @ 24,0  say "Exit? (Y/N)"
       choice = "N"
       @ 24,12 get m->choice picture "!" valid choice $ "YN"
       read
       if choice = "Y"
          finished = .T.
       endif
     case ed_key = -2                     && F3 save without exit
       do save_file
     case ed_key = -3                     && F4 load file from list
       if adir("*.TXT") = 0               && make sure text files exist
          @ 24,0  clear to 24,62
          @ 24,0  say "No text files to load! Hit any key"
          beep()
          inkey(0)
          loop
       endif
       save screen

       ********************************************************************
       * declare and fill arrays with file names, sizes, dates, and times *
       ********************************************************************

       matches = adir("*.TXT")
       declare names[matches]
       declare sizes[matches]
       declare dates[matches]
       declare times[matches]
       declare choices[matches]
       adir("*.txt",names,sizes,dates,times)
       for x = 1 to matches
         choices[x] = left(names[x] + space(12),12) + space(2) +;
                      str(sizes[x],9) + space(2) + dtoc(dates[x]) +;
                      space(2) + times[x]
         next

       ****************************************
       * display files and have user pick one *
       ****************************************

       @ 24,0  clear to 24,62
       @ 24,0  say "Use arrow keys and select file with <Enter>"
       if iscolor()
           set color to w+/r,w+/b
       endif
       store 1 + adir("*.txt") to bot
       bot = if(bot > 23,23,bot)
       @  0,13 clear to bot,60
       @  0,13 to bot,60
       key_char = achoice(1,15,22,58,choices,"","AFUNC")

       **************************************************
       * if user picked a file, read file into text_str *
       **************************************************

       if key_char > 0
          text_str = text_str + memoread(names[key_char])
          filename = trim(names[key_char])
       endif
       restore screen
     case ed_key = -4                     && F5 print file
       @ 24,0  clear to 24,62
       @ 24,0  say "Number of copies to print?"
       store 1 to copys
       @ 24,27 get m->copys picture "999" valid copys >= 0
       read

       ********************************************
       * loop if Esc or 0 copys are to be printed *
       ********************************************

       if lastkey() = 27 .or. copys = 0
          loop
       endif

       ********************************
       * make sure printer is on-line *
       ********************************

       do while !isprinter() .and. lastkey() <> 27
          @ 24,0  SAY "Printer not ready! Correct and hit any key, Esc to cancel"
          beep()
          inkey(0)
       enddo
       if lastkey() = 27
          loop
       endif
       @ 24,0  clear to 24,62
       @ 24,0  say "Printing..."
       set cursor off
       set console off
       set print on
       num_lines = mlcount(text_str,line_length)
       do while copys > 0 .and. lastkey() <> 27
          for x = 1 to num_lines
            ? memoline(text_STR,line_length,x)
          next
          eject
          copys = copys - 1
          inkey()
       enddo
       set print off
       set console on
       set cursor on
      case ed_key = -5          && F6 clear current file from word processor
        @ 24,0  clear to 24,62
        @ 24,0  say "Warning: All changes will be lost! Proceed? (Y/N)"
        beep()
        store "N" to clr
        @ 24,50 get m->clr picture "!" valid clr $ "YN"
        read
        if clr = "Y"
           text_str = ""        && clear work file string
        endif
     case ed_key = -6                     && F7 Search for text
       @ 24,0  clear to 24,62
       search_str = space(30)
       @ 24,0  say "Enter string to search for:"
       @ 24,33 get m->search_str
       read
       if empty(search_str)               && check for blank string entered
          loop
       endif
       pos = at(trim(search_str),text_str)
       if pos = 0                         && if string not found, loop
          @ 24,0  clear to 24,62
          @ 24,0  say "Search string not found! Hit any key "
          beep()
          inkey(0)
          loop
       endif
       start_row = mlcount(substr(text_str, 1, pos))
       start_col = at(trim(search_str),;
                      memoline(text_str, line_length, start_row)) -1
       rel_col = start_col
                           * put editing row in middle of box
       rel_high = int((bottom - top -1) /2)
       rel_row = if(start_row <= rel_high, start_row, rel_high)
     case ed_key = -7                     && F8 Search and replace text
       @ 24,0  clear to 24,62
       search_str = space(30)
       repl_str = space(30)
       @ 24,0  say "Enter string to search for:"
       @ 24,33 get m->search_str
       read
       if empty(search_str)               && check for blank string entered
          loop
       endif
       @ 24,0  clear to 24,62
       @ 24,0  say "Enter string to replace with:"
       @ 24,33 get m->repl_str
       read
       if lastkey() = 27
          loop
       endif
       @ 24,0  clear to 24,62
       @ 24,0  say "OK to proceed? (Y/N)"
       choice = "Y"
       @ 24,21 get m->choice picture "!" valid choice $ "YN"
       read

       ********************************************************
       * perform search and replace option if user desires to *
       ********************************************************

       if lastkey() <> 27 .and. choice = "Y"
          text_str = strtran(text_str, trim(search_str), trim(repl_str))
       endif
     case ed_key = -14                    && Shift + F5 Set horizontal margins
       @ 24,0  clear to 24,62
       @ 24,0  say "Enter left margin:     Right margin:"
       new_left  = left +1
       new_right = right +1
       @ 24,19 get m->new_left  picture "99" range 1,73
       @ 24,37 get m->new_right picture "99" range 8,80
       read
       if lastkey() <> 27 .and. new_left < new_right -6
          left  = new_left -1
          right = new_right -1
          line_length = right - left -2
          restore screen from init      && redisplay initial screen
       endif
     case ed_key = -15                  && Shift + F6 Set vertical margins
       @ 24,0  clear to 24,62
       @ 24,0  say "Enter top line:     Bottom line:"
       new_top    = top +1
       new_bottom = bottom +1
       @ 24,16 get m->new_top    picture "99" range 1,22
       @ 24,32 get m->new_bottom picture "99" range 3,24
       read
       if lastkey() <> 27 .and. new_top < new_bottom -1
          top    = new_top -1
          bottom = new_bottom -1
          restore screen from init      && redisplay initial screen
       endif
     case ed_key = -16                  && Shift + F7 Modify current tab length
       @ 24,0  clear to 24,62
       @ 24,0  say "Enter tab length:"
       new_tab = tab_size
       @ 24,18 get m->new_tab picture "99" range 1,40
       read
       if lastkey() <> 27
          tab_size = new_tab
       endif
     case ed_key = -19                  && Shift + F10 operating ststem
       save screen
       clear
       @  0,0  say "Type EXIT to return..."
       run command.com
       restore screen
   endcase
enddo

***************************************
* restore initial working environment *
***************************************

setcolor(old_color)       && restore origional color
set key 28 to help        && reenable help
restore screen from init  && restore initial screen
return

function edfunc

*****************************************************************
* Called to process keystrokes from within memoedit()           *
* note: mode parameter can contain one of four possible values: *
*       0 - memoedit() is idle                                  *
*       1 - keystroke exception, data unchanged                 *
*       2 - keystroke exception, data changed                   *
*       3 - memoedit() has just been invoked                    *
* note: cur_row parameter contains the file's current row       *
* note: cur_col parameter contains the file's current col       *
*****************************************************************

parameters mode, cur_row, cur_col
do case
  case mode = 0                 && memoedit() is idle

    ******************************************
    * display current row and column numbers *
    ******************************************

    set cursor off
    @ 24,26 say str(cur_row,4)
    @ 24,36 say str(cur_col,2)
    set cursor on
    ret_val = 0
  case mode = 1 .or. mode = 2   && keystroke exception, data unchanged/changed
    ed_key = lastkey()          && save last keystroke
    start_row = cur_row         && reset starting row # of file to be displayed
    start_col = cur_col         && reset starting col # of file to be displayed
    rel_row = row() - top       && reset row to place cursor relative to ed box
    rel_col = col() - left      && reset col to place cursor relative to ed box
    do case

      ************************************************************************
      * process configurable keys:                                           *
      * (these keys are provided by memoedit() and can be changed)           *
      * note: these keys are intentionally NOT listed in the help screens    *
      *       they are included for users who wish to use "default" commands *
      ************************************************************************

      case ed_key = 25          && Ctrl-Y delete current line
        ret_val = 0
      case ed_key = 20          && Ctrl-T delete word right
        ret_val = 0
      case ed_key = 2           && Ctrl-B format paragraph
        ret_val = 0
      case ed_key = 22          && Ctrl-V, Ins toggle INSERT mode
        @ 24,55 say if(!readinsert(), "<Insert>", space(8))
        ret_val = 0
      case ed_key = 23          && Ctrl-W save and exit
        ret_val = 0             && terminate
      case ed_key = 27          && Esc cancel and exit, return unchanged
        ret_val = 23            && don't cancel changes; terminate

      **************************************************
      * process function keys displayed in help screen *
      * note: some commands require exit of memoedit() *
      **************************************************

      case ed_key = 28          && F1 display help
        old_row = row()         && save current row
        old_col = col()         && save current col
        save screen             && save current screen
        if iscolor()            && paint help screen
           set color to w+/n
           clear
           @  0,0  to 23,79
           set color to w/n
           @ date_row,date_col say date()
           set color to w+/g
           @ 24,64 say "F1-Help Esc-Exit"
           set color to w+/b,w+/g
        else
           clear
           @  0,0  to 23,79
           @ date_row,date_col say date()
           @ 24,64 say "F1-Help Esc-Exit"
        endif
        @  1,12 say "Key"
        @  1,43 say "Purpose"
        @ 24,0  say "Press Esc to exit, PgUp, PgDn"
        set cursor off
        memoedit(help_str,2,1,22,78,.F.,"",77)
        set cursor on
        restore screen                       && restore memoedit() screen
        @ old_row,old_col say ""             && restore cursor position
        ret_val = 0
      case ed_key = -1          && F2 save with exit
        ret_val = 23            && terminate
      case ed_key = -2          && F3 Save without exit
        ret_val = 23            && terminate
      case ed_key = -3          && F4 load file from list
        ret_val = 23            && terminate
      case ed_key = -4          && F5 print file
        ret_val = 23            && terminate
      case ed_key = -5          && F6 clear current file from word processor
        ret_val = 23            && terminate
      case ed_key = -6          && F7 Search for text
        ret_val = 23            && terminate
      case ed_key = -7          && F8 Search and replace text
        ret_val = 23            && terminate
      case ed_key = -8          && F9 Delete the current line
        ret_val = 25            && Ctrl-Y
      case ed_key = -9          && F10 Delete right word
        ret_val = 20            && Ctrl-T
      case ed_key = -10         && Shift + <F1> Insert line above current line
        keyboard if(readinsert(),;
                     replicate(chr(19), col()) + chr(13) + chr(5),;
                     replicate(chr(19), col()) + chr(22) + chr(13) +;
                               chr(22) + chr(5))
        ret_val = 0
      case ed_key = -11         && Shift + <F2> Insert fieldname to merge
        if !used()              && make sure area has a database
           @ 24,0  clear to 24,62
           @ 24,0  say "Current work area closed! Hit any key"
           beep()
           inkey(0)
        else
           save screen
           declare names[fcount()] && declare and fill array with field names
           for x = 1 to fcount()
             names[x] = fieldname(x)
           next
           @ 24,0  clear to 24,62
           @ 24,0  say "Select field name to insert or hit <Esc>"
           if iscolor()
              set color to w+/r,w+/b
           endif
           store 1 + fcount() to bot
           bot = if(bot > 23,23,bot)
           @  0,31 clear to bot,45
           @  0,31 to bot,45
           key_char = achoice(1,33,22,43,names,"","AFUNC")
           restore screen
           if iscolor()
              set color to w+/b,w+/g
           endif
           if key_char > 0
              keyboard if(readinsert(),"{" + trim(names[key_char]) + "}",;
                       chr(22) + "{" + trim(names[key_char]) + "}" + chr(22))
           endif
        endif
        ret_val = 23            && must terminate and redraw screen
      case ed_key = -12         && Shift + <F3> Insert date
        keyboard if(readinsert(),cmonth(date()) + " " +;
                                 ltrim(str(day(date()))) + ", " +;
                                 ltrim(str(year(date()))),;
                       chr(22) + cmonth(date()) + " " +;
                                 ltrim(str(day(date()))) + ", " +;
                                 ltrim(str(year(date()))) + chr(22))
        ret_val = 0
      case ed_key = -13         && Shift + <F4> Insert time
        keyboard if(readinsert(),time(),chr(22) + time() + chr(22))
        ret_val = 0
      case ed_key = -14         && Shift + <F5> Set horizontal margins
        ret_val = 23            && terminate
      case ed_key = -15         && Shift + <F6) Set vertical margins
        ret_val = 23            && terminate
      case ed_key = -16         && Shift + <F7> Modify current tab length
        ret_val = 23            && terminate
      case ed_key = -17         && Shift + <F8> Toggle scroll
        scrl_on = !scrl_on
        @ 24,39 say if(scrl_on, "<Scroll>", space(8))
        ret_val = 35            && toggle scrolling within window
      case ed_key = -18         && Shift + <F9> Toggle word wrap
        word_wrap = !word_wrap
        @ 24,48 say if(word_wrap, "<Wrap>", space(6))
        ret_val = 34            && Toggle automatic word wrapping
      case ed_key = -19         && Shift + <F10> Operating system
        ret_val = 23            && terminate
      otherwise                 && unprocessable keystroke
        beep()                  && make error sound
        ret_val = 32            && ignore keystroke
    endcase
  case mode = 3                 && memoedit() has just been invoked
    set cursor off              && display current filename being edited
    if !empty(filename)
       @ 24,0 say filename + space(4)
    endif

    @ 24,20 say "Line: "        && display line and column labels
    @ 24,31 say "Col: "

    @ 24,48 say if(word_wrap, "<Wrap>", space(6))      && display wrap mode

    @ 24,55 say if(readinsert(), "<Insert>", space(8)) && display insert mode

    @ 24,39 say if(scrl_on, "<Scroll>", space(8))      && display scroll mode
    set cursor on
    ret_val = 0
endcase
return(ret_val)

*** eof edfunc ***

function loadhelp

******************************************************
* load help_str string with help screen routine      *
* note: Editing keys information obtained from:      *
*       "Tom Rettig's Clipper Encyclopedia" (pp 217) *
******************************************************

store chr(13) + chr(10) to new               && CR + LF
temp_str = " <F1>                        Display help" + new +;
" <F2>                        Save with exit" + new +;
" <F3>                        Save without exit" + new +;
" <F4>                        Load file from list" + new +;
" <F5>                        Print file" + new +;
" <F6>                        Clear current file from Word Processor" + new +;
" <F7>                        Search for text" + new +;
" <F8>                        Search and replace text" + new +;
" <F9>                        Delete the current line" + new +;
" <F10>                       Delete right word" + new +;
" Shift + <F1>                Insert blank line above current line" + new +;
" Shift + <F2>                Insert fieldname to merge from database" + new +;
" Shift + <F3>                Insert date" + new +;
" Shift + <F4>                Insert time" + new +;
" Shift + <F5>                Set horizontal margins" + new +;
" Shift + <F6>                Set vertical margins" + new +;
" Shift + <F7>                Modify current tab length" + new +;
" Shift + <F8>                Toggle scroll" + new +;
" Shift + <F9>                Toggle word wrap" + new +;
" Shift + <F10>               Operating system" + new +;
" Editing Keys:" + new +;
" UpArrow     or Ctrl-E       Move up one line" + new +;
" DownArrow   or Ctrl-X       Move down one line" + new +;
" LeftArrow   or Ctrl-S       Move left one character" + new +;
" RightArrow  or Ctrl-D       Move right one character" + new +;
" Ctrl-LeftArrow  or Ctrl-A   Move left one word" + new +;
" Ctrl-RightArrow or Ctrl-F   Move right one word" + new +;
" Home                        Beginning of line" + new +;
" End                         End of line" + new +;
" Ctrl-Home                   Beginning of current window" + new +;
" Ctrl-End                    End of current window" + new +;
" PgUp                        Previous window" + new +;
" PgDn                        Next window" + new +;
" Ctrl-PgUp                   Begining of text" + new +;
" Ctrl-PgDn                   End of text" + new +;
" Enter                       Move to begining of next line" + new +;
" Del                         Delete character at cursor" + new +;
" Backspace                   Delete character left of cursor" + new +;
" Tab                         Insert tab character or spaces" + new +;
" Printable characters        Insert character" + new +;
" Ins                         Toggle insert mode"
return(temp_str)

*** eof loadhelp ***

procedure save_file

*****************************
* save current file routine *
*****************************

@ 24,0 clear to 24,62
@ 24,0 say "Save document? (Y/N)"
choice = "Y"
@ 24,21 get m->choice picture "!" valid choice $ "YN"
read
if lastkey() = 27 .or. choice= "N"      && return if Esc or choice = (N)o
   return
endif

********************************
* get name of file to be saved *
********************************

@ 24,0  clear to 24,62
if !empty(filename)
   filename = left(filename,len(filename)-4)
endif
filename = filename + space(8-len(filename))
@ 24,0  say "Enter document name:"
@ 24,21 get m->filename picture "@!"
read
if lastkey() = 27 .or. empty(filename)  && return if Esc or blank file name
   return
endif
filename = trim(filename) + ".TXT"

*******************************
* check for existing filename *
*******************************

if file(filename)
   @ 24,0  say "Replace existing document? (Y/N)"
   choice = "Y"
   @ 24,33 get m->choice picture "!" valid choice $ "YN"
   read
   if lastkey() = 27 .or. choice = "N"    && return if Esc or no overwrite
      return
   endif
endif

******************************************************
* if in demo (crippleware) mode and                  *
* there are at least two *.txt files, disallow write *
******************************************************

@ 24,0  clear to 24,62
set cursor off
if type("demo") = "L"
   if demo .and. adir("*.TXT") >= 2
      @ 24,0 say "Demo mode only allows use of two text files!"
      beep()
      beep()
      beep()
      inkey(1)
      set cursor on
      return
   endif
endif
@ 24,0  say "Writing " + filename     && write new file!
memowrit(filename,text_str)
beep(3)                               && beep OK
inkey(1)
set cursor on
return

*** eop save_file ***

function afunc

*****************************************************************
* Called to process keystrokes from within achoice()            *
* allows arrow keys on number pad with num-lock on;             *
* beeps high at top of list, low at bottom of list              *
* note: mode parameter can contain one of five possible values: *
*       0 - Idle                                                *
*       1 - Past first menu choice                              *
*       2 - Past last menu choice                               *
*       3 - Keystroke exception                                 *
*       4 - No item selectable                                  *
*****************************************************************

parameters mode, choice, row
store lastkey() to key_char
do case
  case mode = 0             && idle
    ret_val = 2             && continue
  case mode = 1             && Past first menu choice
    beep(1)                 && beep high
    ret_val = 2             && continue
  case mode = 2             && Past last menu choice
    beep(2)                 && beep low
    ret_val = 2             && continue
  case mode = 3             && Keystroke exception
    do case
      case key_char = 13    && return was hit
        ret_val = 1         && Make menu selection
      case key_char = 27    && Esc was hit
        ret_val = 0         && Cancel menu selection
      case key_char = 49 .or. key_char = 6    && 1 or end was hit
        keyboard chr(30)        && stuff ^PgDn
        ret_val = 2             &&
      case key_char = 50        && 2 was hit
        keyboard chr(24)        && stuff down arrow
        ret_val = 2             &&
      case key_char = 51        && 3 was hit
        keyboard chr(3)         && stuff PgDn
        ret_val = 2             &&
      case key_char = 55 .or. key_char = 1    && 7 .or. home was hit
        keyboard chr(31)        && stuff ^PgUp
        ret_val = 2             &&
      case key_char = 56        && 8 was hit
        keyboard chr(5)         && stuff up arrow
        ret_val = 2             &&
      case key_char = 57        && 9 was hit
        keyboard chr(18)        && stuff PgUp
        ret_val = 2             &&
      case isalpha(chr(key_char))             && alphabetical key pressed
        ret_val = 3             && Go to next choice with matching first key
      otherwise                 && unprocessable keystroke
        beep()                  && make error noise
        ret_val = 2             &&
    endcase
  case mode = 4                 && No item selectable
    ret_val = 0                 && Cancel menu selection
endcase
return(ret_val)

*** eof afunc ***

function beep

**************************************************************
* Called to generate a warning or error tone                 *
* note: mode parameter can contain one of 3 possible values: *
*       not passed - generate high/low error tone            *
*                1 - generate high warning tone              *
*                2 - generate low warning tone               *
*                3 - generate low/high OK tone               *
**************************************************************

parameters mode
do case
  case pcount() = 0
    tone(261.63,2)
    tone(130.81,2)
  case mode = 1
    tone(261.63,2)
  case mode = 2
    tone(130.81,2)
  case mode = 3
    tone(130.81,2)
    tone(261.63,2)
endcase
return(0)

*** eof beep ***

*** eof ME3.PRG ***
