EXTERNAL _VDBFMDX

#command USE <(db)>                                                     ;
             [ IN <anum>                        ]                       ;
             [ INDEX <(index1)> [, <(indexn)> ] ]                       ;
             [ ORDER [ TAG ] <tag>                                      ;
             [ OF <mdx> ]                       ]                       ;
             [ ALIAS <a>                        ]                       ;
             [ VIA <rdd>                        ]                       ;
             [ TYPE                             ]                       ;
             [       <db3: DBMEMO3>             ]                       ;
             [ <ex: EXCLUSIVE>                  ]                       ;
             [ <ro: READONLY, NOUPDATE>         ]                       ;
             [ <new: NEW>                       ]                       ;
             [ <sh: SHARED>                     ]                       ;
                                                                        ;
         =>  d4UseArea( <.new.>, <rdd>, <(db)>, <(a)>,                  ;
                        if( <.sh.> .or. <.ex.>, !<.ex.>, NIL ),         ;
                        <.ro.>, <anum>, !<.db3.>                        ;
                      )                                                 ;
             [; d4SetIndex( <(index1)>, <anum> ) ]                      ;
             [; d4SetIndex( <(indexn)>, <anum> ) ]                      ;
             [; d4SetOrder( <(tag)>, <(mdx)>, <anum>, .T. ) ]


#command USE [ IN <anum> ]          => [ ( <anum> )->]( dbCloseArea() )


#command SET INDEX TO [ <(index1)> [, <(indexn)> ] ]                    ;
                      [ ORDER [ TAG ] <tag>                             ;
                      [ OF <mdx> ]             ]                        ;
                                                                        ;
         =>  d4ClearIndex()                                             ;
             [; d4SetIndex( <(index1)> )                            ]   ;
             [; d4SetIndex( <(indexn)> )                            ]   ;;
             if <.tag.>                                                 ;;
                d4SetOrder( <(tag)>,                                    ;
                     if( <.mdx.>, <(mdx)>, <(index1)> ), , .T. )        ;;
             end


#command SET ORDER TO [ TAG             ] <n>                           ;
                      [ OF <mdx>        ]                               ;
                                                                        ;
         => d4SetOrder( <(n)>, <(mdx)>, , .F. )


#command SET ORDER TO                                                   ;
                                                                        ;
         => d4SetOrder( '0' )


#command DELETE TAG <tag> [ OF <(mdx)> ] [, <*more*> ]                  ;
                                                                        ;
         => d4DelTag( <(mdx)>, <(tag)> )                                ;
            [; DELETE TAG <more> ]


#command INDEX [ ON <key>                          ]                    ;
               [ <to: TO> <(ntx)>                  ]                    ;
               [ <tg: TAG> <(tag)>                                      ;
               [ OF <mdx>                   ]      ]                    ;
               [ FOR <cond>                        ]                    ;
               [ <u: UNIQUE>                       ]                    ;
               [ <d: DESCENDING>                   ]                    ;
                                                                        ;
         => d4CreateIndex( <(ntx)>, <(tag)>, <"key">, <{key}>,          ;
                           if( <.u.>, .t., NIL ),                       ;
                           <(mdx)>, <"cond">, <{cond}>,                 ;
                           <.d.>, <.to.>                                ;
                         )


#command CLOSE INDEXES         => d4ClearIndex()


#command CREATE <(file1)> [FROM <(file2)>]                              ;
                [ TYPE <db3: DBMEMO3> ]                                 ;
                                                                        ;
      => _ddbCreate( <(file1)>, <(file2)>, <.db3.> )


#command COPY [ STRUCTURE           ]                                   ;
              [ EXTENDED            ]                                   ;
              [ TO <(file)>         ]                                   ;
              [ TYPE <db3: DBMEMO3> ]                                   ;
                                                                        ;
      => _ddbCopyXStruct( <(file)>, <.db3.> )

#command COPY [ STRUCTURE                   ]                           ;
              [ TO <(file)>                 ]                           ;
              [ FIELDS <fields,...>         ]                           ;
              [ [ WITH ] <prod: PRODUCTION> ]                           ;
              [ TYPE <db3: DBMEMO3>         ]                           ;
                                                                        ;
      => _ddbCopyStruct( <(file)>, { <(fields)> }, <.db3.>, <.prod.> )


///////////// standard translates, position important //////////////////

#command COPY [TO <(file)>] [DELIMITED [WITH <*delim*>]]                ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
                                                                        ;
      => __dbCopyDelim(                                                 ;
                        <(file)>, <(delim)>, { <(fields)> },            ;
                        <{for}>, <{while}>, <next>, <rec>, <.rest.>     ;
                      )


#command COPY [TO <(file)>] [SDF]                                       ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
                                                                        ;
      => __dbCopySDF(                                                   ;
                      <(file)>, { <(fields)> },                         ;
                      <{for}>, <{while}>, <next>, <rec>, <.rest.>       ;
                    )

////////////////////   end standard translates /////////////////////////

#command COPY                                                           ;
         [ TO <(file)>          ]                                       ;
         [ FIELDS <fields,...>  ]                                       ;
         [ FOR    <for>         ]                                       ;
         [ WHILE  <while>       ]                                       ;
         [ NEXT   <next>        ]                                       ;
         [ RECORD <rec>         ]                                       ;
         [ <rest: REST>         ]                                       ;
         [ TYPE <db3: DBMEMO3>  ]                                       ;
         [ [ WITH ] <prd: PRODUCTION> ]                                 ;
         [ ALL                  ]                                       ;
                                                                        ;
      => _ddbCopy( <(file)>, { <(fields)> }, <{for}>, <{while}>,        ;
                    <next>, <rec>, <.rest.>, <.db3.>, <.prd.> )



