;
;  MAXWORDLEN( <expC> ) -> <expN> : This function will find the longest
;                                   word in string and return its length 
;
;  Written by: Kurt R. Hoehn, CIS# 73150, 1321
;  Date:  04/24/94
;  
;  This little function is a good addition to any clipper lib 
;

PUBLIC MaxWordLen

EXTRN   __parc :FAR
EXTRN   __retni:FAR

DGROUP GROUP   data

data  SEGMENT PUBLIC 'data'
data  ENDS

code  SEGMENT 'CODE' 
            ASSUME   cs:code, ds:DGROUP

MaxWordLen  PROC  FAR
   
   push  bp                 ;save clipper registers
   mov   bp, sp
   push  ds
   push  si
   push  di
   
   mov   ax, 1
   push  ax
   call  __parc             ;places pointer info into DX:AX
   add   sp, 2              ;reset stack pointer

   mov   es, dx             ;move pointer info into the es, si registers
   mov   si, ax
   
   xor   dx, dx             ;clear out the cx and dx registers 
   xor   cx, dx             ;for counting info.   

Main_Loop:                  
   lods  byte ptr es:[si]   ;put a char byte into the AL register
   
   cmp   al, ' '
   je    Compare_A_Word     ;check the length of a word
   
   cmp   al, 00h
   je    Compare_A_Word     ;if AL is the NULL char check for a last word
                            ;and its length   
   inc   cx                 ;counter 
   jmp   Main_Loop

Compare_A_Word:
   cmp   dx, cx
   jl    Update_Len         ;if DX is < CX update DX
   
   xor   cx, cx             ;reset cx back to zero
   
   cmp   al, 00h           
   je    Good_Bye           ;if AL is the NULL char exit
   
   jmp   Main_Loop

Update_Len:
   mov   dx, cx             ;update the dx register with new value
   jmp   Compare_A_Word

Good_Bye:   
   push  dx
   call  __retni
   add   sp, 2

   pop   di
   pop   si
   pop   ds
   pop   bp                 ;reset   registers
   ret
maxwordlen   ENDP

code ENDS
END

