****  Author:  John Charles Agusta
****  Date  :  9/22/87
****
****  Copyright by John Charles Agusta 1987
****  NOT for resale under any circumstances without written permission
****  from the author
****
****  Program MakePat.prg
****
****
****  Purpose:  Utility to edit/create printer tables
****

Private MPrnt

Clear

MPrnt = Space(8)

@ 1,00 Say 'Enter printer table:  ' Get MPrnt Valid DOSFName2(MPrnt)
@ 1,31 Say '.PAT'
Read

If LastKey() = 27 .or. Empty(MPrnt)
   Return
Endif

MPrnt = Trim(MPrnt)

@ 1,0
@ 1,0 Say 'Active printer table:  &MPrnt..PAT'

If File('&MPrnt..pat')

   Restore from &MPrnt..Pat Additive
   
   Str_Reset = SpaceFill(VtoS(Pat_Reset), 60)
   Str_Comp  = SpaceFill(VtoS(Pat_Comp), 60)
   Str_UOn   = SpaceFill(VtoS(Pat_UOn), 60)
   Str_UOff  = SpaceFill(VtoS(Pat_UOff), 60)
   Str_BOn   = SpaceFill(VtoS(Pat_BOn), 60)
   Str_BOff  = SpaceFill(VtoS(Pat_BOff), 60)
   Str_66LPP = SpaceFill(VtoS(Pat_66LPP), 60)
   Int_LPP   = Pat_LPP

Else

   Store Space(60) to Str_Reset, Str_Comp, Str_UOn, Str_UOff, Str_BOn, Str_BOff, Str_66LPP
   Int_LPP = 66

Endif

@ 03,00 Say 'PRINTER FEATURE'
@ 03,20 Say 'SETUP STRING'

@ 04,00 Say 'Reset'
@ 04,20 Get Str_Reset

@ 05,00 Say 'Compressed'
@ 05,20 Get Str_Comp

@ 06,00 Say 'Underline On'
@ 06,20 Get Str_UOn

@ 07,00 Say 'Underline Off'
@ 07,20 Get Str_UOff

@ 08,00 Say 'Bold On'
@ 08,20 Get Str_BOn

@ 09,00 Say 'Bold Off'
@ 09,20 Get Str_BOff

@ 10,00 Say '66 lines/page'
@ 10,20 Get Str_66LPP

@ 11,00 Say 'Lines per page'
@ 11,20 Get Int_LPP Picture '99'

@ 13,0

Text
Press <Esc> to abort                         <PgDn> to save

Enter printer codes for associated printer features, up to 60 characters.

You may enter any printable characters as is.  Special printer codes should
be entered in the form \nnn, a backslash followed by a 3-digit decimal number.
If your printer does not support an above feature, leave the field blank.

Ex.  \015             Epson compressed
     \027E            Epson emphasized on
     \027(s16.66H     Hewlett-Packard LaserJet compressed
EndText

Read

If LastKey() = 27
   Return
Endif

Pat_Reset = StoV(Str_Reset)
Pat_Comp  = StoV(Str_Comp)
Pat_UOn   = StoV(Str_UOn)
Pat_UOff  = StoV(Str_UOff)
Pat_BOn   = StoV(Str_BOn)
Pat_BOff  = StoV(Str_BOff)
Pat_66LPP = StoV(Str_66LPP)
Pat_LPP   = Int_LPP

Save All Like Pat_* to &MPrnt..Pat

Return

Function DOSFname2

Parameter FName

Private Kntr

If Empty(FName)
   Return .T.
Endif

For Kntr = 1 to Len(Trim(FName))

    If Substr(FName,Kntr,1) $ ' ."/\[]:|<>+=;,'    && Invalid file name
       Return .F.
    Endif

Next Kntr

Return .T.


Function VtoS  && Printer Setup Variable to Printer String

Parameter PVar

Private PStr, Knt

PStr = ''
Knt = 1

Do While Knt <=  Len(Trim(PVar))

    If Asc(Substr(PVar, Knt,1)) < 32
       PStr = PStr + '\' + IIf(Asc(Substr(PVar, Knt,1)) <= 99, '0', '') + LTrim(Str(Asc(Substr(PVar, Knt,1))))
    Else
       PStr = PStr + Substr(PVar, Knt,1)
    Endif

    Knt  = Knt + 1

Enddo

Return PStr

*EOF VtoS



Function StoV  && Printer Setup String to Printer Setup Variable

Parameter PStr

Private PVar, Knt

PVar = ''

If At('\', PStr) = 0
   Return Trim(PStr)
Endif


Knt = 1

Do While Knt <= Len(Trim(PStr))

    If Substr(PStr, Knt,1) = '\'
       PVar = PVar + Chr(Val(Substr(PStr, Knt + 1,3)))
       Knt = Knt + 4
    Else
       PVar = PVar + Substr(PStr, Knt,1)
       Knt = Knt + 1
    Endif

Enddo

Return PVar

*EOF StoV


**	SPACEFILL	- Space fills a source string.
**
**	format:	dest = spacefill(src, len)
**
**		dest (C)	- Destination string.
**		src  (C)	- Source string to be space filled.
**		len  (N)	- Length of string after space fill.
**
**	Examples:							Output
**
**	spacefill("ABC",5)					"ABC  "
**	spacefill("ABC",1)					"A"
**
**	Note:	This routine will truncate a string which is longer than len.
**
function spacefill
parameter cl_str,cl_ln
return substr(cl_str+space(cl_ln),1,cl_ln)
**
**	SPACEFILL	- End of function.
