************************************************************************
*
*   For Clipper 5.0 developers the program builds and maintains an
*   application specific header file containing definitions of each
*   field in the .dbf files in the project directory.
*
*   This header file is used with the Scatter and Gather user functions
*   distributed with this program.  See suporting documentation for
*   more details.
*
*   Placed in public domain by the author: John Lucas
*                                          John Lucas Systems Ltd.
*                                          Toronto, CANADA
*                                          CRS 'John Lucas'
*                                          CIS 73700,1074
*
************************************************************************

#Include "Inkey.ch"

#Define DirPr       Directories[1]
#Define DirCh       Directories[2]

Function EasyCopy

Local DDREC, PrDbf, PrDbt
Local I, FF
Local Directories, Header, DbfNames

Directories := Setup()                  // Get directory paths

Header := OldHead(Directories)          // Get users part of header file

*
*       Build array of all .dbf files in users project directory
*

DbfNames := Directory (DirPr + "*.dbf")

@ 16,10 say "Processing file ==>"

aEval (DbfNames, {|x| Header := Header + BuildCh (DirPr + x[1])})

memowrit (DirCh, Header)                     // Write new header

@ 0,0 clear
? "EasyCopy completed"
?

return


************************************************************************
*
*       Build new defines for each field
*
************************************************************************

Function BuildCh (FF)

Local mDefs := "", Hrt := chr(13) + chr(10)

FF := Substr(FF,1,at(".",FF)-1)
@ 16,30 say padr(FF,30)
use (FF) new alias Dbf
FF := Substr(FF,rat("\",FF)+1,20)

mDefs := mDefs + Hrt + Hrt + Hrt + "// Field defines for " + FF + Hrt+ Hrt

for I = 1 to fcount()
    mDefs := mDefs + "#Define m" + padr(FieldName(I),25) +;
                     "a" + FF + " [" + str(I,2) + "]" + ;
                     Hrt
next I

close Dbf

return mDefs + Hrt
           
      


****************************************************************************
*
*       Get directory paths and other setup stuff
*
****************************************************************************

Function Setup

setkey (K_F10, {|| __Keyboard(chr(K_Ctrl_W))})
           
if File ("CH.mem")
    Restore from CH additive
else
    Private Dir_Pr := space(40)
    Private Dir_Ch := space(40)
endif

Dir_Pr := padr(Dir_Pr,40)
Dir_Ch := padr(Dir_Ch,40)

@  0, 0  clear
@  1,  8 say "<< MakeCh >>"
@  1, 22 to 1,77 double

@  3, 8, 11,77 box ""
setcolor ("N/W")
@  3, 9 say "Enter directory paths"
@ 11, 9 say "F10 to accept"
@ 11,66 say "Esc to quit"
set color to
do while lastkey() <> K_Ctrl_W
    @  6,10 say "      Project directory:" get Dir_Pr
    @  8,10 say "Header directory & name:" get Dir_Ch
    ReadIt
    if Escaped; quit; endif
enddo

set cursor off

Dir_Pr := trim(Dir_Pr)
Dir_Ch := trim(Dir_Ch)

if right(Dir_Pr,1) <> "\";               Dir_Pr := Dir_Pr + "\";       endif
if len(Dir_Ch) > 0 .and. upper(right(Dir_Ch,3)) <> ".CH"
    Dir_Ch := Dir_Ch + ".ch"
endif

save all like Dir_* to CH

return {Dir_Pr, Dir_Ch}



************************************************************************
*
*       Get previous header without our definitions
*
************************************************************************

Function OldHead (Directories)

Local Head := "", I, Hrt := chr(13) + chr(10)

if File(DirCh)
    Head := memoread(DirCh)                     // Get existing header file
endif

I := at("// Common data base defines", Head)
if I > 0
    Head = Left(Head,I-1)                       // Drop old versions
endif

Head := Head + "// Common data base defines"    // New separator
Head := Head + Hrt

*
*       Copy commands for Scatter and Gather
*

Head := Head + Hrt + ;
    "#Command Scatter to <ar> [<new: new>]  => <ar> := Scatter(<.new.>)";
    + Hrt
Head := Head + ;
    "#Command Scatter to <ar> from <alias> [<new: new>]  ;" + Hrt ;
    + "     => <ar> := <alias> -> (Scatter(<.new.>))";
    + Hrt
Head := Head + ;
    "#Command Gather from <ar>              => Gather(<ar>)";
    + Hrt
Head := Head + ;
    "#Command Gather from <ar> to <alias>   => <alias> -> (Gather(<ar>))";
    + Hrt

return Head
