*  Ŀ
* ݳ                                                                       
* ݳ   Function: parse_code()                                              
* ݳ   Purpose : WordPerfect codes added                                   
* ݳ   Usage   :                                                           
* ݳ                                                                       
* ݳ   Author  : Copyright (C) 1992, LumiNet Publishing Corporation        
* ݳ                                 All Rights Reserved.                  
* ݳ                                                                       
* ݳ   Comments: Required linked libraries include:                        
* ݳ                CLP2WPC.LIB                                            
* ݳ                                                                       
*  
* 
*-------------------------------------------------------------------------*
* Translate the WPC code                
* Objective........Convert the WordPerfect text & document formatting
*                  codes that appear in a memo field into their actual
*                  WordPerfect equivalent.
* Arguments........The entire code value is passed, which includes user
*                  defined paramaters, such as # of inches within a
*                  left and right margin. 
* Returns..........nothing
* Translation......Uses the docMAKER(tm) toolkit library of routines to
*                  transform user formatting requests into a 
*                  WordPerfect compatable document.
*-------------------------------------------------------------------------*


Function Parse_code
Parameters codefound

private mark, wpcval, wpcval2, wpcval3, wpcval4, comma


DO CASE

*  Ŀ
* ݳ Left / Right Margins                                                  
*  
* 
	CASE "LRMARG|" $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
		    comma = AT(",", codefound)
			If comma > 0
				wpcval = VAL(Substr(codefound, mark + 1, comma - mark - 1)) * 1200
				wpcval2 = VAL(Substr(codefound, comma + 1)) * 1200
				If wpcval > 0 .and. wpcval2 > 0
					WpLRMarg(wpcval, wpcval2)		
				Endif
			Endif
		Endif
	
*  Ŀ
* ݳ Top / Bottom Margins                                                  
*  
* 
	CASE "TBMARG|" $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
		    comma = AT(",", codefound)
			If comma > 0
				wpcval = VAL(Substr(codefound, mark + 1, comma - mark - 1)) * 1200
				wpcval2 = VAL(Substr(codefound, comma + 1)) * 1200
				If wpcval > 0 .and. wpcval2 > 0
					WpTBMarg(wpcval, wpcval2)		
				Endif
			Endif
		Endif
	
*  Ŀ
* ݳ Page Numbering Position                                               
*  
* 
	CASE "PAGENO|" $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = VAL(Alltrim(SUBSTR(codefound, mark)))
		    If wpcval > 0
				WpHPAGE(wpcval)
			Endif
		Endif
	
*  Ŀ
* ݳ Justification                                                         
*  
* 
	CASE "JUST|"   $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = VAL(Alltrim(SUBSTR(codefound, mark)))
		    If wpcval > 0
				WpJUST(wpcval)
			Endif
		Endif

*  Ŀ
* ݳ Horizontal Line                                                       
*  
* 
	CASE "HOR|"    $ codefound   
	    mark = AT("|", codefound)
		If mark > 0
			commafir = 0
		    commasec = ATNEXT(",", codefound,1)
			If commasec > 0
				wpcval1 = VAL(Substr(codefound, mark + 1, commasec - mark - 1)) 
				wpcval2 = VAL(Substr(codefound, commasec+1,1)) 
				wpcval3 = VAL(Substr(codefound, AtNext(",", codefound,2)+1,1)) 
				wpcval4 = VAL(Substr(codefound, AtNext(",", codefound,3)+1, AtNext(",",codefound,4)-AtNext(",",codefound,3)-1)) 
				wpcval5 = VAL(Substr(codefound, AtNext(",", codefound,4)+1, AtNext(",",codefound,5)-AtNext(",",codefound,4)-1)) 
				wpcval6 = VAL(Substr(codefound, AtNext(",", codefound,5)+1)) 
				WpHLine(wpcval1, wpcval2, wpcval3, wpcval4, wpcval5, wpcval6)		
			Endif
		Endif


*  Ŀ
* ݳ Vertical Line                                                         
*  
* 
	CASE "VER|"    $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
			commafir = 0
		    commasec = ATNEXT(",", codefound,1)
			If commasec > 0
				wpcval1 = VAL(Substr(codefound, mark + 1, commasec - mark - 1)) 
				wpcval2 = VAL(Substr(codefound, commasec+1,1)) 
				wpcval3 = VAL(Substr(codefound, AtNext(",", codefound,2)+1,1)) 
				wpcval4 = VAL(Substr(codefound, AtNext(",", codefound,3)+1, AtNext(",",codefound,4)-AtNext(",",codefound,3)-1)) 
				wpcval5 = VAL(Substr(codefound, AtNext(",", codefound,4)+1, AtNext(",",codefound,5)-AtNext(",",codefound,4)-1)) 
				wpcval6 = VAL(Substr(codefound, AtNext(",", codefound,5)+1)) 
				WpVLine(wpcval1, wpcval2, wpcval3, wpcval4, wpcval5, wpcval6)		
			Endif
		Endif

*  Ŀ
* ݳ Bold  (On)  (Off)                                                     
*  
* 
	CASE "BOLD|ON" $ codefound  
		WpAttOn(Bold)

	CASE "BOLD|OFF" $ codefound 
		WpAttOff(Bold)

*  Ŀ
* ݳ Line Centering                                                        
*  
* 
	CASE "CENTER" $ codefound
		WpCntr()

*  Ŀ
* ݳ Double Underline  (On)  (Off)                                         
*  
* 
	CASE "DBLUND|ON" $ codefound 
		WpAttOn(Dbl_under)
		
	CASE "DBLUND|OFF" $ codefound 
		WpAttOff(Dbl_under)

*  Ŀ
* ݳ Strikeout   (On)  (Off)                                               
*  
* 
	CASE "STRIKE|ON" $ codefound 
		WpAttOn(Strike_out)
		
	CASE "STRIKE|OFF" $ codefound 
		WpAttOff(Strike_out)
		
*  Ŀ
* ݳ Extra Large   (On)   (Off)                                            
*  
* 
	CASE "EXLRG|ON" $ codefound 
		WpAttOn(Extra_large)

	CASE "EXLRG|OFF" $ codefound 
		WpattOff(Extra_large)

*  Ŀ
* ݳ Very Large   (On)   (Off)                                             
*  
* 
	CASE "VLARGE|ON" $ codefound 
		WpAttOn(Very_large)

	CASE "VLARGE|OFF" $ codefound 
		WpattOff(Very_large)

*  Ŀ
* ݳ Fine  (On)  (Off)                                                     
*  
* 
	CASE "FINE|ON" $ codefound 
		WpattOn(Fine)

	CASE "FINE|OFF" $ codefound 
		WpattOff(Fine)

*  Ŀ
* ݳ Hard Page Return                                                      
*  
* 
	CASE "HARDPAGE|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = VAL(Alltrim(SUBSTR(codefound, mark)))
		    If wpcval > 0
				WpHPAGE(wpcval)
			Endif
		Endif

*  Ŀ
* ݳ Hard Line Return                                                      
*  
* 
	CASE "HR|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = VAL(Alltrim(SUBSTR(codefound, mark)))
		    If wpcval > 0
				WpHRTN(wpcval)
			Endif
		Endif
		    		

*  Ŀ
* ݳ Indent                                                                
*  
* 
	CASE "INDENT|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = VAL(Alltrim(SUBSTR(codefound, mark)))
		    If wpcval > 0
				WpINDENT(wpcval)
			Endif
		Endif

*  Ŀ
* ݳ Italics   (On)   (Off)                                                
*  
* 
	CASE "ITALIC|ON" $ codefound 
		WpAttOn(Italics)

	CASE "ITALIC|OFF" $ codefound 
		WpAttOff(Italics)

*  Ŀ
* ݳ Large (On)  (Off)                                                     
*  
* 
	CASE "LARGE|ON" $ codefound 
		WpAttOn(Large)

	CASE "LARGE|OFF" $ codefound 
		WpAttOff(Large)

*  Ŀ
* ݳ Outline   (On)   (Off)                                                
*  
* 
	CASE "OUTLN|ON" $ codefound 
		WpAttOn(Outline)

	CASE "OUTLN|OFF" $ codefound 
		WpAttOff(Outline)

*  Ŀ
* ݳ Redline   (On)    (Off)                                               
*  
* 
	CASE "REDLN|ON" $ codefound 
		WpAttOn(Redline)

	CASE "REDLN|OFF" $ codefound 
		WpAttOff(Redline)

*  Ŀ
* ݳ Shadow   (On)    (Off)                                                
*  
* 
	CASE "SHAD|ON" $ codefound 
		WpAttOn(Shadow)

	CASE "SHAD|OFF" $ codefound 
		WpAttOff(Shadow)

*  Ŀ
* ݳ Small (On)  (Off)                                                     
*  
* 
	CASE "SMALL|ON" $ codefound 
		WpAttOn(Small)

	CASE "SMALL|OFF" $ codefound 
		WpAttOff(Small)

*  Ŀ
* ݳ Small Caps  (On)   (Off)                                              
*  
* 
	CASE "SMCAP|ON" $ codefound 
		WpAttOn(Small_caps)

	CASE "SMCAP|OFF" $ codefound 
		WpAttOff(Small_caps)

*  Ŀ
* ݳ Soft Return  (On)   (Off)                                             
*  
* 
	CASE "SOFT|ON" $ codefound 
		softon=.T.

	CASE "SOFT|OFF" $ codefound 
		softon=.F.

*  Ŀ
* ݳ Subscript   (On)   (Off)                                              
*  
* 
	CASE "SUBSC|ON" $ codefound 
		WpAttOn(Subscript)

	CASE "SUBSC|OFF" $ codefound 
		WpAttOff(Subscript)
		
*  Ŀ
* ݳ Superscript  (On)   (Off)                                             
*  
* 
	CASE "SUPSC|ON" $ codefound 
		WpAttOn(Superscript)

	CASE "SUPSC|OFF" $ codefound 
		WpAttOff(Superscript)

*  Ŀ
* ݳ Underline   (On)   (Off)                                              
*  
* 
	CASE "UNDLN|ON" $ codefound 
		WpAttOn(Underline)

	CASE "UNDLN|OFF" $ codefound 
		WpAttOff(Underline)

*  Ŀ
* ݳ Tab                                                                   
*  
* 
	CASE "TAB|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = Max (VAL(Alltrim(SUBSTR(codefound, mark))), 1)
		    If wpcval > 0
				wptab(wpcval)
			Endif
		Endif

*  Ŀ
* ݳ System Date and Time                                                  
*  
* 
	CASE "SDATE|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = Alltrim(SUBSTR(codefound, mark))
		    If !Empty(wpcval)
				WpDATE(wpcval)
			Endif
		Endif

*  Ŀ
* ݳ Set Tabs (maximum of 6 settings)                                      
*  
* 
	CASE "SETTAB|" $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
			commafir = 0
		    commasec = ATNEXT(",", codefound,1)
			If commasec > 0
				wpcval1 = VAL(Substr(codefound, mark + 1, commasec - mark - 1)) 
				wpcval2 = VAL(Substr(codefound, commasec+1,1)) 
				wpcval3 = VAL(Substr(codefound, AtNext(",", codefound,2)+1,1)) 
				wpcval4 = VAL(Substr(codefound, AtNext(",", codefound,3)+1, AtNext(",",codefound,4)-AtNext(",",codefound,3)-1)) 
				wpcval5 = VAL(Substr(codefound, AtNext(",", codefound,4)+1, AtNext(",",codefound,5)-AtNext(",",codefound,4)-1)) 
				wpcval6 = VAL(Substr(codefound, AtNext(",", codefound,5)+1, AtNext(",",codefound,6)-AtNext(",",codefound,5)-1)) 
				wpcval7 = VAL(Substr(codefound, AtNext(",", codefound,6)+1, AtNext(",",codefound,7)-AtNext(",",codefound,6)-1)) 
				wpcval8 = VAL(Substr(codefound, AtNext(",", codefound,7)+1, AtNext(",",codefound,8)-AtNext(",",codefound,7)-1)) 
				wpcval9 = VAL(Substr(codefound, AtNext(",", codefound,8)+1, AtNext(",",codefound,9)-AtNext(",",codefound,8)-1)) 
				wpcval0 = VAL(Substr(codefound, AtNext(",", codefound,9)+1)) 
				WpSetTab(wpcval1, wpcval2, wpcval3, wpcval4, wpcval5, wpcval6, wpcval7, wpcval8, wpcval9, wpcval0)		
			Endif
		Endif


*  Ŀ
* ݳ Figure Graphics                                                       
*  
* 
	CASE "FIGGR|" $ codefound  
	    mark = AT("|", codefound)
		If mark > 0
			commafir = 0
		    commasec = ATNEXT(",", codefound,1)
			If commasec > 0
				wpcval1 =Substr(codefound, mark + 1, commasec - mark - 1)
				wpcval2 = Substr(codefound, commasec+1,1)
				wpcval2 = val(wpcval2)
				wpcval3 = Substr(codefound, AtNext(",", codefound,2)+1,1)
				wpcval3 = val(wpcval3)
				wpcval4 = Substr(codefound, AtNext(",", codefound,3)+1, AtNext(",",codefound,4)-AtNext(",",codefound,3)-1)
				wpcval4 = Val(wpcval4)
				wpcval5 = Substr(codefound, AtNext(",", codefound,4)+1, AtNext(",",codefound,5)-AtNext(",",codefound,4)-1)
				wpcval5 = val(wpcval5)
				wpcval6 = Substr(codefound, AtNext(",", codefound,5)+1)
				wpcval6 = val(wpcval6)
				WpFig(wpcval1, wpcval2, wpcval3, wpcval4, wpcval5, wpcval6)		
			Endif
		Endif
	
*  Ŀ
* ݳ Newspaper Columns   (On)   (Off)                                      
*  
* 
	CASE "NEWCOL|ON" $ codefound 
		WpClmOn()

	CASE "NEWCOL|OFF" $ codefound 
		WpClmOff()


*  Ŀ
* ݳ Font change                                                           
*  
* 
	CASE "FNTCHG|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			mark=mark+1
		    wpcval  = Max (VAL(Alltrim(SUBSTR(codefound, mark))), 1)
		    If wpcval > 0
				wpfont(wpcval)
			Endif
		Endif


*  Ŀ
* ݳ Header A/B Footer A/B  (On)   (Off)                                   
*  
* 
	CASE "H/FSTART|" $ codefound 
	    mark = AT("|", codefound)
		If mark > 0
			commafir = 0
		    commasec = ATNEXT(",", codefound,1)
			If commasec > 0
				wpcval1 = VAL(Substr(codefound, mark + 1, commasec - mark - 1)) 
				wpcval2 = VAL(Substr(codefound, commasec+1,1)) 
				Wphfstrt(wpcval1, wpcval2)		
			Endif
		Endif

	CASE "H/FEND|" $ codefound 
		WpHfend()

	
ENDCASE

Return(.t.)
