/****************************************************************************/
/*******    Function prototypes, DEFINES, and required structures   *********/
/****************************************************************************/
#define	HDFT_ALL_PAGES		(char)1
#define	HDFT_ODD_PAGES		(char)2
#define	HDFT_EVEN_PAGES	(char)4
#define	HEADER_A				(char)0
#define	HEADER_B				(char)1
#define	FOOTER_A				(char)2
#define	FOOTER_B				(char)3

#define	LINE_PRINTER		(int)0
#define	COURIER_10			(int)1
#define	COURIER_10_BOLD	(int)2
#define	COURIER_10_ITALIC	(int)3
#define	COURIER_12     	(int)4
#define	COURIER_12_BOLD	(int)5
#define	COURIER_12_ITALIC	(int)6
#define	HELVETICA_18PT		(int)7
#define	HELVETICA_24PT		(int)8
#define	ROMAN_10			(int)9
#define	ROMAN_12			(int)10
#define	CENTURY_10			(int)11
#define	ROMAN_20    		(int)12
#define	WIN_ARIAL			(int)13
#define	WIN_TIMES_R			(int)14
#define	WIN_ROMAN			(int)15
#define	WIN_COURIER_NEW	(int)16
#define	WIN_LINE_PRINTER	(int)17
#define	WIN_CENTURY			(int)18

//	the following defines are for control codes and other
//	single byte functions
#define	INSERT_PAGEN 	2

//	printer and font maximums
#define	MAX_WP_PRINTERS	 	20
#define	MAX_WP_FONTS			50

//	text attributes
#define  DM_EXTRALARGE      0
#define  DM_VERYLARGE       1
#define  DM_LARGE           2
#define  DM_SMALL           3
#define  DM_FINE            4
#define  DM_SUPERSCRIPT     5
#define  DM_SUBSCRIPT       6
#define  DM_OUTLINE         7
#define  DM_ITALIC          8
#define  DM_SHADOW          9
#define  DM_REDLINE         10
#define  DM_DOUBLEUND       11
#define  DM_BOLD            12
#define  DM_STRIKEOUT       13
#define  DM_UNDERLINE       14
#define  DM_SMALLCAPS       15

struct	printer
		{
		int	status;	// 0xffff not used 0x00 selected 0x01 default printer
		unsigned char	LongName[37];
		unsigned char	PRSName[13];
		unsigned char	Descriptor[27];
		unsigned int	MinTM;
		unsigned int	MinBM;
		unsigned int	MinLM;
		unsigned int	MinRM;
		unsigned char	flags;
		unsigned int	PRSDate;
		unsigned int	PRSTime;
		char	fpath[80];
		};

struct	fonts
		{
		int	status;	// 0xffff not used 0x00 selected 0x01 default printer
		char	name[40];
		};


int   wpopen(char *ptr );            			// open document using
															// appropriate printer
int  	wpadd( unsigned char *ptr );							// add text to document
void 	wpclose( void );								// close document
void 	wphrtn( int count);							// add n hard returns
void 	wpindent( int count );						// add n indents
void 	wpcntr(void);									// center line
void 	wptab(int count);								// add n tabs
int  	wpatton( unsigned char  att_type );		// set attribute on
int  	wpattoff( unsigned char  att_type );	// set attribute off
void 	wphpage( void );								// insert hard page break
void 	wpdate( char *ptr );								// insert system date
int  	wppagen( unsigned char  np );					// insert page number
void 	wphline(int hpf, int xpos, int ypos, int line_width,
					int line_height, int shading);	//	draw horizontal line
void 	wpvline(int hpf, int xpos, int ypos, int line_width,
					int line_height, int shading);	//	draw vertical line
void 	wplrmarg( int newlmarg, int newrmarg );	// left and right margins
void 	wptbmarg( int newtmarg, int newbmarg );	// top and bottom margins

// header and footer start
int 	wphfstrt( char hf_type, char oe_page );	

// header and footer end
int  	wphfend(void);										

// insert graphic
void   wpfig(char *fname, int alignment, int x_pos, 
				int y_pos, int width, int height);	

// justification
void 	wpjust( unsigned char just);					

// columns on
void 	wpclmon( void );									

// columns off
void 	wpclmoff( void );									

void	wpsettab( int *tab );

// change font
int	wpfont( int f_nmb );


// set orientation
void	wporient( int orient );							

//	convert document s_ptr to	ascii text file d_ptr
int	wpascii( char *s_ptr, char *d_ptr );

//	insert control code
//	see control codes and sbf codes above
int	wpccodes( int code );





