/******************************************************************************
*  LSTGRF.C - List settings in Quicksilver and dbXL GRF files. Dan Kenny 8/88 *
******************************************************************************/
#include <stdio.h>
#include <fcntl.h>
#define PIE 2

main(int argc,char *argv[])
{
   typedef struct {
        char ignore1;                   /* Unknown                     */
        char type;                      /* Graph type                  */
        char ignore2[2];                /* Unknown                     */
        char numyxpr;                   /* Number of y-axis expr.'s    */
        char ignore3;                   /* Unknown                     */
        char color1;                    /* Y-axis expr/Slice 1 color   */
        char color2;                    /* Y-axis expr/Slice 2 color   */
        char color3;                    /* Y-axis expr/Slice 3 color   */
        char color4;                    /* Y-axis expr/Slice 4 color   */
        char color5;                    /* Y-axis expr/Slice 5 color   */
        char color6;                    /* Slice 6 color               */
        char color7;                    /* Slice 7 color               */
        char color8;                    /* Slice 8 color               */
        char color9;                    /* Slice 9 color               */
        char color10;                   /* Slice 10 color              */
        char ignore4[10];               /* Unknown                     */
        char clrbkgrd;                  /* Background color            */
        char clrtext;                   /* Text color                  */
        char ignore5[50];               /* Unknown                     */
        char pagetitle[81];             /* Pagetitle                   */
        char footnote[81];              /* Footnote                    */
        char xtitle[81];                /* X-axis title                */
        char ytitle[81];                /* Y-axis title                */
        char xxpr[61];                  /* X-axis/SLICES expression    */
        char yxpr1[61];                 /* Y-axis 1/SIZE expression    */
        char yxpr2[61];                 /* Y-axis 2/EXPLODE expression */
        char yxpr3[61];                 /* Y-axis 3 expression         */
        char yxpr4[61];                 /* Y-axis 4 expression         */
        char yxpr5[61];                 /* Y-axis 5 expression         */
   } GRF_FILE;
   
   GRF_FILE graph={0};
   int fhandle,i;
   char filename[13];
   char *types[] = {"","Bar Graph","Pie Chart","Line Graph",
                    "Scatter Plot","Step Graph","Regress Line"};
   char *colors[] = {"Black","Blue","Green","Cyan","Red","Magenta",
                     "Brown","Grey","Dark Grey","Lt Blue","Lt Green",
                     "Lt Cyan","Lt Red","Lt Magenta","Yellow","White"};
                
   if (argc < 2) {                                   /* Improper syntax */
      printf ("Usage is LSTGRF <GRFile[.EXT]> \n");
      exit();                                    
   }
      
   strcpy(filename,strupr(argv[1]));
   if (!strstr(filename,"."))           /* Concat .EXT if necessary     */
      strcat(filename,".GRF");

/******************************************************************************
* Open up the GRF file - exit if not found.                                   *
******************************************************************************/
   printf("LSTGRF.C : List .GRF settings      -    Dan Kenny/Omaha, Ne.\n");
   if ((fhandle = open(filename,O_RDONLY | O_BINARY)) == -1) {
      printf ("Can't find graph file: %s\n",filename);
      exit();
   }

/******************************************************************************
* Read settings into structure variables and close GRF file.                  *
******************************************************************************/
   read (fhandle,&graph,sizeof(graph));
   close(fhandle);

/******************************************************************************
* Print listing.....                                                          *
******************************************************************************/
   printf("-------------------------------------------------------------\n");
   printf("File: %-13s                        Type: %-13s\n",
          filename,types[graph.type]);
   printf("\nBorder/Text Color: %-11s      Background Color: %-11s\n",
          colors[graph.clrtext],colors[graph.clrbkgrd]);
   printf("\nPagetitle   : %s\n",graph.pagetitle);
   printf("Footnote    : %s\n",graph.footnote);

   if (graph.type != PIE) {                        /* X-Y graphs        */
      printf("X-axis Title: %s\n",graph.xtitle);
      printf("Y-axis Title: %s\n",graph.ytitle);
      printf("\nX-axis Expression   : %s\n",graph.xxpr);
      if (graph.numyxpr < 2) {
         printf("Y-axis Expression   : %s\n",graph.yxpr1);
         printf("\nY-axis Expression Color : %s\n",colors[graph.color1]);
      }
      else {
         for (i=1; i <= graph.numyxpr; i++)
            switch(i) {
               case 1: printf("Y-axis Expression 1 : %s\n",graph.yxpr1);
                       break;
               case 2: printf("Y-axis Expression 2 : %s\n",graph.yxpr2);
                       break;
               case 3: printf("Y-axis Expression 3 : %s\n",graph.yxpr3);
                       break;
               case 4: printf("Y-axis Expression 4 : %s\n",graph.yxpr4);
                       break;
               case 5: printf("Y-axis Expression 5 : %s\n",graph.yxpr5);
            }
         for (i=1; i <= graph.numyxpr; i++)
            switch(i) {
               case 1: printf("\nY-axis Expression 1 - Color: %s\n",
                              colors[graph.color1]);
                       break;
               case 2: printf("Y-axis Expression 2 - Color: %s\n",
                              colors[graph.color2]);
                       break;
               case 3: printf("Y-axis Expression 3 - Color: %s\n",
                              colors[graph.color3]);
                       break;
               case 4: printf("Y-axis Expression 4 - Color: %s\n",
                               colors[graph.color4]);
                       break;
               case 5: printf("Y-axis Expression 5 - Color: %s\n",
                              colors[graph.color5]);
                       break;
         }
      }
   }
   else {                                              /* PIE chart    */
      printf("\nSLICES Expression : %s\n",graph.xxpr);
      printf("SIZE Expression   : %s\n",graph.yxpr1);
      printf("EXPLODE Expression: %s\n",graph.yxpr2);
      printf("\nSlice 1  Color : %s\n",colors[graph.color1]);
      printf("Slice 2  Color : %s\n",colors[graph.color2]);
      printf("Slice 3  Color : %s\n",colors[graph.color3]);
      printf("Slice 4  Color : %s\n",colors[graph.color4]);
      printf("Slice 5  Color : %s\n",colors[graph.color5]);
      printf("Slice 6  Color : %s\n",colors[graph.color6]);
      printf("Slice 7  Color : %s\n",colors[graph.color7]);
      printf("Slice 8  Color : %s\n",colors[graph.color8]);
      printf("Slice 9  Color : %s\n",colors[graph.color9]);
      printf("Slice 10 Color : %s\n",colors[graph.color10]);
   }
}
