#include "lscmd.ch"

/*
ķ
                                                                            
 Purpose...: Demonstration of LaSer ComManD library (version 1.0)           
                                                                            
 Author....: Rmy Therrien                                                  
                                                                            
 Updated...: 07-22-93 10:22am                                               
                                                                            
 Compile...: RMAKE DEMO                                                     
                                                                            
 Copyright Unigiciel Inc. 1993                                              
                                                                            
Ľ
*/

/*
ķ
 Functions prototypes:                                                      
                                                                            
   - LS_BigPrint(cStr,nHeight,nWidth,nThick,nLineShade)                     
         Prints a string of specified characteristics                       
                                                                            
   - LS_Box(nPosY,nPosX,nHeight,nWidth,nFill,nShadow,nThick,nLineShade)     
         Prints a box of specified characteristics                          
                                                                            
   - LS_Calen(aConf,aDates)                                                 
         Prints a one month calendar with specified characteristics passed  
         in aConf.                                                          
                                                                            
   - LS_DayPlot(dDate,cTimeS,nInc,nHrs,nPosY,nPosX,nHght,nWdth,nHdL,aApp)   
         Prints a daily agenda for dDate starting at cTimeS in nInc         
         increments for a period of nHrs. You can adjust header height with 
         nHdl. aApp is an array of appointments for the day.                
                                                                            
   - LS_Fields(aFields)                                                     
         Initialise aFields with current area fields.                       
                                                                            
   - LS_Grid(aFields)                                                       
         Prints a worksheet style grid.                                     
                                                                            
   - LS_HmiVmi(nHmi,nVmi)                                                   
         Overrides default horizontal and vertical spacing for the current  
         font.                                                              
                                                                            
   - LS_LSpacing( nLine )                                                   
         Sets the number of lines per inches.                               
                                                                            
   - LS_Line(nPosY,nPosX,nHeight,nWidth,nFill)                              
         Prints a line of given specifications.                             
                                                                            
   - LS_Macro(nCommand,nMacro)                                              
         Performs macro operations which allows a set of commands to be     
         stored in and executed directly from the printer. It is possible   
         to simultaneously define up to 32 macros using nMacro. Default     
         value is 0. nCommand  can be any of the following:                 
         MAC_LEARN, MAC_ENDLEARN, MAC_EXECUTE, MAC_CALL,                    
         MAC_EVERYPAGE, MAC_SINGLECALL, MAC_DELETEALL,                      
         MAC_DELETE, MAC_PERMANENT, MAC_TEMPORARY                           
                                                                            
   - LS_Pcx(cName,lInvert,nOption,nReso)                                    
         Allows to insert a PCX graphic at current location. cName is a full
         name specification with path and the .PCX extension included.      
         lInvert will reverse the graphic. nOption can be PCX_STATUS which  
         displays a status window on the monitor and/or PCX_DIRECT which    
         send the output dirctly to the printer instead of returning a      
         string. PCX_DIRECT is mandatory for graphics that are more than    
         64K in size. nReso is the graphic resolution.                      
                                                                            
   - LS_Pos(nPosY,nPosX)                                                    
         Sets position to desired location.                                 
                                                                            
   - LS_RestFont()                                                          
         Restores a previously saved font.                                  
                                                                            
   - LS_SaveFont()                                                          
         Saves current font to temporarily use another one.                 
                                                                            
   - LS_SayInBox(nPosY,nPosX,nHeight,nWidth,cStr,nJustify,lWordWrap,nFit)   
         Allows to print a string inside a box of specified dimensions at   
         given location with options like word-wrapping and text fitting.   
         nFit ajust the fitting of text inside the boxe by a factor of      
         nFit * nPoints                                                     
                                                                            
   - LS_SetFont(nPitch,nPoints,nStyle,nStroke,nTypeFace,lProport,cSymbol)   
         Allows to set a new current font with specified characteristics    
                                                                            
   - LS_SetGrid(nPosY,nPosX,nHeight,nWidth,nFill,nShadow,nThick,nFactor)    
         Sets-up a worksheet style grid specifications                      
                                                                            
   - LS_SetUp(nComm,nSet)                                                   
         Allows to modify specific parameters like orientation, shade       
         thickness, initialisation,... nComm can be any of the following:   
         LS_ORIENTATION, LS_SHADETHICK, LS_HEADING, LS_INIT, LS_DAYS,       
         LS_MONTHS                                                          
                                                                            
   - LS_Week(aConf,aAppoint)                                                
         Prints a weekly diary using the specifications defined in the array
         aConf. It also prints the list of appointments given by the array  
         aAppoint.                                                          
                                                                            
Ķ
 Common parameters description:                                             
                                                                            
   - cStr            : text string to print.                                
                                                                            
   - nPosY, nPosX    : cursor positions in inches.                          
   - nHeight, nWidth : item size in inches.                                 
   - nThick          : line thickness in inches.                            
                                                                            
   - nLineShade      : level of shading for the lines.                      
   - nShade          : box shading level outside the box on the right side  
                       and on the bottom.                                   
   - nFill           : level of shading inside the box.                     
                                                                            
                       nLineShade, nShade and nFill can have any of the     
                       following values: SH_NOSHADE, SH_LIGHT,              
                       SH_DEMILIGHT, SH_SEMILIGHT, SH_MEDIUM, SH_SEMIDARK,  
                       SH_DEMIDARK, SH_DARK, SH_BLACK.                      
                                                                            
   - nJustify        : Justifies text. It can hold the following values :   
                       LS_LEFT, LS_CENTER, LS_RIGHT.                        
                                                                            
   - aConf           : In LS_CALEN holds the following parameters in that   
                       order: nType (0-5), nPosY, nPosX, nHeight, nWidth,   
                       nFill, nShadow, nLineShade and cTitle.               
                                                                            
                     : In LS_WEEK holds the following parameters in that    
                       order: nType (1-2), nIncre, nPosY, nPosX, nHeight,   
                       nWidth, nFill, nShadow.                              
                                                                            
   - aDates          : Contains an array of arrays to display text inside   
                       the calendar. Each sub-array contains the following: 
                       dDate, cText, nJustify, lWordWrap, nFill, nShade,    
                       nThick, nLineShade, nShrink.                         
                                                                            
   - aApp            : Is an array of arrays each containing an appointment 
                       specification. Each sub-array contains the following:
                       dDate, cTime, nDuration, cText, nJustify, lWordWrap, 
                       nFill.                                               
                                                                            
   - aFields         : Is an array of arrays each containing the            
                       characteristics of each field. Used in the worksheet 
                       printing functions. Each sub-array contains the      
                       following:                                           
                       cName, cType, nLength, nDecimals, bUser, cHeading,   
                       nJustify, lWordWrap, nFill, nShade, nThick,          
                       nLineShade.                                          
                                                                            
                                                                            
   Note: Please refer to lscmd.ch file for complete defines lists.          
Ľ
*/

cText := "LaSer ComManD is a great small library that you can use to create "+;
         "calendars, diaries, data tables and much more... Look how "+;
         "simple the code for this demo is and see the professionnal results "+;
         "it creates. This library is only 22K of pure CLIPPER 5 code, so it "+;
         "can be all overlaid. Now stay seated and see the price: 30 US$ for "+;
         "the library ; 60 US$ for the library and the source code! shipping "+;
         "and handling included. Stop waiting and register now! "+;
         "You will receive the latest version of the library."

SET DATE ANSI
SET PRINTER ON
SET CONSOLE OFF
CLEAR

// Initialisation of LS_CMD
?? LS_SetUp(LS_INIT)

// Demo Page 1 
@ 1,0 SAY "1.Printing boxes examples..."
?? LS_Pos(.8,.5)
?? LS_BigPrint("laser command",.30,.25,1/720,100)

// Boxe 0 , uses default values
?? LS_Box()

// Boxe 1
?? LS_SetFont(10)
?? LS_Box(1,.5,5.5,2,SH_SEMILIGHT,SH_MEDIUM,1/16,SH_SEMIDARK)
?? LS_SayInBox(1,.5,5.5,2,cText,LS_CENTER,.t.)

// Boxe 2
?? LS_SetFont(12)
?? LS_HmiVmi(14)
?? LS_Box(2,4,4,3,SH_DEMILIGHT,SH_LIGHT,1/32)
?? LS_SayInBox(2,4,4,3,cText,LS_RIGHT,.t.)

// Boxe 3
?? LS_SetFont(16.66)
?? LS_Box(6.5,3.5,2,4,SH_DEMILIGHT,SH_DARK,)
?? LS_SayInBox(6.5,3.5,2,4,cText,LS_LEFT,.t.)

// Boxe 4
nThick := 1/16
?? LS_HmiVmi(6)
?? LS_LSpacing(10)
?? LS_Box(7.5,1,2,2,SH_NOSHADE,SH_NOSHADE,nThick,SH_MEDIUM)
?? LS_SayInBox(7.5+nThick,1+nThick,2-2*nThick,2-2*nThick,cText,LS_CENTER,.t.)

// Boxe 5
?? LS_Box(8.75,5,1,2,SH_SEMIDARK,SH_NOSHADE,1/8,SH_SEMILIGHT)

// Boxe 6
nDist := .5
FOR i := 1 TO 6
  ?? LS_Box(.50-nDist/2,5-nDist/2,1+nDist,1+nDist,SH_NOSHADE,SH_NOSHADE,1/64/i/i)
  nDist /= 2
NEXT
nDist := .5
FOR i := 1 TO 6
  ?? LS_Box(.50+nDist/2,5+nDist/2,1-nDist,1-nDist,SH_NOSHADE,SH_NOSHADE,1/64/i/i)
  nDist /= 2
NEXT

EJECT

// Demo Page 2 
// Printing one yeay calendar
@ 2,0 SAY "2.Printing 1 year calendar..."
dDate:=CTOD(STR(YEAR(DATE()),4)+".01.01")

?? LS_Pos(.7,2.8)
?? LS_BigPrint(STR(YEAR(dDate),4),.6,1,1/16,SH_MEDIUM)

?? LS_SetUp(LS_SHADETHICK,1/16)
?? LS_Box(0,0,10,8,SH_NOSHADE,SH_NOSHADE,1/16)

k := 0
FOR j := 0 TO 3
  FOR i := 0 TO 2
    ?? LS_Calen({INT(k/2),.8+j*2.3,.4+i*2.5,2.2,2.2},dDate)
    dDate := dDate+35 - DAY(dDate+35) + 1
    k++
  NEXT
NEXT

EJECT

// Demo Page 3 
// Printng second calendar example
@ 3,0 SAY "3.Printing a two day worksheet..."
?? LS_SetUp(LS_ORIENTATION,LS_LANDSCAPE)
?? LS_SetUp(LS_DAYS , {"Sunday","Monday","Tuesday","Wednesday","Thursday","TgiF","Saterday"})

// Put weekends in gray and HI-Light current date
// Also add some events
aP     := {}
dDateB := DATE() - DAY(DATE())+ 1
dDateE := DATE()+35 - DAY(DATE()+35)+ 1
FOR i := dDateB TO dDateE -1
  cTxt     := ""
  nShadeIn := IIF(DOW(i)=1.or.DOW(i)=7,SH_SEMILIGHT,SH_NOSHADE)
  nBorder  := IIF(DAY(i)=DAY(DATE()),1/32,0)
  nShadeOut:= SH_NOSHADE
  nShrink  := 1
  DO CASE
    CASE DAY(i)=1
      cTxt := "Mom's birthday"
    CASE DAY(i)=7
      cTxt := "Meeting with Mrs Late"
    CASE DAY(i)=12
      cTxt      := "My birthday"
      nShadeOut := SH_MEDIUM
      nShrink   := .8
      nborder   := 1/128
    CASE DAY(i)=22
      cTxt := "Deadline for project A"
    CASE DAY(i)=27
      cTxt := "Golf with Robert"
  ENDCASE
  AADD(aP,{i,cTxt,LS_CENTER,.t.,nShadeIn,nShadeOut,nBorder,,nShrink})
NEXT

// Print two calendars
?? LS_Calen({2,0,.2,7.5,5.5,SH_NOSHADE,SH_MEDIUM},aP)
?? LS_Calen({2,0,6.1,2.5,4.4,SH_LIGHT,SH_DARK,SH_MEDIUM},dDateE+1)

// Add some dummy meetings
aAp := { {DATE()  ,"9:00",2,"Meeting with Suzan"},;
         {DATE()  ,"11:30",.5,"Meeting with John"},;
         {DATE()  ,"14:00",.5,"Meeting with Robert"},;
         {DATE()+1,"8:30",.5,"Meeting with Cathy"},;
         {DATE()+1,"9:30",1,"Meeting with Todd"},;
         {DATE()+1,"13:00",2,"Meeting with Helen"}}

// Plot two diary
?? LS_DayPlot(DATE()  ," 8:00",30,8,2.7,6.1,5,2.2,.8,aAp)
?? LS_DayPlot(DATE()+1," 8:00",30,8,2.7,6.1+2.3,5,2.2,.8,aAp)

EJECT


// Demo Page 4 
// Plot a full week diary
@ 4,0 SAY "4.Printing a full week diary..."
?? LS_SetUp(LS_ORIENTATION,LS_PORTRAIT)
?? LS_Week({2})

EJECT

// Demo Page 5 
// Printing boxes demo
@ 5,0 SAY "5.Printing a DBF within boxes..."

// Creating a dummy file
aDefF1Name := { "Jeff","Cathy","Sylvia","Todd","John","Helen" }
aDefS1Name := { "Peterson","Haley","Brown","Rice","Watkins","Smith"}

dbCREATE("DEMO",{{"Cl_name" ,"C",35,0},;
                 {"Cl_code" ,"C",10,0},;
                 {"Cl_YtD"  ,"N",10,2},;
                 {"Cl_Total","N",10,2};
                })

USE DEMO
FOR ii := 1 TO 4
  FOR i := 1 TO 6
    FOR j := 1 TO 6
      cRecNo := STRZERO(RECNO()+1,4)
      APPEND BLANK
      DEMO->Cl_name := aDefS1Name[j]+", "+aDefF1Name[i]
      DEMO->Cl_code := cRecNo
      DEMO->Cl_Ytd  := SQRT(VAL(SUBSTR(cRecNo,3,2))**2+VAL(RIGHT(cRecNo,1))**2)-4*VAL(RIGHT(STR(SECONDS()),1))
      DEMO->Cl_total:= SQRT(VAL(SUBSTR(cRecNo,3,2))**3+VAL(RIGHT(cRecNo,1))**3)-6*VAL(RIGHT(STR(SECONDS()),1))
   NEXT
  NEXT
NEXT
aFields := LS_Fields()

aFields[4,GD_FILL]    := {||IIF(cl_YTD<0,SH_MEDIUM,SH_NOSHADE)}

?? LS_SetFont(12)
?? LS_SetGrid(0,1,2.5,6,SH_LIGHT,SH_DEMIDARK)
dbGOTOP()
FOR i := 1 TO 9
  ?? LS_Grid(aFields)
  SKIP
NEXT

aFields[1,GD_USER]   := {||IIF(RECNO()%4=0,LS_SetFont(,,FT_ITALIC),"")}
aFields[1,GD_LENGTH] := 10
aFields[1,GD_JUSTIFY]:= LS_LEFT
aFields[2,GD_JUSTIFY]:= LS_CENTER
aFields[3,GD_USER]   := {||IIF(RECNO()%4=0,LS_SetFont(,,FT_UPRIGHT),"")}

?? LS_SetFont(10)
?? LS_LSPacing(6)
?? LS_SetGrid(3,2,3.6,4.94,,SH_NOSHADE,1/16,2)
FOR i := 1 TO 5
  ?? LS_Grid(aFields)
  SKIP
NEXT

aFields[1,GD_HEADING] := "Client name"
aFields[2,GD_HEADING] := "Account#"
aFields[3,GD_HEADING] := "Year to Date"
aFields[4,GD_HEADING] := "TOTAL"
aFields[1,GD_LENGTH]  := 20
aFields[1,GD_JUSTIFY] := LS_RIGHT
aFields[2,GD_JUSTIFY] := LS_CENTER
?? LS_SetFont(16.66)
?? LS_SetGrid(7,1,2.4,5,SH_NOSHADE,SH_NOSHADE,0,1.5)
FOR i := 1 TO 10
  ?? LS_Grid(aFields)
  SKIP
NEXT

EJECT

// 
// Macro example
@ 6,0 SAY "6.Learning invoice macro..."

// Start learning how to create invoice overlay
?? LS_Macro(MAC_LEARN)

// Company Logo & address
?? LS_Pos(.24,.50)
?? LS_Pcx("UNIGI.PCX",.t.,PCX_STATUS,300)
FOR i := 0 TO 4
  ?? LS_Line(.25+i/8,2.1,1/200,2.25)
NEXT
?? LS_Line(.25+5/8,1.25,1/200,3.10)
?? LS_Line(.25+6/8,1.25,1/200,3.10)
?? LS_Line(.25+7/8,1.15,1/200,3.20)
?? LS_SetFont(16.66)
?? LS_LSpacing(8)
?? LS_SayInBox(1.2,.50,3,2,"800 Boul. Chomedey;Suite A-290;Laval Qubec  H7V 3Y4",LS_LEFT,.f.)

// Boxe with Date,Page# & Invoice #
?? LS_SetFont(12)
?? LS_LSpacing(6)
?? LS_Box(.75,5,1,2.5,SH_DEMILIGHT,SH_NOSHADE,1/32,SH_SEMIDARK)
?? LS_Line(1.20,5,1/32,2.5,SH_SEMIDARK)
?? LS_Pos( .95 ,5.45) + "Date"
?? LS_Pos( .95 ,6.7) + "Page"
?? LS_Pos(1.45 ,5.65) + "Invoice Number"

// Ship to and Sold To boxes
?? LS_Pos(2.4,.50) + "Sold to:"
?? LS_Pos(2.4,4.25)   + "Ship to:"
?? LS_Box(2.5,.50,1,3.25) + LS_Box(2.5,4.25,1,3.25)

// Body of the invoice
?? LS_Box(4,.50,.25,7,SH_DEMILIGHT,SH_NOSHADE)
?? LS_Box(4,.50,4.75,7)
for i := 1 to 9
  ?? LS_Line(4+i*.50,.50,.25,7,SH_LIGHT)
next

?? LS_Line(4,1.25,4.75,1/128)
?? LS_SayInBox(4,.5,.25,.75,"Item N",LS_CENTER)

?? LS_Line(4,2   ,4.75,1/128)
?? LS_SayInBox(4,1.25,.25,.75,"Qty.")

?? LS_Line(4,5   ,4.75,1/128)
?? LS_SayInBox(4,2,.25,3,"Description")

?? LS_Line(4.25,5   ,4.50,.50,SH_LIGHT)
?? LS_SayInBox(4,5,.25,.5,"%")

?? LS_Line(4,5.50,4.75,1/128)
?? LS_Line(4,6.50,4.75,1/128)
?? LS_SayInBox(4,5.5,.25,1,"Unit Price")
?? LS_SayInBox(4,6.5,.25,1,"Amount")

// Bottom boxe with comments and invoce TOTAL
?? LS_Box(9,.5,.75,7+.125,SH_DEMILIGHT,SH_NOSHADE,1/32)
?? LS_Line(9,5.50,.75,1/32)
?? LS_Pos(9.2,.60) + "Comments:"
?? LS_SetFont(10)
?? LS_Pos(9.4,5.60)+ "TOTAL (US)"

// Ok, Stop learning macro #0
?? LS_Macro(MAC_ENDLEARN)
// Make permanet
?? LS_Macro(MAC_PERMANENT)

// Demo Page 6 
// Print a blank overlay
@ 7,0 SAY "7.Printing a blank invoice..."
?? LS_Macro(MAC_CALL)
EJECT

// Demo Page 7 
// Print a blank overlay
@ 8,0 SAY "7.Printing invoice with data..."

// Print overlay With DATA
?? LS_Macro(MAC_CALL)

?? LS_SetFont(10,,FT_UPRIGHT,FT_BOLD)
?? LS_Pos(1.1 ,5.2) + DTOC(DATE())               // Date
?? LS_Pos(1.1 ,6.8) + "1"                        // Page #
?? LS_Pos(1.60 ,5.8) + "93-000234"               // Invoice Number

// Sold To
cShipTo := "Brian McTigue;2280 Lincoln blvd.;Boston MA 43768"
cSoldTo := "MULTIWARE INC.;A/S Brian McTigue;4232 St-Charles Hgwy;Boston MA 43654"

?? LS_SayInBox(2.5, .50,1,3.25,cSoldTo,LS_LEFT)
?? LS_SayInBox(2.5,4.25,1,3.25,cShipTo)

// Sold What
i = 1
  ?? Ls_Pos(4.20+i*.50,1.5) + "1"
  ?? Ls_SayInBox(4+i*.50,2,2,3,"LaSer ComManD version 1.0",,.t.)
  ?? Ls_Pos(4.20+i*.50,5.8) +" 30.00"
  ?? Ls_Pos(4.20+i*.50,6.8) +" 30.00"

i = 2
  ?? Ls_Pos(4.20+i*.50,1.5) + "1"
  ?? Ls_SayInBox(4+i*.50,2,2,3,"LaSer ComManD version 1.0 with Source Code")
  ?? Ls_Pos(4.20+i*.50,5.8) +" 60.00"
  ?? Ls_Pos(4.20+i*.50,6.8) +" 60.00"

i = 8
  ?? Ls_SayInBox(4+i*.50,2,2,3,"Shipping and handling",LS_RIGHT)
  ?? Ls_Pos(4.20+i*.50,5.8) +"  0.00"
  ?? Ls_Pos(4.20+i*.50,6.8) +"  0.00"

//Total
?? Ls_Pos(9.4,6.8) +" 90.00"
EJECT

// That's all folks 



