/*
ͻ
 Program.....: DEMOLAND.PRG                                                   
                                                                              
 System......: HP LaserJet Series II / PCL print driver                       
                                                                              
 Author......: Kevin Loucks                                                   
             : Box 15303                                                      
             : Minneapolis  MN  55415-0303                                    
             :                                                                
             : (612) 871-9461                                                 
             :                                                                
             : CI$ 76276,1333                                                 
                                                                              
Copyright....: (c) 1992, Kevin Loucks   All rights reserved                   
                                                                              
Last modified: 01/02/92     10:12                                             
                                                                              
 Purpose.....: Demonstrates full page print procedures and line graphics      
             : functions on HP LaserJet Series II printer using LJPRTII       
                                                                              
                                                                              
 Parameters..: none                                                           
                                                                              
                                                                              
 Req Hardware: HP LaserJet Series II Printer or fully PCL 4 compatible Laser  
             : Printer - I haven't had the opportunity to test this on the    
             : HP LaserJet Series III Printers - its supposed to be fully     
             : compatible but you can never tell.                             
                                                                              
 Req Software: Clipper 5.01, Rtlink 3.13                                      
                                                                              
 Compilation.: Clipper DEMOPRT /A /M /N /P /W                                 
                                                                              
 Link........: RTLINK fi DEMOPRT,LJPRTII lib Clipper, extend                  
                                                                              
ͼ
*
The fine print.

I hold the copyright to this product ( LJPRTII.OBJ) - ITS NOT PUBLIC DOMAIN.

You are licensed to use this for as long as you want to do whatever pleases you.

As long as:

    1. You dont try to sell it to anybody. It isn't yours to sell.

       ++ see below

    2. You don't try to change anything about this product.


    3. You are using this product solely at your own risk - without the
       source code - caveat emptor!


If you want the source code for LJPRTII.OBJ (approx 800-900 lines)  thats easy.

Just send me $39.00. ( or pay my current CI$ bill <g> )

send that check or money order payable in US DOLLARS to:

    KEVIN LOUCKS
    BOX 15303
    MINNEAPOLIS  MN  55415-0303

in return you will receive a 3.5 or 5.25 (please specify) diskette with the
current source, object, bat, samples, etc files and any documentation that
exists.

Having the source code means you could change this program to do whatever you
like, except sell, lease, give, or distribute this as a stand alone module
(its just fine to link it into your own application and distribute that)
without my written permission and the appropriate $$$.  Call me!

Any suggestions, complaints or defects - Call Me at 612-871-9461 or write
to the above address of contact me via Email on Compuserve CI$ 76276,1333.
I'll be happy to entertain any suggestions you may offer for improvement.


There ARE BETTER PRODUCTS on the market - if you need a full featured
product to handle your PCL 4 printer try ESCAPE from Pinacle Publishing
- if you want to learn about this stuff inexpensively
- send me the $39 for the source code


**
Code Conventions: (more or less Hungarian notation)ͻ
                                                                              
     Type Prefixes       State Qualifiers              Qualifier Tags         
       
 a = Array          new  = new state               alias = alias              
 b = code Block     sav  = saved                   attr  = attribute          
 c = Character      tem  = temporary               arr   = array              
 d = Date           src  = source/original         area  = area               
 h = Handle         dest = destination/receiving   clr   = color              
 l = Logical        f    = first as in fname       crs   = cursor             
 n = Numeric        l    = last as in lname        dbf   = database           
 o = Object                                        file  = any file           
 u = Undetermined                                  fld   = field              
                                                   msg   = message            
Ŀ name  = any type name      
                                                  ntx   = index              
 Type Prefix   - a single lowercase character     ord   = order              
                 defining the variable type       rec   = record             
                                                  ret   = return value       
 State tag     - the state of the variable        scr   = screen             
                                                  str   = string             
 Qualifier tag - Represents the variable          t     = top                
                 description. Should normally be  l     = left               
                 no longer than 3 or 4 characters b     = bottom             
                                                  r     = right              
Ĵ row   = row                
 I do adhere to this (more or less).              col   = column             
                                                  win   = window             
                                                  y     = row                
                                                  x     = column             
                                                                             
ͼ
ͻ
 DEFINITIONS:                                                                 
                                                                              
           PCL = Printer Control Language - HP's way of talking to a printer  
          Dots = 1/300th of an inch                                           
    Decipoints = 1/720th of an inch                                           
                                                                              
        X axis = can be measured in Dots, Decipoints, Inches or Columns       
        Y axis = can be measures in Dots, Decipoints, Inches or Rows          
                                                                              
                                                                             
                                                                             
                                                                             
                   Y                                                          
                                                                             
                                                                             
                  .X                                             
                                                                             
                                                                              
                                                                              
  For more detailed information about HP PCL and the HP LaserJet Series II    
  see the LaserJet Series II Printer Technical Reference Manual part          
  number 33440-90905. Or you may want the HP LaserJet IID Technical Reference 
  Manual, Part number 33447-90905. Or for a REAL soporific you could order    
  the HP LaserJet III Technical Reference Manual, part number 33449-90903.    
  They cost between $20 and $30 PLUS shipping and handling direct direct      
  from HP Personal Peripherals Assist Line  1-208-323-2551                    
                                                                              
                                                                              
ͼ
*/
//
#include "Set.ch"
#include "LJPRTII.CH"

FUNCTION Main()
   local lConsole, cDevice, lPrinter

   local nX := 4.5

   // if you want to see how stuff gets to the printer uncomment the next line
   // set printer to ljprtII.prn

       @ 0, 0 clear

       @ 0, 0, maxrow(), maxcol() box replicate(chr(176),9)

       @ 0, 0 say "Mode Execute Ready" color "R*/w"   // thanks andrew

       inkey(3)

       @ 3,10 say "reseting & Initializing printer"

       LJ_Reset()

       LJ_PaprSrc( UPPER_TRAY )   //  OPTIONAL if you only have 1 tray
       LJ_Orient( LANDSCAPE )
   //  LJ_PgSz( A4 )                  //  select size of paper
   //  LJ_PgSz( LEGAL  )              //  select size of paper
       LJ_PgSz( LETTER )              //  select size of paper

   // set print to Normal / 10 cpi mode
       LJ_Send( LJ_Font(BASE_LANDSCAPE_10_CPI) )
       LJ_Status( CPI,10 )

       @ 5,10 say "Printing Form Graphics/Boxes"

   /*  please notice I did not "SET PRINT ON" or "DEVICE TO" or any thing
       let the LJ_ routines handle that for you.
       you will want to do those things when directly accessing the printer
       with @ x,y say ... Get, or ?/?? commands  ++ see below
   */

   // ship to box
       LJ_Box( INCHES,  0.04, .25 ,1.32, 4.2,   0.02, SHADED_FILL, 100)

   //  sold to box
       LJ_Line( ROWCOL,10.2, 2.5, 40,   9, SHADED_FILL, 10)

   //  invoice Header info  box
       LJ_Box( INCHES, 1.70 , 4.5, 3.20, 7.98,  0.018, 2, 100)

       // HORIZONTAL LINES - top to bottom 1 - 8
       LJ_Line( INCHES,  1.86,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 1
       LJ_Line( INCHES,  2.04,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 2
       LJ_Line( INCHES,  2.20,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 3
       LJ_Line( INCHES,  2.34,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 4
       LJ_Line( INCHES,  2.51,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 5
       LJ_Line( INCHES,  2.67,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 6
       LJ_Line( INCHES,  2.86,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 7
       LJ_Line( INCHES,  3.01,  nX,    3.5, 0.002, SOLID_FILL, 100 )   // line 8

       // VERTICAL LINES  left to right 1 - 4
       LJ_Line( INCHES,  2.67,  5.3,   0.003,  0.55, SOLID_FILL, 100 )  // line 1
       LJ_Line( INCHES,  1.70,  5.75,  0.003,  1.50, SOLID_FILL, 100 )  // line 2
       LJ_Line( INCHES,  2.67,  6.25,  0.003,  0.34, SOLID_FILL, 100 )  // line 3
       LJ_Line( INCHES,  1.70,  7.15,  0.003,  0.35, SOLID_FILL, 100 )  // line 4

       // SHADED HORIZONTAL LINES - top to bottom 1 - 5
       LJ_Line( INCHES,  1.70,  nX,      3.5, 0.167, SHADED_FILL, 10 ) // line 1
       LJ_Line( INCHES,  2.04,  nX,      3.5, 0.166, SHADED_FILL, 10 ) // line 2
       LJ_Line( INCHES,  2.340, nX,      3.5, 0.166, SHADED_FILL, 10 ) // line 3
       LJ_Line( INCHES,  2.670, nX,      0.8, 0.55 , SHADED_FILL, 10 ) // line 4
       LJ_LINE( INCHES,  2.670, nX+1.25, 0.5, 0.33 , SHADED_FILL, 10 ) // line 5

*
*   i didn't get around to this  - its not hard all you need is a ruler and
*   a calculator and some time
*
*   think of it as homework
*
*   now remember you're in landscape mode the page is now 11" x 8 1/2"
*   NOT 8 1/2" x 11" so any thing that positions itself at a Y axis point
*   greater than 8" (either explicitly or implicitly) will not work
*
*   the brute, trial and error method for making these lines work and modifying
*   them would be to uncomment 1 at a time link and print until you've got
*   it right  or you could review the documentation above and calculate
*   the changes and do it all in one swell foop. good luck.
*
*  //  box 4 Detail Info
*
*      LJ_Box( INCHES, 3.35, 0.0, 3.52, 5.0,  0.015, SHADED_FILL, 100 )
*      LJ_Box( INCHES, 3.53, 0.0, 8.78, 7.97, 0.015, SHADED_FILL, 100 )
*
*      LJ_Line( INCHES, 3.35, 0.0,  1.0, 0.166, SHADED_FILL, 10 )
*      LJ_Line( INCHES, 3.53, 0.0, 7.98, 0.166, SHADED_FILL, 10 )
*
*      LJ_Line( INCHES, 3.68, 0.0,   8.0,   0.002, SOLID_FILL, 100 )
*      LJ_Line( INCHES, 3.53, 0.55,  0.003, 5.25,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 3.53, 1.64,  0.003, 5.25,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 3.53, 5.735, 0.003, 5.25,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 3.53, 6.60,  0.003, 5.25,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 3.53, 6.95,  0.003, 5.25,  SOLID_FILL, 100 )
*
*
*  //  invoice totals / summary box
*
*      LJ_Box(  INCHES, 8.84, 0.0,   9.50, 7.98,  0.015, SOLID_FILL, 100 )
*      LJ_Box(  INCHES, 8.84, 6.5,   9.48, 7.96,  0.035, SOLID_FILL, 100 )
*
*      LJ_Line( INCHES, 8.84, 0.0,   8.0,  0.350,  SHADED_FILL, 15 )
*
*      LJ_Line( INCHES, 9.19, 0.0,   8.0,   0.002, SOLID_FILL, 100 )
*      LJ_Line( INCHES, 8.84, 1.455, 0.003, 0.68,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 8.84, 2.84,  0.003, 0.68,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 8.84, 3.5,   0.003, 0.68,  SOLID_FILL, 100 )
*      LJ_Line( INCHES, 8.84, 4.78,  0.003, 0.68,  SOLID_FILL, 100 )

   @ 7,10 say "Printing Form Text"
   // set print to Compressed / 16.66 cpi mode

       LJ_Send( LJ_Font(BASE_LANDSCAPE_16_CPI) )
       LJ_Status( CPI,16.66 )

   //  invoice Header info  TEXT
       LJ_SayYX( ROWCOL, 11, 80, "Invoice Date     Invoice Number              Page  ")
       LJ_SayYX( ROWCOL, 13, 80, "Our Order #      Your Order #")
       LJ_SayYX( ROWCOL, 15, 80, "Account No.      Sales Rep   ")
       LJ_SayYX( ROWCOL, 17, 77, "Taxable %           Terms:      ")
       LJ_SayYX( ROWCOL, 18, 77, "Our Truck           F.O.B.")
       LJ_SayYX( ROWCOL, 19, 77, "Ship Via                 ")
       LJ_SayYX( ROWCOL, 21, 1,  "Job Description:")
       LJ_SayYX( ROWCOL, 22, 1,  "Prd Code       Quantity      Description")
       LJ_SayYX( ROWCOL, 22, 99, "Unit Price  Per      Extension")

   // set print to Normal / 10 cpi mode

       LJ_Send( LJ_Font(BASE_LANDSCAPE_10_CPI) )
       LJ_Status( CPI,10 )

       LJ_SayYX( ROWCOL,  1,  3, "Ship To:" )
       LJ_SayYX( ROWCOL, 11,  3, "Sold To:" )
       LJ_SayYX( ROWCOL,  0, 29, "R O U G H   D R A F T   I N V O I C E")
       LJ_SayYX( ROWCOL, 42,  3, "Total of")
       LJ_SayYX( ROWCOL, 42, 19, "Taxable" )
       LJ_SayYX( ROWCOL, 43,  2, "Merchandise")
       LJ_SayYX( ROWCOL, 43, 16, "Merchandise")
       LJ_SayYX( ROWCOL, 43, 30, "TAX %")
       LJ_SayYX( ROWCOL, 43, 37, "Sales Tax")
       LJ_SayYX( ROWCOL, 43, 48, "Shipping/Handling")
       LJ_SayYX( ROWCOL, 43, 68, "AMOUNT DUE")
       LJ_SayYX( ROWCOL, 45, 28, "Thank You For Your Business!")
*      LJ_SayYX( ROWCOL, 60,  2, "[Original]")

   @ 9,10 say "Printing Form Debugging Marks"

   // FORM DEBUGGING MARKS - DELETE THESE BEFORE PUTTING CODE INTO PRODUCTION

       LJ_SayYX(ROWCOL,0,0,"")
       LJ_SayYX(ROWCOL,0,40,"")
       LJ_SayYX(ROWCOL,0,79,"")
       LJ_SayYX(ROWCOL,45,0,"")
       LJ_SayYX(ROWCOL,45,40,"")
       LJ_SayYX(ROWCOL,45,79,"")
   *
   // AND now back to DEFAULT/CLIPPER print formatting

      LJ_SayYX(ROWCOL,0,0," ")          // reset print cursor to row 0, col 0

   @ 11,10 say "Form Completed!"


   lConsole := set(_SET_CONSOLE, .F.)        // SET CONSOLE OFF
   cDevice  := set(_SET_DEVICE , "PRINTER")  // SET DEVICE TO PRINTER
   lPrinter := set(_SET_PRINTER, .T.)        // SET PRINTER ON

   @  1,47 say "Kevin Loucks"
   @  2,47 say "Box 15303   "
   @  3,47 say "Minneapolis  MN  55415-0303"
   @  5,47 say "(612) 871-9461"
   @  7,47 say "CI$ - 76276,1333"


   @ 11,47 SAY DATE() PICTURE "@D"
   @ 12, 5 say "Your Clients Name Here"
   @ 13, 5 say "Your Clients Title Here"
   @ 14, 5 say "Secondary Address Line Here"
   @ 15, 5 say "Primary Address Line Here"
   @ 15,46 SAY "91-06-0009"

   @ 16, 5 say "City, State Zip Line Here"

   @ 22, 1 SAY "OBJ"
   @ 22,10 SAY "1"
   @ 22,17 SAY "LaserJet Full Page print object module "
   @ 22,60 SAY "36.00"
   @ 22,67 SAY "EA"
   @ 22,74 SAY "36.00"

   @ 23,17 SAY "Version 1.1"

   @ 30,17 SAY "Via @ X,Y say syntax: ->"
   @ 43, 2 SAY "$   36.00"
   @ 43,18 SAY "$   36.00"
   @ 43,30 SAY "6.50"
   @ 43,40 SAY "none  "
   @ 43,56 SAY "$ 3.00"
   @ 43,70 SAY "$ 39.00"

   set(_SET_DEVICE,  cDevice )       // Restore device  setting
   set(_SET_PRINTER, lPrinter)       // Restore printer setting
   set(_SET_CONSOLE, lConsole)       // Restore console setting

   LJ_SayYX( ROWCOL, 31, 41, "<- via lj_sayYx function")

   @ 15,10 say "Reseting Printer!      -  Please Wait."

   lj_reset()                 //reset printer

   @ 17,10 say "All Done!"
   @ 22,20 say "Thanks For All The Fish!" color "R*/w"
   @ 23, 0 say " "

   return NIL
