***********************************
*  NAME:       LJMACRO.PRG
*  DATE:       2/12/89
*  NOTICE:     Copyright 1989, Clifford Green
*  RELEASE:    Clipper Summer '87
*
*  A sample program for managing
*     laserjet macros and overlays.
*
*  This program sample is intended only
*     as an educational adjunct for Clipper
*     programmers beginning to explore the
*     programmability of the Hewlett-Packard
*     LaserJet family of printers.
*  No warrantability or utility is implied
*     or intended, other than the above-
*     mentioned educational purpose.
*  If any snippets of this code are to be used,
*     you would be well-advised to make sure
*     adequate validation and consistency 
*     checks are included.  If you screw up,
*     don't blame it on this hack.
*

***********************************
*  This program assumes the use of a .DBF file
*     called MACRO.DBF, with a file structure
*     consisting of:
*
*        NAME     C   15
*        CONTENTS M   10
*

DECLARE mac_type[3]
mac_type[1] = "Execute"
mac_type[2] = "Call"
mac_type[3] = "Overlay"

esc = chr(27)

CLEAR
USE MACRO
maccount = LASTREC()
DECLARE MACPICK[maccount]
GO TOP
FOR X = 1 TO maccount
   macpick[x] = MACRO->NAME
   SKIP
NEXT
SAVE SCREEN
@ 10,40 CLEAR TO 17,57
@ 10,40 TO 17,57 DOUBLE
ID = ACHOICE(11,41,16,56,macpick)
RESTORE SCREEN
GOTO ID         && As a side-effect, each record number becomes an ID number
Macro_ID(ID)
Start_mac(ID)
Defmac(CONTENTS)
End_mac(ID)
SAVE SCREEN
@ 10,45 CLEAR TO 14,53
@ 10,45 TO 14,53 DOUBLE
TYPE = ACHOICE(11,46,13,52,mac_type)
RESTORE SCREEN
invoke_mac(TYPE)


****
*  Macro_ID - This assigns an ID number to the subsequent macro
*
*
FUNCTION Macro_ID
PARAMETER id_num
IF PCOUNT() = 1
   SET PRINT ON
   SET CONSOLE OFF
   ?? esc+"&f"+LTRIM(STR(id_num))+"Y"
   SET PRINT OFF
   SET CONSOLE ON
ELSE
   err_buff = SAVESCREEN(22,10,25,69)
   @ 22,10 CLEAR TO 25,69
   @ 22,10 TO 25,69 DOUBLE
   err_col = SETCOLOR("W*/N")
   @ 23,18 SAY "You MUST pass an ID number to this function"
   SETCOLOR(err_col)
   @ 24,25 SAY "press any key to continue..."
   value = INKEY(0)
   RESTSCREEN(22,10,25,69,err_buff)
ENDIF
RETURN (.T.)


****
*  Def_mac - This is used to mark the beginning of the definition of a macro
*
*
FUNCTION Def_mac
SET CONSOLE OFF
SET PRINT ON
?? esc+"&f0X"
SET PRINT OFF
SET CONSOLE ON
RETURN (.T.)


******************************
*  An alternate form of the above, which includes the ID number:
*  FUNCTION Def_mac
*  PARAMETER Id
*  SET CONSOLE OFF
*  SET PRINT ON
*  ?? esc+"&f"+LTRIM(STR(Id))+"y0X"
*  SET PRINT OFF
*  SET CONSOLE ON
*  RETURN(.T.)
******************************


****
*  End_mac - This is used to signify the end of a macro's definition
*
*
FUNCTION End_mac
SET CONSOLE OFF
SET PRINT ON
?? esc+"&f1X"
SET PRINT OFF
SET CONSOLE ON
RETURN(.T.)


****
*  Invoke_mac - This is used, with the parameter passed, to decide whether
*  the macro is invoked as an Execution, Call, or Overlay
*
*
FUNCTION Invoke_mac
** This is also a model for the general form of a laserjet macro function
PARAMETER Type
SET CONSOLE OFF
SET PRINT ON
?? esc+"&f"+LTRIM(STR(Type))+"X
SET PRINT OFF
SET CONSOLE ON
RETURN(.T.)


****
*  Def_mac - This is used to actually pass the definition of the macro to
*  the printer.  An alternate would be to !COPY filename.ext/b for those
*  cases where the macro has been saved in an external text file
*
*
FUNCTION Def_mac
PARAMETER Macro
SET CONSOLE OFF
SET PRINT ON
**    Be careful here.  If you use a memo field, it will come through
**    formatted;  any text formatting may not be what you want.
?? Macro
SET PRINT OFF
SET CONSOLE ON
RETURN(.T.)
