*  Font39LandDownload sub.

* This group of routines with the function Code39 defines the 128
* characters of the Code 39 barcode set, and downloads them to the HP
* Laserjet II printer as an alternate character set.  This character
* set is for use in the landscape mode only.  The printer is reset by
* the function DownFont39, and landscape mode is then selected, the
* font set is then formated, and downloaded.  The function Code39 is
* used to toggle between Code 39 and normal text sent to the printer.

* Note:	This code does not check printer ready status (online,paper,etc).

* Clipper S-87   - Kent Walker, April, 1990

* Previous versions:

* PowerBASIC 2.0 - Walter Haase
* QuickBASIC 4.5 - Kevin Fong
* TurboBASIC 1.1 - Walter Haase
* TurboBASIC 1.0 - Kent Walker



******************************************************************

** Demo starts here...

SET PRINT ON
SET CONSOLE OFF

DownFont39()                                     && download fonts to the HPLJ-II printer

?  CHR(27)+")1X"                                 && select Code 39 as secondary font
?? CHR(15)                                       && select characters from primary font
?                                                && do a blank line
?? Code39("THIS IS A TEST")                      && print some Code 39 stuff for test
?                                                && do a blank line
?  "THIS IS A TEST"                              && print some ASCII text for test
?? CHR(12)                                       && eject the page

SET PRINT OFF
SET CONSOLE ON

RETURN                                           && return to calling program

** End of demo....

******************************************************************

FUNCTION DownFont39

  PRIVATE AX,BX,CX,DX

  ?? CHR(27)+"E"                                 && reset the printer
  ?? CHR(27)+"&l1O"                              && select landscape mode
  ?? CHR(27)+"*c0F"                              && delete all current soft fonts
  ?? CHR(27)+"*c1D"                              && select font #1 for definition
  ?? CHR(27)+")s64W"                             && issue descriptor command

  * build font descriptor block (fixed-length of 64 bytes, reserved bytes
  * are set to null)

  ?? CHR(0)                                      && byte 0 is null
  ?? CHR(64)                                     && set font descriptor size (64 bytes)
  ?? CHR(0)                                      && reserved  - 1 byte
  ?? CHR(0)                                      && set font type to 7 bit (default)
  ?? CHR(0)+CHR(000)                             && reserved  - 2 bytes
  ?? CHR(0)+CHR(050)                             && set baseline distance (12/72*300=32h)
  ?? CHR(0)+CHR(255)                             && set cell width  (255d)
  ?? CHR(0)+CHR(255)                             && set cell height (255d)
  ?? CHR(1)                                      && set orientation to landscape
  ?? CHR(0)                                      && set spacing to fixed (default)
  ?? CHR(0)+CHR(025)                             && set symbol set to Code 39
  ?? CHR(1)+CHR(004)                             && set pitch 4.6 cpi (26/120*1200=104h)
  ?? CHR(1)+CHR(096)                             && set height 21.1 (21/72*1200=160h)
  ?? CHR(0)+CHR(000)                             && set xHeight (HPLJ ignores)
  ?? CHR(0)                                      && set width type (HPLJ ignores)
  ?? CHR(0)                                      && set style to upright (0, 1 is Italic)
  ?? CHR(0)                                      && set stroke weight medium (-7 to +7)
  ?? CHR(0)                                      && set typeface (default)
  ?? CHR(0)                                      && reserved - 1 byte
  ?? CHR(0)                                      && set Serif style (HPLJ ignores)
  ?? CHR(0)+CHR(0)                               && reserved - 2 bytes
  ?? CHR(0)                                      && set underline distance (default)
  ?? CHR(0)                                      && set underline height (HPLJ ignores)
  ?? CHR(0)+CHR(0)                               && set text height (HPLJ ignores)
  ?? CHR(0)+CHR(0)                               && set text width (HPLJ ignores)
  ?? REPLICATE(CHR(0),4)                         && reserved - 4 bytes
  ?? CHR(0)                                      && set pitch extended  (default)
  ?? CHR(0)                                      && set height extended (default)
  ?? REPLICATE(CHR(0),6)                         && reserved - 6 bytes
  ?? "CODE 39         "                          && issue font name (16 bytes padded)

                                                 && end of font descriptor block

                                                 && below are listed the four combinations of wid/narrow bar/space masks
                                                 && used in the 128 character Code 39 set

  AX=1                                           && define narrow bar, narrow space mask
  BX=2                                           && define narrow bar, wide space mask
  CX=3                                           && define wide bar, narrow space mask
  DX=4                                           && define wide bar, wide space mask

                                                 && define 128 character set masks, and perform character format

  Fmt39(  0,AX,BX,BX,BX,AX,DX,AX,AX,AX,CX)       && 0   NUL	(%U)
  Fmt39(  1,BX,BX,BX,AX,AX,CX,AX,BX,AX,CX)       && 1   SOH	($A)
  Fmt39(  2,BX,BX,BX,AX,AX,AX,CX,BX,AX,CX)       && 2   STX	($B)
  Fmt39(  3,BX,BX,BX,AX,AX,CX,CX,BX,AX,AX)       && 3   ETX	($C)
  Fmt39(  4,BX,BX,BX,AX,AX,AX,AX,DX,AX,CX)       && 4   EOT	($D)
  Fmt39(  5,BX,BX,BX,AX,AX,CX,AX,DX,AX,AX)       && 5   ENQ	($E)
  Fmt39(  6,BX,BX,BX,AX,AX,AX,CX,DX,AX,AX)       && 6   ACK	($F)
  Fmt39(  7,BX,BX,BX,AX,AX,AX,AX,BX,CX,CX)       && 7   BEL	($G)
  Fmt39(  8,BX,BX,BX,AX,AX,CX,AX,BX,CX,AX)       && 8   BS		($H)
  Fmt39(  9,BX,BX,BX,AX,AX,AX,CX,BX,CX,AX)       && 9   HT		($I)
  Fmt39( 10,BX,BX,BX,AX,AX,AX,AX,DX,CX,AX)       && 10  LF		($J)
  Fmt39( 11,BX,BX,BX,AX,AX,CX,AX,AX,BX,CX)       && 11  VT		($K)
  Fmt39( 12,BX,BX,BX,AX,AX,AX,CX,AX,BX,CX)       && 12  FF		($L)
  Fmt39( 13,BX,BX,BX,AX,AX,CX,CX,AX,BX,AX)       && 13  CR		($M)
  Fmt39( 14,BX,BX,BX,AX,AX,AX,AX,CX,BX,CX)       && 14  SO		($N)
  Fmt39( 15,BX,BX,BX,AX,AX,CX,AX,CX,BX,AX)       && 15  SI		($O)
  Fmt39( 16,BX,BX,BX,AX,AX,AX,CX,CX,BX,AX)       && 16  DLE	($P)
  Fmt39( 17,BX,BX,BX,AX,AX,AX,AX,AX,DX,CX)       && 17  DC1	($Q)
  Fmt39( 18,BX,BX,BX,AX,AX,CX,AX,AX,DX,AX)       && 18  DC2	($R)
  Fmt39( 19,BX,BX,BX,AX,AX,AX,CX,AX,DX,AX)       && 19  DC3	($S)
  Fmt39( 20,BX,BX,BX,AX,AX,AX,AX,CX,DX,AX)       && 20  DC4	($T)
  Fmt39( 21,BX,BX,BX,AX,AX,DX,AX,AX,AX,CX)       && 21  NAK	($U)
  Fmt39( 22,BX,BX,BX,AX,AX,BX,CX,AX,AX,CX)       && 22  SYN	($V)
  Fmt39( 23,BX,BX,BX,AX,AX,DX,CX,AX,AX,AX)       && 23  ETB	($W)
  Fmt39( 24,BX,BX,BX,AX,AX,BX,AX,CX,AX,CX)       && 24  CAN	($X)
  Fmt39( 25,BX,BX,BX,AX,AX,DX,AX,CX,AX,AX)       && 25  EM 	($Y)
  Fmt39( 26,BX,BX,BX,AX,AX,BX,CX,CX,AX,AX)       && 26  SUB	($Z)
  Fmt39( 27,AX,BX,BX,BX,AX,CX,AX,BX,AX,CX)       && 27  ESC	(%A)
  Fmt39( 28,AX,BX,BX,BX,AX,AX,CX,BX,AX,CX)       && 28  FS		(%B)
  Fmt39( 29,AX,BX,BX,BX,AX,CX,CX,BX,AX,AX)       && 29  GS		(%C)
  Fmt39( 30,AX,BX,BX,BX,AX,AX,AX,DX,AX,CX)       && 30  RS		(%D)
  Fmt39( 31,AX,BX,BX,BX,AX,CX,AX,DX,AX,AX)       && 31  US		(%E)
  Fmt39( 32,0 ,0 ,0 ,0 ,0 ,BX,CX,AX,CX,AX)       && 32  SPACE
  Fmt39( 33,BX,BX,AX,BX,AX,CX,AX,BX,AX,CX)       && 33  !			(/A)
  Fmt39( 34,BX,BX,AX,BX,AX,AX,CX,BX,AX,CX)       && 34  "			(/B)
  Fmt39( 35,BX,BX,AX,BX,AX,CX,CX,BX,AX,AX)       && 35  #			(/C)
  Fmt39( 36,0 ,0 ,0 ,0 ,0 ,BX,BX,BX,AX,AX)       && 36  $
  Fmt39( 37,0 ,0 ,0 ,0 ,0 ,AX,BX,BX,BX,AX)       && 37  %
  Fmt39( 38,BX,BX,AX,BX,AX,AX,CX,DX,AX,AX)       && 38  &	 	(/F)
  Fmt39( 39,BX,BX,AX,BX,AX,AX,AX,BX,CX,CX)       && 39  && 	(/G)
  Fmt39( 40,BX,BX,AX,BX,AX,CX,AX,BX,CX,AX)       && 40  (	 	(/H)
  Fmt39( 41,BX,BX,AX,BX,AX,AX,CX,BX,CX,AX)       && 41  )	 	(/I)
  Fmt39( 42,0 ,0 ,0 ,0 ,0 ,BX,AX,CX,CX,AX)       && 42  *
  Fmt39( 43,0 ,0 ,0 ,0 ,0 ,BX,AX,BX,BX,AX)       && 43  +
  Fmt39( 44,BX,BX,AX,BX,AX,AX,CX,AX,BX,CX)       && 44  ,	 	(/L)
  Fmt39( 45,0 ,0 ,0 ,0 ,0 ,BX,AX,AX,CX,CX)       && 45  -
  Fmt39( 46,0 ,0 ,0 ,0 ,0 ,DX,AX,AX,CX,AX)       && 46  .
  Fmt39( 47,0 ,0 ,0 ,0 ,0 ,BX,BX,AX,BX,AX)       && 47  /
  Fmt39( 48,0 ,0 ,0 ,0 ,0 ,AX,BX,CX,CX,AX)       && 48  0
  Fmt39( 49,0 ,0 ,0 ,0 ,0 ,CX,BX,AX,AX,CX)       && 49  1
  Fmt39( 50,0 ,0 ,0 ,0 ,0 ,AX,DX,AX,AX,CX)       && 50  2
  Fmt39( 51,0 ,0 ,0 ,0 ,0 ,CX,DX,AX,AX,AX)       && 51  3
  Fmt39( 52,0 ,0 ,0 ,0 ,0 ,AX,BX,CX,AX,CX)       && 52  4
  Fmt39( 53,0 ,0 ,0 ,0 ,0 ,CX,BX,CX,AX,AX)       && 53  5
  Fmt39( 54,0 ,0 ,0 ,0 ,0 ,AX,DX,CX,AX,AX)       && 54  6
  Fmt39( 55,0 ,0 ,0 ,0 ,0 ,AX,BX,AX,CX,CX)       && 55  7
  Fmt39( 56,0 ,0 ,0 ,0 ,0 ,CX,BX,AX,CX,AX)       && 56  8
  Fmt39( 57,0 ,0 ,0 ,0 ,0 ,AX,DX,AX,CX,AX)       && 57  9
  Fmt39( 58,BX,BX,AX,BX,AX,BX,CX,CX,AX,AX)       && 58  :			(/Z)
  Fmt39( 59,AX,BX,BX,BX,AX,AX,CX,DX,AX,AX)       && 59  ;			(%F)
  Fmt39( 60,AX,BX,BX,BX,AX,AX,AX,BX,CX,CX)       && 60  <			(%G)
  Fmt39( 61,AX,BX,BX,BX,AX,CX,AX,BX,CX,AX)       && 61  =			(%H)
  Fmt39( 62,AX,BX,BX,BX,AX,AX,CX,BX,CX,AX)       && 62  >			(%I)
  Fmt39( 63,AX,BX,BX,BX,AX,AX,AX,DX,CX,AX)       && 63  ?			(%J)
  Fmt39( 64,AX,BX,BX,BX,AX,BX,CX,AX,AX,CX)       && 64  @			(%V)
  Fmt39( 65,0 ,0 ,0 ,0 ,0 ,CX,AX,BX,AX,CX)       && 65  A
  Fmt39( 66,0 ,0 ,0 ,0 ,0 ,AX,CX,BX,AX,CX)       && 66  B
  Fmt39( 67,0 ,0 ,0 ,0 ,0 ,CX,CX,BX,AX,AX)       && 67  C
  Fmt39( 68,0 ,0 ,0 ,0 ,0 ,AX,AX,DX,AX,CX)       && 68  D
  Fmt39( 69,0 ,0 ,0 ,0 ,0 ,CX,AX,DX,AX,AX)       && 69  E
  Fmt39( 70,0 ,0 ,0 ,0 ,0 ,AX,CX,DX,AX,AX)       && 70  F
  Fmt39( 71,0 ,0 ,0 ,0 ,0 ,AX,AX,BX,CX,CX)       && 71  G
  Fmt39( 72,0 ,0 ,0 ,0 ,0 ,CX,AX,BX,CX,AX)       && 72  H
  Fmt39( 73,0 ,0 ,0 ,0 ,0 ,AX,CX,BX,CX,AX)       && 73  I
  Fmt39( 74,0 ,0 ,0 ,0 ,0 ,AX,AX,DX,CX,AX)       && 74  J
  Fmt39( 75,0 ,0 ,0 ,0 ,0 ,CX,AX,AX,BX,CX)       && 75  K
  Fmt39( 76,0 ,0 ,0 ,0 ,0 ,AX,CX,AX,BX,CX)       && 76  L
  Fmt39( 77,0 ,0 ,0 ,0 ,0 ,CX,CX,AX,BX,AX)       && 77  M
  Fmt39( 78,0 ,0 ,0 ,0 ,0 ,AX,AX,CX,BX,CX)       && 78  N
  Fmt39( 79,0 ,0 ,0 ,0 ,0 ,CX,AX,CX,BX,AX)       && 79  O
  Fmt39( 80,0 ,0 ,0 ,0 ,0 ,AX,CX,CX,BX,AX)       && 80  P
  Fmt39( 81,0 ,0 ,0 ,0 ,0 ,AX,AX,AX,DX,CX)       && 81  Q
  Fmt39( 82,0 ,0 ,0 ,0 ,0 ,CX,AX,AX,DX,AX)       && 82  R
  Fmt39( 83,0 ,0 ,0 ,0 ,0 ,AX,CX,AX,DX,AX)       && 83  S
  Fmt39( 84,0 ,0 ,0 ,0 ,0 ,AX,AX,CX,DX,AX)       && 84  T
  Fmt39( 85,0 ,0 ,0 ,0 ,0 ,DX,AX,AX,AX,CX)       && 85  U
  Fmt39( 86,0 ,0 ,0 ,0 ,0 ,BX,CX,AX,AX,CX)       && 86  V
  Fmt39( 87,0 ,0 ,0 ,0 ,0 ,DX,CX,AX,AX,AX)       && 87  W
  Fmt39( 88,0 ,0 ,0 ,0 ,0 ,BX,AX,CX,AX,CX)       && 88  X
  Fmt39( 89,0 ,0 ,0 ,0 ,0 ,DX,AX,CX,AX,AX)       && 89  Y
  Fmt39( 90,0 ,0 ,0 ,0 ,0 ,BX,CX,CX,AX,AX)       && 90  Z
  Fmt39( 91,AX,BX,BX,BX,AX,CX,AX,AX,BX,CX)       && 91  [			(%K)
  Fmt39( 92,AX,BX,BX,BX,AX,AX,CX,AX,BX,CX)       && 92  \			(%L)
  Fmt39( 93,AX,BX,BX,BX,AX,CX,CX,AX,BX,AX)       && 93  ]			(%M)
  Fmt39( 94,AX,BX,BX,BX,AX,AX,AX,CX,BX,CX)       && 94  ^			(%N)
  Fmt39( 95,AX,BX,BX,BX,AX,CX,AX,CX,BX,AX)       && 95  _			(%O)
  Fmt39( 96,AX,BX,BX,BX,AX,DX,CX,AX,AX,AX)       && 96  `			(%W)
  Fmt39( 97,BX,AX,BX,BX,AX,CX,AX,BX,AX,CX)       && 97  a			(+A)
  Fmt39( 98,BX,AX,BX,BX,AX,AX,CX,BX,AX,CX)       && 98  b			(+B)
  Fmt39( 99,BX,AX,BX,BX,AX,CX,CX,BX,AX,AX)       && 99  c			(+C)
  Fmt39(100,BX,AX,BX,BX,AX,AX,AX,DX,AX,CX)       && 100 d			(+D)
  Fmt39(101,BX,AX,BX,BX,AX,CX,AX,DX,AX,AX)       && 101 e			(+E)
  Fmt39(102,BX,AX,BX,BX,AX,AX,CX,DX,AX,AX)       && 102 f			(+F)
  Fmt39(103,BX,AX,BX,BX,AX,AX,AX,BX,CX,CX)       && 103 g			(+G)
  Fmt39(104,BX,AX,BX,BX,AX,CX,AX,BX,CX,AX)       && 104 h			(+H)
  Fmt39(105,BX,AX,BX,BX,AX,AX,CX,BX,CX,AX)       && 105 i			(+I)
  Fmt39(106,BX,AX,BX,BX,AX,AX,AX,DX,CX,AX)       && 106 j			(+J)
  Fmt39(107,BX,AX,BX,BX,AX,CX,AX,AX,BX,CX)       && 107 k			(+K)
  Fmt39(108,BX,AX,BX,BX,AX,AX,CX,AX,BX,CX)       && 108 l			(+L)
  Fmt39(109,BX,AX,BX,BX,AX,CX,CX,AX,BX,AX)       && 109 m			(+M)
  Fmt39(110,BX,AX,BX,BX,AX,AX,AX,CX,BX,CX)       && 110 n			(+N)
  Fmt39(111,BX,AX,BX,BX,AX,CX,AX,CX,BX,AX)       && 111 o			(+O)
  Fmt39(112,BX,AX,BX,BX,AX,AX,CX,CX,BX,AX)       && 112 p			(+P)
  Fmt39(113,BX,AX,BX,BX,AX,AX,AX,AX,DX,CX)       && 113 q			(+Q)
  Fmt39(114,BX,AX,BX,BX,AX,CX,AX,AX,DX,AX)       && 114 r			(+R)
  Fmt39(115,BX,AX,BX,BX,AX,AX,CX,AX,DX,AX)       && 115 s			(+S)
  Fmt39(116,BX,AX,BX,BX,AX,AX,AX,CX,DX,AX)       && 116 t			(+T)
  Fmt39(117,BX,AX,BX,BX,AX,DX,AX,AX,AX,CX)       && 117 u			(+U)
  Fmt39(118,BX,AX,BX,BX,AX,BX,CX,AX,AX,CX)       && 118 v			(+V)
  Fmt39(119,BX,AX,BX,BX,AX,DX,CX,AX,AX,AX)       && 119 w			(+W)
  Fmt39(120,BX,AX,BX,BX,AX,BX,AX,CX,AX,CX)       && 120 x			(+X)
  Fmt39(121,BX,AX,BX,BX,AX,DX,AX,CX,AX,AX)       && 121 y			(+Y)
  Fmt39(122,BX,AX,BX,BX,AX,BX,CX,CX,AX,AX)       && 122 z			(+Z)
  Fmt39(123,AX,BX,BX,BX,AX,AX,CX,CX,BX,AX)       && 123 {			(%P)
  Fmt39(124,AX,BX,BX,BX,AX,AX,AX,AX,DX,CX)       && 124 |			(%Q)
  Fmt39(125,AX,BX,BX,BX,AX,CX,AX,AX,DX,AX)       && 125 }			(%R)
  Fmt39(126,AX,BX,BX,BX,AX,AX,CX,AX,DX,AX)       && 126 ~			(%S)
  Fmt39(127,AX,BX,BX,BX,AX,AX,AX,CX,DX,AX)       && 127 DEL (%T)

  ?? CHR(27)+"*c5F"                              && make soft font permanent

RETURN( .T. )

******************************************************************

FUNCTION Fmt39

  PARAMETERS AsciiValue,AX,BX,CX,DX,EX,FX,GX,HX,IX,JX

  ?? CHR(27) + "*c"
  ?? AsciiValue
  ?? "E"                                         && assign character A,B,C,D, etc
  ?? CHR(27) + "(s731W"                          && issue char. descriptor command

  * build char. format descriptor block (reserved bytes are set to null)

  ?? CHR(  4)                                    && set Fmt39 (4 for HPLJ)
  ?? CHR(  0)                                    && set continuation flag (default)
  ?? CHR( 14)                                    && set descriptor size (14 for HPLJ)
  ?? CHR(  1)                                    && set class (1 for HPLJ)
  ?? CHR(  1)                                    && set orientation to landscape
  ?? CHR(  0)                                    && reserved - 1 byte
  ?? CHR(255)+CHR(206)                           && set left offset to -50 (FFCEh)
  ?? CHR(  0)+CHR( 66)                           && set top  offset to +66 (0042h)
  ?? CHR(  0)+CHR( 88)                           && set char. width  to 88 dots (11 bytes)
  ?? CHR(  0)+CHR( 65)                           && set char. heigth to 65 dots
  ?? CHR(  0)+CHR(  0)                           && set delta X (default)

  * bytes 16 - 64 character data

  * note that the following are sent in REVERSE order; this is because
  * landscape fonts are defined in raster scan order

  Decode39(JX)                                   && send standard Code 39 masks
  Decode39(IX)
  Decode39(HX)
  Decode39(GX)
  Decode39(FX)

  IF AX>0                                        && is it a special Code 39 mask ?

    Decode39(EX)                                 && if yes; then use $,%,+, or / masks
    Decode39(DX)
    Decode39(CX)
    Decode39(BX)
    Decode39(AX)

  ENDIF

RETURN( .T. )

******************************************************************

FUNCTION Decode39                                && calculates byte pixel patterns from masks

  PARAMETERS Mask

  DO Case

    Case Mask = 1                                && narrow bar, narrow space - 2 bytes

      Download(000)
      Download(255)

    Case Mask = 2                                && narrow bar, wide space	  - 2 bytes

      Download(000)
      Download(000)
      Download(255)

    Case Mask = 3                                && wide bar, narrow space	  - 3 bytes

      Download(000)
      Download(255)
      Download(255)

    Case Mask = 4
                                                 && wide bar, wide space	  - 4 bytes
      Download(000)
      Download(000)
      Download(255)
      Download(255)

  ENDCASE

RETURN( .T. )

******************************************************************

FUNCTION Download                                && downloads bit patterns to printer

  PARAMETERS BitPattern

  PRIVATE AX,BX

  For AX = 1 To 5

    For BX = 1 To 11

      ?? CHR(BitPattern)

    Next BX

  Next AX

RETURN( .T. )

******************************************************************

FUNCTION Code39                                  && builds Code 39 ASCII strings

  PARAMETER Text39

  If Len(Text39) < 1

    RETU( "" )

  ENDIF

RETURN( CHR(14) + "*" + Text39 + "*" + CHR(15) )

