/*
   Program: TestMenu.PRG
   Author:  Greg Lief
   Date:    March 1991
   Modified By: James J. Orlowski, M.D.
   Modified Date: 8/3/91
   Dialect: Clipper 5.01
   Purpose: Alternate Menuing System
   Compile: clipper TestMenu /n/w/a/m
   Compile: clipper LiteMenu /n/w/a/m
   Link:    rtlink /free fi LiteMenu, TestMenu

   This program shows a demonstration of most of the features of the
   enhancements to litemenu2.
*/


#include "litemenu.ch"

#define Color_Line "B/N"
#define Color_Head "GR+/B"
#define Color_Say  "N/BG,   N/W, , , B/BG"  // Say/Get Colors
#define Color_Msg  "B/W,   N/BG, , , N/W"   // Reg Msg Box Colors 

#xcommand DRAW SINGLE LINE @ <line> [, <linen> ]         ;
      =>  DispBox( <line>,  0, <line>,  MaxCol(), 1 )    ;
       [; DispBox( <linen>, 0, <linen>, MaxCol(), 1 ) ]
#xcommand  @ <row> CENTER <xpr> [COLOR <color>]          ;
      =>  DevPos( <row>, (MaxCol()+1 - LEN(<xpr>) )/2 )  ;
        ; DevOut( <xpr> [, <color>] )
#xcommand REPEAT => DO WHILE .T.
#xcommand UNTIL <expl> => IF (<expl>); EXIT; END; END

PROC test
   LOCAL aMenu      := {}
   LOCAL cChoice    := "Edit File"
   LOCAL nChoice    := 1
   LOCAL cOrigColor := SetColor()
   CLEAR SCREEN
   SetColor(Color_Line)
   DRAW SINGLE LINE @ 3, MaxRow() - 5, MaxRow() - 1
   SetColor(Color_Head)
   @ 0,0 CLEAR TO 2,MaxCol()
   @ 0 CENTER "Demonstration Of LiteMenu"
   @ 1 CENTER "Originally Conceived By Greg Lief"
   @ 2 CENTER "Enhanced By James J. Orlowski"
   SetColor(Color_Say)
   @ 4,0 CLEAR TO MaxRow()-6,MaxCol()
   SetColor(Color_Msg)
   @ MaxRow()-4,0 CLEAR TO MaxRow()-2,MaxCol()

   MENU WAIT 15 IDLEFUNCTION BlankScrn()
   @ MaxRow()-3 CENTER "Please Note - Screen Will Blank If No Activity " + ;
      "In 15 Seconds"
   @ MaxRow()-3,0
   REPEAT
      SetColor(Color_Say)
      @ 5, 0 CLEAR TO 16, MaxCol()
      @ 5 CENTER "Vertical Menu - Returns Character String"

      @ 0,0 PROMPT "Edit File"      ACTION EditFile()
      IF nChoice <> 2
         @ 0,0 PROMPT "Maintenance" ACTION Maintain()
      ENDIF
      IF nChoice <> 3
         @ 0,0 PROMPT "Reports"     ACTION Reports()
      ENDIF
      @ 0,0 PROMPT "Quit"
      MENU TO cChoice ROWSTART 7 ROWSKIP 2

      @ 6, 0 CLEAR TO 16, MaxCol()
      @ 10,1  SAY "Choice Was " + cChoice
      @ 10,40 SAY "Valtype Of Choice Was " + VALTYPE(cChoice)

      IF cChoice == "Quit"
         nChoice := 0
      ELSE
         SetColor(Color_Msg)
         @ MaxRow()-4,0 CLEAR TO MaxRow()-2,MaxCol()
         @ MaxRow()-4 CENTER "Numeric Menu - Returns Number"
         @ MaxRow()-3,0 PROMPT "Try ~All"
         @ MaxRow()-3,0 PROMPT "Try Without ~Maintenance"
         @ MaxRow()-3,0 PROMPT "Try Without ~Reports"
         @ MaxRow()-3,0 PROMPT "Quit"
         MENU TO nChoice
   
         @ MaxRow()-3,0 CLEAR TO MaxRow()-2,MaxCol()
         @ MaxRow()-2,1  SAY "Choice Was " + STR(nChoice,1)
         @ MaxRow()-2,40 SAY "Valtype Of Choice Was " + VALTYPE(nChoice)
      ENDIF
   UNTIL nChoice == 0 .OR. nChoice = 4
   MENU WAIT OFF
   SetColor(cOrigColor)
   @ MaxRow(),0
RETURN

FUNCTION EditFile
RETURN(PretendRun("Edit"))

FUNCTION Maintain
RETURN(PretendRun("Maintenance"))

FUNCTION Reports
RETURN(PretendRun("Reports"))

FUNCTION PretendRun(cName)
   LOCAL cOldColor := SetColor(Color_Say)
   LOCAL cOldScrn  := SAVESCREEN(5, 0, 16, MaxCol() )
   @  5, 0 CLEAR TO 16, MaxCol()
   @  8 CENTER "Run " + cName + " File"
   @ 12 CENTER "Press Space Bar To Continue"
   INKEY(30)
   RESTSCREEN(5, 0, 16, MaxCol(), cOldScrn )
   SetColor(Color_Say)
RETURN NIL

FUNCTION BlankScrn
   * Note BlankScrn Adopted From Don Caton 71067,1350 on CIS
   LOCAL cOldScrn := SaveScreen( 0, 0, Maxrow(), Maxcol() )
   LOCAL nX := 0, nY := 0, nOldX := ROW(), nOldY := COL()
   LOCAL cOldColor := SetColor("W+/N")
   KEYBOARD CHR(0)
   CLEAR SCREEN
   @ nX,nY SAY "Press any key to restore screen"
   WHILE INKEY(30) == 0
      nX := IF(nX == 24, 0, nX + 1)
      nY := IF(nY == 0, 40, 0)
      CLEAR SCREEN
      @ nX,nY SAY "Press any key to restore screen"
   END // ENDWHILE
   RestScreen( 0, 0, Maxrow(), Maxcol(), cOldScrn)
   SetColor( cOldColor )
   @ nOldX,nOldY SAY ""
RETURN(.t.)
* EOF BlankScrn()
