#include "inkey.ch"
#include "libmake.ch"

PARAMETERS nLib
LOCAL i, o, nRoot, lcr, line, start, mName, lDepends := [], dLines,;
	xLen, objs := {}
save screen
cls
start = seconds()
if (pCount()==0)
	? [Usage: libmake <lib name>]
	?
	quit
endif
* Put Extension on file name if it's not there \\\\*
if (at([.], nLib)==0)
	nRoot := nLib
	nLib += [.lib]
else
	nRoot := left(nLib, at([.], nLib)-1)
endif
* Lib will not look for your library so we better, using the ENV var *
if (!file(nLib) .and. !file(getEnv([LIB]) + [\] + nLib))
	? [Cannot find ] + nLib
	? [Must be in either current working dir or the directory specified ]
	? [in the LIB environment var.]
	?
	quit
endif
* Invoke LIB and redirect output to NUL \\\*
omsg([Extracting Library Contents...])
! ([lib ] + nLib + ",,lib.o > NUL") 

// Open LIB's listing file and process....
* Using the F-Functions resulted in code that was about 25x faster *
* than equivalent memo code *
omsg([Reading Listing File...])
lcr := fOpen("lib.o")
* Simply examine each line.  If it passes the test for containing the *
* name of a module in the library, extract the name and add it to the *
* list.
fEval(lcr, { |xLine| ;
	IIF(objLine(xLine), aadd(objs, oForm(xObj())), NIL);
	})
omsg([Generating Make File...])
if ((o := fCreate(nRoot + [.rmk]))==FERR)
	? [Error Creating Make File.]
	? [Ferror #:] + str(ferror())
	?
	quit
endif
* Write the Make File, Bob \\\*
fWriteLn(o, [#include "libmake.mh"])
fBlankLn(o)
aEval(objs,	{ |oName| ;
	lDepends += oName + [.obj ];
	})
if (len(lDepends) > MAXLNLEN)
	xLen := rat([ ], left(lDepends, MAXLNLEN))
	fWriteLn(o, [mods = ] + substr(lDepends,1,xLen) + [ \])
	fWriteLn(o, chr(TAB) + substr(lDepends,xLen))
else 
	fWriteLn(o, [mods = ] + lDepends)
endif
fBlankLn(o)
aEval(objs,	{ |oName| ;
	fWriteLn(o, srcLine(oName));
	})
fBlankLn(o)
fWriteLn(o, nLib + [: $(mods)])
fClose(o)
@1,0 say [Process took: ] + allTrim(str(seconds()-start)) + [ seconds.]
* fErase([lib.o])

	


