name LAT1
page 66,132

comment $____________________________________________________________

	    This is meant to be used from within a dBASE application.
	    To prepare the BIN file (assuming you have the Microsoft or
	    IBM Macro Assembler (MASM.EXE) EXE2BIN.EXE, and LINK.EXE
	    available along your DOS search path), type:

	    MASM LAT1;
	    LINK LAT1;
            EXE2BIN LAT1;
	    DEL LAT1.OBJ
	    DEL LAT1.EXE

	    Now you can use LAT1.BIN as described in the article.
	    ___________________________________________________________$



_prog SEGMENT PUBLIC
         assume CS:_prog,DS:nothing,ES:nothing,SS:nothing

search_str EQU  Byte Ptr DS:[bx]   ;string to search, starts as [bx+1]
find_char  EQU  Byte ptr DS:[bx-1] ;character to find, starts as [bx]
max_len    EQU  254                ;max search string length

LAT1 PROC FAR
ORG 0h
START:
        jmp BEGIN
info    db  13,'LAT.ASM, BIN _ Author R. Russell Freeland',13,10
        db  'returns last occurrence of given character',13,10,26
BEGIN:

comment $____________________________________________________________
         First, get length of search string--we could just get it from
         the byte before the actual string and subtract one for the
         character "pasted" in front, but FOX doesn't set this up and
         other dBASE compilers (QS) may pass the length
 differently.
         ___________________________________________________________$


        inc   bx              ;make BX point to second character of
                              ;passed parameter (search_str)
        PUSH  ES              ;save ES
        PUSH  DS              ;get DS into
        POP   ES              ;ES,
        PUSH  bx              ;BX into
        POP   di              ;DI for string scan
        mov   cx,max_len+1    ;scan max string length+1
        mov   al,0            ;for nul (terminator)
        CLD                   ;scan "left-to-right"
REPNE   SCASB                 ;scan it
        jcxz  ERROR           ;CX=0--no find, maybe no param passed?
        NOT   cl              ;CL=255-CL=length of search_str
        dec   di
        dec   di              ;point to last character of string

comment $____________________________________________________________
         Now get position of character in string--easy, since CX will
         hold the number of characters *not scanned* after a SCASB.
         ___________________________________________________________$

        mov   al,find_char    ;what to search for
        STD                   ;search in reverse now
REPNE   SCASB
        mov   find_char,cl    ;pass back location
        jmp   DONE
ERROR:
        mov   find_char,255
DONE:
        CLD
        POP   ES
        RET
LAT1  ENDP

_prog   ENDS

END  START
