* Function ..... LAST_FIELD()
* Author ....... Steve Straley
* Date ......... August 21, 1985
* Syntax ....... LAST_FIELD(character string)
* Parameters ... Filename
* Returns ...... <numeric value>
* Notes ........ This function will return the number of fields in the
*                given database.  This function does a binary search to
*                determine the position of the last field in the database.

FUNCTION LAST_FIELD

Parameters Filename

Use &Filename

first  = 1
last   = 1024
middle = INT(last/2)

DO WHILE first <> last
   ******************************
   * check to see what is the length of the field at position middle.
   * IF the value is 0, then there is no field at position middle and
   * make the value of last equal to middle.
   * ELSE, there is a value at position middle and then make the value
   * of first equal to middle.
   * Once this is done, then re-calculate the value of middle based on
   * the new values of first and last
   ******************************
   IF LEN(FIELDNAME(middle)) = 0
      last = middle
   ELSE
      first = middle
   ENDIF
   middle = first + INT((last-first)/2)
   IF LEN(FIELDNAME(middle)) > 0 .AND. LEN(FIELDNAME(middle + 1)) = 0
      last = middle
      first = middle
   ENDIF
ENDDO


RETURN(last)
