* LASLBL.PRG - Avery 3 x 11 Photocopy/Laser Label printing routine
* by Hugh Hemington 72447,3475
*
#include "inkey.ch"
#include "set.ch"
SET CURSOR OFF
CLEAR
col := {'*p0X','*p810X','*p1670X'}  && the three columns of labels
tp := '&l0e66F(1X(s1P'  && one-time printer setup string
tpl := .T.  && does printer need to be setup
lmem := MEMORY(2)
dl := .F.   && has a download occurred
l1 := '*p'
l2 := 'Y'
PRIVATE tl := bl := cl := 1  && top and bottom (4 & 5 line special labels)
PRIVATE ll := 8  && next row to load next standard label, 'cl' is column
PRIVATE lbs := 0  && main body labels (not counting top and bottom row)
PRIVATE Add := ARRAY(6)
AFILL(Add,'')
Page := ARRAY(76,3)
FOR x := 1 TO 76
  FOR y = 1 TO 3
    page[x][y] := L1+LTRIM(STR((x-1)*43))+L2+col[y]  && 43 dots per line
  NEXT
NEXT
IF FILE('LASLBL.MEM')
  RESTORE FROM LASLBL ADDITIVE
  IF !EMPTY(Ffile)
    tst := Ffile+'.DBF'
    tsx := Ffile+'.NTX'
    IF FILE('&tst')
      USE &Ffile
    END
    IF FILE('&tsx')
      SET INDEX TO &Ffile
    END
  ELSE
    Ffile := ""
  END
ELSE
  Ffile := Findx := Fdesc := Fproj := Font := ""
  Fprinter := 'LPT1'
END
@  1, 2 SAY PADC('Hewlett Packard LaserJet II Label Program',75)
@  2, 2 SAY PADC('by Hugh Hemington',75)
@  4, 0 TO 22,77 DOUBLE
@  6, 2 SAY 'Q - Quit'
@  8, 2 SAY 'D - Database'
@ 10, 2 SAY 'I - Index'
@ 12, 2 SAY 'C - Choose'
@ 14, 2 SAY 'F - Font'
@ 16, 2 SAY 'P - Project'
@ 18, 2 SAY 'G - Go!'
DO WHILE .T.
  IF !EMPTY(Ffile)
    @  8,30 SAY 'DATABASE: '+Ffile
    @  9,30 SAY 'PAGES NEEDED: '+LTRIM(STR(INT(LASTREC()/33)+1))
  ELSE
    @  8,30 CLEAR TO 9,76
  END
  IF !EMPTY(Findx)
    @ 10,30 SAY '---- File Indexed ----'
  ELSE
    @ 10,30 CLEAR TO 10,76
  END
  IF !EMPTY(Fdesc)
    @ 12,30 SAY '---- Data Chosen ----'
  ELSE
    @ 12,30 CLEAR TO 12,76
  END
  IF !EMPTY(Font)
    @ 14,30 SAY 'FONT: '+Font
  ELSE
    @ 14,30 CLEAR TO 14,76
  END
  IF !EMPTY(Fproj)
    @ 16,30 SAY 'PROJECT: '+Fproj
  ELSE
    @ 16,30 CLEAR TO 16,76
  END
  ans := SPACE(1)
  SET CURSOR ON
  @ 20, 2 SAY 'YOUR SELECTION: ' GET ans PICTURE '!' VALID(ans $'QDICFPG')
  READ
  IF Ans = 'Q'
    SAVE TO LASLBL ALL LIKE F*
    SET PRINT ON
    SET CONSOLE OFF
    ?? CHR(27)+'E'  && reset printer 
    SET PRINT OFF
    SET CONSOLE ON
    CLEAR
    QUIT
  END
  SET CURSOR OFF
  DO CASE
    CASE ans = 'D'  && database
      Ffile := PADR(Ffile,8)
      SET CURSOR ON
      @  8,30 CLEAR TO 9,76
      @  8,40 GET Ffile PICTURE '!!!!!!!!'
      READ
      @  8,30 CLEAR TO 9,76
      Ffile := TRIM(Ffile)
      ifile := Ffile+'.NTX'
      tfile := Ffile+'.DBF'
      IF !FILE('&tfile')
        @  8,30 SAY '**** FILE: '+tfile+' NOT FOUND ****'
        ldummy = inkey(2)
        Ffile := ""
        @  8,30 CLEAR TO 9,76
        LOOP
      END
      USE &Ffile
      IF FILE('&ifile')
        SET INDEX TO &Ffile
        Findx := INDEXKEY()
      ELSEIF !EMPTY(Findx)
        INDEX ON &Findx TO &Ffile
      END
    CASE ans = 'I'  && index
      IF !EMPTY(ALIAS())
        Findx := PADR(Findx,200)
        SET CURSOR ON
        @ 10,30 CLEAR TO 10,76
        @ 10,30 SAY 'INDEX FORMULA: ' GET Findx PICTURE '@S30'
        READ
        SET CURSOR OFF
        @ 10,30 CLEAR TO 10,76
        Findx := TRIM(Findx)
        IF !EMPTY(Findx)
          @ 10,30 SAY '****   INDEXING   ****'
          INDEX ON &Findx TO &Ffile
          @ 10,30 CLEAR TO 10,76
        ELSE
          SET INDEX TO
        END
      END  
    CASE ans = 'C'  && choose - descriminate
      Fdesc := PADR(Fdesc,200)
      SET CURSOR ON
      @ 12,30 SAY 'CHOOSE FORMULA: ' GET Fdesc PICTURE '@S30'
      @ 13,30 SAY "Enter the formula for the data you DON'T want"
      READ
      Fdesc := TRIM(Fdesc)
      @ 12,30 CLEAR TO 13,76
    CASE ans = 'F'  && font selection
      fnt := SPACE(1)
      scn := SAVESCREEN(0,0,24,79)
      @  5, 1 CLEAR TO 21,76
      @  6, 6 SAY '  YOUR FONT CHOICES: '
      @  8, 6 SAY '1 - Courier (Regular)'
      @ 10, 6 SAY '2 - Helvetica (Swiss)'
      @ 12, 6 SAY '3 - Times Roman (Dutch)'
      @ 14, 6 SAY '4 - Times Roman BOLD'
      @ 16, 6 SAY '5 - Times Roman ITALIC'
      @ 18, 6 SAY '6 - Times Roman BOLD ITALIC'
      SET CURSOR ON
      @ 20, 6 SAY 'YOUR SELECTION: ' GET fnt PICTURE '!' VALID(Fnt $'123456')
      READ
      SET CURSOR OFF
      IF fnt = '1'      && courier
        font := 'COU1210.SFP'
      ELSEIF fnt = '2'  && Helvetica
        font := 'HLVN3010.SFP'
      ELSEIF fnt = '3'  && Times Roman
        font := 'TMS10F.SFP'
      ELSEIF fnt = '4'  && Times BOLD
        font := 'TMS10BF.SFP'
      ELSEIF fnt = '5'  && Times ITALIC
        font := 'TMS10IF.SFP'
      ELSEIF fnt = '6'  && Times BOLD ITALIC
        font := 'TMS10BIF.SFP'
      END
      snd := 'DOWNLOAD '+font+',1,P'
      CLEAR
      RUN &snd
      dl := .T.
      RESTSCREEN(0,0,24,79,scn)
    CASE ans = 'P'  && project name
      Fproj := PADR(Fproj,30)
      SET CURSOR ON
      @ 16,30 SAY 'PROJECT:' GET Fproj
      READ
      SET CURSOR OFF
      Fproj := TRIM(Fproj)
      @ 16,30 CLEAR TO 16,76
    CASE ans = 'G'  && print (go)
      IF EMPTY(Ffile)  && no file in use
        LOOP
      END
      IF !dl  && font not downloaded
        scn := SAVESCREEN(0,0,24,79)
        snd := 'DOWNLOAD '+font+',1,P'
        CLEAR
        RUN &snd
        dl := .T.
        RESTSCREEN(0,0,24,79,scn)
      END
      SET PRINTER TO &Fprinter
      PLABEL()
      SET PRINTER TO LPT1
  END
END

PROCEDURE PLABEL
@ 18,30 SAY 'Loading... '
Pg := ACLONE(Page)
* load the first label with run data...
Pg[4][1] += 'Run on: '+DTOC(DATE())
Pg[5][1] += 'At time: '+TIME()
Pg[6][1] += 'Database: '+Ffile
Pg[7][1] += 'Project: '+TRIM(Fproj)
tl := 2
GO TOP
DO WHILE ! EOF()
  IF DELETED()
    SKIP
    LOOP
  END
  IF lbs = 27  && this page is history!
    @ 18,30 SAY 'PRINTING...'
    SET PRINT ON
    SET CONSOLE OFF
    IF tpl  && need to set-up printer
      ?? tp
      tpl := .F.
    END
    FOR zx = 1 TO 76
      FOR zy = 1 TO 3
        ?? Pg[zx][zy]
      NEXT
    NEXT
    EJECT
    SET PRINT OFF
    SET CONSOLE ON
    lbs := 0
    tl := bl := cl := 1
    ll := 8
    Pg := ACLONE(Page)
    @ 18,30 SAY 'Loading... '
  END
  * send the record off for processing - 
  Ad := ACLONE(Add)
  p := 2
  Ad[1] := TRIM(FIRST)+' '+TRIM(LAST)
  IF !EMPTY(TITLE)
    Ad[p] := TRIM(TITLE)
    p++
  END
  IF !EMPTY(COMPANY)
    Ad[p] := TRIM(COMPANY)
    p++
  END
  Ad[p] := TRIM(ADDRESS)
  p++
  Ad[p] := TRIM(CITY)+IF(EMPTY(STATE),' ',', '+STATE+' ')+TRIM(ZIP)
  IF !EMPTY(COUNTRY)
    p++
    Ad[p] := TRIM(COUNTRY)
  END
  IF tl < 4 .AND. p < 5  && room for another top special
    FOR z = 1 TO p
      Pg[z+3][tl] += Ad[z]
    NEXT
    tl++
    SKIP
    LOOP
  END
  IF bl < 4 .AND. p < 6  && room for another bottom special
    FOR z = 1 TO p
      Pg[z+71][bl] += Ad[z]
    NEXT
    bl++
    SKIP
    LOOP
  END
  * now load wherever it goes!
  lx := ll
  FOR z = 1 TO p
    Pg[ll+z][cl] += Ad[z]
  NEXT
  cl++
  IF cl = 4
    cl := 1
    ll := lx+7
  ELSE
    ll := lx
  END
  lbs++
  SKIP
END
IF lbs > 0 .OR. tl + bl > 2
  @ 18,30 SAY 'PRINTING...'
  SET PRINT ON
  SET CONSOLE OFF
  IF tpl  && need to set-up printer
    ?? tp
  END
  FOR zx = 1 TO 76
    FOR zy = 1 TO 3
      ?? Pg[zx][zy]
    NEXT
  NEXT
  EJECT
  SET PRINT OFF
  SET CONSOLE ON
  lbs := 0
  tl := bl := cl := 1
  ll := 8
  @ 18,30 SAY 'FINISHED!  '
  ldummy := inkey(1)
  @ 18,30 SAY '           '
END
RETURN
