/* LANKEYC.C - extended C language routines for use with Clipper programs

  contains : C_INKEY()    - time-slice function called by P_INKEY()
             C_PEEK()     - classic PEEK function

  requires Microsoft C Compiler 5.1

  compile command:  CL /c /AL /Zl /FPa /Gs lankeyc.c

  author: Shawn B. Lipscomb, Intelligent Decisions, Inc.
*/


#include "extend.h"
#include "stdlib.h"
#include "math.h"
#include "bios.h"


CLIPPER c_inkey()
/*
  Time-slice function called by P_INKEY() that allows a non-dedicated network
  server time to print part of a spooled print job.  There are better ways to
  sense when half a second has passed, but this method has proven to provide
  the maximum benefit to the network spooler.
  Syntax : C_INKEY(nKeybdTailPtr)
*/
{
  int mMidnight,pTailPos;
  int far *KeybdBuffTail;
  long mTimesUp,mTimeIs;

  pTailPos=_parni(1);

  /* create pointer to location of pointer to keyboard buffer tail */
  KeybdBuffTail=(int far *) 0x00400000;
  KeybdBuffTail+=0x1C;

  _bios_timeofday(_TIME_GETCLOCK,&mTimesUp);
  mTimesUp+=9;      /* 18.2 ticks/second, and I want to wait half a second */
  mTimeIs=0L;
  mMidnight=0;

  while (!kbhit() && (*KeybdBuffTail == pTailPos) && (mTimeIs < mTimesUp) && (! mMidnight))
    mMidnight=_bios_timeofday(_TIME_GETCLOCK,&mTimeIs);

  _ret();
}


CLIPPER c_peek()
/*
  Classic Peek function, restricted to segment 0400.
  Called by P_INKEY() that gets the pointer to the keyboard buffer which
  will later get passed onto c_inkey
  Syntax : C_PEEK(nOffset) => nValue
*/
{
  int pOffset;
  int far *mPointer;

  pOffset=_parni(1);
  mPointer=(int far *) 0x00400000;
  mPointer+=pOffset;
  _retni(*mPointer);
}
