/* LANKEYC.C - extended C language routines for use with Clipper programs

  contains : C_INKEY()    - time-slice function called by P_INKEY()
             C_PEEK()     - classic PEEK function

  requires Microsoft C Compiler 5.1

  compile command:  CL /c /AL /Zl /Oalt /FPa /Gs lankeyc.c

  author: Shawn B. Lipscomb, Intelligent Decisions, Inc.
*/


#include "extend.h"
#include "stdlib.h"
#include "math.h"
#include "bios.h"

CLIPPER c_inkey()
/*
  Time-slice function called by P_INKEY() that allows a non-dedicated network
  server time to print part of a spooled print job.  There are better ways to
  sense when half a second has passed, but this method has proven to provide
  the maximum benefit to the network spooler.
  Syntax : C_INKEY(nKeybdTailPtr)
*/
{
  int mMidnight,pTailPos;
  int far *KeybdBuffTail;
  long mTimesUp,mTimeIs;

  pTailPos=_parni(1);

  /* create pointer to location of pointer to keyboard buffer tail */
  KeybdBuffTail=(int far *) 0x041C;

  _bios_timeofday(_TIME_GETCLOCK,&mTimesUp);
  mTimesUp+=9;      /* 18.2 ticks/second, and I want to wait half a second */
  mTimeIs=0L;
  mMidnight=0;

  while (!kbhit() && (*KeybdBuffTail == pTailPos) && (mTimeIs < mTimesUp) && (! mMidnight))
    mMidnight=_bios_timeofday(_TIME_GETCLOCK,&mTimeIs);

  _ret();
}


CLIPPER c_peek()
/*
  Classical Peek function.
  Called by P_INKEY() to get the pointer to the keyboard buffer which will
  later get passed onto C_INKEY().
  Syntax : C_PEEK(nAddress)
*/
{
  long pAddress;
  int far *mPointer;

  pAddress=_parni(1);
  mPointer=(int far *) pAddress;
  _retni(*mPointer);
}
