FUNCTION P_INKEY(pTime,pIfNoHotKeys)
  //
  // SYNTAX : P_INKEY([nTime],[lIfNoHotKeysAllowed]) => nKeyHit
  //
  // - THIS IS THE SAME AS CLIPPER'S INKEY() BUT IT IS ALSO A WAIT STATE
  // - ALSO AUTOMATICALLY PROVIDES TIME SLICING BETWEEN CLIPPER AND C SO
  //   THAT A NON-DEDICATED NOVELL SERVER CAN GET TIME TO PRINT FROM THE
  //   SPOOLER
  //
  // COMPILE COMMAND:  CLIPPER LANKEY /N
  //
  // AUTHOR: Shawn B. Lipscomb, Intelligent Decisions, Inc.
  //
  LOCAL mKeyBlock,mKey,mEvaled,mCounter,mKeybdTailPtr,;
        mRow:=ROW(),;
        mCol:=COL()
  WHILE TRUE
    IF (pTime == NIL)
      mKey:=INKEY()
    ELSE
      // THIS SECTION OF CODE HANDLES HALF SECOND TIME SLICING TO A C
      // FUNCTION SO THAT, ON A NON-DEDICATED NOVELL SERVER, A PRINT SPOOLING
      // JOB WILL GET SOME TIME AS OFTEN AS POSSIBLE, WHILE STILL PRESERVING
      // A HALF SECOND FOR CLIPPER TO DO GARBAGE COLLECTION.  TO FURTHER
      // COMPLICATE MATTERS, DOS 3.3 HAS A BUG THAT MAKES IT HARD TO
      // REALIZE THAT AN ENHANCED KEYBOARD KEY HAS BEEN HIT FROM C.  SO WE
      // SAVE THE POINTER TO THE KEYBOARD BUFFER'S TAIL AND SEND IT TO
      // C_INKEY SO THAT C CAN SEE IF IT MOVES.  EVEN WITH DOS 3.3'S BUG, THE
      // KEYBOARD POINTER TAIL STILL MOVES.
      mCounter:=0
      mKeybdTailPtr:=C_PEEK(1052)
      WHILE ((pTime = 0) .OR. (mCounter++ < pTime))
        IF EMPTY(mKey:=INKEY(0.5))
          C_INKEY(mKeybdTailPtr)
        ELSE
          EXIT
        ENDIF
      ENDDO
    ENDIF

    // DELETE THE FOLLOWING IF...THEN...ELSE...ENDIF IF YOU DON'T
    // WANT P_INKEY() TO BE A WAIT STATE.
    IF (pIfNoHotKeys == NIL) .AND. ((mKeyBlock:=SETKEY(mKey)) # NIL)
      mEvaled:=EVAL(mKeyBlock)
      // RESTORE CURSOR POSITION BECAUSE THE SETKEY BLOCK MAY HAVE MOVED IT
      DEVPOS(mRow,mCol)
      LOOP
    ELSE
      EXIT
    ENDIF
  ENDDO
  RETURN mKey
