/*
 Ŀ
  Module....: TEXTGET.prg                                                 
  Descrip...: standard text GET source code for CA-Technicon '93 demo.    
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "class(y).ch"
#include "koltermn.ch"

FUNCTION TextGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO ""

RETURN TextGet():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                      nMrow,nMcol,cMtxt,cMClr )

CREATE CLASS TextGet FROM BaseGET

    EXPORT:

    method init
    method skGetReader

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::skGetReader() }
  ::id:= "TEXTGET"

RETURN self

METHOD skGetReader()
LOCAL oGet,nKey

oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()
		
		WHILE ( oGet:exitState == GE_NOEXIT )
		
			// Check for initial typeout (no editable positions)
			IF ( oGet:typeOut )
				oGet:exitState := GE_ENTER
			ENDIF
		
			// Apply keystrokes until exit
			WHILE ( oGet:exitState == GE_NOEXIT )
				nKey:= SKInkey(oGet)
				IF SetKey(nKey) == NIL
					GetApplyKey( oGet, nKey )
				ENDIF
			ENDDO

			// Disallow exit if the VALID condition is not satisfied
			IF ( !GetPostValidate( oGet ) )
				oGet:exitState := GE_NOEXIT
			ENDIF
		ENDDO

		// De-activate the GET
		oGet:killFocus():clearMsg()

	ENDIF

	RETURN self
