/*
 Ŀ
  Module....: SK_MOUSE.ch                                                 
  Descrip...: Mouse header file for CA-Technicon '93 demo.                
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#define K_MOUSE                             999
#define M_EXECUTE                           998

/*  LastClick() values  */
#define MNONE                               0
#define MLEFT                               1
#define MMIDDLE                             2
#define MRIGHT                              3

#xtranslate MRow()                       => FT_MGETX()
#xtranslate MCol()                       => FT_MGETY()
#xtranslate MInregion(<t>,<l>,<b>,<r>)   => FT_MINREGION(<t>,<l>,<b>,<r>)
#xtranslate MShow()                      => FT_MSHOWCRS()
#xtranslate MHide()                      => FT_MHIDECRS()
#xtranslate MCursor([<l>])               => FT_MCURSOR([<l>])
#xtranslate MInit()                      => FT_MINIT()
#xtranslate MReset()                     => FT_MRESET()
#xtranslate MRClick()                    => (FT_MBUTPRS(1)==2)
#xtranslate MMClick()                    => (FT_MBUTPRS(2)==4)
#xtranslate MLClick()                    => (FT_MBUTPRS(0)==1)
#xtranslate MSetpos(<r>,<c>)             => FT_MSETCOORD(<r>,<c>)

#xcommand   SET MOUSE CURSOR ASCII <ch>  => MCURSDEF( 112,0,15,<ch> )
#xcommand   RESET MOUSE CURSOR           => MCURSDEF( 255,255,119,0 )
