/*
 Ŀ
  File......: PASSWORD.PRG                                                
  Descrip...: Source code for password GET.                               
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "inkey.ch"
#include "class(y).ch"
#include "koltermn.ch"

FUNCTION PassWordGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr,cPw )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO "" ,;
        cPw TO "*"

RETURN PassWord():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                      nMrow,nMcol,cMtxt,cMClr,cPw )

CREATE CLASS PassWord FROM BaseGET

    EXPORT:
    var passChar type char
    var maxTries type integer

    method init
    method passWordReader
    method pWord

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr,cPw ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::passWordReader() }
  ::id:= "PASSWORD"
  ::passChar:= cPw
  ::maxTries:= 3

RETURN self

METHOD passWordReader()
	LOCAL nKey:= 0,cBuffer:= "",nLenBuffer,oGet
        oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		nLenBuffer:= Len(oGet:varget)
		oGet:varput( Space(nLenBuffer) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()

		WHILE ( oGet:exitState == GE_NOEXIT )
		
			// Apply keystrokes until exit
			WHILE ( oGet:exitState == GE_NOEXIT )
				cBuffer:= oGet:pWord( Inkey(0),cBuffer,nLenBuffer )
			ENDDO
		
			// validation here.
			IF oGet:exitstate <> GE_ESCAPE
                                IF !Eval( oGet:postBlock,oGet,cBuffer )
					oGet:exitstate:= GE_NOEXIT
					cBuffer:= ""
					oGet:varput(Space(nLenBuffer))
				ENDIF
			ENDIF

		ENDDO

		// De-activate the GET
		oGet:killFocus():dispMsg()

		// varput stored password.
		IF oGet:exitstate <> GE_ESCAPE
			oGet:varPut( Trim(cBuffer) )
		ENDIF

	ENDIF

	RETURN self

METHOD pWord( nKey,cBuffer,nLenBuffer )
	LOCAL nCol,oGet,cPw
        
        oGet:= self
        cPw:= oGet:passChar

	DO CASE
	CASE nKey==K_DEL
		cBuffer:= ""
		oGet:varput(Space(nLenBuffer))
	CASE nKey==K_BS
		cBuffer:= Left(cBuffer,Len(cBuffer)-1)
		oGet:varPut( Padr(Replic(cPw,Len(cBuffer)),nLenBuffer) )
	CASE nKey >= K_SPACE .and. nKey <= 126
		cBuffer+= Chr(nKey)
		oGet:varPut( Padr(Replic(cPw,Len(cBuffer)),nLenBuffer) )
	OTHER
		ApplyKey(oGet,nKey)
	ENDCASE

	oGet:updateBuffer()

	IF Len(cBuffer) < nLenBuffer
		nCol:= oGet:col+Len(cBuffer)
		SetPos(oGet:row,nCol)
	ENDIF

	RETURN cBuffer
