/*
 Ŀ
  Module....: KOLTERMN.prg                                                
  Descrip...: Main source code for CA-Technicon '93 demo.                 
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "inkey.ch"
#include "getexit.ch"
#include "setcurs.ch"
#include "color.ch"
#include "ft_ach2t.ch"
#include "koltermn.ch"
#include "sk_mouse.ch"

#define SCREEN     1
#define GETCOL     2

#define DISPLAY_GETS  .T.

// keeping NF Toolkit happy.
ANNOUNCE CLIPPER501

FUNCTION Main(cAction)
	LOCAL getlist:= {},cPw:= Space(29)
	LOCAL aScreen,aS,bF1,bF2,bF3,bF5,bF10,bIns

	DEFAULT cAction TO ""
	cAction:= Upper(cAction)
	aScreen:= Sscreen()

	IF cAction=="FILES"
	   SetBlink(.F.)
	   WHILE SourceFiles() > 0
	   ENDDO
	   Rscreen(aScreen)
	   RETURN NIL
	ENDIF

	bF2:=  Setkey(K_F2, {|p,l,v,g| WhatProc(p,l,v,g)} )
	bF3:=  Setkey(K_F3, {|p,l,v,g| SourceFiles(p,l,v,g)} )

	USE customer NEW

	USE password NEW
	IF !File("password.ntx")
		INDEX ON field->password TO password
	ELSE; SET INDEX TO password
	ENDIF


	SET SCOREBOARD OFF
	SetBlink(.F.)
	SetColor("+w/b")
	Scroll()

	DispBegin()

	aS:= CenterBox( 2,30," Password ","+gr/r")

	@ maxrow()/2,aS[GETCOL] GET cPw PASSWORD CHARACTER "*" ;
				COLOR "+gr/b,n/w*" ;
				MESSAGE INFO 23,35,"PW get","+w/n"

	getlist[1]:postblock:= IIF( Upper(GetEnv("NOPW"))=="YES", ;
				    {|| .T.}, {|g,b| PWValid(g,b)} )

	// signal GET to DispEnd() following :setFocus()
	getlist[1]:endDisp:= .T.

	READ SAVE 
	Rscreen(aS[SCREEN])

	IF getlist[1]:exitstate <> GE_ESCAPE
		Scroll()
		bF1:=  Setkey(K_F1, {|p,l,v,g| SKHelp(p,l,v,g)} )
		bF5:=  Setkey(K_F5, {|p,l,v,g| JumpTo(p,l,v,g)} )
		bF10:= Setkey(K_F10,{|p,l,v,g| NoseTail(p,l,v,g)} )
		bIns:= Setkey(K_INS,InsKey() )
#ifndef NOMOUSE
		MInit()
		MCursor(.T.)
		SET MOUSE CURSOR ASCII 21
#endif
		GETS(cAction)
		Setkey(K_F1,bF1)
		Setkey(K_F5,bF5)
		Setkey(K_F10,bF10)
		Setkey(K_INS,bIns)
		CLOSE ALL
	ENDIF

#ifndef NOMOUSE
	RESET MOUSE CURSOR
	MCursor(.F.)
#endif

	Rscreen(aScreen)
	QUIT

	RETURN NIL

STATIC FUNCTION Gets(cAction)
	LOCAL nKey,getlist,aGets,nGetlist,aColor,bF9,bUp,bDn

	IF cAction == "SINGLE"
		Titles( Gets1(),DISPLAY_GETS )
		ReadModal( Gets1() )
	ELSE  // multiple pages.
		dbSelectArea("CUSTOMER")
		aGets:= IIF( cAction=="DATA",;
			     { Getlists(1,20,"+gr/b,n/w*"),;
			       Getlists(21,40,"+gr/r,n/w*"),;
			       Getlists(41,60,"+gr/gr,n/w*" )},;
			     { Gets1(),Gets2(),Gets3() } )
		IF cAction=="DATA"
		   bUp:=  Setkey(K_CTRL_PGUP,{|p,l,v,g| NewRec(p,l,v,g,aGets,K_CTRL_PGUP)})
		   bDn:=  Setkey(K_CTRL_PGDN,{|p,l,v,g| NewRec(p,l,v,g,aGets,K_CTRL_PGDN)})
		ENDIF

		bF9:=  Setkey(K_F9,{|p,l,v,g| SaveGets(p,l,v,g,aGets)} )

		dbSelectArea("PASSWORD")
		aColor:= {"+w/b","+w/r","+w/gr"}
		ReadPages( aGets,aColor,cAction )
	ENDIF

	RETURN NIL

FUNCTION PWValid(oGet,cBuffer)
	STATIC nTries
	LOCAL lRet:= .T.,aS
	DEFAULT nTries TO 0
	IF !(password->( dbSeek(cBuffer) ) .and. ;
		Trim(Upper(cBuffer))== Trim(Upper( password->password )) )
		TONE( 100,3 )
		cBuffer:= ""
		oGet:varput(Space(Len(oGet:buffer)))
		oGet:upDateBuffer()
		lRet:= .F.
		nTries++
		IF nTries == oGet:maxTries
		   CenterBox( 2,30," Sorry... ","+gr/r" )
		   SKCenter( 12,"We Won't Be Fooled Again!","+w/r" )
		   oGet:exitstate:= GE_ESCAPE
		   lRet:= .T.
		   Inkey(5)
		ENDIF
	ENDIF
	RETURN lRet

FUNCTION CB(cButn)
	RETURN IIF( cButn==NIL,chr(9),cButn )

FUNCTION SKHelp(p,l,v,oGet)
	LOCAL aS,nRow:= row(),nCol:= col(),bKey,cAlias,nPos,cTitle,cField,cVal,;
	cFieldStr
	bKey:= Setkey(K_F1,NIL)
	DEFAULT oGet TO GetActive()

	cAlias:= oGet:alias
	nPos:= IIF(oGet:id=="FLDGET",oGet:fldPos,oGet:ordPos)
	cTitle:= " Table: "+ cAlias+" "
	cField:= (cAlias)->(Field(nPos))
	IIF( Empty(cField),cField:= "NOFIELD", )

	cVal:=   IIF( Empty(oGet:varget),"EMPTY",Trim(TransForm(oGet:varget,"")) )
	cFieldStr:= " Field "+Ltrim(Str(nPos))+": "+cField+" "+cVal

	aS:= CenterBox( 2,50,cTitle,"+gr/r")

	SKCenter( MR/2,cFieldStr,"+w/r" )

	Inkey(10)
	Rscreen(aS[SCREEN])
	SetPos( nRow,nCol )
	Setkey( K_F1,bKey )

	RETURN NIL

FUNCTION PL( nPos )
	LOCAL aRet
	DO CASE
	CASE nPos==2 .or. nPos==9 .or. nPos==6
		aRet:= {{"WASHINGTON","Great White Father"},  ;
			{"ADAMS","First Veep"},               ;
			{"JEFFERSON","Sage of Monticello"},   ;
			{"MADISON","Little Jimmy"},           ;
			{"MONROE","Era of Good Feeling",2},   ;
			{"ADAMS, J.Q.","Son o' First Veep",2},;
			{"JACKSON","Old Hickory",3},          ;
			{"VAN BUREN","Little Magician"}       ;
			}
	OTHER
	ENDCASE
	RETURN aRet

FUNCTION PL2()
	RETURN {{"Al Bundy","Shoes, everywhere Shoes"},        ;
		{"Peggy Bundy","Domestic Goddess"},            ;
		{"Kelly Bundy","Unparalleld intellect"},       ;
		{"Bud Bundy","Bellringer B"},                  ;        
		{"Marcy Darcy","My life if over"},             ;
		{"Jefferson Darcy","No job, but looks good"},  ;
		{"Buck","The Wonder Dog",2} ;
		}

FUNCTION PL3(oGet,nFieldPos)
STATIC aVals
	LOCAL nX,nArea,nRec
	IF aVals==NIL
		nArea:= Select()
		dbSelectArea(oGet:alias)
		nRec:= Recno()
		aVals:= Array(LastRec(),3)
		dbGotop()
		WHILE !Eof()
			aVals[Recno()][1]:= Trim(Transform(FieldGet(nFieldPos),""))
			SKIP
		ENDDO
		dbGoTo(nRec)
		dbSelectArea(nArea)
	ENDIF
	RETURN aVals

FUNCTION WhatProc( p,l,v,oGet )
LOCAL aCurs:= {row(),col()},cId,aS,cFile
DEFAULT oGet TO Getactive()
cId:= oGet:id
aS:= Sscreen()

DO CASE
CASE cId=="TEXTGET"
    cFile:= "TEXTGET.PRG"
CASE cId=="RADIO GROUP"
    cFile:= "RADIOGRP.PRG"
CASE cId=="AUTO PICKLIST"
    cFile:= "AUTOPICK.PRG"
CASE cId=="CHECKBOX"
    cFile:= "CHECKBOX.PRG"
CASE cID=="INCREMENT"
    cFile:= "INCREMEN.PRG"
CASE cID=="TEXTWRAP"
    cFile:= "TEXTWRAP.PRG"
CASE cId=="CALCULATOR"
    cFile:= "CALCULAT.PRG"
CASE cId=="FLDGET"
    cFile:= "FLDGET.PRG"
ENDCASE

IIF( cFile<>NIL,BrowFile( cFile ), )

Rscreen(aS)
Setpos( aCurs[1],aCurs[2] )
RETURN NIL

FUNCTION SourceFiles( p,l,v,oGet )
LOCAL nX,aFiles:= Directory( "*.prg" ),aCurs:= {row(),col()},nChoice,aS

Aeval( Directory("*.ch"),{|e| Aadd(aFiles,e)} )
Aeval( Directory("*.txt"),{|e| Aadd(aFiles,e)} )
ASort( aFiles,,,{|a,b| SUBS( a[1],AT(".",a[1]) ) < SUBS( b[1],AT(".",b[1]) )})

FOR nX:= 1 TO Len(aFiles)
   aFiles[nX]:= { aFiles[nX][1] }
NEXT

MHide()

aS:= Sscreen()

IF (nChoice := A_CHOICE( 5,5,, ARRAY:aFiles ;
		BOXCOLOR:"+w/b" ;
		BOXTITLE:" Source code " ;
		TITLECOLOR:"n/w*"        ;
		TITLEPOS:1               ;
		USELCOLOR:"+gr/b"          ;
		HOTKEYCOLOR:"+w/b"         ;
		SHADOW:"FT"                 ;
		)) > 0
   BrowFile( aFiles[nChoice][1] )
ENDIF

Rscreen(aS)
MShow()

SetPos( aCurs[1],aCurs[2] )
RETURN nChoice

FUNCTION NewRec( p,l,v,oGet,aGets,nKey )
LOCAL nX,nLen,getlist,aCurs:= {row(),col()},nArea

DEFAULT oGet TO Getactive()
nArea:= Select()

SELECT sk_test

dbSkip( IIF( nKey==K_CTRL_PGDN,1,-1 ) )
IIF( Eof(),dbGoTop(),IIF( Bof(),dbGoBottom(),) )

DispBegin()
DispRec()
nLen:= Len(aGets)

FOR nX:= 1 TO nLen
   getlist:= aGets[nX]
   Aeval( getlist,{|e,n| e:varput( FieldGet(e:fldPos) ) } )
   // when we hit the current getlist, display.
   IF oGet:getlist==getlist
      Aeval( getlist,{|e| e:display()} )
   ENDIF
NEXT

oGet:updateBuffer()

dbSelectArea(nArea)

SetPos( aCurs[1],aCurs[2] )

DispEnd()

RETURN NIL

FUNCTION DispRec( cAction )
LOCAL aCurs:= {row(),col()},cAlias

DispBegin()
SetPos( 0,3 )
cAlias:= IIF(cAction=="DATA","sk_test",alias())
DispOut( " Rec: "+Padl(Ltrim(Str( (cAlias)->(Recno()))),2)+" " )
SetPos( aCurs[1],aCurs[2] )
DispEnd()

RETURN NIL

