/*
 Ŀ
  File......: BROWFILE.PRG                                                
  Descrip...: Source code for TBrowse-based ASCII file browser.           
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "inkey.ch"
#include "setcurs.ch"

#define  MR               maxrow()
#define  MC               maxcol()
#define  C_WIDTH          20
#define  MAX_LINE_LEN     256
#define  FAR_RIGHT        MAX_LINE_LEN -C_WIDTH
#define  TBROWSE_DATA     "n/w*"
#define  TBROWSE_SELECTED "+gr/n"
#define  COLOR_SPEC       TBROWSE_DATA+","+TBROWSE_SELECTED

#define  FT_FBof()        (FT_FRecno() < 1)
#define  LINE             cargo[1]
#define  NCOLPOS          cargo[2]
#define  FRAMECOLOR       "R"

#xcommand STABILIZE <o> => <o>:forceStable()

STATIC nC

FUNCTION BrowFile( cFile )
LOCAL oBr := TBrowseNew( 1,1,MR-1,MC-1 ),nKey:= 0
LOCAL oCol,nCurs,cScrn,aCurs,lBlink,nOldc

IF cFile==NIL .or. FT_FUSE(cFile)== -1
   RETURN NIL
ENDIF

oBr:cargo:= {"",1}

oCol:= TBColumnNew("",{|| Transline(oBr)} )

lBlink:= SetBlink(.F.)
nCurs:= SetCursor(SC_NONE)
aCurs:= {row(),col()}
cScrn:= SaveScreen( 0,0,MR,MC )

oCol:width:= MC-1
oBr:addcolumn(oCol)
oBr:gotopblock   := {|| FT_FGotop(),oBr:LINE:= TransLine(oBr)}
oBr:gobottomblock:= {|| FT_FGobot(),oBr:LINE:= TransLine(oBr)}
oBr:skipblock    := {|n| Fskipper(n,oBr)}
oBr:colorspec    := COLOR_SPEC
oCol:colorblock  := {|| {1} }
oCol:defcolor    := {3,2}

FT_FGotop()
oBr:LINE:= TransLine(oBr)

DISPBOX( 0,0,MR,MC," ",FRAMECOLOR+"/"+FRAMECOLOR )
DISPBOX( 0,0,MR,MC,2,"+gr/"+FRAMECOLOR )
SetPos( 0, Int(MC/2) - ((Len(cFile)+4)/2)  )
DispOut( "  "+Upper(cFile)+"  ","+w/r" )

WHILE nKey <> K_ESC

    DispBegin()
    STABILIZE oBr
    DispEnd()

    nKey:= Inkey(0)

    IF nKey <> K_ESC
       nOldc:= oBr:NCOLPOS
       StdMethods(nKey,oBr)
       IF nOldC <> oBr:NCOLPOS
         oBr:refreshAll()
       ENDIF
    ENDIF

ENDDO

FT_FUSE()

SetCursor(nCurs)
SetPos( aCurs[1],aCurs[2] )
RestScreen( 0,0,maxrow(),maxcol(),cScrn )
SetBlink(lBlink)

RETURN NIL

*****************************************************************************
STATIC FUNCTION StdMethods(nKey,oBr)

 DO CASE
    CASE nKey == K_DOWN
        IIF( FT_FRecno()<> FT_FLastRec(), oBr:down(), )

    CASE nKey == K_UP
        IIF( FT_FRecno() > 1, oBr:up(), )

    CASE nKey == K_PGDN .and. FT_FRecno()<>FT_FLastRec(); oBr:pagedown()
    CASE nKey == K_PGUP .and. FT_FRecno() > 1 ;           oBr:pageup()

    CASE nKey == K_CTRL_PGUP;  oBr:gotop()
    CASE nKey == K_CTRL_PGDN;  oBr:gobottom()

    CASE nKey == K_RIGHT  //;      oBr:right()
       IF oBr:NCOLPOS < FAR_RIGHT ; oBr:NCOLPOS++ ; ENDIF

    CASE nKey == K_LEFT   //;       oBr:left()
       IF oBr:NCOLPOS > 1 ; oBr:NCOLPOS-- ; ENDIF

    CASE nKey == K_HOME ; oBr:NCOLPOS:= 1

    CASE nKey == K_END
       oBr:NCOLPOS:= 256

    CASE nKey == K_CTRL_LEFT  //;  oBr:panleft()

       oBr:NCOLPOS:= IF( oBr:NCOLPOS <= C_WIDTH,1, oBr:NCOLPOS-C_WIDTH )

    CASE nKey == K_CTRL_RIGHT //; oBr:panright()
       oBr:NCOLPOS+= IF(oBr:NCOLPOS <= FAR_RIGHT,C_WIDTH,0)

    CASE nKey == K_CTRL_HOME  //;  oBr:panhome()  ; oBr:NCOLPOS:= 1
       oBr:NCOLPOS:= 1

    CASE nKey == K_CTRL_END  //;   oBr:panend()   ; oBr:NCOLPOS:= FAR_RIGHT
       oBr:NCOLPOS:= FAR_RIGHT

 ENDCASE
 
RETURN NIL
****************************************************************************
STATIC FUNCTION FSKipper(n,oBr)
LOCAL nSkipped := 0

    IF n > 0
        WHILE nSkipped < n .and. (FT_FRecno() < FT_FLastrec())
            FT_FSkip() ; nSkipped++
        ENDDO
    ELSEIF n < 0
        WHILE nSkipped > n .and. FT_FRecno() > 1
            FT_FSkip(-1) ; nSkipped--
        ENDDO
    ENDIF

    IF n <> 0
       oBr:LINE:= TransLine(oBr)
    ENDIF

RETURN (nSkipped)
****************************************************************************

STATIC FUNCTION Transline(oBr)
LOCAL cLine
cLine:= FT_FReadLn()
Aeval( {chr(9),chr(10),chr(13)} ,{|e| cLine:= Strtran(cLine,e," ")} )
RETURN SUBS(cLine,oBr:NCOLPOS)
