/*
 Ŀ
  Module....: TEXTWRAP.prg                                                
  Descrip...: Multi-line GET source code for CA-Technicon '93 demo.       
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "class(y).ch"
#include "inkey.ch"
#include "getexit.ch"
#include "setcurs.ch"
#include "koltermn.ch"
#include "sk_mouse.ch"

#define GE_JUMP       10

#xcommand ACCESS <m>  =>  METHOD <m>
#xcommand ASSIGN <m>  =>  METHOD <m>

FUNCTION TextWrapGetNew(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                        cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
			nMrow,nMcol,cMtxt,cMClr,nMaxc,lDyn )
DEFAULT cPict TO "",cColor TO Setcolor(),nMaxc TO maxcol(),lDyn TO .T.
DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO ""
RETURN TextWrap():New(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                        cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                        nMrow,nMcol,cMtxt,cMClr,nMaxc,lDyn )

CREATE CLASS TextWrap FROM BaseGET

 PROTECTED:
    var maxTWcol     type integer

    var lDisplay     type logical
    var lenFirstrow  type integer
    var lenLastrow   type integer

    method rScreen
    method rTrimC
    method stdColor

 EXPORT:
    var cargo

    var sArea      type char
    var hasFocus   type logical RO
    var original   type char    RO
    var reader                  RO
    var rowPos     type integer
    var colPos     type integer
    var buffMaxRow type integer RO
    var buffer
    var inscursor  TYPE integer
    var dynamic    TYPE logical
    var ordPos     type integer RO
    var numRows    type integer RO

    method init
    method updateBuffer
    method setFocus
    method killFocus
    method display
    method colorPart
    method assign
    method textwrapreader
    method maxTWrow
    method wrapApplykey
    method delEnd
    method delEndLine
    method insert
    method overstrike
    method lastCol
    method undo
    method undoLine
    method undoWord
    method deleteC
    method bufferPos
    method pushLineRight
    method wordLeft
    method wordright
    method delwordright
    method delwordLeft
    method pushWordRight
    method rePos
    method overFlow
    method maxSize
    method backSpace
    method changed
    method relRowPos
    method relColPos
    method reset

    method cursPos

    // ACCESS/ASSIGN
    method maxColumn
    method _maxColumn

    message delete method deleteC

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
            cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
		nMrow,nMcol,cMtxt,cMClr,nMaxc,lDyn ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
            cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
            nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::textWrapReader()}
  ::id:= "TEXTWRAP"
  ::rowPos:= nRow
  ::colPos:= nCol
  ::maxTWcol:= nMaxc
  ::inscursor:= SC_INSERT
  ::name:= cName
  ::hasFocus:= .F.
  ::dynamic:= lDyn
  ::sArea:= Savescreen( ::row,::col,maxrow(),maxcol() )
  ::lDisplay:= .T.

RETURN self

METHOD display()
LOCAL aBuffer,cBuffer,nX,nLines,nPos,nWidth,nMod
LOCAL aCurpos:= {row(),col()},cColor

cBuffer:= IIF(::hasFocus,::buffer,Transf(::varget,::picture))
cColor:= ::colorPart( IIF(::hasFocus,2,1) )
nPos:= 1
nWidth:= ::maxColumn -::col +1
nMod:= ( Len(cBuffer) % nWidth )
::numRows:= Int( Len(cBuffer)/nWidth ) + IIF(nMod >0,1,0)
::lenFirstRow:= Len( SUBS(cBuffer,1,nWidth) )

DispBegin()
::rScreen()

FOR nX:= 1 TO ::numRows
   SetPos( ::row+nX-1,::col ) ; Dispout( SUBS(cBuffer,nPos,nWidth),cColor )
   nPos+= nWidth
NEXT

::lenLastRow:= Len(SUBS(cBuffer,nPos-nWidth))
SetPos( aCurpos[1],aCurpos[2] )
DispEnd()

RETURN self

METHOD upDateBuffer()
IF ::hasFocus
   ::buffer  := Transf(::varget,::picture)

// this is for compatibility with Clipper's uB() since the default
// behavior is to display.  Otherwise, our uB() would exclude it,
// as with our set/killFocus().
   ::display()

ENDIF
RETURN self

METHOD setFocus()
::buffer:= Transf(::varget,::picture)
::original:= Transf(::varget,::picture)
SetPos(::rowPos,::colPos) ; ::rePos()
::hasFocus:= .T.
RETURN self

METHOD killFocus()
::hasFocus:= .F.
RETURN self

METHOD colorPart(nPart)
LOCAL nComma:= AT( ",",::colorspec )
RETURN IIF( nPart==1,Left(::colorspec,nComma-1),SUBS(::colorspec,nComma+1) )

METHOD maxTWrow()
RETURN ::row+::numRows-1

METHOD textWrapReader()

   // this is our first point of entry at runtime.  so here,
   // we grab the ::row of the immediately next GET in order
   // to limit buffer growth.  only once.
   IF ::buffMaxRow==NIL
      ::buffMaxRow:= IIF( Len(::getlist) > ::ordPos,;
                          ::getlist[::ordPos+1]:row -1,maxrow() )
   ENDIF

   // Read the GET if the WHEN condition is satisfied
   IF ( GetPreValidate( self ) )

      // Activate the GET for reading
      ::setFocus():display():dispMsg()
      ::sArea:= Savescreen( ::row,::col,maxrow(),maxcol() )
            
      WHILE ( ::exitState == GE_NOEXIT )

         // Apply keystrokes until exit
         WHILE ( ::exitState == GE_NOEXIT )
            ::wrapApplyKey()
         ENDDO

         // note: we have to assign() ourselves because ::changed
         // which triggers assignment in GPV below, isn't updated
         // because we've written our own movememt methods which
         // don't respect ::changed.
         IIF( ::changed(), ::assign(), )

         // Disallow exit if the VALID condition is not satisfied
         IF ( !GetPostValidate( self ) )
            ::exitState := GE_NOEXIT ; ::rePos()
         ENDIF

      ENDDO

      // De-activate the GET
      ::killFocus():display():clearMsg()
      ::buffer:= ::original:= ""

   ENDIF

   RETURN self


#define SCANKEY 1
#define INKEY   2
#define K_SH_INS    21040
#define K_SH_DEL    21294

METHOD wrapApplyKey( aKeys )
   LOCAL cKey,nKey,nCurs
   LOCAL bKeyBlock,nRowpos:= ::rowPos

   nKey:= SKInkey( self )

   DispBegin()

   DO CASE
   CASE ( nKey == K_UP )
      IF ::rowPos==::row
         ::exitstate:= IIF(ReadExit(),GE_WRITE,GE_UP)
      ELSE; ::rowPos-- ; ::lDisplay:= .F.
      ENDIF

   CASE nKey==K_DOWN
      IF ::rowPos==::maxTWrow()
         ::exitstate:= IIF(ReadExit(),GE_WRITE,GE_DOWN)
      ELSE; ::rowPos++ ; ::lDisplay:= .F.
      ENDIF

   CASE ( nKey == K_ENTER )
      DO CASE
      CASE ::rowPos == ::maxTWrow()
           ::exitState := GE_ENTER ; ::lDisplay:= .F.
      CASE ReadInsert()  ; ::pushLineRight()
      OTHER ; ::rowPos++ ; ::colPos:= ::col ; ::lDisplay:= .F.
      ENDCASE

   CASE ( nKey == K_ESC )
      IF ( SET( _SET_ESCAPE ) )
         ::undo()
         ::exitState := GE_ESCAPE
      ENDIF

   CASE ( nKey == K_PGDN ) .or. nKey==K_PGUP
      ::exitState := GE_WRITE

   CASE nKey==K_CTRL_PGUP
      ::rowPos:= ::row ; ::lDisplay:= .F.

   CASE nKey==K_CTRL_PGDN
      ::rowPos:= ::maxTWrow() ; ::lDisplay:= .F.
      IIF( ::lastCol() < ::colPos, ::rowPos-- , )

   CASE ( nKey == K_CTRL_HOME )
      ::rePos() ; ::lDisplay:= .F.

   CASE ( nKey == K_CTRL_END )
      ::rowPos:= ::maxTWrow()
      ::colPos:= MIN( ::maxTwCol,::lastCol() )
      ::lDisplay:= .F.

   CASE ( nKey == K_CTRL_W )
      ::exitState := GE_WRITE

   CASE ( nKey == K_CTRL_U )
      ::undo()

   CASE nKey==K_ALT_U
      ::undoLine()

   CASE nKey==K_ALT_W
      ::undoWord()

   CASE ( nKey == K_HOME )
      ::colPos:= ::col ; ::lDisplay:= .F.

   CASE ( nKey == K_END )
      ::colPos:= IIF(::rowPos==::maxTWrow(),;
                 MIN( ::maxTwCol,::lastCol() ),::maxTWcol)
      ::lDisplay:= .F.

   CASE ( nKey == K_RIGHT )
      ::colPos++ ; ::lDisplay:= .F.

   CASE ( nKey == K_LEFT )
      ::colPos-- ; ::lDisplay:= .F.

   CASE ( nKey == K_CTRL_RIGHT )
      ::wordRight() ; ::lDisplay:= .F.

   CASE ( nKey == K_CTRL_LEFT ) .or. nKey==K_SH_TAB
      ::wordLeft() ; ::lDisplay:= .F.

   CASE ( nKey == K_BS )
      ::backSpace()

   CASE ( nKey == K_DEL )
      ::delete()

   CASE ( nKey == K_CTRL_T )
      ::delWordRight()

   CASE ( nKey == K_CTRL_Y )
      ::delEnd()

   CASE nKey==K_CTRL_L
      ::delEndLine()

   CASE nKey==K_TAB
      IIF( ReadInsert(),::pushWordRight(),::wordRight() )
      IIF( !ReadInsert(),::lDisplay:= .F., )

   CASE nKey==K_CTRL_R
      ::rowPos:= ::row ; ::colPos:= ::maxTWcol
      ::lDisplay:= .F.

   CASE nKey==K_SH_INS .or. nKey==K_SH_DEL
      IF ::maxColumn > ::col .and. ::maxColumn <= maxcol()
         ::maxColumn+= IIF(nKey==K_SH_INS,1,-1)
         IF ::rowPos==::maxTWrow() .and. ;
            ::lenLastRow < ::lenFirstRow .and. ;
            ::lenLastRow <= ::numRows-1 
            ::rowPos--
         ENDIF

         ::display() ; ::lDisplay:= .F.

         IIF( ::colPos > ::lastCol(), ::colPos:= ::lastCol(), )
      ENDIF

   CASE ( nKey == K_CTRL_BS )
      ::delWordLeft()

   OTHERWISE

      IF ( nKey >= 32 .AND. nKey <= 255 )
         cKey := CHR( nKey )

         IF ( SET( _SET_INSERT ) )
               ::insert( cKey )
         ELSE; ::overstrike( cKey )
         ENDIF

         ::colPos++
      ENDIF

   ENDCASE

   nCurs:= SetCursor(SC_NONE)

   IF ::rowPos < ::row .or. ::rowPos > ::maxTWrow()
      ::rowPos:= IIF( ::rowPos < ::row,::row,::maxTWrow() )
   ENDIF

   DO CASE
   CASE ::colPos < ::col
      ::colPos:= IIF( ::rowPos > ::row,::maxTWcol,::col )
      IIF( ::rowPos > ::row,::rowPos--, )
   CASE ::colPos > ::maxTWcol
      ::colPos:= IIF( ::rowPos < ::maxTWrow(),::col,::maxTWcol )
      IIF( ::rowPos < ::maxTWrow(),::rowPos++, )
   CASE ::colPos > ::lastCol() .and. ::rowPos==::maxTWrow()
      ::colPos:= ::lastCol()
   ENDCASE

   SetPos( ::rowPos,::colPos )
   IIF( ::lDisplay, ::display(), )
   ::lDisplay:= .T.

   DispEnd()
   SetCursor(nCurs)

   RETURN self

METHOD insert(cKey)
 ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),0,cKey ),::picture)
 IIF( !::dynamic .or. ::overFlow(),::buffer:= ::rTrimC(::buffer), )
RETURN self

METHOD overStrike(cKey)
 ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),1,cKey ),::picture)
RETURN self

METHOD deleteC()
 ::buffer:= Stuff( ::buffer,::bufferPos(),1,"" )
 IIF( !::dynamic,::buffer+= " ", )
 IIF( ::colPos==::lastCol() .and. ::dynamic,::colPos--, )
RETURN self

METHOD rTrimC(cStr)
RETURN Left(cStr,Len(cStr)-1)

METHOD bufferPos()
LOCAL nOneElemLen:= ::lenFirstRow
RETURN (nOneElemLen *(::rowPos -::row)) + (::colPos-::col+1)

METHOD stdColor()
LOCAL cColor:= Setcolor()
RETURN Left(cColor,AT(",",cColor)-1)

METHOD lastCol()
RETURN ::col+ ::lenLastRow-1

METHOD undo()
::buffer:= Transf(::original,::picture)
::rePos()
RETURN self

METHOD delEndLine()
LOCAL nCols,cRepl,nLastcol
nLastcol:= IIF( ::rowPos==::maxTWrow(),::lastCol(),::maxTWCol )
nCols:= nLastcol -::colPos +1
cRepl:= IIF( ::dynamic,"",Space(nCols) )
::buffer:= Transf(Stuff( ::buffer,::bufferPos(),nCols,cRepl ),::picture)
IF Len(::buffer)==0
   ::rePos(); ::buffer:= Space(Len(::original))
ENDIF
RETURN self

METHOD delEnd()
LOCAL nCols,cRepl
nCols:= Len(::buffer) -::bufferPos()+1
cRepl:= Space(nCols)
::buffer:= Transf(Stuff( ::buffer,::bufferPos(),nCols,cRepl ),::picture)
IIF( Len(::buffer)==0,::rePos(), )
RETURN self

METHOD delWordRight()
LOCAL nBuf,nCols:= 1,bBlock,nOldColpos:= ::colPos
   nBuf:= ::bufferPos()
   bBlock:= IIF( SUBS(::buffer,nBuf,1)==" ",;
                 {|| SUBS(::buffer,nBuf,1) == " " .and. ;
                     SUBS(::buffer,nBuf+1,1) == " "} ,;
                 {|| SUBS(::buffer,nBuf,1) <> " " } )
   WHILE Eval(bBlock) .and. ::bufferPos() < Len(::buffer)
       nCols++ ; nBuf++ ; ::colPos++
   ENDDO
   ::colPos:= nOldColpos
   ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),nCols,"" ),::picture)
   IIF( !::dynamic,::buffer+= Space(nCols), )
   ::display() ; ::lDisplay:= .F.
   IIF( ::colPos > ::lastCol(), ::colPos--, )

RETURN self

METHOD delWordLeft()
LOCAL nCols:= 1,nBuf,cRepl
IF !( ::colPos == ::col .and. ::relRowPos()== 1 )
    ::wordLeft()
    nBuf:= ::bufferPos()
    WHILE SUBS(::buffer,nBuf,1) <> " "
          nCols++ ; nBuf++
    ENDDO
    ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),nCols,"" ),::picture)
    IIF( !::dynamic,::buffer+= Space(nCols), )
ENDIF
RETURN self

METHOD wordRight()
LOCAL nCol:= ::bufferPos()
IF SUBS(::buffer,nCol-1,1)==" "
   ::colPos++ ; nCol++
ENDIF
WHILE !(SUBS(::buffer,nCol-1,1) == " " .and. ;
        (SUBS(::buffer,nCol,1) <> " " ))
      ::colPos++ ; nCol++
ENDDO
RETURN self

METHOD pushWordRight()
LOCAL nColPos:= ::colPos,nLenBuf,nCols,nBufpos
nBufpos:= ::bufferPos()
::wordRight()
nCols:= ::colPos-nColPos
nLenBuf:= Len(::buffer)
::buffer:= Transf(Stuff( ::buffer,nBufpos,0,Space(nCols) ),::picture)
IIF( !::dynamic .or. ::overFlow(),;
     ::buffer:= Left(::buffer,Len(::buffer)-nCols), )
RETURN self

METHOD pushLineRight()
LOCAL nCols:= ::maxTWcol -::colPos+1
IF !::dynamic .or. ( Len(::buffer)+nCols <= ::maxSize() )
   ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),0,Space(nCols)),::picture)
   IIF( !::dynamic .or. ::overFlow(),;
        ::buffer:= Left(::buffer,Len(::buffer)-nCols), )
   ::colPos:= ::col
   IIF( ::rowPos < MIN(::maxTWrow,::buffMaxRow),::rowPos++, )
ENDIF
RETURN self

METHOD wordLeft()
LOCAL nCol,nColpos
IF ::colPos == ::col .and. ::rowPos > ::row
   ::rowPos-- ; ::colPos:= ::maxTWcol
ELSE
   nCol:= ::bufferPos()
   IF SUBS(::buffer,nCol-1,1)==" "
      ::colPos-- ; nCol--
   ENDIF
   WHILE !(SUBS(::buffer,nCol-1,1)==" " .and. ;
           (SUBS(::buffer,nCol,1) <> " "))
      ::colPos-- ; nCol--
   ENDDO
ENDIF
RETURN self

METHOD backSpace()
 ::buffer:= Transf(Stuff( ::buffer,::bufferPos()-1,1,"" ),::picture)
 ::colPos--
 IIF( !::dynamic,::buffer+= " ", )
RETURN self

METHOD undoLine()
LOCAL nCols,cOrig,nOldcol:= ::colPos
nCols:= ::maxTWcol -::col+1
::colPos:= ::col
cOrig:= SUBS(::original,::bufferPos(),nCols)
IF !(cOrig==SUBS(::buffer,::bufferPos(),nCols))
   IIF( ::dynamic .and. ::maxTWRow() < ::buffMaxRow ,nCols:= 0, )
   ::buffer:= Transf(Stuff( ::buffer,::bufferPos(),nCols,cOrig ),::picture)
ENDIF
::colPos:= nOldcol
RETURN self

METHOD undoWord()
LOCAL cOrig,nChars:= 1,nOldcolpos,nPos
IF SUBS(::buffer,::bufferPos(),1) <> " "
   nOldColpos:= ::colPos
   WHILE SUBS(::buffer,::bufferPos(),1) <> " " .and. ;
         SUBS(::buffer,::bufferPos()-1,1) <> " "
       ::colPos--
   ENDDO
   nPos:= ::bufferPos()
   WHILE SUBS(::buffer,::bufferPos(),1) <> " " .and. ;
         SUBS(::buffer,::bufferPos()+1,1) <> " "
         ::colPos++ ; nChars++
   ENDDO
   cOrig:= SUBS(::original,nPos,nChars)
   ::buffer:= Transf(Stuff( ::buffer,nPos,nChars,cOrig ),::picture)
   ::colPos:= nOldColpos
ENDIF
RETURN self

METHOD changed()
RETURN !(::buffer==::original)

METHOD relRowPos()
RETURN (::rowPos -::row +1)

METHOD relColPos()
RETURN (::colPos -::col +1 )

METHOD assign()
 Eval( ::block,::buffer )
RETURN NIL

METHOD reset()
IF ::hasFocus
   ::upDateBuffer()
   SetPos(::row,::col) ; ::rePos()
ENDIF
RETURN self

METHOD rScreen()
RestScreen(::row,::col,maxrow(),maxcol(),::sArea)
IF Len(::getlist) > ::ordPos
   Aeval( ::getlist,{|e| IIF(e:row > ::maxTWrow(),( e:dispTitle(),e:display()), ) },::ordPos+1 )
ENDIF
RETURN self

METHOD rePos()
 ::rowPos:= ::row ; ::colPos:= ::col
RETURN self

METHOD overFlow()
RETURN ( Len(::buffer) > ::maxSize() )

METHOD maxSize()
RETURN (::lenFirstRow* (::buffMaxRow-::row+1))

ACCESS maxColumn()
RETURN ::maxTWcol

ASSIGN _maxColumn(nVal)
LOCAL nRows,nOldCol:= ::maxTWcol
 nRows:= Int( Len(::buffer) / (nVal -::col +1) )
 IF !(nVal==::maxTWcol) .and. (nVal <= maxcol()) .and. ;
    (::row+nRows <= ::buffMaxRow)
    ::maxTWcol:= nVal
 ENDIF
RETURN nOldCol

// this overrides the method in BASEGET.
METHOD cursPos()
 IF ::newPos <> NIL
    SetPos( ::newPos[1],::newPos[2] )
    ::rowPos:= ::newPos[1] ; ::colPos:= ::newPos[2]
    ::newPos:= NIL
 ENDIF
RETURN self


#ifndef NOMOUSE

FUNCTION twMouseHandler( oGet )
	LOCAL nR,nC,nGet:= 0,nKey:= K_IDLE,nLastcol,lIn:= .F.,nTtlpos:= 0

	WHILE Nextkey() == 0 .and. nKey== K_IDLE
		
                DispTime()

		DO CASE
		CASE MRClick()      ; nKey:= K_ESC
			LastClick(MRIGHT)
			WHILE MRClick()  ; ENDDO
		CASE MMClick()      ; nKey:= K_PGDN
		        LastClick(MMIDDLE)
                        WHILE MMClick()  ; ENDDO
		CASE MLClick()
			// mouse row and col. 
			nR:= MRow() ; nC:= MCol()
			// if within our buffer, move there. 
                        IF nR==oGet:maxTwrow()
                           lIn:= MInregion( oGet:maxTWrow(),oGet:col,oGet:maxTwrow(),oGet:lastCol() )
                        ELSE
                           lIn:= MInregion( oGet:row,oGet:col,oGet:maxTwrow(),oGet:maxColumn )
                        ENDIF

                        IF lIn
				SetPos(nR,nC)
				oGet:rowPos:= nR ; oGet:colPos:= nC
			ELSE  	// have we a GET there?
                        	IF (nTtlpos:= MouseInTitle(oGet,nR,nC)) > 0 .or.;
			   		(nGet:= MouseInGet(oGet,nR,nC)) > 0
					nGet:= MAX( nTtlpos,nGet )
					IF !(oGet==oGet:getlist[nGet])
						nKey:= K_MOUSE
						ReadPos( nGet )
						oGet:exitstate:= GE_JUMP
						IF nTtlpos > 0
							nC:= oGet:getlist[nGet]:col						
						ENDIF
						oGet:getlist[nGet]:newPos:= {nR,nC}
					ENDIF
				ENDIF
			ENDIF

			// clear mouse click.                                                                                                                                                             
                        LastClick(MLEFT)
			WHILE MLClick() ; ENDDO
		ENDCASE
	ENDDO

	RETURN nKey

#endif
