/*
 Ŀ
  Module....: SUPPORT.prg                                                 
  Descrip...: Support source code for CA-Technicon '93 demo.              
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "inkey.ch"
#include "getexit.ch"
#include "setcurs.ch"
#include "color.ch"
#include "ft_ach2t.ch"
#include "koltermn.ch"
#include "sk_mouse.ch"

#define SCREEN     1
#define GETCOL     2

#define GE_JUMP    10
#define DISPLAY_GETS  .T.

FUNCTION ReadPages( aGets,aColor,cAction )
	LOCAL nGetList:= 1,nKey
	DEFAULT aColor TO {"+w/b","+w/r","+w/gr"}

	WHILE nGetlist > 0
#ifndef NOMOUSE
		MHide()
#endif
		SETCOLOR(aColor[nGetlist])
		DISPBOX( 0,0,MR,MC," ","+gr/"+Bkgrnd(SetColor()) )
		SKCenter( 0,"  GETs Page "+LTRIM(STR(nGetlist))+"  " )
		DispRec( cAction )
		DispTime(.T.)

		Titles( aGets[nGetlist],aColor[nGetlist],DISPLAY_GETS )
#ifndef NOMOUSE
		MShow()
#endif
		ReadModal( aGets[nGetlist] )
		nKey:= IIF( LastClick()==MMIDDLE .and. Lastkey()<>K_ESC, ;
			K_PGDN,LASTKEY() )
		nGetlist+= IIF( nKey==K_PGDN,1,-1 )
		IF nGetlist < 1 .or. nGetlist > Len(aGets)
			nGetlist:= IIF( nGetlist < 1,Len(aGets),1 )
		ENDIF
#ifndef NOMOUSE
		IIF( nKey==K_ESC .or. LastClick()==MRIGHT,nGetlist:= 0, )
#else
		IIF( nKey==K_ESC,nGetlist:= 0, )
#endif
		
	ENDDO

	RETURN nKey


FUNCTION SScreen( nT,nL,nB,nR )
	DEFAULT nT TO 0,nL TO 0,nB TO MR,nR TO MC
	RETURN { nT,nL,nB,nR,SaveScreen(nT,nL,nB,nR) }

FUNCTION RScreen( aS )
	RETURN RestScreen( aS[1],aS[2],aS[3],aS[4],aS[5] )

FUNCTION ApplyKey(oGet,nKey)
	IF !(nKey >= K_SPACE .and. nKey <= 255) .and. ;
		(VALTYPE( SETKEY(nKey) ) <> "B")
		GetApplyKey(oGet,nKey)
	ENDIF
	RETURN NIL

FUNCTION CenterBox( xType,nWidth,cTitle,cColor )
	LOCAL nTop,nLeft,nBot,nRight,aS,nRow,nCol,nCenter
	nRow:= row()    ; nCol:= col()
	nTop:= (MR/2)-1 ; nLeft:= ((MC+1)/2)-(nWidth/2)-1
	nBot:= (MR/2)+1 ; nRight:= ((MC+1)/2)+(nWidth/2)+1
	nCenter:= (MC+1)/2
	aS:= Sscreen( nTop,nLeft,nBot+2,nRight+2 )
	DISPBEGIN()
	FT_Shadow( nTop,nLeft,nBot,nRight )
	DISPBOX( nTop,nLeft,nBot,nRight,xType,cColor )
	SKCenter( nTop,cTitle,"+w/r" )

	SetPos( nTop+1,nLeft+1 ) ; DispOut( Space(nWidth+1),cColor )
	SetPos(nRow,nCol)
	DISPEND()
	RETURN {aS,nLeft+2}

FUNCTION Titles(getlist,cDefColor,lGetdisp)
	LOCAL nX,cColor,oGet,nLen:= Len(getlist)
	DEFAULT lGetdisp TO .F.

	DISPBEGIN()
	FOR nX:= 1 TO nLen
		oGet:= getlist[nX]
		cColor:= IIF( Empty(oGet:ttlcolor) ,;
				cDefcolor, oGet:ttlcolor)
		oGet:dispTitle( cColor )
		IF lGetDisp
			IF oGet:id=="TEXTWRAP"
				oGet:sArea:= SaveScreen(oGet:row,oGet:col,MR,MC)
			ENDIF
			oGet:display()
		ENDIF
		// reset each exitstate.
		oGet:exitstate:= GE_NOEXIT
	NEXT
	DISPEND()
	RETURN NIL

FUNCTION NoseTail( p,l,v,oGet )
	DEFAULT oGet TO Getactive()
	IF oGet==oGet:getlist[1] .or. oGet==Atail(oGet:getlist)
		oGet:exitstate:= IIF( oGet==oGet:getlist[1],GE_BOTTOM,GE_TOP )
	ELSE; oGet:exitstate:= GE_BOTTOM
	ENDIF
	RETURN NIL

FUNCTION JumpTo( p,l,v,oGet )
	LOCAL getlist:= {},nCurs,aS,nPos,cDest:= Space(29),nRow:= row(),nCol:= col()
	DEFAULT oGet TO GetActive()

#ifndef NOMOUSE
	MHide()
#endif

	nCurs:= SetCursor(SC_NORMAL)

	aS:= CenterBox( 2,30," Jump to: ","+gr/r")
	@ maxrow()/2,aS[GETCOL] GET cDest COLOR "+gr/b,n/w*"
	READ

	cDest:= Trim(cDest)
	IF IsAlpha(cDest)
		nPos:= Ascan(oGet:getlist,{|e| Upper(e:ttltext)==Upper(cDest)})
	ELSE; nPos:= Val(cDest)
	ENDIF
	IF nPos > 0 .and. nPos <> oGet:ordPos
		ReadPos( nPos )
		oGet:exitstate:= GE_JUMP
	ENDIF

	Rscreen(aS[SCREEN])
	SetPos(nRow,nCol)

#ifndef NOMOUSE
	MShow()
#endif

	RETURN nPos

STATIC FUNCTION ColorPart(cStr,nPart)
	LOCAL nComma:= AT(",",cStr)
	RETURN IIF( nPart==1,Left(cStr,nComma-1),SUBSTR(cStr,nComma+1) )

FUNCTION SKCenter(nRow,cStr,cColor)
	DEFAULT cColor TO Setcolor()
	SetPos( nRow,Int( (MC+1 - Len(cStr)) /2) )
	RETURN DispOut( cStr,cColor )

FUNCTION InsKey()
	RETURN {|| ReadInsert(!Readinsert()),;
		SetCursor(IIF(ReadInsert(),SC_INSERT,SC_NORMAL)) }

FUNCTION Bkgrnd( cColor )
	LOCAL nStartpos:= AT("/",cColor)+1
	LOCAL nEndpos:= IIF( "," $ cColor,AT(",",cColor),Len(cColor)+1 )
	RETURN Upper(Subs( cColor,nStartpos,(nEndpos-nStartpos) ))

FUNCTION GetBlock( aArr,nPos )
	RETURN {|e| IIF(Pcount()==0,aArr[nPos],aArr[nPos]:= e)}

FUNCTION GetLists( nStart,nLimit,cColor )
LOCAL nX,getlist:= {},aVals:= {},aStruct:= {},nRow:= 2,nElem,nVal
DEFAULT cColor TO Setcolor()

IF !File("sk_test.dbf")
   FOR nX:= 1 TO 60
      Aadd( aStruct,{"Field"+ltrim(Str(nX)),"N",10,0} )
   NEXT
   dbCreate( "sk_test.dbf",aStruct )
   USE sk_test NEW SHARED
   FOR nX:= 1 TO 4
      dbAppend()
      Aeval( Array(60),{|e,n| nVal:= Fld2Val(nX,Field(n)) ,;
			      FieldPut( n,nVal ) } )
      dbCommit() ; dbUnlock()
   NEXT
   dbGoTop()
ENDIF

IF Select("SK_TEST") == 0
   USE sk_test NEW SHARED
ENDIF

nLimit:= MIN( nLimit,FCount() )

FOR nX:= nStart TO nLimit
   @ nRow,10 SAY "Field "+ PadL(Ltrim(Str(nX)),2) ;
	     GET FIELD nX COLOR cColor NODISPLAY
   nRow++
NEXT
RETURN getlist

FUNCTION Fld2Val( nX,cField )
LOCAL nVal:= 0,nInc

WHILE Len(cField) > 0
      IF nX==2 .or. nX==4
	 nVal+= ASC( Right(cField,1) )
	 cField:= Left(cField,Len(cField)-1)
      ELSE
	 nVal+= ASC( Left(cField,1) )
	 cField:= SUBS(cField,2)
      ENDIF
ENDDO
nInc:= IIF( nX==1,40000,IIF(nX==2,10000,IIF(nX==3,40000,20000)))

RETURN nVal+ nInc


FUNCTION SKInkey( oGet,nKey )
	LOCAL lLooping:= .T.,bBlock
	DEFAULT nKey TO K_IDLE

#ifndef NOMOUSE
	MShow()
#endif

	WHILE lLooping
#ifndef NOMOUSE
		
		IF oGet:id=="TEXTWRAP"
			nKey:= twMouseHandler( oGet )
		ELSE
			nKey:= MouseHandler( oGet )
		ENDIF
				
		IF nKey== K_IDLE .and. Nextkey() <> 0
#endif
			nKey:= Inkey(0)
			IF valtype( bBlock := SetKey(nKey) ) == "B"
				Eval( bBlock, Procname(1), Procline(1), Readvar(), oGet )
			ENDIF
#ifndef NOMOUSE
		ENDIF
#endif
		
		lLooping:= (nKey== K_IDLE)
				
	ENDDO

#ifndef NOMOUSE
	MHide()
#endif

	RETURN (nKey)

#ifndef NOMOUSE

STATIC FUNCTION MouseHandler( oGet )
	LOCAL nR,nC,nGet:= 0,nKey:= K_IDLE,nTtlpos:= 0

	WHILE Nextkey() == 0 .and. nKey== K_IDLE
		
		DispTime()

		DO CASE
		CASE MRClick()
			nKey:= K_ESC
			oGet:exitstate:= GE_ESCAPE
			LastClick(MRIGHT)
			WHILE MRClick()
			ENDDO

		CASE MMClick()      ; nKey:= K_PGDN
			LastClick(MMIDDLE)
			WHILE MMClick()  ; ENDDO

		CASE MLClick()
			// mouse row and col.
			nR:= MRow() ; nC:= MCol()
			// have we a GET there?
			IF (nTtlpos:= MouseInTitle(oGet,nR,nC)) > 0 .or.;
			   (nGet:= MouseInGet(oGet,nR,nC)) > 0

				// if a title hit and not current GET.
				IF nTtlpos > 0 .and. ;
				   !(oGet==oGet:getlist[nTtlPos])
				      nGet:= nTtlPos
				      nC:= oGet:col
				      nKey:= K_MOUSE
				      ReadPos( nTtlpos )
				      oGet:exitstate:= GE_JUMP
				ENDIF
				IF nTtlpos==0
					IF oGet==oGet:getlist[nGet] .and. ;
						oGet:id <> "CALCULATOR"
						IF  oGet:id $ "AUTO PICKLIST CHECKBOX RADIO GROUP"
							nKey:= M_EXECUTE
						ELSE
							GetMousePos(oGet,nC)
						ENDIF
					ELSE
						nKey:= K_MOUSE
						ReadPos( nGet )
						oGet:getlist[nGet]:newPos:= {nR,nC}
						oGet:exitstate:= GE_JUMP
					ENDIF
				ENDIF   // nTtlpos==0
			ENDIF   // mouseintitle or mouseinget.

			LastClick(MLEFT)
			// clear mouse click.
			WHILE MLClick()
			ENDDO

		ENDCASE

	ENDDO

	RETURN nKey

FUNCTION GetMousePos(oGet,nC)
	LOCAL nDestPos:= nC-oGet:col+1
#ifndef NOMOUSE
	MHide()
#endif
	WHILE oGet:pos < nDestPos
		oGet:right()
	ENDDO
	WHILE oGet:pos > nDestPos
		oGet:left()
	ENDDO
#ifndef NOMOUSE
	MShow()
#endif
	RETURN NIL

FUNCTION MouseInGet(oGet,nR,nC)
LOCAL bBlock

bBlock:= ;
 {|e| IIF(e:id=="TEXTWRAP",;
      IIF( nR==e:maxTWrow() ,;
      MInregion( e:maxTWrow(),e:col,e:maxTwrow(),e:lastCol() ) , ;
      MInregion( e:row,e:col,e:maxTwrow(),e:maxColumn ) ) , ;
      MInregion( e:row,e:col,e:row,e:col+Len(TRANSF(e:varget,e:picture))-1 ))}

RETURN Ascan(oGet:getlist,bBlock)

FUNCTION MouseInTitle( oGet,nR,nC )
RETURN Ascan( oGet:getlist,{|e| e:withinTitle( nR,nC )} )

FUNCTION LastClick(cClk)
	STATIC cClick
	LOCAL cClique
	DEFAULT cClick TO 0
	cClique:= cClick
	IIF( valtype(cClk)=="N",cClick:= cClk, )
	RETURN cClique

#endif

FUNCTION DispTime( lForce )
STATIC cTime
LOCAL aCurs,nCurs,cFmttime
DEFAULT lForce TO .F.

IF lForce .or. cTime==NIL .or. !(Time()==cTime)
   aCurs:= {row(),col()}
   cTime:= Time()
   cFmtTime:= CvrtTime(Left(cTime,5))
   DispBegin()
   nCurs:= SetCursor(SC_NONE)
   SetPos( 0,MC-12 )
   DispOut( " "+cFmtTime+" " )
   SetPos( aCurs[1],aCurs[2] )
   SetCursor(nCurs)
   DispEnd()
ENDIF

RETURN NIL

FUNCTION CvrtTime( cTime )
LOCAL cTm:= Left(cTime,2),cMerid:= "am"
IF cTm >= "12" .and. cTm <= "23"
   cTm:= Ltrim(Str(Val( cTm ) -12))
   cTime:= cTm+SUBS(cTime,3)
   cMerid:= "pm"
ELSEIF cTm=="00" 
   cTime:= "12"+SUBS(cTime,3)
ENDIF
RETURN cTime+cMerid

FUNCTION SelfBlock( getlist,nX )
RETURN {|e| IIF(PCount()==0,getlist[nX]:fldVal,getlist[nX]:fldVal:= e)}

FUNCTION SaveGets( p,l,v,oGet,aGets )
LOCAL aCurs:= {row(),col()},nKey:= 0,aS

aS:= Sscreen( MR-3,0,MR-3,MC )
SKCenter( maxrow()-3,"Write to disk? ","+w/"+Bkgrnd(Setcolor()) )
WHILE nKey <> ASC("y") .and. nKey <> ASC("n")
   nKey:= Inkey(0)
ENDDO
IF nKey==ASC("y")
   Gets2Disk( aGets )
ENDIF
SetPos( aCurs[1],aCurs[2] )
Rscreen(aS)

RETURN NIL

FUNCTION Gets2Disk( aGets )
LOCAL nX,nX2,nLen:= Len(aGets),oGet

   FOR nX:= 1 TO nLen
      FOR nX2:= 1 TO Len( aGets[nX] )
	 oGet:= aGets[nX][nX2]
	 IF (oGet:alias)->(RLock())
	    (oGet:alias)->(FieldPut( oGet:fldPos,oGet:fldVal))
	    (oGet:alias)->(dbUnlock())
	 ENDIF
      NEXT
   NEXT

RETURN NIL

