/*
 Ŀ
  File......: RADIOGRP.PRG                                                
  Descrip...: Source code for radio button GETs.                          
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "class(y).ch"
#include "koltermn.ch"
#include "sk_mouse.ch"

FUNCTION RGroupGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
			nMrow,nMcol,cMtxt,cMClr,nID,cBtn )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO "" ,;
        nID TO 1,cBtn TO chr(9)

RETURN RadioGrp():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
			nMrow,nMcol,cMtxt,cMClr,nID,cBtn )

CREATE CLASS RadioGrp FROM BaseGET

    EXPORT:
    var isRadio type logical RO
    var radioID type integer
    var	rButton type char

    method init
    method radiogrpReader
    method voidButton

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr,nID,cBtn ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::radioGrpReader() }
  ::id:= "RADIO GROUP"
  ::isRadio:= .T.
  ::radioID:= nID
  ::rButton:= cBtn

RETURN self

METHOD radioGrpReader()
	LOCAL nKey:= 0,oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()
		
		WHILE ( oGet:exitState == GE_NOEXIT )
		
			IF (nKey:= SKInkey(oGet)) == K_SPACE .or. ;
				nKey==M_EXECUTE
                                		
				// set other group members to empty space.
				Aeval( oGet:getlist, {|e| IIF(e:isRadio .and. ;
					e:radioID==oGet:radioID,;
					::voidButton(e), ) } )
				// depress radio button for current GET.
				oGet:varput( oGet:rButton )
				oGet:upDateBuffer()
				oGet:exitstate:= GE_ENTER
			ELSE
				ApplyKey(oGet,nKey)
			ENDIF
		
                   IF !GetPostValidate( oGet )
                      oGet:exitstate:= GE_NOEXIT
                   ENDIF

                ENDDO
                
		// De-activate the GET
		oGet:killFocus():clearMsg()
                
	ENDIF

	RETURN self

METHOD voidButton(oGet)
 oGet:varPut( " " )
 oGet:display()
RETURN self
