/*
 Ŀ
  Module....: KOLTERMN.ch                                                 
  Descrip...: Main header file for CA-Technicon '93 demo.                 
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#define MR         maxrow()
#define MC         maxcol()

#ifndef K_SPACE
  #define K_SPACE  32
#endif

#define K_PLUS     43
#define K_MINUS    45
#define K_IDLE     -999

#xcommand DEFAULT <p> TO <val> [,<pn> TO <valn>]      =>                  ;
            IIF( <p> == NIL, <p> := <val>,)                               ;
            [; IIF( <pn> == NIL, <pn> := <valn>,) ]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var> AUTO PICKLIST                           ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]    =>                                ;
                                                                          ;
  AAdd(                                                                   ;
       GetList,                                                           ;
       AutoPickGETNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,    ;
               {|e| IIF(Pcount()==0,<var>,<var>:= e ) } ,                 ;
               <(var)>, ,[<clr>] ,                                        ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var>  CHECKBOX                               ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
       GetList,                                                           ;
       CheckBoxGetNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,            ;
               {|e| IIF(Pcount()==0, IIF(<var>,""," "),<var>:= (e=="") ) } ,;
               <(var)>, ,[<clr>] ,                                        ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var> RADIO GROUP <grp>                       ;
                        [BUTTON <btn>]                                    ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
       GetList,                                                           ;
       RGroupGetNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,            ;
               {|e| IIF(Pcount()==0, IIF(<var>,CB([<btn>])," "),<var>:= (e==CB([<btn>])) ) },;
               <(var)>,,[<clr>] ,                                         ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>],<grp>,[<btn>] ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var> PASSWORD [CHARACTER <pw> ]              ;
                        [COLOR <clr>]                                     ;
                        [VALID <valid>]                                   ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
  GetList,                                                                ;
  PassWordGETNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,                 ;
          {|e| IIF(Pcount()==0,<var>,<var>:= e ) } ,                      ;
          <(var)>, ,[<clr>] ,                                             ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; Atail(getlist):postblock:= <{valid}> ]                               ;
  [; ATail(GetList):<msg>]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var> INCREMENT <inc>                         ;
                        [PICTURE <pic>]                                   ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
  GetList,                                                                ;
  IncrementGETNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,                 ;
          {|e| IIF(Pcount()==0,<var>,<var>:= e ) } ,                      ;
          <(var)>,[<pic>],[<clr>] ,                                       ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>],<inc> ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var> CALCULATOR                              ;
                        [PICTURE <pic>]                                   ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
  GetList,                                                                ;
  CalculatorGETNew( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,                 ;
          {|e| IIF(Pcount()==0,<var>,<var>:= e ) } ,                      ;
          <(var)>,[<pic>],[<clr>] ,                                       ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) )                                                           ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]


#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET <var>                                         ;
                        TEXTWRAP                                          ;
                        [PICTURE <p>]                                     ;
                        [COLOR <clr>]                                     ;
                        [WHEN <when>]                                     ;
                        [VALID <valid>]                                   ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]                                      ;
                        [MAXCOLUMN <mxc>]                                 ;
                        [<dyn: DYNAMIC_MODE>]                             ;
                        [<nodisp: NODISPLAY>]  =>                         ;
                                                                          ;
  Aadd(getlist,TextWrapGetNew(<row>,                                      ;
               IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,                  ;
               {|e| IIF(Pcount()==0,<var>,<var>:= e)},                    ;
               <(var)>,[<p>],[<clr>], ;
               IIF(<.say.>,<row>,-1) ,;
               IIF(<.say.>,<col>,-1) ,;
               IIF(<.say.>,<text>,"") ,;
               IIF(<.say.>,<sclr>,"") ,;
               Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>],[<mxc>],<.dyn.> ;
            ) )                                                           ;
  [; Atail(getlist):preblock:= <{when}> ]                                 ;
  [; Atail(getlist):postblock:= <{valid}> ]                               ;
  [; ATail(GetList):<msg>]                                                ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )


#xcommand @ <row>,<col> [<say: SAY> <text> [<abv: ABOVE>] [SCOLOR <sclr>] ]              ;
                        GET <var>                                         ;
                        [PICTURE <pic>]                                   ;
                        [COLOR <clr>]                                     ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg> ]                                     ;
                        [<nodisp: NODISPLAY>]  =>                         ;
                                                                          ;
  AAdd(                                                                   ;
  GetList,                                                                ;
  TextGETNEW( <row>,IIF(<.say.>,IIF(<.abv.>,<col>,<col>+Len(<text>)+1),<col> ) ,                 ;
          {|e| IIF(Pcount()==0,<var>,<var>:= e ) } ,                      ;
          <(var)>,[<pic>],[<clr>] ,                                       ;
              IIF(<.say.>,IIF(<.abv.>,<row>-1,<row>),-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) ) ;
  [; ATail(getlist):<msg> ]        ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )

#xcommand @ <row>,<col> [<say: SAY> <text> [SCOLOR <sclr>] ]              ;
                        GET FIELD <nSub>                                  ;
                        [PICTURE <pic>]                                   ;
                        [COLOR <clr>]                                     ;
                        [<nodisp: NODISPLAY>]                             ;
                        [MESSAGE INFO <mr>,<mc>[,<mtxt>,<mclr>] ]         ;
                        [SEND <msg>]   =>                                 ;
                                                                          ;
  AAdd(                                                                   ;
  GetList,                                                                ;
  FldGETNEW( <row>,IIF(<.say.>,<col>+Len(<text>)+1,<col> ) ,             ;
               ,                      ;
              ,[<pic>],[<clr>] , ;
              IIF(<.say.>,<row>,-1) ,;
              IIF(<.say.>,<col>,-1) ,;
              IIF(<.say.>,<text>,"") ,;
              IIF(<.say.>,<sclr>,"") ,;
              Len(getlist)+1,getlist,[<mr>],[<mc>],[<mtxt>],[<mclr>] ;
            ) )                                                           ;;
  ATail(getlist):fldVal:= FieldGet(<nSub>)                                 ;;
  ATail(getlist):fldPos:= <nSub>  ;;
  ATail(getlist):block:= SelfBlock(getlist,Len(getlist))   ;;
  IIF( !(<.nodisp.>),Atail(getlist):display(), )                          ;
  [; ATail(GetList):<msg>]

