/*
 Ŀ
  File......: INCREMEN.PRG                                                
  Descrip...: Source code for inc/decrementing GET.                       
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "class(y).ch"
#include "koltermn.ch"

FUNCTION IncrementGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr,nIncr )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO "" ,;
        nIncr TO 1

RETURN Increment():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr,nIncr )

CREATE CLASS Increment FROM BaseGET

    EXPORT:
    var increVal type numeric

    method init
    method incDecReader

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr,nIncr ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::incDecReader() }
  ::id:= "INCREMENT"
  ::increVal:= nIncr

RETURN self

METHOD incDecReader()
	LOCAL nKey:= 0,nVal,oGet

        oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()
		
		WHILE ( oGet:exitState == GE_NOEXIT )
		
			IF (nKey:= SKInkey(oGet)) == K_PLUS .or. nKey==K_MINUS
				nVal:= IIF( nKey==K_PLUS,oGet:increVal,-oGet:increVal )
				oGet:varPut( oGet:varget+nVal )
				oGet:updateBuffer()
			ELSE
				ApplyKey(oGet,nKey)
			ENDIF
		
                   IF !GetPostValidate( oGet )
                      oGet:exitstate:= GE_NOEXIT
                   ENDIF

                ENDDO
                
		// De-activate the GET
		oGet:killFocus():clearMsg()

	ENDIF

	RETURN self
