/*
 Ŀ
  File......: CHECKBOX.PRG                                                
  Descrip...: Source code for checkbox GET.                               
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "class(y).ch"
#include "koltermn.ch"
#include "sk_mouse.ch"

FUNCTION CheckBoxGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO ""

RETURN CheckBox():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                      nMrow,nMcol,cMtxt,cMClr )

CREATE CLASS CheckBox FROM BaseGET

    EXPORT:


    method init
    method checkBoxReader

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::checkBoxReader() }
  ::id:= "CHECKBOX"

RETURN self

METHOD checkBoxReader()
	LOCAL nKey:= 0,oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()
                		
		WHILE ( oGet:exitState == GE_NOEXIT )
		
			// act only if the keystroke is a space.
			IF (nKey:= SKInkey(oGet)) == K_SPACE .or. ;
				nKey==M_EXECUTE
				oGet:varput( IIF(oGet:varget==""," ","") )
				oGet:upDateBuffer()
				oGet:exitstate:= GE_ENTER
			ELSE
				ApplyKey(oGet,nKey)
			ENDIF
		
                        IF !GetPostValidate( oGet )
                           oGet:exitstate:= GE_NOEXIT
                        ENDIF

                ENDDO


		// De-activate the GET
		oGet:killFocus():clearMsg()

	ENDIF

	RETURN self

