/*
 Ŀ
  File......: CALCULAT.PRG                                                
  Descrip...: Source code for calculator GET.                             
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "inkey.ch"
#include "class(y).ch"
#include "koltermn.ch"

FUNCTION CalculatorGetNew( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO ""

RETURN Calc():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                      nMrow,nMcol,cMtxt,cMClr )

CREATE CLASS Calc FROM BaseGET

    EXPORT:

    method init
    method calcReader
    method dispCalc

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::calcReader() }
  ::id:= "CALCULATOR"

RETURN self

METHOD calcReader()
	LOCAL nKey:= 0,nLenBuf,nDecPos,oGet

        oGet:= self

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )
		
		// Activate the GET for reading
		oGet:setFocus():dispMsg()

		nLenBuf:= Len(oGet:buffer)
		nDecPos:= oGet:decPos
		
		WHILE ( oGet:exitState == GE_NOEXIT )
		
			SetPos(oGet:row,oGet:col+nLenbuf-1)
			nKey:= SKInkey(oGet)
		
			// if 0-9 or "." and "." not already present.
			IF (nKey >= ASC("0") .and. nKey <= ASC("9")) .or. ;
				nKey==ASC(".") .or.  nKey==K_DEL
				::dispCalc( nKey,nDecPos,nLenBuf )
			ELSE
				ApplyKey(oGet,nKey)
			ENDIF
		
                   IF !GetPostValidate( oGet )
                      oGet:exitstate:= GE_NOEXIT
                   ENDIF

                ENDDO

		// De-activate the GET
		oGet:killFocus():clearMsg()

	ENDIF

	RETURN self
        
METHOD dispCalc( nKey,nDecPos,nLenBuf )
	LOCAL cBuffer,oGet

        oGet:= self

	DispBegin()

	IF nKey==K_DEL
		cBuffer:= "0"+IIF(nDecPos>0,"."+Replic("0",nLenBuf-nDecPos),"")
	ELSE
		IF nKey==ASC(".")
			cBuffer:= oGet:buffer+ IIF( "." $oGet:buffer,"",Chr(nKey) )
		ELSE
			cBuffer:= SUBS( oGet:buffer+ Chr(nKey),2 )
		ENDIF
		// if we've just added a ".", add a couple of decimal places
		IF Right(cBuffer,1)=="."
			cBuffer+= "00"
			cBuffer:= SUBS(cBuffer,4)
			nDecPos:= AT(".",cBuffer)
		ENDIF
		// if we have a decimal point, remove, and reposition.
		IF nDecPos > 0
			cBuffer:= Stuff(Strtran(cBuffer,"."),nDecPos,0,".")
		ENDIF
	ENDIF

	oGet:buffer:= PadL(cBuffer,nLenbuf)
	oGet:assign()
	oGet:upDatebuffer()

	DispEnd()

	RETURN self

