/*
 Ŀ
  File......: BASEGET.PRG                                                 
  Descrip...: GET inheritance base for CA-Technicon '93 demo.             
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "class(y).ch"
#define  MR  maxrow()

CREATE CLASS BaseGet FROM GET

 EXPORT:

    var cargo
    var ttlRow type integer
    var ttlCol type integer
    var ttlText type char
    var ttlColor type char
    var ordPos type integer
    var getlist type array
    var Id type char
    var alias type char
    var isRadio type logical
    var msgRow
    var msgCol
    var msgText type char
    var msgColor type char
    var newPos
    var endDisp

    method init
    method dispMsg
    method clearMsg
    method dispTitle
    method lastTitleCol
    method withinTitle

    PROTECTED:
    var msgArea type array

    method cursPos
    method checkDisp

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,cTtltext,;
            cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr ) ,;
            ( nRow,nCol,bBlock,cName,cPict,cColor )

       ::ttlRow:= nTtlrow
       ::ttlCol:= nTtlcol
       ::ttlText:= cTtltext
       ::ttlColor:= cTtlcolor
       ::ordPos:= nOrdPos
       ::getlist:= aGetlist
       ::id:= "BASEGET"
       ::alias:= Alias()
       ::isRadio:= .F.
       ::msgRow:=   nMrow
       ::msgCol:=   nMcol
       ::msgText:=  IIF( cMtxt==NIL,"",cMtxt )
       ::msgColor:= IIF( cMClr==NIL,"",cMClr )
       ::msgArea:= {}
       ::endDisp:= .F.

RETURN self

#ifdef DEMO

METHOD dispMsg()
LOCAL cMsg,cColor,aCurs:= {row(),col()}
 IF Empty(::msgArea)
    ::msgArea:= SScreen( 23,0,23,maxcol() )
 ENDIF
 SetPos( 23,Int( (maxcol()/2) -(Len(::id)/2) ) )
 DispOut( ::id,"+w/n" )
 SetPos( aCurs[1],aCurs[2] )
 ::cursPos()
 ::checkDisp()

RETURN self

#else

METHOD dispMsg()
LOCAL cMsg,cColor,aCurs:= {row(),col()}
IF ::msgRow <> NIL .and. ::msgCol <> NIL
   ::msgArea:= SScreen( ::msgRow,::msgCol,::msgRow,maxcol() )
   SetPos( ::msgRow,::msgCol )
   cMsg:=   IIF( Empty(::msgText),::id,::msgText )
   cColor:= IIF(Empty(::msgColor),Setcolor(),::msgColor)
   DispOut( cMsg,cColor )
   SetPos( aCurs[1],aCurs[2] )
ENDIF
::cursPos()
::checkDisp()

RETURN self

#endif

METHOD clearMsg()
 IF !Empty( ::msgArea )
    Rscreen( ::msgArea )
 ENDIF
RETURN self

METHOD cursPos()
 IF ::newPos <> NIL
    GetMousePos( self,::newPos[2] )
    ::newPos:= NIL
 ENDIF
RETURN self

METHOD dispTitle( cColor )
LOCAL aCurs
IF !Empty( ::ttlText )
 IIF( cColor==NIL, cColor:= ::ttlColor, )
 aCurs:= {row(),col()}
 SetPos( ::ttlRow,::ttlCol )
 DispOut( ::ttlText,cColor )
 SetPos( aCurs[1],aCurs[2] )
ENDIF
RETURN self

METHOD lastTitleCol()
RETURN IIF( Empty(::ttlText),-1,::ttlCol+Len(::ttlText)-1 )

METHOD withinTitle(nRow,nCol)
RETURN IIF( !Empty(::ttlText),;
       (nRow==::ttlRow) .and. ;
       (nCol >= ::ttlCol .and. nCol <= ::lastTitleCol() ),.F. )

METHOD checkDisp()
IF ::endDisp
   DispEnd() ; ::endDisp:= .F.
ENDIF
RETURN self
