/*
 Ŀ
  File......: AUTOPICK.PRG                                                
  Descrip...: Source code for auto picklist GET.                          
  Author....: Steve Kolterman                                             
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Session: Data Entry in Clipper 5.2:  User Interface Issues  
  Notes.....:          and Possibilities.                                 
 
*/

#include "getexit.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "class(y).ch"
#include "koltermn.ch"
#include "ft_ach2t.ch"
#include "sk_mouse.ch"

FUNCTION AutoPickGet( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                     cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                     nMrow,nMcol,cMtxt,cMClr )

DEFAULT nTtlrow TO -1,nTtlcol TO -1,cTtltext TO "",cTtlcolor TO ""

RETURN AutoPick():new( nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,;
                      cTtltext,cTtlcolor,nOrdPos,aGetlist, ;
                      nMrow,nMcol,cMtxt,cMClr )

CREATE CLASS AutoPick FROM BaseGET

    EXPORT:
    var pcklist

    method init
    method autopickListReader
    method getPicklist
    method notEmpty

END CLASS

METHOD init(nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr ) ,;
           (nRow,nCol,bBlock,cName,cPict,cColor,nTtlrow,nTtlcol,nTtltext,;
           cTtlcolor,nOrdPos,aGetlist,nMrow,nMcol,cMtxt,cMClr )

  ::reader:= {|| ::autoPickListReader() }
  ::pckList:= PL( Len(::getlist)+1 )
  ::id:= "AUTO PICKLIST"

RETURN self

METHOD autoPicklistReader()
LOCAL oGet:= self,nKey

	// Read the GET if the WHEN condition is satisfied
	IF ( GetPreValidate( oGet ) )

		// Activate the GET for reading
		oGet:setFocus():dispMsg()

		WHILE ( oGet:exitState == GE_NOEXIT )

                      IF !Empty(::varget)
                         ::notEmpty()
                      ELSE
			::getPickList()
                      ENDIF

                   IF !GetPostValidate( oGet )
                      oGet:exitstate:= GE_NOEXIT
                   ENDIF

                ENDDO

		// De-activate the GET
		oGet:killFocus():clearMsg()

	ENDIF

	RETURN self

METHOD getPickList()
	LOCAL nChoice:= 0,aS,aCurs,nCurs,nLongest:= 0,cBkgnd,bIns,oGet
	LOCAL nTop,nLeft,nBottom,nRight,aOptions,cColor,nKey:= Lastkey()

        oGet:= self
	nCurs:= SetCursor(SC_NONE)
	aCurs:= {row(),col()}
	aS:= Sscreen( oGet:row-1,oGet:col,maxrow(),maxcol() )
	bIns:= Setkey(K_INS,NIL)
	aOptions:= oGet:pcklist

	Aeval( aOptions,{|e| nLongest:= MAX( nLongest,Len(e[1]) ) } )

	nTop:= oGet:row-1
	nLeft:= oGet:col
	nBottom:= MIN( Maxrow()-4,oGet:row+Len(aOptions) )
	nRight:= nLeft+nLongest+1

	cBkgnd:= Bkgrnd(Setcolor())

	IF (nChoice := A_CHOICE( nTop,nLeft,, ARRAY:aOptions ;
		BOXCOLOR:"+w/b" ;
		USELCOLOR:"+gr/b"          ;
		HOTKEYCOLOR:"+w/b"         ;
		SHADOW:"FT"                 ;
		MES_COLOR:"+w/"+cBkgnd ;
		)) > 0
		oGet:varPut( Padr(aOptions[nChoice][1],nLongest)  )
		oGet:upDatebuffer()
		IF oGet:exitstate==GE_NOEXIT
			oGet:exitstate:= IIF( nKey==K_UP,GE_UP,GE_ENTER )
		ENDIF
	ELSE
		oGet:exitstate:= IIF( nKey==K_UP,GE_UP,GE_ENTER )
	ENDIF

	SetCursor(nCurs)
	SetPos(aCurs[1],aCurs[2])
	Rscreen(aS)
	SetKey(K_INS,bIns)

	RETURN self

METHOD notEmpty()
LOCAL nKey:= SKInkey( self )
IF nKey==K_ENTER .or. nKey==M_EXECUTE
   ::getPicklist()
   ::exitstate:= GE_ENTER
ELSE
   Applykey( self,nKey )
ENDIF
RETURN self
