;    Title:    KEYLOCK.ASM
;    Author:   F. Ho 
;    Date:     28th May 1986
;    Syntax:   LOCKSTAT()
;    Note:     returns current status of the 4 "lock" keys in the form - ICNS
;              Clipper Function.
;
;    Revised:
;    P. Baenziger, pbprograms, 1215 Lane, Kalamzoo, MI 49001
;    (616) 349-9720 (Evenings), 323-7392 (Days, 8-4:30 EDT)
;
;       Calling syntax:  1) ? LOCKSTAT()
;                        2) X = LOCKSTAT()
;
;       Returns a character type string in the form: "icns"
;
;       where:  i = insert lock key
;               c = caps lock key
;               n = num lock key
;               s = scroll lock key
;
;       If the returned string ("icns") displays any letters in upper
;       case, it means that that lock key has been "activated".
;
;       example:
;       - if the function returns: iCnS
;       it means that the Caps Lock and the Scroll Lock keys are ON
;
;    Revised:
;    by Craig Steinberg, 8/30/87 CompuServe 70166,337 Source NA2606
;              INSTOGG(): toggles insert status
;              CAPTOGG(): toggles caps lock status
;              NUMTOGG(): toggles number lock status
;              SCRTOGG(): toggles scroll lock status
;
;    Revised:
;    by Alex Feldstein, August 1988, Compuserve 72237,2150
;    Converted to Clipper Summer 87.
;
;
public LOCKSTAT, NUMTOGG, CAPTOGG, SCRTOGG, INSTOGG
;
;
extrn  __RETC:far                       ; Clipper return character
;
;==================================================
DGROUP    GROUP     DATASG
datasg segment PUBLIC  'DATA'
;==================================================
;    
;
; Table for following lock status:
LOCKTABLE   DB 'icns',0 ; All off: Insert, Caps, Numlock, Scroll
            DB 'icnS',0 ;
            DB 'icNs',0 ;
            DB 'icNS',0 ;
            DB 'iCns',0 ;
            DB 'iCnS',0 ;
            DB 'iCNs',0 ;
            DB 'iCNS',0 ;
            DB 'Icns',0 ;
            DB 'IcnS',0 ;
            DB 'IcNs',0 ;
            DB 'IcNS',0 ;
            DB 'ICns',0 ;
            DB 'ICnS',0 ;
            DB 'ICNs',0 ;
            DB 'ICNS',0 ; All on
;
;
;==================================================
datasg ends
;==================================================
;
;
;==================================================
_prog  segment byte                     ; byte aligned
assume cs:_prog,ds:DGROUP,es:NOTHING    ; original ->datasg
;==================================================
;
LOCKSTAT  proc far            ; far process for Clipper
          push bp             ; save BP on stack
                    
          mov  ah,02          ; request current shift status (into AL)
          int  16h            ; issue keyboard input ROM BIOS interrupt

          ;Returns shift state in AL in upper nibble
          ; 80h - Insert state
          ; 40h - Caps Lock state
          ; 20h - Num Lock state
          ; 10h - Scroll Lock state

          ; The index value of the KEYBOARD FLAG is in the upper
          ; nibble of AL.  To use it as a pointer, we have to divide it
          ; by 16 (or shift it right 4 times, move it into the lower
          ; nibble.  However, LOCKTABLE has 5 byte steps, so we have
          ; to multiply back by 5.  One way to do it is:
          ;    1 - Clear out the lower nibble, extend the returned
          ;        byte to a word
          ;    2 - shift right 2 times (divide by 4).  This is
          ;        the same as dividing by 16, then multiplying
          ;        by 4.  This is all that would be needed for a 
          ;        4 byte step table. 
          ;    3 - save this intermediate value in BL (or wherever)
          ;    4 - shift right 2 more times for a total of 4
          ;        right shifts (divided by 16)
          ;    5 - add in the saved value from step 3.  This gives
          ;        use the 5 byte step index in AX
          ;    6 - add the value to the base offset of LOCKTABLE
          ;        BX is now pointing to the correct entry,
          ;        ready for transfer back to CLIPPER after pushing
          ;        it and the segment value

          SUB AH, AH          ; Make a word value out of AL
          AND AL, 0F0H        ; Clear out lower nibble
          MOV CL, 2           ; Divide by 4 - 2 shift right
          SHR AL, CL
          MOV BL, AL          ; Save the divided by 4 value
          SHR AL, CL          ; Divide by 4 - a total of 16
          ADD AL, BL          ; Now we have the 5 byte a step index
                              ; into LOCKTABLE in AX
          LEA BX, LOCKTABLE   ; Get the base offset
          ADD BX, AX          ; Now points to correct entry
          MOV AX, DGROUP      ; And also the right segment
          
          ; restore stack to original position
          pop  bp             ; restore stack base pointer

          push ax             ; push AX (segment)
          push bx             ; push BX (offset)
          call __RETC         ; call Clipper return for type CHAR
          ADD SP, 4           ; quicker

          ret                 ; far return

LOCKSTAT  endp                ; end of process
;
;
;==================================================
; TOGGLE NUMBER LOCK
;==================================================
;  status is in memory location 0417h
;  XOR 0417h with  to toggle
;                80h - Insert state
;                40h - Caps Lock state
;                20h - Num Lock state
;                10h - Scroll Lock state
;
NUMTOGG   proc far  ; far process
          push bp
          mov  AX,DS               ; put data seg into AX
          push AX                  ; put it onto stack to remember it
          mov  AX,0040h            ; make a new data seg
          mov  DS,AX               ;
          mov  BX,0017h            ; offset into seg
          xor  BYTE PTR [BX],20h   ; toggle the byte pointed to by BX
          pop  AX                  ; get data seg back
          mov  DS,AX               ; restore the data seg
          pop  bp                  ; restore stack base pointer
          ret                      ; far return
NUMTOGG   endp                     ; end of process

;==================================================
; TOGGLE CAPS LOCK
;==================================================
CAPTOGG   proc far
          push bp
          mov  AX,DS
          push AX
          mov  AX,0040h
          mov  DS,AX
          mov  BX,0017h
          xor  BYTE PTR [BX],40h
          pop  AX
          mov  DS,AX
          pop  bp
          ret
CAPTOGG   endp

;==================================================
; TOGGLE SCROLL LOCK
;==================================================
SCRTOGG   proc far
          push bp
          mov  AX,DS
          push AX
          mov  AX,0040h
          mov  DS,AX
          mov  BX,0017h
          xor  BYTE PTR [BX],10h
          pop  AX
          mov  DS,AX
          pop  bp
          ret
SCRTOGG   endp

;==================================================
; TOGGLE INSERT
;==================================================
INSTOGG   proc far
          push bp
          mov  AX,DS
          push AX
          mov  AX,0040h
          mov  DS,AX
          mov  BX,0017h
          xor  BYTE PTR [BX],80h
          pop  AX
          mov  DS,AX
          pop  bp
          ret
INSTOGG   endp

_prog     ends                          ; end of segment
          end                           ; end of programme

