// KEYCODES.CH
// This file contains the inkey() codes for every possible key combination
// available on an IBM PS2/70.	These should be valid for IBM compatible
// computers as well.  Where possible - the names match inkey.ch.
// This file can be use in place in inkey.ch if desired.
// See KEYCODES.DOC for a list of all the key names.
// Note: Some keys when used with SHIFT, CONTROL, or ALTERNATE will produce
//	 the same code as they normally do.  Some produce no code at all.
// Ronald W. Frazier  07/19/91	   CIS ID: 70312,2450
// Note: I have made every effort to cross-check these numbers.  They
//	 were obtained by punching each key on the keyboard and writing
//	 down what lastkey() returned.	However, I had no practical way
//	 to TEST every single one.  Keep this in mind when debugging.

// ***********************  NORMAL KEYS  **************************

#define K_ESC		     27        // ESC

// ***********************  FUNCTION KEYS  **************************

#define K_F1		     28        // F1
#define K_F2		     -1        // F2
#define K_F3		     -2        // F3
#define K_F4		     -3        // F4
#define K_F5		     -4        // F5
#define K_F6		     -5        // F6
#define K_F7		     -6        // F7
#define K_F8		     -7        // F8
#define K_F9		     -8        // F9
#define K_F10		     -9        // F10
#define K_F11		     -40       // F11
#define K_F12		     -41       // F12

// ***********************  NUMBER KEYS  **************************

#define K_BK_APPOS	     96        // BK_APPOS - `
#define K_1		     49        // 1
#define K_2		     50        // 2
#define K_3		     51        // 3
#define K_4		     52        // 4
#define K_5		     53        // 5
#define K_6		     54        // 6
#define K_7		     55        // 7
#define K_8		     56        // 8
#define K_9		     57        // 9
#define K_0		     48        // 0
#define K_MINUS 	     45        // MINUS - -
#define K_EQUAL 	     61        // EQUAL - =

// ***********************  SPECIAL KEYS  **************************

#define K_BS		     08        // BS
#define K_TAB		     09        // TAB
#define K_ENTER 	     13        // ENTER
#define K_RETURN	     13        // RETURN

// ***********************  ALPHA KEYS	**************************

#define K_SPACEBAR	     32        // SPACEBAR
#define K_A		     97        // A
#define K_B		     98        // B
#define K_C		     99        // C
#define K_D		     100       // D
#define K_E		     101       // E
#define K_F		     102       // F
#define K_G		     103       // G
#define K_H		     104       // H
#define K_I		     105       // I
#define K_J		     106       // J
#define K_K		     107       // K
#define K_L		     108       // L
#define K_M		     109       // M
#define K_N		     110       // N
#define K_O		     111       // O
#define K_P		     112       // P
#define K_Q		     113       // Q
#define K_R		     114       // R
#define K_S		     115       // S
#define K_T		     116       // T
#define K_U		     117       // U
#define K_V		     118       // V
#define K_W		     119       // W
#define K_X		     120       // X
#define K_Y		     121       // Y
#define K_Z		     122       // Z
#define K_LF_BRKT	     91        // LF_BRKT - [
#define K_RT_BRKT	     93        // RT_BRKT - ]
#define K_BK_SLASH	     92        // BK_SLASH - \
#define K_SEMI		     59        // SEMI - ;
#define K_APPOS 	     39        // APPOS - '
#define K_COMMA 	     44        // COMMA - ,
#define K_PERIOD	     46        // PERIOD - .
#define K_SLASH 	     47        // SLASH - /

// ***********************  KEYPAD KEYS  **************************

#define K_INS		     22        // INS
#define K_DEL		     07        // DEL
#define K_HOME		     01        // HOME
#define K_END		     06        // END
#define K_PGUP		     18        // PGUP
#define K_PGDN		     03        // PGDN
#define K_UP		     05        // UP
#define K_DOWN		     24        // DOWN
#define K_LEFT		     19        // LEFT
#define K_RIGHT 	     04        // RIGHT

// ***********************  SHIFTED KEYS  **************************

#define K_SH_ESC	     27        // SH_ESC

// ***********************  SHIFTED FUNCTION KEYS  **************************

#define K_SH_F1 	     -10       // SH_F1
#define K_SH_F2 	     -11       // SH_F2
#define K_SH_F3 	     -12       // SH_F3
#define K_SH_F4 	     -13       // SH_F4
#define K_SH_F5 	     -14       // SH_F5
#define K_SH_F6 	     -15       // SH_F6
#define K_SH_F7 	     -16       // SH_F7
#define K_SH_F8 	     -17       // SH_F8
#define K_SH_F9 	     -18       // SH_F9
#define K_SH_F10	     -19       // SH_F10
#define K_SH_F11	     -42       // SH_F11
#define K_SH_F12	     -43       // SH_F12

// ***********************  SHIFTED NUMBER KEYS  **************************

#define K_TILDE 	     126       // TILDE - ~
#define K_EXCLAM	     33        // EXCLAM - !
#define K_AT		     64        // AT - @
#define K_NUMBER	     35        // NUMBER - #
#define K_POUND 	     35        // POUND - #
#define K_DOLLAR	     36        // DOLLAR - $
#define K_PERCENT	     37        // PERCENT - %
#define K_CARET 	     94        // CARET - ^
#define K_AMPERSAND	     38        // AMPERSAND - &
#define K_ASTERISK	     42        // ASTERISK - *
#define K_LF_PAREN	     40        // LF_PAREN - (
#define K_RT_PAREN	     41        // RT_PAREN - )
#define K_UNDERSCORE	     95        // UNDERSCORE - _
#define K_PLUS		     43        // PLUS - +

// ***********************  SHIFTED SPECIAL KEYS  **************************

#define K_SH_BS 	     08        // SH_BS
#define K_SH_TAB	     271       // SH_TAB
#define K_SH_ENTER	     13        // SH_ENTER
#define K_SH_RETURN	     13        // SH_RETURN

// ***********************  SHIFTED ALPHA KEYS	**************************

#define K_SH_SPACEBAR	     32        // SH_SPACEBAR
#define K_CAP_A 	     65        // CAP_A
#define K_CAP_B 	     66        // CAP_B
#define K_CAP_C 	     67        // CAP_C
#define K_CAP_D 	     68        // CAP_D
#define K_CAP_E 	     69        // CAP_E
#define K_CAP_F 	     70        // CAP_F
#define K_CAP_G 	     71        // CAP_G
#define K_CAP_H 	     72        // CAP_H
#define K_CAP_I 	     73        // CAP_I
#define K_CAP_J 	     74        // CAP_J
#define K_CAP_K 	     75        // CAP_K
#define K_CAP_L 	     76        // CAP_L
#define K_CAP_M 	     77        // CAP_M
#define K_CAP_N 	     78        // CAP_N
#define K_CAP_O 	     79        // CAP_O
#define K_CAP_P 	     80        // CAP_P
#define K_CAP_Q 	     81        // CAP_Q
#define K_CAP_R 	     82        // CAP_R
#define K_CAP_S 	     83        // CAP_S
#define K_CAP_T 	     84        // CAP_T
#define K_CAP_U 	     85        // CAP_U
#define K_CAP_V 	     86        // CAP_V
#define K_CAP_W 	     87        // CAP_W
#define K_CAP_X 	     88        // CAP_X
#define K_CAP_Y 	     89        // CAP_Y
#define K_CAP_Z 	     90        // CAP_Z
#define K_LF_BRACE	     123       // LF_BRACE - {
#define K_RT_BRACE	     125       // RT_BRACE - }
#define K_V_BAR 	     124       // V_BAR - |
#define K_COLON 	     58        // COLON - :
#define K_QUOTE 	     34        // QUOTE - "
#define K_LESS_THAN	     60        // LESS_THAN - <
#define K_GREATER_THAN	     62        // GREATER_THAN - >
#define K_QUESTION	     63        // QUESTION - ?

// ***********************  SHIFTED KEYPAD KEYS  **************************

#define K_SH_INS	     22        // SH_INS
#define K_SH_DEL	     07        // SH_DEL
#define K_SH_HOME	     01        // SH_HOME
#define K_SH_END	     06        // SH_END
#define K_SH_PGUP	     18        // SH_PGUP
#define K_SH_PGDN	     03        // SH_PGDN
#define K_SH_UP 	     05        // SH_UP
#define K_SH_DOWN	     24        // SH_DOWN
#define K_SH_LEFT	     19        // SH_LEFT
#define K_SH_RIGHT	     04        // SH_RIGHT

// ***********************  CONTROL KEYS  **************************

#define K_CTRL_ESC	     27        // CTRL_ESC

// ***********************  CONTROL FUNCTION KEYS  **************************

#define K_CTRL_F1	     -20       // CTRL_F1
#define K_CTRL_F2	     -21       // CTRL_F2
#define K_CTRL_F3	     -22       // CTRL_F3
#define K_CTRL_F4	     -23       // CTRL_F4
#define K_CTRL_F5	     -24       // CTRL_F5
#define K_CTRL_F6	     -25       // CTRL_F6
#define K_CTRL_F7	     -26       // CTRL_F7
#define K_CTRL_F8	     -27       // CTRL_F8
#define K_CTRL_F9	     -28       // CTRL_F9
#define K_CTRL_F10	     -29       // CTRL_F10
#define K_CTRL_F11	     -44       // CTRL_F11
#define K_CTRL_F12	     -45       // CTRL_F12

// ***********************  CONTROL NUMBER KEYS  **************************
// The following number keys have no discernible output when used with the
//    CONTROL key: BK_APPOS,1,3,4,5,7,8,9,0

#define K_CTRL_2	     259       // CTRL_2
#define K_CTRL_6	     30        // CTRL_6
#define K_CTRL_MINUS	     31        // CTRL_MINUS

// ***********************  CONTROL SPECIAL KEYS  **************************

#define K_CTRL_BS	     127       // CTRL_BS
#define K_CTRL_TAB	     404       // CTRL_TAB
#define K_CTRL_ENTER	     10        // CTRL_ENTER
#define K_CTRL_RETURN	     10        // CTRL_RETURN

// ***********************  CONTROL ALPHA KEYS	**************************
// The following alpha keys have no discernible output when used with the
//    CONTROL key: SEMI, APPOS, COMMA, PERIOD, SLASH

#define K_CTRL_SPACEBAR      32        // CTRL_SPACEBAR
#define K_CTRL_A	     01        // CTRL_A
#define K_CTRL_B	     02        // CTRL_B
#define K_CTRL_C	     03        // CTRL_C
#define K_CTRL_D	     04        // CTRL_D
#define K_CTRL_E	     05        // CTRL_E
#define K_CTRL_F	     06        // CTRL_F
#define K_CTRL_G	     07        // CTRL_G
#define K_CTRL_H	     08        // CTRL_H
#define K_CTRL_I	     09        // CTRL_I
#define K_CTRL_J	     10        // CTRL_J
#define K_CTRL_K	     11        // CTRL_K
#define K_CTRL_L	     12        // CTRL_L
#define K_CTRL_M	     13        // CTRL_M
#define K_CTRL_N	     14        // CTRL_N
#define K_CTRL_O	     15        // CTRL_O
#define K_CTRL_P	     16        // CTRL_P
#define K_CTRL_Q	     17        // CTRL_Q
#define K_CTRL_R	     18        // CTRL_R
#define K_CTRL_S	     19        // CTRL_S
#define K_CTRL_T	     20        // CTRL_T
#define K_CTRL_U	     21        // CTRL_U
#define K_CTRL_V	     22        // CTRL_V
#define K_CTRL_W	     23        // CTRL_W
#define K_CTRL_X	     24        // CTRL_X
#define K_CTRL_Y	     25        // CTRL_Y
#define K_CTRL_Z	     26        // CTRL_Z
#define K_CTRL_LF_BRKT	     27        // CTRL_LF_BRKT
#define K_CTRL_RT_BRKT	     29        // CTRL_RT_BRKT
#define K_CTRL_BK_SLASH      28        // CTRL_BK_SLASH

// ***********************  CONTROL KEYPAD KEYS  **************************

#define K_CTRL_INS	     402       // CTRL_INS
#define K_CTRL_DEL	     403       // CTRL_DEL
#define K_CTRL_HOME	     29        // CTRL_HOME
#define K_CTRL_END	     23        // CTRL_END
#define K_CTRL_PGUP	     31        // CTRL_PGUP
#define K_CTRL_PGDN	     30        // CTRL_PGDN
#define K_CTRL_UP	     397       // CTRL_UP
#define K_CTRL_DOWN	     401       // CTRL_DOWN
#define K_CTRL_LEFT	     26        // CTRL_LEFT
#define K_CTRL_RIGHT	     02        // CTRL_RIGHT

// ***********************  ALTERNATE KEYS  **************************

#define K_ALT_ESC	     257       // ALT_ESC

// ***********************  ALTERNATE FUNCTION KEYS  **************************

#define K_ALT_F1	     -30       // ALT_F1
#define K_ALT_F2	     -31       // ALT_F2
#define K_ALT_F3	     -32       // ALT_F3
#define K_ALT_F4	     -33       // ALT_F4
#define K_ALT_F5	     -34       // ALT_F5
#define K_ALT_F6	     -35       // ALT_F6
#define K_ALT_F7	     -36       // ALT_F7
#define K_ALT_F8	     -37       // ALT_F8
#define K_ALT_F9	     -38       // ALT_F9
#define K_ALT_F10	     -39       // ALT_F10
#define K_ALT_F11	     -46       // ALT_F11
#define K_ALT_F12	     -47       // ALT_F12

// ***********************  ALTERNATE NUMBER KEYS  **************************

#define K_ALT_BK_APPOS	     297       // ALT_BK_APPOS
#define K_ALT_1 	     376       // ALT_1
#define K_ALT_2 	     377       // ALT_2
#define K_ALT_3 	     378       // ALT_3
#define K_ALT_4 	     379       // ALT_4
#define K_ALT_5 	     380       // ALT_5
#define K_ALT_6 	     381       // ALT_6
#define K_ALT_7 	     382       // ALT_7
#define K_ALT_8 	     383       // ALT_8
#define K_ALT_9 	     384       // ALT_9
#define K_ALT_0 	     385       // ALT_0
#define K_ALT_MINUS	     386       // ALT_MINUS
#define K_ALT_EQUAL	     387       // ALT_EQUAL

// ***********************  ALTERNATE SPECIAL KEYS  **************************

#define K_ALT_BS	     270       // ALT_BS
#define K_ALT_TAB	     421       // ALT_TAB
#define K_ALT_ENTER	     284       // ALT_ENTER
#define K_ALT_RETURN	     284       // ALT_RETURN

// ***********************  ALTERNATE ALPHA KEYS  **************************
// Note: ALT_C will halt a program.  ALT_D may not be detectable.

#define K_ALT_SPACEBAR	     32        // ALT_SPACEBAR
#define K_ALT_A 	     286       // ALT_A
#define K_ALT_B 	     304       // ALT_B
#define K_ALT_C 	     302       // ALT_C
#define K_ALT_D 	     288       // ALT_D
#define K_ALT_E 	     274       // ALT_E
#define K_ALT_F 	     289       // ALT_F
#define K_ALT_G 	     290       // ALT_G
#define K_ALT_H 	     291       // ALT_H
#define K_ALT_I 	     279       // ALT_I
#define K_ALT_J 	     292       // ALT_J
#define K_ALT_K 	     293       // ALT_K
#define K_ALT_L 	     294       // ALT_L
#define K_ALT_M 	     306       // ALT_M
#define K_ALT_N 	     305       // ALT_N
#define K_ALT_O 	     280       // ALT_O
#define K_ALT_P 	     281       // ALT_P
#define K_ALT_Q 	     272       // ALT_Q
#define K_ALT_R 	     275       // ALT_R
#define K_ALT_S 	     287       // ALT_S
#define K_ALT_T 	     276       // ALT_T
#define K_ALT_U 	     278       // ALT_U
#define K_ALT_V 	     303       // ALT_V
#define K_ALT_W 	     273       // ALT_W
#define K_ALT_X 	     301       // ALT_X
#define K_ALT_Y 	     277       // ALT_Y
#define K_ALT_Z 	     300       // ALT_Z
#define K_ALT_LF_BRKT	     282       // ALT_LF_BRKT
#define K_ALT_RT_BRKT	     283       // ALT_RT_BRKT
#define K_ALT_BK_SLASH	     299       // ALT_BK_SLASH
#define K_ALT_SEMI	     295       // ALT_SEMI
#define K_ALT_APPOS	     296       // ALT_APPOS
#define K_ALT_COMMA	     307       // ALT_COMMA
#define K_ALT_PERIOD	     308       // ALT_PERIOD
#define K_ALT_SLASH	     309       // ALT_SLASH

// ***********************  ALTERNATE KEYPAD KEYS  **************************

#define K_ALT_INS	     418       // ALT_INS
#define K_ALT_DEL	     419       // ALT_DEL
#define K_ALT_HOME	     407       // ALT_HOME
#define K_ALT_END	     415       // ALT_END
#define K_ALT_PGUP	     409       // ALT_PGUP
#define K_ALT_PGDN	     417       // ALT_PGDN
#define K_ALT_UP	     408       // ALT_UP
#define K_ALT_DOWN	     416       // ALT_DOWN
#define K_ALT_LEFT	     411       // ALT_LEFT
#define K_ALT_RIGHT	     413       // ALT_RIGHT

