;****************************************************************************
; PROGRAM ----: RODENTIF.ASM
; AUTHOR -----: Kevin E. Saffer 
; COPYRIGHT --: (c) 1991 by Kevin E. Saffer 
; CREATED ----: 10/2/1991 at 9:07
;****************************************************************************
; Implements the Clipper interface to the Rodent mouse routine 
;
; Compile to an OBJ using MASM, then link into the Clipper application.
;****************************************************************************

PUSH_REGS MACRO         ;register push and pop macros for clipper interface
        PUSH    BP
        MOV     BP,SP
        PUSH    DI      
        PUSH    SI
        PUSH    DS
        PUSH    ES
        PUSH    SS
ENDM

POP_REGS MACRO
        POP     SS
        POP     ES
        POP     DS
        POP     SI
        POP     DI
        POP     BP
ENDM

;declare clipper parameter routines
EXTRN   __PARINFO:FAR	;get number of parameters or type of one
EXTRN   __PARINFA:FAR	;get size of array parameter or element type
EXTRN   __PARCSIZ:FAR	;get size of memory allocated for string parameter
EXTRN   __PARC:FAR	;get CHARACTER string, segment:offset in DX:AX
EXTRN   __RETC:FAR	;return string, push seg:off onto stack
EXTRN   __PARCLEN:FAR	;get length of a string parameter into ax
EXTRN   __RETCLEN:FAR	;return string of x length, push length:seg:off
EXTRN   __PARDS:FAR	;get DATE string, segment:offset in DX:AX
EXTRN   __RETDS:FAR	;return date string, push seg:off onto stack
EXTRN   __PARL:FAR	;get LOGICAL, value in AX
EXTRN   __RETL:FAR	;return logical, push 1 register onto stack
EXTRN   __PARND:FAR	;get numeric DOUBLE, segment:offset in DX:AX
EXTRN   __RETND:FAR	;return double, push 4 registers onto stack
EXTRN   __PARNI:FAR	;get numeric INTEGER, value in AX
EXTRN   __RETNI:FAR	;return integer, push 1 register onto stack
EXTRN   __PARNL:FAR	;get numeric LONG, value in DX:AX
EXTRN   __RETNL:FAR	;return long, push 2 registers onto stack

;declare clipper callable functions
PUBLIC MSKEYON          ;activates keyboard emulation mouse
PUBLIC MSKEYOFF         ;de-activates keyboard mouse   
PUBLIC MSFLTON          ;activates floating cursor mouse 
PUBLIC MSFLTOFF         ;de-activates floating mouse
PUBLIC MSCLRSCN         ;clears the floating mouse screen array
PUBLIC MSSETSCN         ;sets a floating mouse trigger string
PUBLIC MSGETROW         ;returns mouse cursor row
PUBLIC MSGETCOL         ;returns mouse cursor column
PUBLIC MSHORDLY         ;sets horizontal movement delay
PUBLIC MSVERDLY         ;sets vertical movement delay
PUBLIC MSCLKTIM         ;sets double click timeout
PUBLIC MSGETKEY         ;returns last keycode inserted 
PUBLIC MSCLRKEY         ;clears the last keycode value

PROGSEG SEGMENT BYTE 'CODE'     ;set up our code segment, and
        ASSUME CS:PROGSEG       ;let MASM know of our intentions

;*****************************************************************************
; system data area
;*****************************************************************************
TMP_VAR1        DW      ?               ;temporary working storage for   
TMP_VAR2        DW      ?               ;various purposes
TMP_VAR3        DW      ?               
TMP_VAR4        DW      ?               

;*****************************************************************************
; MSKEYON - activates keyboard emulation mouse
;
; Syntax: mresult = MSKEYON()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSKEYON PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        MOV     BX,AX           ;return code to BX
        XOR     AX,AX           ;assume false return
        CMP     BH,232          ;rodent installed?
        JNE     MSKEYON1        ;no, set error code and exit
        MOV     AH,81h
        INT     33h

MSKEYON1:
        POP_REGS
        PUSH    AX
        CALL    __RETL          
        POP     AX
        RET

MSKEYON ENDP

;*****************************************************************************
; MSKEYOFF - de-activates keyboard emulation mouse
;
; Syntax: mresult = MSKEYOFF()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSKEYOFF PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        MOV     BX,AX           ;return code to BX
        XOR     AX,AX           ;assume false return
        CMP     BH,232          ;rodent installed?
        JNE     MSKEYOFF1       ;no, set error code and exit
        MOV     AH,82h
        INT     33h

MSKEYOFF1:
        POP_REGS
        PUSH    AX
        CALL    __RETL          
        POP     AX
        RET

MSKEYOFF ENDP

;*****************************************************************************
; MSFLTON - activates floating cursor mouse
;
; Syntax: mresult = MSFLTON(row,col)
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSFLTON PROC FAR
        PUSH_REGS

        MOV     AX,1                    ;get row value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     CS:TMP_VAR1,AX          ;save for later

        MOV     AX,2                    ;get column value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2

        MOV     BL,AL                   ;column value to BL
        MOV     AX,CS:TMP_VAR1          ;retrieve saved row
        MOV     BH,AL                   ;row to BH
        MOV     AH,83h
        INT     33h

        POP_REGS
        PUSH    AX              ; return logical to Clipper
        CALL    __RETL          
        POP     AX
        RET

MSFLTON ENDP

;*****************************************************************************
; MSFLTOFF - de-activates floating mouse
;
; Syntax: mresult = MSFLTOFF()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSFLTOFF PROC FAR
        PUSH_REGS
        MOV     AH,84h
        INT     33h
        POP_REGS
        PUSH    AX              ; return logical to Clipper
        CALL    __RETL          
        POP     AX
        RET

MSFLTOFF ENDP

;*****************************************************************************
; MSCLRSCN - clear the floaing mouse trigger screen
;
; Syntax: mresult = MSCLRSCN()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSCLRSCN PROC FAR
        PUSH_REGS
        MOV     AH,85h
        INT     33h
        POP_REGS
        PUSH    AX              ; return logical to Clipper
        CALL    __RETL          
        POP     AX
        RET

MSCLRSCN ENDP

;*****************************************************************************
; MSSETSCN - sets a floating mouse trigger string
;
; Syntax: mresult = MSSETSCR(row,col,char value,repetition count)
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSSETSCN PROC FAR
        PUSH_REGS

        MOV     AX,1                    ;get row value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     CS:TMP_VAR1,AX          ;save for later

        MOV     AX,2                    ;get column value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     CS:TMP_VAR2,AX          ;save for later

        MOV     AX,3                    ;get ASCII character
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     CS:TMP_VAR3,AX          ;save for later

        MOV     AX,4                    ;get repitition count
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2

        MOV     CL,AL                   ;repition to CL
        MOV     AX,CS:TMP_VAR3          ;retrieve saved char
        MOV     CH,AL                   ;character to CH
        MOV     AX,CS:TMP_VAR2          ;retrieve saved column
        MOV     BL,AL                   ;column to BL
        MOV     AX,CS:TMP_VAR1          ;retrieve saved row
        MOV     BH,AL                   ;row to BH
        MOV     AH,86h
        INT     33h

        POP_REGS
        PUSH    AX
        CALL    __RETL          
        POP     AX
        RET

MSSETSCN ENDP

;*****************************************************************************
; MSGETROW - returns mouse row
;
; Syntax: mresult = MSGETROW()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSGETROW PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        XOR     BX,BX           ;assume zero
        CMP     AH,232          ;rodent installed?
        JNE     MSGETROW1       ;no, set error code and exit
        MOV     AH,89h
        INT     33h

MSGETROW1:
        POP_REGS
        PUSH    BX              
        CALL    __RETNI         
        POP     BX
        RET

MSGETROW ENDP

;*****************************************************************************
; MSGETCOL - returns mouse column
;
; Syntax: mresult = MSGETCOL()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSGETCOL PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        XOR     BX,BX           ;assume zero
        CMP     AH,232          ;rodent installed?
        JNE     MSGETCOL1       ;no, set error code and exit
        MOV     AH,8Ah
        INT     33h

MSGETCOL1:
        POP_REGS
        PUSH    BX              ; return logical to Clipper
        CALL    __RETNI         
        POP     BX
        RET

MSGETCOL ENDP

;*****************************************************************************
; MSHORDLY - sets horizontal delay value
;
; Syntax: mresult = MSHORDLY(<delay value>)
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSHORDLY PROC FAR
        MOV     AX,1                    ;get value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     BX,AX
        MOV     AH,8Dh
        INT     33h
        PUSH    AX              
        CALL    __RETNI         
        POP     AX
        RET

MSHORDLY ENDP

;*****************************************************************************
; MSVERDLY - sets vertical delay value
;
; Syntax: mresult = MSVERDLY(<delay value>)
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSVERDLY PROC FAR
        MOV     AX,1                    ;get value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     BX,AX
        MOV     AH,8Eh
        INT     33h
        PUSH    AX              
        CALL    __RETNI         
        POP     AX
        RET

MSVERDLY ENDP

;*****************************************************************************
; MSCLKTIM - sets double click time in 18 tics per second
;
; Syntax: mresult = MSCLKTIM(<delay value>)
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSCLKTIM PROC FAR
        MOV     AX,1                    ;get value
        PUSH    AX                 
        CALL    __PARNI        
        ADD     SP,2
        MOV     BX,AX
        MOV     AH,8Fh
        INT     33h
        PUSH    AX              
        CALL    __RETNI         
        POP     AX
        RET

MSCLKTIM ENDP

;*****************************************************************************
; MSGETKEY - returns last keycode inserted into the keyboard buffer
;
; Syntax: mresult = MSGETKEY()
;
; Returns: Clipper INKEY() equivalent of the keycode
;*****************************************************************************
MSGETKEY PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        XOR     BX,BX           ;assume zero
        CMP     AH,232          ;rodent installed?
        JNE     MSGETKEY9       ;no, return zero
        MOV     AH,8Bh
        INT     33h
        CMP     BH,0            ;normal key inserted?
        JE      MSGETKEY9       ;yes, return it
        CMP     BX,1C0Dh        ;left button keycode    - Return
        JNE     MSGETKEY1       ;no, continue checking
        MOV     BX,13 
        JMP     MSGETKEY9

MSGETKEY1:
        CMP     BX,011Bh        ;right button keycode   - Escape 
        JNE     MSGETKEY2       ;no, continue checking
        MOV     BX,27 
        JMP     MSGETKEY9

MSGETKEY2:
        CMP     BX,5100h        ;double left keycode    - PgUp
        JNE     MSGETKEY3       ;no, continue checking
        MOV     BX,18 
        JMP     MSGETKEY9

MSGETKEY3:
        CMP     BX,4900h        ;double right keycode   - PgDn
        JNE     MSGETKEY4       ;no, continue checking
        MOV     BX,3  
        JMP     MSGETKEY9

MSGETKEY4:
        CMP     BX,4800h        ;movement up keycode    - UpArrow
        JNE     MSGETKEY5       ;no, continue checking
        MOV     BX,5  
        JMP     MSGETKEY9

MSGETKEY5:
        CMP     BX,5000h        ;movement down keycode  - DownArrow 
        JNE     MSGETKEY6       ;no, continue checking
        MOV     BX,24 
        JMP     MSGETKEY9

MSGETKEY6:
        CMP     BX,4B00h        ;movement left keycode  - LeftArrow
        JNE     MSGETKEY7       ;no, continue checking
        MOV     BX,19 
        JMP     MSGETKEY9

MSGETKEY7:
        CMP     BX,4D00h        ;movement right keycode - RightArrow
        JNE     MSGETKEY8       ;no, continue checking
        MOV     BX,4  
        JMP     MSGETKEY9

MSGETKEY8:
        XOR     BX,BX

MSGETKEY9:
        POP_REGS
        PUSH    BX              
        CALL    __RETNI         
        POP     BX
        RET

MSGETKEY ENDP

;*****************************************************************************
; MSCLRKEY - clear the mouse LAST_KEY value
;
; Syntax: mresult = MSCLRKEY()
;
; Returns: logical value .T. or .F.
;*****************************************************************************
MSCLRKEY PROC FAR
        PUSH_REGS
        MOV     AH,80h          ;installation check
        INT     33h
        MOV     BX,AX
        XOR     AX,AX           ;assume zero
        CMP     BH,232          ;rodent installed?
        JNE     MSCLRKEY1       ;no, set error code and exit
        MOV     AH,8Ch
        INT     33h

MSCLRKEY1:
        POP_REGS
        PUSH    AX              ; return logical to Clipper
        CALL    __RETL          
        POP     AX
        RET

MSCLRKEY ENDP

PROGSEG ENDS    ;end the code segment
END             ;end the program

