;*****************************************************************************
; PROGRAM ----: RODENT.ASM 
; AUTHOR -----: Kevin E. Saffer 
; COPYRIGHT --: None, placed in the public domain
; CREATED ----: 12/5/1991 at 18:12
;*****************************************************************************
; This program implements the TSR portion of the mouse system.
;
; Compile with MASM to an object file, then link to an EXE file, ignoring
; the 'no stack' warning message.  Convert to a COM file using EXE2BIN, then
; delete the EXE file.  Do not attempt to execute the EXE or the system will
; crash.
;*****************************************************************************

;*****************************************************************************
; data segment to access the PC keyboard buffer
;*****************************************************************************
BIOS_DATA SEGMENT AT 40h
        ORG             1AH
        BUFFER_HEAD     DW   ?  ;pointer to the keybord buffer head
        BUFFER_TAIL     DW   ?  ;pointer to the keyboard buffer tail
        ORG             80h
        BUFFER_START    DW   ?  ;starting keyboard buffer address
        BUFFER_END      DW   ?  ;ending keyboard buffer address
BIOS_DATA ENDS

;*****************************************************************************
; program segment
;*****************************************************************************
PROGSEG SEGMENT
	ASSUME	CS:PROGSEG              ;set up a standard COM file
        ORG	100H

RODENT PROC FAR
      	JMP	STARTUP                 ;jump to the initialization portion

RODENT ENDP

;*****************************************************************************
; system messages
;*****************************************************************************
INITMSG	DB	'RODENT - The Mouse Wrangler (C) 1992 Kevin E. Saffer',13,10
	DB	'Interrupt Handler is Loaded.$'
NOMSMSG	DB	'The Mouse Interface Must Be Loaded Before Before Rodent, Cancelling...$'
LOADMSG	DB	'Rodent has already been loaded, re-activating.$'

;*****************************************************************************
; system data area
;*****************************************************************************
TMP_VAR1        DW      ?               ;temporary working storage for   
TMP_VAR2        DW      ?               ;various purposes
TMP_VAR3        DW      ?               
TMP_VAR4        DW      ?               
SCREEN_MAP      DB      2000 DUP(0)     ;floating cursor screen map 80x25
HORI_DELAY      DW      30              ;horizontal motion delay factor
VERT_DELAY      DW      15              ;vertical motion delay factor
CLICK_DELAY     DW      6               ;double click delay in timer ticks
LEFT_CLICK      DW      1C0Dh           ;left button keycode    - Return
RIGHT_CLICK     DW      011Bh           ;right button keycode   - Escape 
DLEFT_CLICK     DW      5100h           ;double left keycode    - PgUp
DRIGHT_CLICK    DW      4900h           ;double right keycode   - PgDn
MOVE_UP         DW      4800h           ;movement up keycode    - UpArrow
MOVE_DOWN       DW      5000h           ;movement down keycode  - DownArrow 
MOVE_LEFT       DW      4B00h           ;movement left keycode  - LeftArrow
MOVE_RIGHT      DW      4D00h           ;movement right keycode - RightArrow
UP_COUNT        DW      0               ;count of up mickeys received
DOWN_COUNT      DW      0               ;count of down mickeys received
LEFT_COUNT      DW      0               ;count of left mickeys received
RIGHT_COUNT     DW      0               ;count of right mickeys received
LAST_KEY        DW      0               ;value of last key inserted into buffer
LEFT_TIMER      DW      0               ;used for left button double clicks
RIGHT_TIMER     DW      0               ;used for right button double clicks

;*****************************************************************************
; system equates  
;*****************************************************************************
TIMER   EQU     46CH	                ;low-memory timer word

;*****************************************************************************
; PROCESS - processes a function number and calls the appropriate routine
;*****************************************************************************
PROCESS	PROC NEAR
	SUB	AH,80H  		;normalize the function code
        CMP     AH,0                    ;install check?
        JNE     PROCESS1                ;no, continue checking
        MOV     AH,232                  ;set flag to indicate we're here
        RET                                 

PROCESS1:
        CMP     AH,1                    ;activate keyboard mouse?
        JNE     PROCESS2                ;no, continue checking
        CALL    KEYBD_ON
        RET

PROCESS2:
        CMP     AH,2                    ;de-activate keyboard mouse?
        JNE     PROCESS3                ;no, continue checking
        CALL    KEYBD_OFF
        RET

PROCESS3:
        CMP     AH,3                    ;activate floating mouse? 
        JNE     PROCESS4                ;no, continue checking
        CALL    FLOAT_ON
        RET

PROCESS4:
        CMP     AH,4                    ;de-activate floating mouse?
        JNE     PROCESS5                ;no, continue checking
        CALL    FLOAT_OFF
        RET

PROCESS5:
        CMP     AH,5                    ;clear floating mouse screen map?
        JNE     PROCESS6                ;no, continue checking
        CALL    CLEAR_MAP
        RET

PROCESS6:
        CMP     AH,6                    ;set floating mouse screen map entry?
        JNE     PROCESS7                ;no, continue checking
        CALL    SET_MAP
        RET

PROCESS7:
        CMP     AH,7                    ;return entire screen map?
        JNE     PROCESS8                ;no, continue checking
        MOV     BX,CS                   ;segment to BX
        MOV     CX,OFFSET SCREEN_MAP    ;offset to CX
        MOV     DX,2000                 ;length to DX
        MOV     AX,1                    ;set success code
        RET

PROCESS8:
        CMP     AH,8                    ;set entire screen map?
        JNE     PROCESS9                ;no, continue checking

        MOV     AX,1                    ;set success code
        RET

PROCESS9:
        CMP     AH,9                    ;get cursor row?
        JNE     PROCESS10               ;no, continue checking
        MOV     AX,3                    ;use function 3 of 
        INT     33h                     ;mouse interrupt to determine position
        XOR     CH,CH            
        MOV     CL,3            
        SAR     DX,CL                   ;divide vert. pos by 8
        MOV     BX,DX
        MOV     AX,1                    ;set success code
        RET

PROCESS10:
        CMP     AH,10                   ;get cursor column?
        JNE     PROCESS11               ;no, continue checking
        MOV     AX,3                    ;use function 3 of 
        INT     33h                     ;mouse interrupt to determine position
        MOV     AX,CX                   ;store horiz. position in AX
        XOR     CH,CH            
        MOV     CL,3            
        SAR     AX,CL                   ;divide horiz. pos. by 8
        MOV     BX,AX
        MOV     AX,1                    ;set success code
        RET

PROCESS11:
        CMP     AH,11                   ;return last key inserted?
        JNE     PROCESS12               ;no, continue checking
        MOV     BX,LAST_KEY             ;lastkey to BX
        MOV     AX,1                    ;set success code
        RET

PROCESS12:
        CMP     AH,12                   ;clear last key inserted?
        JNE     PROCESS13               ;no, continue checking
        MOV     LAST_KEY,0              ;zero lastkey
        MOV     AX,1                    ;set success code
        RET

PROCESS13:
        CMP     AH,13                   ;set horizontal delay?
        JNE     PROCESS14               ;no, continue checking
        CMP     BX,0
        JNE     PROCESS13_1
        MOV     BX,30

PROCESS13_1:
        MOV     HORI_DELAY,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS14:
        CMP     AH,14                   ;set vertical delay?
        JNE     PROCESS15               ;no, continue checking
        CMP     BX,0
        JNE     PROCESS14_1
        MOV     BX,15

PROCESS14_1:
        MOV     VERT_DELAY,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS15:
        CMP     AH,15                   ;set double click timeout?
        JNE     PROCESS16               ;no, continue checking
        CMP     BX,0
        JNE     PROCESS15_1
        MOV     BX,6 

PROCESS15_1:
        MOV     CLICK_DELAY,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS16:
        CMP     AH,16                   ;set left click character?
        JNE     PROCESS17               ;no, continue checking
        MOV     LEFT_CLICK,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS17:
        CMP     AH,17                   ;set right click character?
        JNE     PROCESS18               ;no, continue checking
        MOV     RIGHT_CLICK,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS18:
        CMP     AH,18                   ;set double left click character?
        JNE     PROCESS19               ;no, continue checking
        MOV     DLEFT_CLICK,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS19:
        CMP     AH,19                   ;set double right click character?
        JNE     PROCESS20               ;no, continue checking
        MOV     DRIGHT_CLICK,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS20:
        CMP     AH,20                   ;set up movement character?
        JNE     PROCESS21               ;no, continue checking
        MOV     MOVE_UP,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS21:
        CMP     AH,21                   ;set down movement character?
        JNE     PROCESS22               ;no, continue checking
        MOV     MOVE_DOWN,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS22:
        CMP     AH,22                   ;set left movement character?
        JNE     PROCESS23               ;no, continue checking
        MOV     MOVE_LEFT,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS23:
        CMP     AH,23                   ;set right movement character?
        JNE     PROCESS24               ;no, continue checking
        MOV     MOVE_RIGHT,BX
        MOV     AX,1                    ;set success code
        RET

PROCESS24:
        MOV     AX,0                    ;set error code
        RET

PROCESS	ENDP

;*****************************************************************************
; KEYBD_ON - activate keyboard mouse
;*****************************************************************************
KEYBD_ON PROC NEAR
        MOV     UP_COUNT,0              ;zero the mouse movement counters
        MOV     DOWN_COUNT,0
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     LAST_KEY,0
        MOV     AX,2                    ;use function 2 of mouse driver
        INT     33h                     ;to turn cursor off
        MOV     AX,CS                   ;tell function 12 where to find the
        MOV     ES,AX                   ;the mouse routine
        MOV     DX,OFFSET KEYBDMOUSE
        MOV     AX,12                   ;use function 12
        MOV     CX,0000000000101011b    ;set up the mask for buttons 
        INT     33h                 
        MOV     AX,1                    ;set success code
        RET

KEYBD_ON ENDP

;*****************************************************************************
; KEYBD_OFF - de-activate keyboard mouse
;*****************************************************************************
KEYBD_OFF PROC NEAR
        MOV     UP_COUNT,0              ;zero the mouse movement counters
        MOV     DOWN_COUNT,0
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     LAST_KEY,0
        MOV     AX,2                    ;use function 2 of mouse driver
        INT     33h                     ;to turn cursor off
        MOV     AX,0                    ;use function 0 to
        INT     33h                     ;reset mouse
        MOV     AX,1                    ;set success code
        RET

KEYBD_OFF ENDP

;*****************************************************************************
; FLOAT_ON - activate floating mouse
;
; On Entry: BH - initial row for the cursor, changed to 0 if error
;           BL - initial column, changed to 0 if error
;
; On Exit:  AH = 1 if successful
;           AH = 0 if error
;*****************************************************************************
FLOAT_ON PROC NEAR
        MOV     UP_COUNT,0              ;zero the mouse movement counters
        MOV     DOWN_COUNT,0
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     LAST_KEY,0
        MOV     LAST_KEY,0
        CMP     BH,0                    ;check row lower limit
        JGE     FLOAT_ON1               ;ok, continue processing
        MOV     BH,0                    ;set default value

FLOAT_ON1:
        CMP     BH,24d                  ;check row upper limit
        JLE     FLOAT_ON2               ;ok, continue processing
        MOV     BH,0                    ;set error code

FLOAT_ON2:
        CMP     BL,0                    ;check col lower limit
        JGE     FLOAT_ON3               ;ok, continue processing
        MOV     BL,0                    ;set default value

FLOAT_ON3:
        CMP     BL,79d                  ;check col upper limit
        JLE     FLOAT_ON4               ;ok, continue processing
        MOV     BL,0                    ;set error code

FLOAT_ON4:
        XOR     AX,AX                   ;clear AX
        MOV     AL,BL                   ;column to AL
        XOR     DX,DX                   ;clear DX
        MOV     DL,BH                   ;row to DL
        MOV     CL,3            
        SAL     AX,CL                   ;multiply hor. pos. by 8
        SAL     DX,CL                   ;multiply vert. pos. by 8
        MOV     CX,AX                   ;hor. pos to CX
        MOV     AX,0004h                ;set mouse position function to AX
        INT     33h                     ;call mouse       
        MOV     AX,1                    ;use function 1 of mouse driver
        INT     33h                     ;to turn cursor on
        MOV     AX,15                   ;use function 15 of mouse driver to
        MOV     CX,4                    ;set horiz pixels/mickey ratio
        MOV     DX,8                    ;set vert pixles/mickey ratio
        INT     33h                 
        MOV     AX,CS                   ;tell function 12 where to
        MOV     ES,AX                   ;find the mouse routine
        MOV     DX,OFFSET FLOATMOUSE  
        MOV     AX,12                   ;use function 12
        MOV     CX,0000000000101010b    ;set up the mask for buttons and cursor
        INT     33h                     
        MOV     AX,1                    ;set success code
        RET

FLOAT_ON ENDP

;*****************************************************************************
; FLOAT_OFF - de-activate floating mouse
;*****************************************************************************
FLOAT_OFF PROC NEAR
        MOV     AX,2                    ;use function 2 of mouse driver
        MOV     UP_COUNT,0              ;zero the mouse movement counters
        MOV     DOWN_COUNT,0
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     LAST_KEY,0
        INT     33h                     ;to turn cursor off
        MOV     AX,0                    ;use function 0 to
        INT     33h                     ;reset mouse
        MOV     AX,1                    ;set success code
        RET

FLOAT_OFF ENDP

;*****************************************************************************
; CLEAR_MAP - clears the floating cursor screen map
;
; On Entry: Nothing
;
; On Exit:  AH = 1
;*****************************************************************************
CLEAR_MAP PROC NEAR
        MOV     CX,2000                 ;set up for the fill
        MOV     BX,0             

CLEAR_MAP1:
        MOV     SCREEN_MAP[BX],0        ;move a null byte to the screen map
        INC     BX                      ;advance pointer to the next byte
        LOOP    CLEAR_MAP1              ;loop until CX = 0
        MOV     AX,1                    ;set success code
        RET                     

CLEAR_MAP ENDP

;*****************************************************************************
; SET_MAP - sets a floating cursor screen map trigger
;
; On Entry: BH = row coordinate (0 - 24)
;           BL = column coordinate (0 - 79)
;           CH = ASCII character to stuff into the keyboard buffer
;           CL = number of screen columns to program
;
; On Exit:  AH = 1 if successful
;           AH = 0 if error
;*****************************************************************************
SET_MAP PROC NEAR
        CMP     BH,0                    ;check row lower limit
        JGE     SET_MAP1                ;ok, continue processing
        MOV     BH,0                    ;set default   

SET_MAP1:
        CMP     BH,24d                  ;check row upper limit
        JLE     SET_MAP2                ;ok, continue processing
        MOV     BH,0                    ;set default   

SET_MAP2:
        CMP     BL,0                    ;check column upper limit
        JGE     SET_MAP3                ;ok, continue processing
        MOV     BL,0                    ;set default   

SET_MAP3:
        CMP     BL,79d                  ;check column upper limit
        JLE     SET_MAP4                ;ok, continue processing
        MOV     BL,0                    ;set default   

SET_MAP4:
        PUSH    CX                      ;save CX register
        XOR     AX,AX                   ;clear AX
        MOV     AL,BH                   ;row coordinate to AL
        MOV     CL,80d                  ;multiply row value by 80
        MUL     CL
        XOR     BH,BH                   ;clear row value from BX
        ADD     AX,BX                   ;add in the column value to compute screen offset
        MOV     BX,AX                   ;offset to BX
        POP     CX                      ;restore character and repitition count
        MOV     AL,CH                   ;character to AH
        XOR     CH,CH                   ;clear character from CX

SET_MAP5:
        CMP     BX,2001d                ;are we about to overshoot the screen?
        JE      SET_MAP6                ;yes, exit loop
        MOV     SCREEN_MAP[BX],AL       ;move character to screen map
        INC     BX                      ;point to next location
        LOOP    SET_MAP5                ;repeat until CX = 0

SET_MAP6:
        MOV     AX,1                    ;set success code
        RET

SET_MAP ENDP

;*****************************************************************************
; FLOATMOUSE - called from the mouse routine to handle floating cursor
;*****************************************************************************
FLOATMOUSE PROC FAR
        CMP     AX,8                    ;right button pressed?
        JNE     FLOATMOUSE1             ;no, left must be 
        MOV     AL,27                   ;set up to stuff an Esc char
        XOR     AH,AH
        CALL    KEYINSERT               ;stuff it and return
        RET

FLOATMOUSE1:
        MOV     AX,3                    ;retrieve cursor position
        INT     33h             
        MOV     AX,CX                   ;store horiz. position in AX
        XOR     CH,CH            
        MOV     CL,3            
        SAR     AX,CL                   ;divide horiz. pos. by 8
        SAR     DX,CL                   ;divide vert. pos by 8
        PUSH    AX                      ;save hor. pos.
        MOV     AX,DX                   ;vert. pos to AX
        SHL     AX,1                    ;multiply vertical count by 80
        MOV     CX,AX
        SHL     AX,1
        SHL     AX,1
        ADD     AX,CX
        MOV     CL,3            
        SHL     AX,CL          
        POP     BX                      ;restore horizontal pos.
        ADD     AX,BX                   ;then add to vertical
        MOV     BX,AX          
        CMP     SCREEN_MAP[BX],0        ;check for character to stuff
        JNE     FLOATMOUSE2             ;character found, continue 
        RET

FLOATMOUSE2:
        MOV     AL,SCREEN_MAP[BX]       ;move character to AL
        XOR     AH,AH                   ;clear AX
        CALL    KEYINSERT               ;stuff character
        RET

FLOATMOUSE ENDP

;*****************************************************************************
; KEYBDMOUSE - called from the mouse routine to handle keyboard mouse 
;*****************************************************************************
KEYBDMOUSE PROC FAR
        TEST    AX,2                    ;left button pressed?
        JZ      KEYBDMOUSE1             ;no, continue checking
        XOR     BX,BX                   ;set up for left button
        MOV     AX,5                    ;button press data function to AX
        INT     33h                     ;call the mouse to check recursive call
        CMP     BX,0
        JNE     KEYBDMOUSE_LTIMER1
        RET

KEYBDMOUSE_LTIMER1:
	PUSH	DS                      ;save DS for later
	XOR	AX,AX                   ;set DS to point to segment 0
	MOV	DS,AX			
        MOV	AX,DS:[TIMER]	        ;retrieve timer
        MOV	CS:LEFT_TIMER,AX	;save timer value for comparison

KEYBDMOUSE_LTIMER2:
        MOV	AX,DS:[TIMER]	        ;retrieve timer
        SUB     AX,CS:LEFT_TIMER        ;calc elapsed time
        CMP     AX,CS:CLICK_DELAY       ;past delay time for double click?
        JG      KEYBDMOUSE_LTIMER4      ;yes, issue single left click char
        XOR     BX,BX                   ;set up for left button
        MOV     AX,5                    ;button press data function to AX
        INT     33h                     ;call the mouse
        CMP     BX,0                    ;button pressed?
        JG      KEYBDMOUSE_LTIMER3      ;yes, issue double left click char
        JMP     KEYBDMOUSE_LTIMER2        

KEYBDMOUSE_LTIMER3:
        POP     DS
        MOV     AX,DLEFT_CLICK          ;load button keycode
        CALL    KEYINSERT               ;insert it into buffer
        RET

KEYBDMOUSE_LTIMER4:
        POP     DS
        MOV     AX,LEFT_CLICK           ;load button keycode
        CALL    KEYINSERT               ;insert it into buffer
        RET

KEYBDMOUSE1:
        TEST    AX,8                    ;right button pressed?
        JZ      KEYBDMOUSE2             ;no, continue checking
        MOV     BX,1                    ;set up for right button
        MOV     AX,5                    ;button press data function to AX
        INT     33h                     ;call the mouse to check recursive call
        CMP     BX,0
        JNE     KEYBDMOUSE_RTIMER1
        RET

KEYBDMOUSE_RTIMER1:
	PUSH	DS                      ;save DS for later
	XOR	AX,AX                   ;set DS to point to segment 0
	MOV	DS,AX			
        MOV	AX,DS:[TIMER]	        ;retrieve timer
        MOV	CS:RIGHT_TIMER,AX	;save timer value for comparison

KEYBDMOUSE_RTIMER2:
        MOV	AX,DS:[TIMER]	        ;retrieve timer
        SUB     AX,CS:RIGHT_TIMER       ;calc elapsed time
        CMP     AX,CS:CLICK_DELAY       ;past delay time for double click?
        JG      KEYBDMOUSE_RTIMER4      ;yes, issue single left click char
        MOV     BX,1                    ;set up for right button
        MOV     AX,5                    ;button press data function to AX
        INT     33h                     ;call the mouse
        CMP     BX,0                    ;button pressed?
        JG      KEYBDMOUSE_RTIMER3      ;yes, issue double left click char
        JMP     KEYBDMOUSE_RTIMER2        

KEYBDMOUSE_RTIMER3:
        POP     DS
        MOV     AX,DRIGHT_CLICK         ;load button keycode
        CALL    KEYINSERT               ;insert it into buffer
        RET

KEYBDMOUSE_RTIMER4:
        POP     DS
        MOV     AX,RIGHT_CLICK          ;load button keycode
        CALL    KEYINSERT               ;insert it into buffer

KEYBDMOUSE2:
        MOV     AX,11                   ;use mouse driver's function 11
        INT     33h                     ;read mouse motion counters

KEYBDMOUSE3:
        CMP     DX,0                    ;vertical count negative?
        JL      KEYBDMOUSE4             ;yes, continue processing
        ADD     DOWN_COUNT,DX           ;add to total 
        JMP     KEYBDMOUSE5

KEYBDMOUSE4:
        NEG     DX                      ;change to positive value
        ADD     UP_COUNT,DX             ;add to total 

KEYBDMOUSE5:
        CMP     CX,0                    ;horizontal count negative?
        JL      KEYBDMOUSE6             ;yes, continue processing
        ADD     RIGHT_COUNT,CX          ;add to total 
        JMP     KEYBDMOUSE7

KEYBDMOUSE6:
        NEG     CX                      ;change to positive value
        ADD     LEFT_COUNT,CX           ;add to total 

KEYBDMOUSE7:
        CALL    KEYBDPROCESS            ;call keystroke processor
        RET

KEYBDMOUSE ENDP

;*****************************************************************************
; KEYBDPROCESS - called from the keyboard routine to handle keystrokes 
;*****************************************************************************
KEYBDPROCESS PROC NEAR

KEYBDPROCESS1:
        MOV     AX,HORI_DELAY           ;retrieve horizontal delay factor
        CMP     RIGHT_COUNT,AX          ;have we reached the delay threshold?
        JL      KEYBDPROCESS3           ;no, continue 
        SUB     RIGHT_COUNT,AX          ;deduct the delay threshold
        CMP     RIGHT_COUNT,0           ;check for overflow
        JGE     KEYBDPROCESS2           ;no overflow, continue
        XOR     AX,AX                   ;zero the counter
        MOV     RIGHT_COUNT,AX

KEYBDPROCESS2:
        MOV     UP_COUNT,0              ;zero the other movement counters
        MOV     DOWN_COUNT,0
        MOV     LEFT_COUNT,0
        MOV     AX,MOVE_RIGHT           ;load movement keycode
        CALL    KEYINSERT               ;insert it into the buffer
        JMP     KEYBDPROCESS1           ;loop back for more


KEYBDPROCESS3:
        MOV     AX,HORI_DELAY           ;retrieve horizontal delay factor
        CMP     LEFT_COUNT,AX           ;have we reached the delay threshold?
        JL      KEYBDPROCESS5           ;no, continue 
        SUB     LEFT_COUNT,AX           ;deduct the delay threshold
        CMP     LEFT_COUNT,0            ;check for overflow
        JGE     KEYBDPROCESS4           ;no overflow, continue
        XOR     AX,AX                   ;zero the counter
        MOV     LEFT_COUNT,AX

KEYBDPROCESS4:
        MOV     UP_COUNT,0              ;zero the other movement counters
        MOV     DOWN_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     AX,MOVE_LEFT            ;load movement keycode
        CALL    KEYINSERT               ;insert it into the buffer
        JMP     KEYBDPROCESS3           ;loop back for more

KEYBDPROCESS5:
        MOV     AX,VERT_DELAY           ;retrieve vertical delay factor
        CMP     UP_COUNT,AX             ;have we reached the delay threshold?
        JL      KEYBDPROCESS7           ;no, continue 
        SUB     UP_COUNT,AX             ;deduct the delay threshold
        CMP     UP_COUNT,0              ;check for overflow
        JGE     KEYBDPROCESS6           ;no overflow, continue
        XOR     AX,AX                   ;zero the counter
        MOV     UP_COUNT,AX

KEYBDPROCESS6:
        MOV     DOWN_COUNT,0            ;zero the other movement counters
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     AX,MOVE_UP              ;load movement keycode
        CALL    KEYINSERT               ;insert it into the buffer
        JMP     KEYBDPROCESS5           ;loop back for more

KEYBDPROCESS7:
        MOV     AX,VERT_DELAY           ;retrieve vertical delay factor
        CMP     DOWN_COUNT,AX           ;have we reached the delay threshold?
        JL      KEYBDPROCESS9           ;no, continue 
        SUB     DOWN_COUNT,AX           ;deduct the delay threshold
        CMP     DOWN_COUNT,0            ;check for overflow
        JGE     KEYBDPROCESS8           ;no overflow, continue
        XOR     AX,AX                   ;zero the counter
        MOV     DOWN_COUNT,AX

KEYBDPROCESS8:
        MOV     UP_COUNT,0              ;zero the other movement counters
        MOV     LEFT_COUNT,0
        MOV     RIGHT_COUNT,0
        MOV     AX,MOVE_DOWN            ;load movement keycode
        CALL    KEYINSERT               ;insert it into the buffer
        JMP     KEYBDPROCESS7           ;loop back for more

KEYBDPROCESS9:
        RET

KEYBDPROCESS ENDP

;*****************************************************************************
; KEYINSERT - Procedure to insert keys into keyboard buffer
;*****************************************************************************
KEYINSERT PROC NEAR
        MOV     LAST_KEY,AX             ;save keycode inserted
        MOV     BX,BIOS_DATA            ;point ds to the BIOS data area
        MOV     DS,BX            
        ASSUME  DS:BIOS_DATA     
        CLI                             ;disable interrupts
        MOV     BX,BUFFER_TAIL          ;get buffer tail address
        MOV     DX,BX                   ;transfer it to DX
        ADD     DX,2                    ;calculate next buffer position
        CMP     DX,BUFFER_END           ;did we overshoot the end?
        JNE     KEYINSERT_1             ;no, then continue
        MOV     DX,BUFFER_START         ;yes, then wrap to start of buffer

KEYINSERT_1:
        CMP     CX,BUFFER_HEAD          ;is the buffer full?
        JE      KEYINSERT_2             ;yes, then end now
        MOV     [BX],AX                 ;insert the keycode
        MOV     BX,DX                   ;advance the tail
        MOV     BUFFER_TAIL,BX          ;record its new position

KEYINSERT_2:
        STI                             ;enable interrupts
        ASSUME  DS:NOTHING       
        RET                             ;exit user sub-routine

KEYINSERT ENDP

;******************************************************************************
; INT33 - the mouse interrupt intercept procedure
;*****************************************************************************
INT33 PROC NEAR
	PUSHF                           ;save flags the real mouse interrupt
	OR	AH,AH		        ;check function number
	JNS	INT33_OUT               ;if less than 80H transfer to real int
	JMP	INT33_HIT	        ;it's ours

INT33_OUT:
	POPF
	DB	0EAH		        ;JMP FAR immediate opcode
EXINT33	DD	0		        ;ex-setting of interrupt 33

INT33_HIT:
	POPF			        ;discard flags
	STI			        ;allow interrupts
	PUSH	BP
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	DS		        ;set ES to caller's segment
	POP	ES
	PUSH	CS		        ;set DS to this segment
	POP	DS
	CLD
	CALL	PROCESS		        ;perform the function
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	BP
	RETF	2

INT33 ENDP

;*****************************************************************************
; STARTUP - the program initialization and TSR install code
;*****************************************************************************
STARTUP PROC NEAR
        MOV     AX,0                    ;use function 0 of driver to see
        INT     33h                     ;if mouse and driver are installed
        OR      AX,AX           
        JNE     STARTUP1                ;installed, continue  
	MOV	DX,OFFSET NOMSMSG	;mouse driver not loaded, exit        
	MOV	AH,9H
	INT	21H
	XOR	AX,AX			
	INT	21H

STARTUP1:
	MOV	AH,80H			;check if RODENT is already loaded
	INT	33H
	CMP	AH,232			;if it is it will return AH = 232
	JNE	STARTUP2
	MOV	DX,OFFSET LOADMSG	;RODENT is already loaded, display message
	MOV	AH,9H
	INT	21H
        MOV     AH,81h                  ;re-activate it
        INT     33h
	XOR	AX,AX			;return to DOS
	INT	21H

STARTUP2:
	MOV	DX,OFFSET INITMSG	;announce program
	MOV	AH,9H
	INT	21H

	MOV	AX,3533H		;get mouse driver int vector
	INT	21H			
	MOV	WORD PTR [EXINT33],BX	;save old offset
	MOV	WORD PTR [EXINT33+2],ES	;and old segment
	MOV	AX,2533H		;change vector for intercept
	MOV	DX,OFFSET INT33
	INT	21H

        CALL    KEYBD_ON                ;start the keyboard mouse
	MOV	DX,OFFSET PROGRAM_END	;calculate paragraphs used
	MOV	CL,4
	SHR	DX,CL
	MOV	AX,3100H		;terminate but stay resident
	INT	21H

STARTUP ENDP

PROGRAM_END     =	$		;end of resident code

PROGSEG ENDS
END RODENT
