******************************************************************************
* PROGRAM ----: MSADJUST.PRG 
* AUTHOR -----: Kevin E. Saffer 
* COPYRIGHT --: None, released into the public domain
* CREATED ----: 1/20/1992 at 11:07
******************************************************************************
* Example program illustrating the use of the floating mouse.
*
* Compile to an OBJ using Clipper Summer '81, then link with the RODENTIF
* object file the Clipper and Extend libraries.
******************************************************************************

MSKEYOFF()  && turn off keyboard mouse
MSCLRSCN()  && clear screen button array
* we will make each screen button 3 rows high by 5 chars wide
* load the top row of buttons
LOADBUTT(06,05,08,09,1)  && load the first screen button to issue CHR(1)
LOADBUTT(06,12,08,16,2)  && load the next screen button to issue CHR(2)
LOADBUTT(06,19,08,23,3)  && load the next screen button to issue CHR(3)
LOADBUTT(06,26,08,30,4)  && load the next screen button to issue CHR(4)
LOADBUTT(06,33,08,37,5)  && load the next screen button to issue CHR(5)
LOADBUTT(06,40,08,44,6)  && load the next screen button to issue CHR(6)
LOADBUTT(06,47,08,51,7)  && load the next screen button to issue CHR(7)
LOADBUTT(06,54,08,58,8)  && load the next screen button to issue CHR(8)
LOADBUTT(06,61,08,65,9)  && load the next screen button to issue CHR(9)
LOADBUTT(06,68,08,73,10) && load the next screen button to issue CHR(10)

* load the bottom row of buttons
LOADBUTT(12,05,14,09,11)  && load the first screen button to issue CHR(11)
LOADBUTT(12,12,14,16,12)  && load the next screen button to issue CHR(12)
LOADBUTT(12,19,14,23,13)  && load the next screen button to issue CHR(13)
LOADBUTT(12,26,14,30,14)  && load the next screen button to issue CHR(14)
LOADBUTT(12,33,14,37,15)  && load the next screen button to issue CHR(15)
LOADBUTT(12,40,14,44,16)  && load the next screen button to issue CHR(16)
LOADBUTT(12,47,14,51,17)  && load the next screen button to issue CHR(17)
LOADBUTT(12,54,14,58,18)  && load the next screen button to issue CHR(18)
LOADBUTT(12,61,14,65,19)  && load the next screen button to issue CHR(19)
LOADBUTT(12,68,14,73,20) && load the next screen button to issue CHR(20)

* load save or cancel buttons
LOADBUTT(17,18,21,34,21) && load the save screen button to issue CHR(21)
LOADBUTT(17,42,21,59,22) && load the exit screen button to issue CHR(22)

* assign default movement values, could be retrieved from a user file.
ms_movedelay = 3
ms_clickdelay = 3

m_newmove = ms_movedelay
m_newclick = ms_clickdelay
SET CURSOR OFF
CLEAR
@ 00,00 TO 02,79 DOUBLE
@ 01,02 SAY "Mouse Adjustment"
@ 21,00 TO 24,79 DOUBLE
@ 21,01 SAY "[Help]"
@ 22,02 SAY "Point to and select the level of sensitivity desired,"
@ 23,02 SAY "or press the Escape key to cancel and return to the menu."
@ 05,05 SAY "Mouse Movement Sensitivity, current setting: " + LTRIM(STR(ms_movedelay,2,0))
@ 06,05 SAY "Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ"
@ 07,05 SAY " 1    2    3    4    5    6    7    8    9    10 "
@ 08,05 SAY "                  "
@ 11,05 SAY "Double-Click Sensivity, current setting: " + LTRIM(STR(ms_clickdelay,2,0))
@ 12,05 SAY "Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ  Ŀ"
@ 13,05 SAY " 1    2    3    4    5    6    7    8    9    10 "
@ 14,05 SAY "                  "
@ 17,18 SAY "Ŀ       Ŀ"
@ 18,18 SAY " SAVE SETTINGS         CANCEL CHANGES "
@ 19,18 SAY "       "
MSFLTON(18,38)   && activate full screen mouse cursor
SET CURSOR OFF
DO WHILE .T.
  m_keypress = INKEY()
  DO WHILE m_keypress = 0
    m_keypress = INKEY()
  ENDDO
  IF m_keypress = 27 .OR. m_keypress < 0 .OR. m_keypress >= 22
    MSKEYON()
    CLEAR TYPEAHEAD
    RETURN
  ENDIF
  IF m_keypress >= 1 .AND. m_keypress <= 10
    m_newmove = m_keypress
    @ 05,60 SAY "New Setting: " + LTRIM(STR(m_newmove,2,0))
  ENDIF
  IF m_keypress >= 11 .AND. m_keypress <= 20
    m_newclick = m_keypress - 10
    @ 11,60 SAY "New Setting: " + LTRIM(STR(m_newclick,2,0))
  ENDIF
  IF m_keypress = 21
    EXIT
  ENDIF
ENDDO
MSFLTOFF() && de-activate cursor mouse
SET CURSOR ON
IF ms_movedelay <> m_newmove .OR. ms_clickdelay <> m_newclick 
  * we could update a user file here
  ms_movedelay = m_newmove
  ms_clickdelay = m_newclick
  m_result = MSHORDLY(m_newmove*10)
  m_result = MSVERDLY(m_newmove*6)
  m_result = MSCLKTIM(m_newclick*2)
ENDIF
MSKEYON()
CLEAR TYPEAHEAD
CLEAR
RETURN

FUNCTION LOADBUTT
  PARAMETERS r1,c1,r2,c2,chrval
  FOR m_cntr = r1 TO r2
    m_result = MSSETSCN(m_cntr,c1,chrval,c2-c1+1)
  NEXT
RETURN ""
