******************************************************************************
* PROGRAM ----: KEVCOMM.PRG
* AUTHOR -----: Kevin E. Saffer 
* COPYRIGHT --: (c) 1991 by Kevin E. Saffer 
* CREATED ----: 10/17/1991 at 20:58
******************************************************************************
* Implements a personal communications system for Clipper Summer '87 or 5.01
******************************************************************************
* set up the Clipper environment
IF ISCOLOR()
  SET COLOR TO +GR/B,N/W,N,N,N/W
ELSE
  SET COLOR TO W/N,N/W,N,N,N/W
ENDIF
SET BELL OFF
SET CENTURY ON
SET CONFIRM ON
SET DELETED ON
SET DELIMITER TO "[]"
SET DELIMITER OFF
SET ESCAPE ON
SET EXCLUSIVE ON
SET INTENSITY ON
SET SAFETY OFF
SET SCOREBOARD OFF
SET TALK OFF

* these public memvars are used throughout the program 
PUBLIC m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits,m_echo,m_dialstr,m_downdir

* establish array for each operator choice in CMPHONE
DECLARE m_aspeed[11]
m_aspeed[1]  = "150"
m_aspeed[2]  = "300"
m_aspeed[3]  = "600"
m_aspeed[4]  = "1200"
m_aspeed[5]  = "2400"
m_aspeed[6]  = "4800"
m_aspeed[7]  = "9600"
m_aspeed[8]  = "19200"
m_aspeed[9]  = "38400"
m_aspeed[10] = "57600"
m_aspeed[11] = "115200"

* establish array for each operator choice in CMGETFILE and CMSENDFILE
DECLARE m_aprotocol[6]
m_aprotocol[1] = "ZMODEM ------- Advanced streaming transfer method                  Best"
m_aprotocol[2] = "YMODEM G ----- streaming YMODEM, use with error corr. modems     Better"
m_aprotocol[3] = "YMODEM BATCH - multiple file transfers, CRC error checks         Better"
m_aprotocol[4] = "XMODEM 1K ---- same as XMODEM, but with 1024 byte blocks         Better"
m_aprotocol[5] = "XMODEM ------- Error checking, 128 byte blocks                   Better"
m_aprotocol[6] = "ASCII -------- straight text, no error checking                    Poor"

* clear the screen and draw boxes and titles
CLEAR
@ 00,00 TO 02,79 DOUBLE
@ 01,02 SAY "KevComm Communications System"
@ 01,67 SAY "Version 1.0"
@ 05,03 SAY "                                   "
@ 06,03 SAY "              "
@ 07,03 SAY "                        "
@ 08,03 SAY "                          "
@ 09,03 SAY "                                    "
@ 10,03 SAY "                             "
@ 11,03 SAY "                                     "
@ 14,15 SAY "         PERSONAL COMMUNICATIONS SYSTEM"
@ 15,15 SAY "       Version 1.0 (but it works! really!)"
@ 17,15 SAY "Written by Kevin E. Saffer, of Jacksonville, Florida."
@ 18,12 SAY "Clipper/Assembler source code is available from the author."
@ 19,15 SAY "   Questions?  Call (904) 262-1020 Evenings EST"
@ 22,00 TO 24,79 DOUBLE
@ 22,01 SAY "[Status]"

IF .NOT. FILE("defaults.dbf")
  @ 23,02 SAY "Creating default settings file, please wait..."
  * create it
  CREATE defaults.tmp
  USE defaults.tmp
  APPEND BLANK
  REPLACE FIELD_NAME WITH "PORTNBR",FIELD_TYPE WITH "N",FIELD_LEN WITH 1
  APPEND BLANK
  REPLACE FIELD_NAME WITH "BAUDRATE",FIELD_TYPE WITH "N",FIELD_LEN WITH 6
  APPEND BLANK
  REPLACE FIELD_NAME WITH "PARITY",FIELD_TYPE WITH "C",FIELD_LEN WITH 1
  APPEND BLANK
  REPLACE FIELD_NAME WITH "DATABITS",FIELD_TYPE WITH "N",FIELD_LEN WITH 1
  APPEND BLANK
  REPLACE FIELD_NAME WITH "STOPBITS",FIELD_TYPE WITH "N",FIELD_LEN WITH 1
  APPEND BLANK
  REPLACE FIELD_NAME WITH "INITSTR",FIELD_TYPE WITH "C",FIELD_LEN WITH 60
  APPEND BLANK
  REPLACE FIELD_NAME WITH "ECHO",FIELD_TYPE WITH "C",FIELD_LEN WITH 1
  APPEND BLANK
  REPLACE FIELD_NAME WITH "DIALSTR",FIELD_TYPE WITH "C",FIELD_LEN WITH 60
  APPEND BLANK
  REPLACE FIELD_NAME WITH "DOWNDIR",FIELD_TYPE WITH "C",FIELD_LEN WITH 60
  USE
  CREATE defaults FROM defaults.tmp
  DELETE FILE defaults.tmp
  USE defaults
  APPEND BLANK
  REPLACE portnbr    WITH 1
  REPLACE baudrate   WITH 2400
  REPLACE parity     WITH "N"
  REPLACE databits   WITH 8
  REPLACE stopbits   WITH 1
  REPLACE initstr    WITH "AT&F S0=0 S7=60 S11=55 E0 &C1 V1 X1"
  REPLACE echo       WITH "N"
  REPLACE dialstr    WITH "ATDT"
ELSE 
  USE defaults
ENDIF

* display port settings and ask for change
* retrieve and convert parameters from the defaults file
m_dbaudrate = baudrate
m_dparity = parity
m_dialstr = LTRIM(TRIM(dialstr))
m_downdir = LTRIM(TRIM(downdir))
IF LEN(m_downdir) <> 0
  IF SUBSTR(m_downdir,LEN(m_downdir),1) <> "\"
    m_downdir = m_downdir + "\"
    REPLACE downdir WITH m_downdir
  ENDIF
ENDIF
@ 23,02 SAY SPACE(76)
@ 23,02 SAY "Set for port " + STR(portnbr,1,0) + " at " + ;
  LTRIM(STR(m_dbaudrate,6,0)) + "," + m_dparity + "," + STR(databits,1,0) + ;
  "," + STR(stopbits,1,0) + ".  Press C to change, any other key to open..."
SET CONSOLE OFF
WAIT
SET CONSOLE ON
IF LASTKEY() = 27
  CLEAR
  RETURN
ENDIF
IF LASTKEY() = 67 .OR. LASTKEY() = 99  && C key
  DO CMSETDEF        
ENDIF

DO WHILE .T.
  * retrieve and convert parameters from the defaults file
  m_portnbr  = portnbr
  m_baudrate = baudrate
  m_dbaudrate = baudrate
  IF m_baudrate = 115200
    m_baudrate = 0
  ENDIF
  m_dparity = parity
  DO CASE
  CASE parity = "O"
    m_parity = 1
  CASE parity = "E"
    m_parity = 2
  OTHERWISE
    m_parity = 0
  ENDCASE
  m_databits = databits
  m_stopbits = stopbits
  m_initstr = LTRIM(TRIM(initstr))
  m_echo = echo
  m_dialstr = LTRIM(TRIM(dialstr))
  @ 23,02 SAY SPACE(76)
  @ 23,02 SAY "Opening port " + STR(portnbr,1,0) + " at " + ;
  LTRIM(STR(m_dbaudrate,6,0)) + "," + m_dparity + "," + STR(databits,1,0) + ;
  "," + STR(stopbits,1,0) + "..."
  m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)

  IF m_result <> 0
    * close, then retry opening the adapter
    m_result = CMCLOSE(m_portnbr)
    m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)
    IF m_result <> 0
      * oh well...
      @ 23,02 SAY SPACE(76)
      @ 23,02 SAY "Unable to open the port! Press C to change parameters or Esc to exit..."
      SET CONSOLE OFF
      WAIT
      SET CONSOLE ON
      IF LASTKEY() = 67 .OR. LASTKEY() = 99  && C key
        DO CMSETDEF        
        LOOP
      ELSE
        CLEAR
        RETURN
      ENDIF
    ENDIF
  ENDIF
  EXIT
ENDDO
COMMIT
CLOSE DATABASES

IF LEN(m_initstr) <> 0
  * initialize the modem
  m_result = CMSENDSTR(m_portnbr,m_initstr + CHR(13))
  * wait for the transmitter to complete
  DO WHILE CMTDCOUNT(m_portnbr) <> 0
  ENDDO
  INKEY(1)
  * ensure input buffer is fully flushed
  DO WHILE CMRDCOUNT(m_portnbr) <> 0
    m_result = CMRDFLUSH(m_portnbr)
  ENDDO
ENDIF

IF m_echo = "Y"
  * set local echo on
  m_result = CMSENDSTR(m_portnbr,"ATE1" + CHR(13))
  DO WHILE CMTDCOUNT(m_portnbr) <> 0
  ENDDO
  INKEY(1)
  DO WHILE CMRDCOUNT(m_portnbr) <> 0
    m_result = CMRDFLUSH(m_portnbr)
  ENDDO
ENDIF
* run the terminal emulator
m_result = CMTERM(m_portnbr)
IF SUBSTR(CMSTATUS(m_portnbr),9,1) = "1"
  * carrier still high, disconnect
  @ 0,0 CLEAR TO 0,79
  @ 0,0 SAY "Hanging up the modem, please wait..."
  m_result = CMHANGUP(m_portnbr)
ENDIF
m_result = CMCLOSE(m_portnbr)
CLEAR
RETURN

*****************************************************************************
* CMSETDEF - changes the default databse modem settings
*****************************************************************************
*  Syntax: DO CMSETDEF
*
*  On Entry - database file DEFAULTS must be open and selected
*  On Exit - record updated
*****************************************************************************
PROCEDURE CMSETDEF
  * edit port parameters and retry
  @ 04,00 CLEAR TO 20,79
  @ 04,08 TO 20,71 DOUBLE
  @ 18,09 SAY REPLICATE("",62)
  @ 05,10 SAY "Port Number:"
  @ 06,10 SAY "      Speed:"
  @ 07,10 SAY "     Parity:"
  @ 08,10 SAY "   Databits:"
  @ 09,10 SAY "   Stopbits:"
  @ 10,10 SAY "       Echo:"
  @ 12,10 SAY "Modem Initialization String:"
  @ 14,10 SAY "Modem Dialing Prefix:"
  @ 16,10 SAY "Download Directory:"
  m_eportnbr = portnbr
  @ 05,23 GET m_eportnbr PICTURE '#'
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the port number (1,2,3, or 4) or press Esc to exit."
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  * get the port speed
  IF baudrate = 0
    m_seekvar = LTRIM(TRIM(STR(m_baudrate,6,0)))
  ELSE 
    m_seekvar = LTRIM(TRIM(STR(baudrate,6,0)))
  ENDIF
  m_speedrec = ASCAN(m_aspeed,m_seekvar)
  m_cmspeedscr = SAVESCREEN(05,48,18,57)
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Select a speed from this list."
  @ 05,48 CLEAR TO 17,57
  @ 05,48 TO 17,57 DOUBLE
  m_speedrec = ACHOICE(06,50,16,55,m_aspeed,"","",m_speedrec)
  RESTSCREEN(05,48,18,57,m_cmspeedscr)
  IF m_speedrec = 0
    RETURN
  ENDIF
  m_ebaudrate = VAL(m_aspeed[m_speedrec])
  @ 06,23 GET m_ebaudrate PICTURE '######'
  CLEAR GETS
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the parity: N)one, E)ven, or O)dd."
  m_eparity = parity
  IF m_eparity = " "
    DO CASE
    CASE m_parity = 0
      m_eparity = "N"
    CASE m_parity = 1
      m_eparity = "O"
    OTHERWISE
      m_eparity = "E"
    ENDCASE
  ENDIF
  @ 07,23 GET m_eparity PICTURE '!' VALID m_eparity $ "NEO"
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the databits: 7 or 8."
  m_edatabits = databits
  IF m_edatabits = 0
    m_edatabits = m_databits
  ENDIF
  @ 08,23 GET m_edatabits PICTURE '#' VALID m_edatabits = 7 .OR. m_edatabits = 8 
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the stopbits: 1 or 2."
  m_estopbits = stopbits
  IF m_estopbits = 0
    m_estopbits = m_stopbits
  ENDIF
  @ 09,23 GET m_estopbits PICTURE '#' VALID m_estopbits = 1 .OR. m_estopbits = 2 
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter Y for local echo, N for no echo."
  m_eecho = echo
  IF m_eecho = " "
    m_eecho = m_echo
  ENDIF
  @ 10,23 GET m_eecho PICTURE '!' VALID m_eecho $ "YN"
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the modem initialization string."
  m_einitstr = initstr
  @ 13,10 GET m_einitstr PICTURE '@!'
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the modem dialing command."
  m_edialstr = dialstr
  @ 15,10 GET m_edialstr PICTURE '@!'
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  @ 19,09 CLEAR TO 19,70 
  @ 19,10 SAY "Enter the download directory."
  m_edowndir = downdir
  @ 17,10 GET m_edowndir PICTURE '@!'
  READ
  IF LASTKEY() = 27
    RETURN
  ENDIF
  * replace 
  REPLACE portnbr    WITH m_eportnbr
  REPLACE baudrate   WITH m_ebaudrate
  REPLACE parity     WITH m_eparity
  REPLACE databits   WITH m_edatabits
  REPLACE stopbits   WITH m_estopbits
  REPLACE initstr    WITH m_einitstr
  REPLACE echo       WITH m_eecho
  REPLACE dialstr    WITH m_edialstr
  REPLACE downdir    WITH m_edowndir
RETURN

******************************************************************************
* CMTERM - terminal emulation function using ASM module CMASTERM
*   usage:
*     m_result = CMTERM(m_portnbr)
*     where:
*       m_result = always zero
******************************************************************************
FUNCTION CMTERM
  PARAMETERS m_portnbr
  PRIVATE m_status,m_capton,m_captfile,m_capthandle,m_prnton,m_result
  PRIVATE m_keypress,m_saverow,m_savecol,m_junk,m_filename
  CLEAR
  * display line in inverse video
  m_status = "F1-HlpF2-DialF3-Capt NF4-ViewF5-Prnt NF6-SndF7-GetF8-DosF9-HangF10-Quit"
  @ 24,00 GET m_status
  CLEAR GETS
  @ 0,0 SAY ""
  m_capton = .F.
  m_capthandle = 0
  m_captfile = "CAPTURE.TXT"
  m_prnton = .F.
  * clear the buffers
  m_result = CMTDFLUSH(m_portnbr)
  m_result = CMRDFLUSH(m_portnbr)
  * set up the static terminal options
  m_result = CMBEEP(.F.)         
  m_result = CMWRAP(.T.)
  m_result = CMCEXIT(.F.)
  DO WHILE .T.
    * set up the changing terminal options
    m_result = CMCAPTURE(m_capthandle)
    m_result = CMPRINTER(m_prnton)
    * call the assembler terminal function
    m_keypress = CMASTERM(m_portnbr)
    * update internal row and column variables, ignored by the asm routine
    m_saverow = CMROW()
    m_savecol = CMCOL()
    @ m_saverow,m_savecol SAY ""
    SAVE SCREEN TO m_cmterm

    DO CASE
    CASE m_keypress = 28  && F1 - help
      DO CMHELP 
      RESTORE SCREEN FROM m_cmterm
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -1  && F2 - dialing directory
      m_result = CMPHONE(m_portnbr)
    CASE m_keypress = -2  && F3 - capture toggle
      IF m_capthandle <> 0
        m_junk = "N"
        @ 24,23 GET m_junk     
        CLEAR GETS
        FCLOSE(m_capthandle)
        m_capthandle = 0
      ELSE
        IF .NOT. FILE(m_captfile)
          m_capthandle = FCREATE(m_captfile,0)       
          IF FERROR() <> 0
            m_capthandle = 0
          ENDIF
        ELSE
          m_capthandle = FOPEN(m_captfile,2)  && open in read-write mode
          IF FERROR() <> 0
            m_capthandle = 0
          ELSE
            FSEEK(m_capthandle,0,2)   && position at end of file
          ENDIF
        ENDIF
        IF m_capthandle <> 0
          m_junk = "Y"
          @ 24,23 GET m_junk     
          CLEAR GETS
        ENDIF
      ENDIF
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -3  && F4 - view and optionally clear the capture file
      IF m_capthandle > 0
        FCLOSE(m_capthandle)
      ENDIF
      IF FILE(m_captfile)
        m_memodata = MEMOREAD(m_captfile)
        CLEAR
        @ 0,0 TO 02,79 DOUBLE
        @ 01,31 SAY "CAPTURE FILE VIEWER"
        @ 22,0 TO 24,79 DOUBLE
        @ 23,02 SAY "Press Esc when finished viewing the capture file."
        m_junk = MEMOEDIT(m_memodata,04,00,20,78,.F.)
        @ 23,02 SAY "Press D to delete the capture file or any other key to continue..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        IF LASTKEY() = 68 .OR. LASTKEY() = 100  && d or D keys
          DELETE FILE &m_captfile
        ENDIF
      ENDIF
      IF m_capthandle > 0
        IF .NOT. FILE(m_captfile)
          m_capthandle = FCREATE(m_captfile,0)       
          IF FERROR() <> 0
            m_capthandle = 0
          ENDIF
        ELSE
          m_capthandle = FOPEN(m_captfile,2)  && open in read-write mode
          IF FERROR() <> 0
            m_capthandle = 0
          ELSE
            FSEEK(m_capthandle,0,2)   && position at end of file
          ENDIF
        ENDIF
        IF m_capthandle <> 0
          m_junk = "Y"
          @ 24,28 GET m_junk     
          CLEAR GETS
        ENDIF
      ENDIF
      RESTORE SCREEN FROM m_cmterm
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -4  && F5 - printer toggle
      IF m_prnton
        m_prnton = .F.
        m_junk = "N"
        @ 24,41 GET m_junk     
        CLEAR GETS
      ELSE
        m_prnton = .T.
        m_junk = "Y"
        @ 24,41 GET m_junk     
        CLEAR GETS
      ENDIF
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -5  && F6 - Send File
      m_result = CMXFER(m_portnbr,"S")
      RESTORE SCREEN FROM m_cmterm
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -6  && F7 - Get File
      m_result = CMXFER(m_portnbr,"R")
      RESTORE SCREEN FROM m_cmterm
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -7  && F8 - Dos Shell
      m_program = "COMMAND"
      CLEAR
      ? "Enter EXIT at the DOS prompt to return to KevComm..."
      m_result = OVERLAY(m_program,0,"","","",.T.)
      RESTORE SCREEN FROM m_cmterm
      @ m_saverow,m_savecol SAY ""
    CASE m_keypress = -8  && F9 - Hang up the line
      m_message = "Disconnecting, please wait a moment...                                          "
      @ 24,00 GET m_message
      CLEAR GETS
      @ 24,38 SAY ""
      m_result = CMHANGUP(m_portnbr)
      CLEAR
      @ 24,00 GET m_status
      CLEAR GETS
      @ 0,0 SAY ""
    CASE m_keypress = -9  && F10 - exit
      IF m_capthandle <> 0
        FCLOSE(m_capthandle)
      ENDIF
      EXIT
    ENDCASE
  ENDDO
RETURN 0

******************************************************************************
* CMHELP - displays a help screen
******************************************************************************
PROCEDURE CMHELP
  PRIVATE m_cmhelp,m_saverow,m_savecol
  CLEAR
  @ 0,0 TO 02,79 DOUBLE
  @ 01,30 SAY "KEVCOMM TERMINAL HELP"
  @ 22,0 TO 24,79 DOUBLE
  @ 03,00 SAY ""
  TEXT
    At the bottom of the screen you will find a status line with several 
    functions available.  Access any of the functions by pressing the 
    appropriate function key.

   F2 Dial  - dials a telephone number and maintains the dialing directory.

   F3 Capt  - toggles screen capture to the file CAPTURE.TXT.
   F4 View  - allows you to read and optionally clear the capture file.

   F5 Prnt  - toggles the printer on/off.

   F6 Snd   - transmits a file to a remote computer.
   F7 Get   - receives a file from a remote computer.

   F8 Dos   - shells to DOS will all memory available.
   F9 Hang  - forces disconnection and hangs up the phone.
   F10 Quit - halts communications, hangs up the phone and returns to DOS.
  ENDTEXT
  @ 23,02 SAY "Press any key to return to the terminal..."
  SET CONSOLE OFF
  WAIT
  SET CONSOLE ON
RETURN

******************************************************************************
* CMPHONE - Telephone Directory module
******************************************************************************
FUNCTION CMPHONE
  PARAMETERS m_portnbr
  PRIVATE m_cmphone,m_saverow,m_savecol,m_retval,m_result,m_cntr,m_name,m_telephone
  SAVE SCREEN TO m_cmphone
  m_saverow = ROW()
  m_savecol = COL()
  m_retval = 1
  CLEAR
  @ 0,0 TO 02,79 DOUBLE
  @ 20,0 TO 24,79 DOUBLE
  @ 01,31 SAY "DIALING DIRECTORY"
  IF .NOT. FILE("dialdir.dbf")
    * create it
    @ 23,02 SAY "Creating dialing directory, please wait..."
    CREATE dialdir.tmp
    USE dialdir.tmp
    APPEND BLANK
    REPLACE FIELD_NAME WITH "NAME",FIELD_TYPE WITH "C",FIELD_LEN WITH 45
    APPEND BLANK
    REPLACE FIELD_NAME WITH "TELEPHONE",FIELD_TYPE WITH "C",FIELD_LEN WITH 14
    APPEND BLANK
    REPLACE FIELD_NAME WITH "BAUDRATE",FIELD_TYPE WITH "N",FIELD_LEN WITH 6
    APPEND BLANK
    REPLACE FIELD_NAME WITH "PARITY",FIELD_TYPE WITH "C",FIELD_LEN WITH 1
    APPEND BLANK
    REPLACE FIELD_NAME WITH "DATABITS",FIELD_TYPE WITH "N",FIELD_LEN WITH 1
    APPEND BLANK
    REPLACE FIELD_NAME WITH "STOPBITS",FIELD_TYPE WITH "N",FIELD_LEN WITH 1
    APPEND BLANK
    REPLACE FIELD_NAME WITH "ECHO",FIELD_TYPE WITH "C",FIELD_LEN WITH 1
    USE
    CREATE dialdir FROM dialdir.tmp
    DELETE FILE dialdir.tmp
    USE dialdir
    DO WHILE RECCOUNT() < 200
      APPEND BLANK
    ENDDO
    GO TOP
  ELSE
    USE dialdir
  ENDIF
  GO TOP
  @ 04,00 SAY "Nbr. Name                                          Telephone       Speed P D S E"
  @ 05,00 SAY REPLICATE("",80)
  @ 21,01 CLEAR TO 23,78
  @ 21,04 SAY "Use the arrow keys, PgUp or PgDn, Ctrl PgUp/PgDn to move the highlight."
  @ 22,04 SAY " Press the Enter key to select a number to dial, or press Esc to exit."
  @ 23,02 SAY "Press a letter to search, Alt-E to edit, Alt-P to purge, or Alt-S to sort."
  PRIVATE m_fields[1]
  m_fields[1] = [STR(RECNO(),3,0) + "  " + name + " " + telephone + " " + STR(baudrate,6,0) + " " + parity + " " + STR(databits,1,0) + " " + STR(stopbits,1,0) + " " + echo]
  * call DBEDIT to select or change entries
  m_retval = 1
  DO WHILE .T.
    DBEDIT(06,00,18,79,m_fields,"CMPHONE1","","","","","","")
    SET CURSOR ON
    IF LASTKEY() = 27
      EXIT
    ENDIF
    BEGIN SEQUENCE
      * try a dial, check for proper parameters
      IF telephone = SPACE(14)
        BREAK
      ENDIF
      IF baudrate = 0 .OR. databits = 0 .OR. stopbits = 0
        BREAK
      ENDIF
      IF .NOT. parity $ "OEN"
        BREAK
      ENDIF
      * OK! retrieve new line settings and reopen the port
      m_baudrate = baudrate
      IF m_baudrate = 115200
        m_baudrate = 0
      ENDIF
      DO CASE
      CASE parity = "O"
        m_parity = 1
      CASE parity = "E"
        m_parity = 2
      OTHERWISE
        m_parity = 0
      ENDCASE
      m_databits = databits
      m_stopbits = stopbits
      m_echo = echo
      * reopen the port
      m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)
      IF m_result <> 0
        BREAK
      ENDIF
      m_name = name
      m_telephone = LTRIM(TRIM(telephone))
      @ 21,01 CLEAR TO 23,78
      @ 21,10 SAY "   Starting up the dialer!  (our motto: connect or bust)" 
      @ 22,10 SAY "If we cannot establish communications, I will retry the dial."
      @ 23,10 SAY "  Press Enter to cycle, or press Escape to halt the dialer."
      IF m_echo = "Y"
        m_result = CMSENDSTR(m_portnbr,"ATE1"+CHR(13))
      ELSE
        m_result = CMSENDSTR(m_portnbr,"ATE0"+CHR(13))
      ENDIF
      m_retval = CMDIAL(m_portnbr,m_name,m_telephone)
    END SEQUENCE
    IF m_retval = 0
      EXIT
    ENDIF
  ENDDO
  USE
  RESTORE SCREEN FROM m_cmphone
  @ m_saverow,m_savecol SAY ""
  IF m_retval = 0
    * set up the screen in B/W
    @ 00,00 CLEAR TO 23,79
    @ 0,0 SAY "Connected to " + m_name
    @ 1,0 SAY ""
  ENDIF
RETURN 0

******************************************************************************
* CMPHONE1 - custom DBEDIT function to allow directory searches,edits and sorts
******************************************************************************
FUNCTION CMPHONE1
  PARAMETERS status,fls_ptr
  PRIVATE m_cmphone1,m_keypress,m_retval,m_saverow,m_saverec
  m_retval = 1
  DO CASE
  CASE status = 0  && idle, all keystrokes have been processed
  CASE status = 1  && attempt to cursor past BOF()
  CASE status = 2  && attempt to cursor past EOF()
  CASE status = 3  && empty database file
  CASE status = 4  && keystroke exception
    m_saverec = RECNO()
    m_keypress = LASTKEY()
    DO CASE
    CASE m_keypress = 27 .OR. m_keypress = 13       
      m_retval = 0
    CASE m_keypress = 274  && Alt-E key
      BEGIN SEQUENCE
        * save the screen area and bring up an editing box
        m_cmphone1 = SAVESCREEN(07,08,19,72)
        @ 07,08 CLEAR TO 19,72 
        @ 08,10 TO 18,70 DOUBLE
        @ 16,11 SAY REPLICATE("",59)
        @ 09,12 SAY "     Name:"
        @ 10,12 SAY "Telephone:"
        @ 11,12 SAY "    Speed:"
        @ 12,12 SAY "   Parity:"
        @ 13,12 SAY " Databits:"
        @ 14,12 SAY " Stopbits:"
        @ 15,12 SAY "     Echo:"
        SET CURSOR ON
        m_ename = name
        @ 09,23 GET m_ename PICTURE '@K'
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter the name or press Esc to exit."
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        m_etelephone = telephone
        @ 10,23 GET m_etelephone PICTURE '@K'
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter the phone or press Esc to exit."
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        * get the port speed
        IF baudrate = 0
          m_seekvar = LTRIM(TRIM(STR(m_baudrate,6,0)))
        ELSE 
          m_seekvar = LTRIM(TRIM(STR(baudrate,6,0)))
        ENDIF
        m_speedrec = ASCAN(m_aspeed,m_seekvar)
        m_cmspeedscr = SAVESCREEN(07,48,19,57)
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Select a speed from this list."
        @ 07,48 CLEAR TO 19,57
        @ 07,48 TO 19,57 DOUBLE
        m_speedrec = ACHOICE(08,50,18,55,m_aspeed,"","",m_speedrec)
        RESTSCREEN(07,48,19,57,m_cmspeedscr)
        IF m_speedrec = 0
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        m_ebaudrate = VAL(m_aspeed[m_speedrec])
        @ 11,23 GET m_ebaudrate PICTURE '######'
        CLEAR GETS
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter the parity: N)one, E)ven, or O)dd."
        m_eparity = parity
        IF m_eparity = " "
          DO CASE
          CASE m_parity = 0
            m_eparity = "N"
          CASE m_parity = 1
            m_eparity = "O"
          OTHERWISE
            m_eparity = "E"
          ENDCASE
        ENDIF
        @ 12,23 GET m_eparity PICTURE '!' VALID m_eparity $ "NEO"
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter the databits: 7 or 8."
        m_edatabits = databits
        IF m_edatabits = 0
          m_edatabits = m_databits
        ENDIF
        @ 13,23 GET m_edatabits PICTURE '#' VALID m_edatabits = 7 .OR. m_edatabits = 8 
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter the stopbits: 1 or 2."
        m_estopbits = stopbits
        IF m_estopbits = 0
          m_estopbits = m_stopbits
        ENDIF
        @ 14,23 GET m_estopbits PICTURE '#' VALID m_estopbits = 1 .OR. m_estopbits = 2 
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        @ 17,12 CLEAR TO 17,69 
        @ 17,12 SAY "Enter Y for local echo, N for no echo."
        m_eecho = echo
        IF m_eecho = " "
          m_eecho = m_echo
        ENDIF
        @ 15,23 GET m_eecho PICTURE '!' VALID m_eecho $ "YN"
        READ
        IF LASTKEY() = 27
          RESTSCREEN(07,08,19,72,m_cmphone1)
          BREAK
        ENDIF
        * replace 
        REPLACE name       WITH m_ename
        REPLACE telephone  WITH SPACE(14-LEN(LTRIM(TRIM(m_etelephone)))) + LTRIM(TRIM(m_etelephone))
        REPLACE baudrate   WITH m_ebaudrate
        REPLACE parity     WITH m_eparity
        REPLACE databits   WITH m_edatabits
        REPLACE stopbits   WITH m_estopbits
        REPLACE echo       WITH m_eecho
        m_retval = 2
      END SEQUENCE
      SET CURSOR OFF
    CASE m_keypress = 281  && Alt-P key
      REPLACE name       WITH " "
      REPLACE telephone  WITH " "
      REPLACE baudrate   WITH 0
      REPLACE parity     WITH " "
      REPLACE databits   WITH 0
      REPLACE stopbits   WITH 0
      REPLACE echo       WITH " "
      m_retval = 2
    CASE m_keypress = 287  && Alt-S key
      m_cmphone1 = SAVESCREEN(11,20,13,75)
      @ 11,20 SAY "ͻ"
      @ 12,20 SAY " Sorting, please wait a moment... "
      @ 13,20 SAY "ͼ"
      COPY TO temp.$$$ FOR name <> SPACE(45)
      USE temp.$$$
      INDEX ON UPPER(name) TO temp1.$$$
      SET INDEX TO temp1.$$$
      COPY TO dialdir
      USE dialdir
      DO WHILE RECCOUNT() < 200
        APPEND BLANK
      ENDDO
      GO TOP
      DELETE FILE temp.$$$
      DELETE FILE temp1.$$$
      m_retval = 2
      RESTSCREEN(11,20,13,75,m_cmphone1)
    CASE m_keypress >= 32 .AND. m_keypress <= 122
      m_saverec = RECNO()
      m_newscan = .F.
      * scan for it
      IF UPPER(CHR(m_keypress)) = UPPER(SUBSTR(name,1,1))
        * on a match, see if we can skip
        SKIP
        IF UPPER(CHR(m_keypress)) <> UPPER(SUBSTR(name,1,1)) .OR. EOF()
          m_newscan = .T.
        ELSE
          m_retval = 2
        ENDIF
      ELSE
        m_newscan = .T.
      ENDIF
      IF m_newscan
        GO TOP
        LOCATE FOR UPPER(CHR(m_keypress)) = UPPER(SUBSTR(name,1,1))
        IF EOF()
          GO m_saverec
        ELSE
          m_retval = 2
        ENDIF
      ENDIF
    ENDCASE
  ENDCASE
RETURN m_retval

******************************************************************************
* CMDIAL - Repeat Dialing module
******************************************************************************
FUNCTION CMDIAL
  PARAMETERS m_portnbr,m_name,m_telephone
  PRIVATE m_cmdial,m_saverow,m_savecol,m_retries,m_timeout,m_retval,m_result
  PRIVATE m_seconds,m_startsec,m_charcount,m_checksec,m_keypress,m_data
  SAVE SCREEN TO m_cmdial 
  m_saverow = ROW()
  m_savecol = COL()
  m_retries = 1
  m_timeout = 60
  m_retval = 1
  @ 09,12 TO 16,68 DOUBLE
  @ 10,13 CLEAR TO 15,67
  @ 10,37 SAY "DIALER"
  @ 11,13 SAY REPLICATE("",55)
  @ 12,14 SAY "Name: " + m_name
  @ 13,14 SAY "Telephone: " + m_telephone
  @ 14,14 SAY "Attempts:       Timeout in    seconds."
  @ 15,14 SAY "Last Message:"
  BEGIN SEQUENCE
    DO WHILE .T.
      @ 14,24 SAY LTRIM(STR(m_retries,3,0))
      IF SUBSTR(CMSTATUS(m_portnbr),9,1) = "1"
        * carrier still high, disconnect
        @ 15,28 CLEAR TO 15,67
        @ 15,28 SAY "Hanging up the modem..."
        m_result = CMHANGUP(m_portnbr)
      ENDIF
      @ 15,28 CLEAR TO 15,67
      @ 15,28 SAY "Dialing, please wait..."
      m_result = CMSENDCHR(m_portnbr,13)
      INKEY(1)
      m_result = CMSENDSTR(m_portnbr,TRIM(m_dialstr)+m_telephone+CHR(13))
      * wait for transmitter to complete
      DO WHILE CMTDCOUNT(m_portnbr) <> 0
      ENDDO
      m_result = CMRDFLUSH(m_portnbr)
      m_seconds = m_timeout
      @ 15,28 CLEAR TO 15,67
      @ 15,28 SAY "Waiting for Connection."
      @ 14,41 SAY STR(m_seconds,2,0)
      m_startsec = INT(SECONDS())
      m_charcount = CMRDCOUNT(m_portnbr)
      m_checksec = m_startsec
      DO WHILE .T.
        * check for the ESC key
        m_keypress = INKEY()
        IF m_keypress = 27
          @ 15,28 CLEAR TO 15,67
          @ 15,28 SAY "Esc key pressed, exiting..."
          BREAK
        ENDIF
        IF m_keypress = 13
          @ 15,28 CLEAR TO 15,67
          @ 15,28 SAY "Enter key pressed, cycling..."
          EXIT
        ENDIF
        * check for timeout
        IF INT(SECONDS()) - m_startsec >= m_timeout .AND. m_timeout <> 0
          * display message and retry
          @ 15,28 CLEAR TO 15,67
          @ 15,28 SAY "Timeout, retrying dial..."
          EXIT
        ENDIF
        * check for display of timeout
        IF INT(SECONDS()) <> m_checksec
          m_checksec = INT(SECONDS()) 
          m_seconds = m_seconds - 1
          @ 14,41 SAY STR(m_seconds,2,0)
        ENDIF
        * monitor the line for any characters
        IF m_charcount <> CMRDCOUNT(m_portnbr)
          * data has been received, monitor for message
          m_data = CMGETSTR(m_portnbr,.F.)
          DO CASE
          CASE "CONNECT" $ m_data
            INKEY(.1)
            m_data = CMGETSTR(m_portnbr,.F.)
            * check for proper connection speed
            m_ebaudrate = VAL(SUBSTR(m_data,AT("CONNECT",m_data)+8,5))
            IF m_ebaudrate <> m_baudrate .AND. m_ebaudrate <> 0
              * change it
              @ 15,28 CLEAR TO 15,67
              @ 15,28 SAY "Switching Line Speeds."
              m_baudrate = m_ebaudrate
              m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)
            ENDIF
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "Connected! Here we go!"
            TONE(100)
            TONE(130.8)
            TONE(164.80)
            TONE(196)
            TONE(0,2)
            TONE(164.80)
            TONE(196,8)
            m_retval = 0
            BREAK
          CASE "RING" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "Your telephone is ringing!."
            m_retval = 1
            BREAK
          CASE "NO CARRIER" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "No carrier detected."
            EXIT
          CASE "ERROR" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "Modem reports an error."
            EXIT
          CASE "NO DIALTONE" $ m_data .OR. "NO DIAL TONE" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "No dialtone detected."
            EXIT
          CASE "BUSY" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "The telephone is busy."
            EXIT
          CASE "NO ANSWER" $ m_data
            @ 15,28 CLEAR TO 15,67
            @ 15,28 SAY "No answer."
            EXIT
          ENDCASE
        ENDIF
      ENDDO
      * check for the ESC key
      m_keypress = INKEY()
      IF m_keypress = 27
        @ 15,28 CLEAR TO 15,67
        @ 15,28 SAY "Esc key pressed, exiting..."
        BREAK
      ENDIF
      m_retries = m_retries + 1
      m_result = CMSENDCHR(m_portnbr,13)
      INKEY(1)
    ENDDO
  END SEQUENCE
  RESTORE SCREEN FROM m_cmdial
  @ m_saverow,m_savecol SAY ""
RETURN m_retval

*****************************************************************************
* CMHANGUP - hangs up the telephone line
*****************************************************************************
*  Syntax: Result = CMHANGUP(<PortNbr>)
*  Passed: <PortNbr> - 1,2,3, or 4 
* Returns: numeric code, where:  0 = sucessful, line now On Hook
*                               -1 = incorrect port number passed
*                               -2 = escape key pressed
*****************************************************************************
FUNCTION CMHANGUP
  PARAMETERS m_portnbr
  PRIVATE m_keypress,m_retries,m_result
  m_result = CMTOGDTR(m_portnbr)
  m_result = CMCLOSE(m_portnbr)
  m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)
  m_result = CMSENDCHR(m_portnbr,43)
  INKEY(.3)
  m_result = CMSENDCHR(m_portnbr,43)
  INKEY(.3)
  m_result = CMSENDCHR(m_portnbr,43)
  INKEY(.3)
  I = INKEY(2)
  IF I = 27
    RETURN 2
  ENDIF
  m_result = CMSENDCHR(m_portnbr,13)
  m_result = CMSENDSTR(m_portnbr,"ATH"+CHR(13))
  INKEY(1)
  m_result = CMRDFLUSH(m_portnbr)
RETURN 0

******************************************************************************
* CMXFER - File transfer module
******************************************************************************
FUNCTION CMXFER
  PARAMETERS m_portnbr,m_sendrecv
  PRIVATE m_choice,m_filename,m_result,m_program
  CLEAR
  @ 0,0 TO 02,79 DOUBLE
  @ 21,0 TO 24,79 DOUBLE
  IF m_sendrecv = "S"
    @ 01,35 SAY "SEND FILE"
  ELSE
    @ 01,35 SAY "GET FILE"
  ENDIF
  m_choice = CMPROTOC()
  IF m_choice <> 0
    * cancel printing and capture
    IF m_prnton
      SET PRINT OFF
    ENDIF
    IF m_capton
      SET ALTERNATE OFF
    ENDIF
    m_filename = ""
    IF m_sendrecv = "S" .OR. m_choice = 4 .OR. m_choice = 5 .OR. m_choice = 6
      IF m_sendrecv = "S"
        @ 15,07 SAY "[File(s) To Send]ͻ"
        @ 22,04 SAY "  Please enter the filename to send or press the Esc key to cancel.    "
        @ 23,04 SAY "If you use YMODEM BATCH, G, or ZMODEM, you may enter a file spec: (*.*)"
      ELSE 
        @ 15,07 SAY "[File To Receive]ͻ"
        @ 22,04 SAY "  Please enter the filename to receive or press the Esc key to cancel. "
        @ 23,04 SAY "                                                                       "
      ENDIF
      @ 16,07 SAY "                                                               "
      @ 17,07 SAY "ͼ"
      m_filename = SPACE(60)
      @ 16,09 GET m_filename PICTURE '@!'
      READ
      IF LASTKEY() = 27 .OR. m_filename = SPACE(60)
        RETURN 0
      ENDIF
    ENDIF
    DO CASE
    CASE m_choice = 1  && zmodem
      IF m_sendrecv = "S"
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " sz " + m_filename
      ELSE
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " rz -y " + m_downdir + " " + m_filename
      ENDIF
      m_result = CMCLOSE(m_portnbr)
      CLEAR
      m_result = OVERLAY(m_program,64,"","","",.T.)
    CASE m_choice = 2  && ymodem G
      IF m_sendrecv = "S"
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " sb " + m_filename
      ELSE
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " rb -g -y " + m_downdir + " " + m_filename
      ENDIF
      m_result = CMCLOSE(m_portnbr)
      CLEAR
      m_result = OVERLAY(m_program,64,"","","",.T.)
    CASE m_choice = 3  && ymodem batch
      IF m_sendrecv = "S"
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " sb " + m_filename
      ELSE
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " rb -y " + m_downdir + " " + m_filename
      ENDIF
      m_result = CMCLOSE(m_portnbr)
      CLEAR
      m_result = OVERLAY(m_program,64,"","","",.T.)
    CASE m_choice = 4  && xmodem 1K
      IF m_sendrecv = "S"
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " sx -k " + m_filename
      ELSE
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " rc -y " + m_downdir + m_filename
      ENDIF
      m_result = CMCLOSE(m_portnbr)
      CLEAR
      m_result = OVERLAY(m_program,64,"","","",.T.)
    CASE m_choice = 5  && xmodem 
      IF m_sendrecv = "S"
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " sx " + m_filename
      ELSE
        m_program = "DSZ CON port " + LTRIM(STR(m_portnbr,1,0)) + " rx -y " + m_downdir + m_filename
      ENDIF
      m_result = CMCLOSE(m_portnbr)
      CLEAR
      m_result = OVERLAY(m_program,64,"","","",.T.)
    CASE m_choice = 6  && ascii
      IF m_sendrecv = "S"
        m_result = CMASCII(m_portnbr,"S",m_filename)
      ELSE
        m_result = CMASCII(m_portnbr,"R",m_downdir + m_filename)
      ENDIF
    ENDCASE
    * re-open the port
    m_result = CMOPEN(m_portnbr,m_baudrate,m_parity,m_databits,m_stopbits)
  ENDIF
RETURN 0

******************************************************************************
* CMPROTOC - Ask for file transfer protocol
******************************************************************************
FUNCTION CMPROTOC
  @ 06,02 SAY "[Transfer Protocols]ͻ"
  @ 07,02 SAY "                                                                         "
  @ 08,02 SAY "                                                                         "
  @ 09,02 SAY "                                                                         "
  @ 10,02 SAY "                                                                         "
  @ 11,02 SAY "                                                                         "
  @ 12,02 SAY "                                                                         "
  @ 13,02 SAY "ͼ"
  @ 21,0 TO 24,79 DOUBLE
  @ 22,04 SAY "Use the arrow keys, PgUp or PgDn, Ctrl PgUp/PgDn to move the highlight."
  @ 23,04 SAY "   Press the Enter key to select a protocol, or press Esc to exit."
  m_choice = 0
  DO WHILE .T.
    m_choice = ACHOICE(07,04,12,74,m_aprotocol,"","",m_choice)
    DO CASE
    CASE m_choice = 0
      EXIT
    CASE m_choice = 1  && zmodem
      EXIT
    CASE m_choice = 2  && ymodemG 
      EXIT
    CASE m_choice = 3  && ymodem batch
      EXIT
    CASE m_choice = 4  && ymodem 1K
      EXIT
    CASE m_choice = 5  && xmodem 
      EXIT
    CASE m_choice = 6  && ascii  
      EXIT
    ENDCASE
  ENDDO
RETURN m_choice

******************************************************************************
* CMASCII - ASCII file transfer
******************************************************************************
FUNCTION CMASCII
  PARAMETERS m_portnbr,m_sendrcv,m_filename
  PRIVATE m_totlines,m_filehandle,m_filedata
  IF PCOUNT() < 3
    RETURN .F.
  ENDIF
  m_totlines = 0
  m_filehandle = 0
  m_retval = .T.
  DO CASE
  CASE m_sendrcv = "R"
    * attempt to create the file
    IF FILE(m_filename)
      DELETE FILE &m_filename
    ENDIF
    m_filehandle = FCREATE(m_filename,0)       
    IF FERROR() <> 0
      @ 08,12 SAY "Unable to create this file, cancelling."
      INKEY(.5) 
      RETURN .F.
    ENDIF
    m_status = " RECEIVING LINE:                                    PRESS THE ESC KEY TO CANCEL "
  CASE m_sendrcv = "S"
    * attempt to open the file in read only mode
    m_filehandle = FOPEN(m_filename,0)       
    IF FERROR() <> 0
      @ 09,12 SAY "Unable to open this file, cancelling."
      INKEY(.5) 
      RETURN .F.
    ENDIF
    m_status = " SENDING LINE:                                      PRESS THE ESC KEY TO CANCEL "
  ENDCASE
  CLEAR
  @ 24,00 GET m_status
  CLEAR GETS
  BEGIN SEQUENCE
    @ 0,0 SAY ""
    DO CASE
    CASE m_sendrcv = "R"
      * signal ready by sending a carriage return
      m_result = CMSENDCHR(m_portnbr,13)
      DO WHILE .T.
        * check for Esc keypress
        m_keypress = INKEY()
        IF m_keypress = 27
          BREAK
        ENDIF
        IF CMRDCOUNT(m_portnbr) > 0
          m_inchar = CMGETCHR(m_portnbr)
          * check for eof()
          IF m_inchar = 26
            * absorb the rest of them
            DO WHILE CMGETCHR(m_portnbr) = 26
            ENDDO
            BREAK
          ENDIF
          * check for line feed, ignore console write
          IF m_inchar <> 10
            * update the screen counters
            IF m_inchar = 13
              m_saverow = ROW()
              m_savecol = COL()
              m_totlines = m_totlines + 1
              @ 24,17 GET m_totlines PICTURE '##########'
              CLEAR GETS
              @ m_saverow,m_savecol SAY ""
              IF ROW() = 23
                SCROLL(0,0,23,79,1)
                @ 22,00 SAY ""
              ENDIF
              ?
            ELSE 
              IF ROW() = 23 .AND. COL() = 79
                SCROLL(0,0,23,79,1)
                @ 23,00 SAY ""
              ENDIF
              ?? CHR(m_inchar)
            ENDIF
          ENDIF
          m_filedata = CHR(m_inchar)
          m_result = FWRITE(m_filehandle,@m_filedata,1)
          IF m_result <> 1
            m_status = " Disk error on file write, cancelling."
            @ 24,00 GET m_status
            CLEAR GETS
            BREAK
          ENDIF
        ENDIF
      ENDDO
    CASE m_sendrcv = "S"
      DO WHILE .T.
        * check for Esc keypress
        m_keypress = INKEY()
        IF m_keypress = 27
          BREAK
        ENDIF
        * process all incoming characters
        DO WHILE CMRDCOUNT(m_portnbr) > 0
          * check for Esc keypress
          m_keypress = INKEY()
          IF m_keypress = 27
            BREAK
          ENDIF
          m_inchar = CMGETCHR(m_portnbr)
          * check for line feed, ignore console write
          IF m_inchar <> 10
            * check for C/R
            IF m_inchar = 13
              * update line counter
              m_saverow = ROW()
              m_savecol = COL()
              m_totlines = m_totlines + 1
              @ 24,19 GET m_totlines PICTURE '##########'
              CLEAR GETS
              @ m_saverow,m_savecol SAY ""
              IF ROW() = 23
                SCROLL(0,0,23,79,1)
                @ 22,00 SAY ""
              ENDIF
              ?
            ELSE 
              IF ROW() = 23 .AND. COL() = 79
                SCROLL(0,0,23,79,1)
                @ 23,00 SAY ""
              ENDIF
              ?? CHR(m_inchar)
            ENDIF
          ENDIF
        ENDDO
        * wait for the transmitter to complete
        IF CMTDCOUNT(m_portnbr) > 0
          LOOP
        ENDIF
        * read a line from the file
        m_filedata = FREADSTR(m_filehandle,4096)
        IF LEN(m_filedata) = 0
          * must be done, send EOFS()
          m_result = CMSENDCHR(m_portnbr,26)
          m_result = CMSENDCHR(m_portnbr,26)
          m_result = CMSENDCHR(m_portnbr,26)
          BREAK
        ENDIF
        m_result = CMSENDSTR(m_portnbr,m_filedata)
      ENDDO
    ENDCASE
  END SEQURNCE
  IF m_filehandle > 0
    FCLOSE(m_filehandle)
  ENDIF
  * do not clear the recieve buffer here
  m_result = CMTDFLUSH(m_portnbr)
  CLEAR TYPEAHEAD
RETURN m_retval

******************************************************************************
* CMWAITFOR - waits a set amount of time for a string to arrive        
*   usage:
*     m_result = CMWAITFOR(<port>,<string>,<timeout>)
*     passed:
*       port = port number (1-4) previously opened
*       string = memvar or quoted string to match
*       timeout = number of seconds to wait for a match
*     returns:
*       m_result = 0 if a match was made
*                 -1 if timeout
******************************************************************************
FUNCTION CMWAITFOR
  PARAMETERS m_portnbr,m_str,m_timeout
  PRIVATE m_startsec,m_retval,m_keypress,m_result
  m_startsec = INT(SECONDS())
  m_retval = 0 
  DO WHILE .T.
    * check for Esc key
    m_keypress = INKEY()
    IF m_keypress = 27
      m_retval = -1
      EXIT
    ENDIF
    * check for timeout
    IF INT(SECONDS()) - m_startsec > m_timeout .AND. m_timeout <> 0
      m_retval = -1 
      EXIT
    ENDIF
    * check for existence of the string
    IF UPPER(m_str) $ UPPER(CMGETSTR(m_portnbr,.F.))
      m_retval = 0
      m_result = CMRDFLUSH(m_portnbr)
      EXIT
    ENDIF
  ENDDO
RETURN m_retval

******************************************************************************
* CMWAIT - waits a set amount of time for the input buffer to receive a character
*   usage:
*     m_result = CMWAIT(<port>,<timeout>)
*     passed:
*       port = port number (1-4) previously opened
*       timeout = number of seconds to wait for input
*     returns:
*       m_result = 0 if input has started
*                 -1 if timeout
*                 -2 if Esc key pressed
*
*  Notes: the recieve buffer is assumed to be empty 
******************************************************************************
FUNCTION CMWAIT
  PARAMETERS m_portnbr,m_timeout
  PRIVATE m_startsec,m_count,m_retval,m_keypress
  m_startsec = SECONDS()
  m_retval = 0 
  DO WHILE .T.
    IF CMRDCOUNT(m_portnbr) > 0
      EXIT
    ENDIF
    * check for timeout
    IF SECONDS() - m_startsec >= m_timeout .AND. m_timeout <> 0
      m_retval = -1 
      EXIT
    ENDIF
    m_keypress = INKEY(.25)
    IF m_keypress = 27
      m_retval = -2
      EXIT
    ENDIF
  ENDDO
RETURN m_retval

*****************************************************************************
* CMGETPAC - retrieves a packet from the host system
*****************************************************************************
*  Syntax: Result = CMGETPAC(<PortNbr>)
*  Passed: <PortNbr> - 1,2,3, or 4 
* Returns: numeric code, where:  0 = sucessful, packet retrieved
*                                1 = host timed out
*                                2 = escape key pressed
*****************************************************************************
FUNCTION CMGETPAC
  PARAMETERS m_portnbr
  PRIVATE m_result,m_count
  I = INKEY()
  IF I = 27
    RETURN 2
  ENDIF
  * wait for incoming data stream to start
  m_result = CMWAIT(m_portnbr,5)
  IF m_result <> 0                
    IF m_result = -1
      * host timed out
      RETURN 1
    ENDIF
    IF m_result = -2
      * esc key pressed
      RETURN 2
    ENDIF
  ENDIF
  * monitor incoming data stream for line silence, then return
  @ 13,31 CLEAR TO 13,69
  @ 13,31 SAY "Receiving data."
  DO WHILE .T.
    m_count = CMRDCOUNT(m_portnbr)
    m_keypress = INKEY(.1)
    IF m_keypress = 27
      RETURN 2
      EXIT
    ENDIF
    IF m_count = CMRDCOUNT(m_portnbr)
      EXIT
    ENDIF
  ENDDO
RETURN 0

*****************************************************************************
* CMSENDPAC - sends a packet to the host, waits for response
*****************************************************************************
*  Syntax: Result = CMSENDPAC(<PortNbr>,<Packet>)
*  Passed: <PortNbr> - 1,2,3, or 4 
*          <Packet> - transmission ready packet with header and crc/checksum
* Returns: numeric code, where:  0 = sucessful, packet send
*                                1 = host timed out or to many retries
*                                2 = escape key pressed
*****************************************************************************
FUNCTION CMSENDPAC
  PARAMETERS m_portnbr,m_txpacket
  PRIVATE m_keypress,m_retries,m_result,m_count
  m_keypress = INKEY()
  IF m_keypress = 27
    RETURN 2
  ENDIF
  m_retries = 0
  DO WHILE .T.
    * check for retry
    IF m_retries <> 0
      @ 15,32 SAY STR(m_retries,1,0)
      @ 16,32 CLEAR TO 16,69
      IF m_retries = 9
        @ 16,32 SAY "Too many errors, cancelling."
        RETURN 1
      ELSE
        @ 16,32 SAY "Host requested retransmission."
      ENDIF
    ENDIF
    * send the packet
    @ 13,31 CLEAR TO 13,69
    @ 13,31 SAY "Transmitting packet."
    m_result = CMTDFLUSH(m_portnbr)
    m_result = CMSENDSTR(m_portnbr,m_txpacket)
    @ 13,31 CLEAR TO 13,69
    @ 13,31 SAY "Awaiting packet response."
    DO WHILE .T.
      m_result = CMRDFLUSH(m_portnbr)
      m_result = CMWAIT(m_portnbr,30)
      IF m_result <> 0
        * cancel
        @ 16,32 CLEAR TO 16,69
        @ 16,32 SAY "Timeout while waiting."
        m_result = CMTDFLUSH(m_portnbr)
        m_result = CMRDFLUSH(m_portnbr)
        RETURN 2
      ENDIF
      * check for ACK
      IF CHR(m_ack) $ CMGETSTR(m_portnbr,.F.)
        m_result = CMTDFLUSH(m_portnbr)
        m_result = CMRDFLUSH(m_portnbr)
        RETURN 0
      ENDIF
      * check for NAK
      IF CHR(m_nak) $ CMGETSTR(m_portnbr,.F.)
        m_retries = m_retries + 1
        EXIT
      ENDIF
      * check for abort
      IF CHR(m_ctrlx) $ CMGETSTR(m_portnbr,.F.)
        @ 13,31 CLEAR TO 13,69
        @ 13,31 SAY "Send cancelled by remote."
        m_result = CMTDFLUSH(m_portnbr)
        m_result = CMRDFLUSH(m_portnbr)
        RETURN 1
      ENDIF
    ENDDO
  ENDDO
  @ 15,32 SAY " "
  @ 16,32 CLEAR TO 16,69
  m_result = CMTDFLUSH(m_portnbr)
  m_result = CMRDFLUSH(m_portnbr)
RETURN 0

