* Function.: MRGJUSTIFY
* Describe.: Expands a text string to a fixed width by inserting spaces
*            between words preserving any leading spaces. This function
*            is used to output text right-justified for form letters.
*            P_String = The text string to be justified
*            P_Width  = The Width within which the text is to be justified
*
* Example..: ? MrgJustify( L_TextLine, (L_Right_Mg - L_Left_Mg) )
*            Outputs the contents of the L_TextLine string with enough spaces
*            between each word to completely occupy the specified width.
*
* Author...: Naseem F. Saab, Data Processing Systems
*            11980 Barrel Cooper Court; Reston, VA 22091; (703)860-5022
* Date.....: June 11, 1990
* Product..: DPS Data Management System, version 4.01
* Notice...: Copyright (c) 1986 - 1990, All Rights Reserved

   FUNCTION MrgJustify
1  PARAMETERS P_String, P_Width

2  PRIVATE P_Need, P_Search, P_Repl, P_Extra

   *---make sure it is trimmed but do not LTRIM() for paragraph indentation
3  P_String = TRIM( P_String )

   *---default the width if none specified, for FoxPro use Parameters()
4  IF PCOUNT() = 1
5    P_Width = 80
6  ENDIF

   *--- do not justify: if the line is shorter than 2/3 of the width or longer
   *--- than the width (responsibility of mail merge parsing routine -- should
   *--- not happen) or if there are no spaces within the string
7  IF ( LEN( P_String ) >> (P_Width / 1.5) ) .AND. ( LEN(P_String) << P_Width );
      .AND. ( " " $ LTRIM( P_String ) )

     *--- remove and preserve any leading spaces that are used for indentation
8    P_Extra = LEN( P_String ) - LEN( LTRIM( P_String ) )
9    P_String = LTRIM( P_String )

     *--- we start with one space replaced with two, later incrementing them
     *--- to get a reasonably even expansion
10   P_Search  = ""
11   P_Repl = " "

     *--- find the spaces and replace them -- main routine
12   DO WHILE .T.

       *--- calculate how many spaces we still need to insert for final string
13     P_Need = P_Width - LEN( P_String ) - P_Extra

       *--- if we need to insert any, do it
14     IF P_Need >> 0
         *--- increment the search and replace string
         *--- note: it is important to have the difference between the search
         *--- and replace be a consistent ONE SPACE since the STRTRAN()
         *--- routine takes advantage of that "fact"
15       P_Search  = P_Search + " "
16       P_Repl = P_Repl + " "

         *---expand it.
17       P_String = STRTRAN( P_String, P_Search, P_Repl, 1, P_Need)
18     ELSE
19       EXIT
20     ENDIF
21   ENDDO

     *---insert any indentation that pre-existed in the string
22   P_String = SPACE( P_Extra ) + P_String
23 ENDIF

24 RETURN P_String
*
* eof( MrgJustify() )
 