/*
    JUMP2GET.PRG  [Steve Kolterman  CIS: 76320,37]
    ====================================================================
    Demonstrates 3 capabilities of Clipper 5.01's GET system, previously
    thought to require direct modification of GETSYS.PRG.  As you'll
    discover, that belief was in error.  The modifications demonstrated
    below consist of 1) the same custom reader for each GET; 2) two
    data values held in the cargo i-var.  The capabilities demonstrated
    are:

    o  Enter a READ at *ANY* GET in the 'getlist'.  At the DOS prompt,
       type 'JUMP2GET 5', e.g., to enter the READ at GET 5;
    o  Jump to any other GET in the getlist from a GET's postblock;
    o  Jump to any other GET based on user input of either the ordinal
       position of the GET in the getlist, or, the GET's name.
       
    I chose here to load the 'name' i-var into a cargo sub-element, but
    you could just as easily use 'name' directly, or re-assign 'name'
    to match what you write to the screen.  e.g., if your GET's SAY was
    'Address', you could re-assign 'name' to 'Address'.  The user, then,
    would enter 'address' at the hotkey's prompt, and jump directly there.
    AAMOF, I use 'City' for GET 3 and 'State' for GET 7.  I chose not to
    re-assign 'name' because of the implications for Readvar()...which you
    can read about in the .NG under 'Get Class.'

    Another feature never did require modification of GETSYS and never did
    require a custom reader, but I implemented it with the reader for this
    demo: jump to the first and last GETs via the press of hotkeys.  F7
    goes top; F8 goes bottom.

    Finally, a quick cursor off/on to prevent the visibility of a 'flying'
    cursor.  This could easily be eliminated, but it 'appears' to perform
    as intended.

    Compile:  CLIPPER jump2get /n/w/m
       Link:  RTLINK fi jump2get /pll:base50

    An article in an upcoming issue of Reference(Clipper) will provide
    more detail.

    Questions or comments to the above CIS ID ...please.
    And, awaaaaaaay we go.
*/

#include "getexit.ch"
#include "inkey.ch"
#include "setcurs.ch"

#define  MR                 maxrow()
#define  MC                 maxcol()
#define  VC                 Int(MC/2)-7
#define  ALTERNATE_FIRSTGET (xInitGet > 1)
#define  ADMISSION          cargo[1][1]
#define  GET_NAME           cargo[1][2]
#define  CURS_TYPE          cargo[1][3]
#define  JUMPKEY            K_F5
#define  TOPKEY             K_F7
#define  BOTKEY             K_F8
#define  KEY                1
#define  BLOCK              2

FUNCTION Test(xInitGet)
LOCAL cOldcolor,cOldscrn,cVar1:= "one",cVar2:= "two",cVar3:= "three",;
      cVar4:= "four",cVar5:= "five",cVar6:= "six",cVar7:= "seven",;
      cVar8:= "eight",cVar9:= "nine",cVar10:= "ten",getlist:= {},aHotkeys,;
      nJumpkey,nTopkey,nBotkey

nJumpkey:= nTopkey:= nBotkey:= 0
xInitGet:= IF( xInitGet==NIL,1,Val(xInitGet) )
cOldScrn:= SaveScreen( 0,0,MR,MC )
cOldColor:= SetColor( "+gr/b,+gr/n,,,+w/r" )

#ifdef JUMPKEY
  nJumpkey:= JUMPKEY
#endif
#ifdef TOPKEY
  nTopkey:= TOPKEY ; nBotkey:= BOTKEY
#endif

Scroll()
DispBegin()

@  2,5  say "JUMP2GET Demo" color "+w/b"
@  2,VC say "Steve Kolterman [76320,37]" color "+gr/b"
@  3,5  say " " color "+r/b"
@  3,VC say Replic("",26) color "+r/b"
@  5,VC say "Press F5 For A UDJ...User-Defined Jump," color "+w/b"
@  6,VC say "Then Enter The Name of the GET, or" color "+w/b"
@  7,VC say "The GET's Number." color "+w/b"
@  9,VC say "e.g., Enter 5 or 'var5' to Jump To GET 5." color "+w/b"
@ 11,VC say "OR...let each GET's postblock (VALID)" color "+w/b"
@ 12,VC say "jump you to a randomly-selected GET.  In" color "+w/b"
@ 13,VC say "this case, exit each GET as you normally" color "+w/b"
@ 14,VC say "would.  GETs 3 and 7 have no postblock..." color "+w/b"
@ 15,VC say "to break the monotony." color "+w/b"
@ 17,VC say "Press F7 To Jump to the first GET." color "+w/b"
@ 18,VC say "Press F8 To Jump to the last GET."  color "+w/b"
@ 20,VC say "[Esc] to Quit." color "+w/b"

@ 5,5   say " Var1:"  get cVar1 VALID {|g| Valfunc(g,getlist) }
@ 6,5   say " Var2:"  get cVar2 VALID {|g| Valfunc(g,getlist) }
@ 7,5   say " City:"  color "+w/b" get cVar3
@ 8,5   say " Var4:"  get cVar4 VALID {|g| Valfunc(g,getlist) }
@ 9,5   say " Var5:"  get cVar5 VALID {|g| Valfunc(g,getlist) }
@ 10,5  say " Var6:"  get cVar6 VALID {|g| Valfunc(g,getlist) }
@ 11,5  say "State:"  color "+w/b" get cVar7
@ 12,5  say " Var8:"  get cVar8 VALID {|g| Valfunc(g,getlist) }
@ 13,5  say " Var9:"  get cVar9 VALID {|g| Valfunc(g,getlist) }
@ 14,5  say "Var10:"  get cVar10 VALID {|g| Valfunc(g,getlist) }

DispEnd()

// 'hotkey' codeblocks
aHotkeys:= { {nJumpkey,{|g,l| JG_Shell(g,l)} },;
             {nTopkey, {|g,l| TopGet(g,l)}   },;
             {nBotkey, {|g,l| BotGet(g,l)}   }  }

// assign custom reader
Aeval( getlist,{|e| e:reader:= {|g| SKReader(g,getlist,aHotkeys) } } )

// assign cargo; decide on admission status
IF ALTERNATE_FIRSTGET
   @ 20,5 say "Entering READ at GET "+Ltrim(Str(xInitGet))+" "
   @ 21,5 say "Press Any Key... "
   Inkey(0)
   Scroll( MR-4,5,MR-3,VC-1 )
   // see note under Jump2Get() below.
   Aeval( getlist,{|e| e:cargo:= {{.F.,SUBS(e:name,2),SetCursor()}} } )
   getlist[xInitGet]:ADMISSION:= .T.
ELSE
   Aeval( getlist,{|e| e:cargo:= {{.T.,SUBS(e:name,2),SetCursor()}} } )
ENDIF

// assign two sample names
getlist[3]:GET_NAME:= "city"
getlist[7]:GET_NAME:= "state"

READ

SetColor( cOldcolor )
RestScreen( 0,0,MR,MC,cOldscrn )
RETURN NIL

PROCEDURE SKReader( get,getlist,aHotkeys )
LOCAL nKey,nN:= 0

    // if off-limits, bail, else grant admission to all.
    IF !get:ADMISSION
       RETURN
    ELSE
       Aeval( getlist,{|g| g:ADMISSION:= .T.} )
       SetCursor( get:CURS_TYPE )
    ENDIF

    if ( GetPreValidate(get) )

	        // activate the GET for reading
                get:SetFocus()

		while ( get:exitState == GE_NOEXIT )

		        // check for initial typeout (no editable positions)
			if ( get:typeOut )
			   get:exitState := GE_ENTER
			end

                        // apply keystrokes until exit
			while ( get:exitState == GE_NOEXIT )
                              nKey:= Inkey(0)
                              // if hotkeys, Eval() block,
                              // else, normal handling.
                              IF (nN:= Ascan( aHotkeys,{|e| e[KEY]==nKey})) > 0
                                 Eval( aHotkeys[nN][BLOCK],get,getlist )
                              ELSE
                                 GetApplyKey( get, nKey )
                              ENDIF
			end

                        // no validation if any hotkeys pressed.
                        IF nN==0
	  		      // disallow exit if the VALID condition is not satisfied
                              if ( !GetPostValidate(get) )
	     		         get:exitState := GE_NOEXIT
		      	      end
                        ENDIF

		end

		// de-activate the GET
		get:KillFocus()

      end

RETURN

#define JUMP2GET .T.
FUNCTION Valfunc( g,getlist )
STATIC nNum
IF nNum==NIL; nNum:= 11; ENDIF

IF JUMP2GET  // whatever condition requires the jump.
     nNum+= IF( nNum==1,5,IF(nNum==Len(getlist),-5,-2 ))
     IF nNum < 1; nNum:= 10; ENDIF
     IF nNum > 10; nNum:= 1; ENDIF
     @ 20,5 say "Now We'll Jump To GET "+Ltrim(Str(nNum))+" "
     @ 21,5 say "Press Any Key... "
     Inkey(0)
     @ 21,5 say "Arrived At GET "+Ltrim(Str(nNum))+" "
     g:CURS_TYPE:= SetCursor(SC_NONE)
     // this next is the critical line
     Jump2Get( nNum,g,getlist )
ENDIF
RETURN .T.

***************************************************************************
FUNCTION Jump2Get( nNum,g,getlist )
   /*
      This is the heart of what's going on.
      Flag all GETs off-limits except the target,
      then jump to top of the getlist.
      The reader then knows whether to grant admission.
      Almost too simple to be believed.
   */
   Aeval( getlist,{|e| e:ADMISSION:= .F.} )
   getlist[nNum]:ADMISSION:= .T.
   g:exitstate:= GE_TOP
RETURN NIL
***************************************************************************
FUNCTION JG_Shell( g,gettlist )
LOCAL getlist:= {},xVal:= Space(10)
@ 17,5 say "Jump To Get: " get xVal VALID !Empty(xVal)
READ
xVal:= IF( IsDigit(xVal),Val(xVal),Alltrim(xVal) )
Scroll( MR-7,5,MR-7,VC-1 )

IF valtype(xVal)=="N"
   xVal:= IF( xVal < 1 .or. xVal > Len(gettlist),1,xVal )
ENDIF
IF valtype(xVal)=="C"
   // determine number of the GET matching user entry.
   xVal:= Ascan( gettlist,{|e| upper(xVal)==upper(e:GET_NAME) } )
   xVal:= IF( xVal==0,1,xVal )
ENDIF

Scroll( MR-4,5,MR-3,VC-1 )
g:CURS_TYPE:= SetCursor(SC_NONE)
// this next is the critical line
Jump2Get(xVal,g,gettlist)

RETURN NIL
***************************************************************************
FUNCTION TopGet( g,getlist )
g:exitstate:= IF( !(g==getlist[1]),GE_TOP,g:exitstate )
RETURN NIL
***************************************************************************
FUNCTION BotGet( g,getlist )
g:exitstate:= IF( !(g==Atail(getlist)),GE_BOTTOM,g:exitstate )
RETURN NIL
