/*********
*
* TRANSLATE.C

*   Author : Jean-Pierre van Melis
* Compiled : with Microsoft C 5.1
*   Object : can only be used in conjunction with Clipper summer '87

*  Syntax: TRANSLATE( <expC> )
*  Return: All non-english characters are replaced by there ASCII-counterpart.
*
*                               A
*                                C
*                                E
*                                N
*                                U
*
*                            a
*                             e
*                             i
*                                n
*                             u
*
*
*          INPUT                  RETURN
*          ---------------------- ----------------------------------
*           "garon"              "garcon"
*           "tte"                "tete"
*           "wilde zeen"         "wilde zeeen"
*           "nia"                "nina"
*
*********/

#include "jpm.h"


#define START  128
#define LENGTH  38


static byte convert[LENGTH] =
{ 'C','u','e','a','a','a','a','c','e','e','e','i','i','i','A','A','E','',''
 ,'o','o','o','u','u','Y','O','U','','','','','','a','i','o','u'
 ,'n','N'};

/*
                                                         
                                                   
       
*/

CLIPPER translate()

{

   byte *par;                                      /* pointer to input */
   byte *retstr;                                   /* pointer to output */

   quant leng;                                     /* leng of string */
   quant n1;                                       /* offset input */
   quant n2;                                       /* offset output */

   Boolean error;

   error = TRUE;

   if(PCOUNT == 1 && ISCHAR(1))
   {
      par    = _parc(1);                           /* receive pointer from clipper */
      leng   = (quant) _parclen(1);                /* receive leng from clipper */

      retstr = _exmgrab(leng+1);                   /* Allocate memory */

      if(retstr)                                   /* Enough memory available */
      {
         error = FALSE;                            /* No errors */
         n2    = 0;                                /* point to first character */

         for(n1 = 0; n1 < leng; n1++)              /* parse input till end of input*/
         {
            if((par[n1] > START-1) && (par[n1] < START + LENGTH))
               retstr[n2++] = convert[par[n1]-START];
            else
               retstr[n2++] = par[n1];
         }

         retstr[n2] = NULLC;                       /* terminate with null */
      }
   }
   if(error)
      _retc(NULLS);                                /* return null string */
   else
   {
      _retclen(retstr, leng);                      /* return string with length */
      _exmback(retstr, leng+1);                    /* deallocate memory */
   }
   return;
}
