/******************************
* Compiled : with Microsoft C 5.1
* Object   : can only be used in conjunction with Clipper summer '87
* Syntax   : RESEMBLE( <expC1>, <expC2> )
* Parameter: <expC1> is the string you want to test, <expC> is the string
             (maybe in the database)
* Return   : A digit between 0 and 1, to reflect the resemblance
             between two strings.
             Every character is given a point.
             Most-used characters are given less points, and less-used
             characters are given more points.
             First <expC2> is tested to check how much points you are
             able to gain.
             Then, all the characters of <expC2> that reappear in <expC1>
             are given points.
             The quotient of those two numbers is returned as a
             resemblance-index.
             
* Author   : Jean-Pierre van Melis, Helmond, The Netherlands
* Date     : June 1, 1988
* Note     : I use this function in combination with the Soundex function
             to get rid off the strings that have a correct Soundex
             code, but do not resemble the original string.
             (if a string has the correct soundex, resemble() must
             be greater than 0.5)
*/

#include "jpm.h"

static byte code[] =  {3,5,4,4,1,5,5,4,3,6,6,4,5,3,3,5,6,3,4,1,5,6,5,6,5,6};

/*                     A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
*/
static byte scrap1[26];
static byte scrap2[26];

CLIPPER resemble()

{
   quant points_possible = 0;
   quant points_gained   = 0;

   quant length;
   quant i;

   byte  *is_now;
   byte  *should_be;

   if (PCOUNT==2 && ISCHAR(1) && ISCHAR(2))
   {
      is_now    = _parc(1);
      should_be = _parc(2);
      length    = min(_parclen(1),_parclen(2));

      if (length > 2)
      {
         for (i=0;i<26;i++)
         {
            scrap1[i] = 0;
            scrap2[i] = 0;
         }
      
         for (i=0;i<length;i++)
         {
            if (is_now[i] >= 'A' && is_now[i] <= 'Z')
               scrap1[is_now[i] - 'A'] = 1;
            else
               if (is_now[i] >= 'a' && is_now[i] <= 'z')
                  scrap1[is_now[i] - 'a'] = 1;


            if (should_be[i] >= 'A' && should_be[i] <= 'Z')
               scrap2[should_be[i] - 'A'] = 1;
            else
               if (should_be[i] >= 'a' && should_be[i] <= 'z')
                  scrap2[should_be[i] - 'a'] = 1;
         }        

         for (i=0;i<26;i++)
         {
            if (scrap2[i])
            {
               points_gained   += ((quant) scrap1[i] * code[i]);
               points_possible += ((quant) code[i]);
            }
         }

         if (points_possible)
            _retnd((double) points_gained/(double) points_possible);
         else
            _retnd(0);
      }
      else
         _retnd(0);

   }
   else
      _ret();
   return;

}
