/**********
*
*   jpm.h
*
*   Header file for C modules.
*
*
**********/

#define CLIPPER      void pascal
#define ABS(p)       ( ((p)<0) ? -(p): (p) )
#define ADTOI(p)     (int) ((p)-('0'))        /* ascii digit to int */
#define DIGIT(p)     (char) ((p)+('0'))       /* int digit to ascii */

#define NULLC        '\0'        /* use to terminate strings */
#define NULLLONG     0L          /* for NULL pointer return */
#define NULLS        ""          /* use with _retc() to return null string */
#define NULLD        "        "  /* use with _retd() to return empty date */

#define SPACEC       ' '
#define ZEROC        '0'

#define FALSE        (0)
#define TRUE         (!(0))

/* min and max macros */

#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))

/* Replace #define macros in Clipper */
 
#define isalpha(p)   (('A'<=(p)&&(p)<= 'Z')||('a'<= (p)&&(p)<='z'))
#define isdigit(p)   ('0'<=(p)&&(p)<='9')

#define islower(p)   ( 'a' <= (p) && (p) <= 'z' )
#define isupper(p)   ( 'A' <= (p) && (p) <= 'Z' )

#define toupper(p)   ( islower(p) ? ((p) + ('A' - 'a')) : ((p)) )
#define tolower(p)   ( isupper(p) ? ((p) - ('A' - 'a')) : ((p)) )

#define ISLPYR(yr)    ((yr)>0 && (((yr)%4==0&&(yr)%100!=0) || (yr)%400==0))

#define ISMONTH(p)    ((p)>=1 && (p)<=12)       /* valid month */

#define ISYEAR(p)     ((p)>=1 && (p)<=9999)     /* valid year */

#define ISDS(p)       ( ISDIGIT(p[0]) && ISDIGIT(p[1]) &&\
                        ISDIGIT(p[2]) && ISDIGIT(p[3]) &&\
                        ISDIGIT(p[4]) && ISDIGIT(p[5]) &&\
                        ISDIGIT(p[6]) && ISDIGIT(p[7]) && !p[8] )

#define DSYEAR(p)     ( (ADTOI(p[0])*1000) +\
                        (ADTOI(p[1])* 100) +\
                        (ADTOI(p[2])*  10) +\
                        (ADTOI(p[3])) )         /* ds year to int */

#define DSMONTH(p)   ( (ADTOI(p[4])*  10) +\
                       (ADTOI(p[5])) )         /* ds month to int */

#define DSDAY(p)     ( (ADTOI(p[6])*  10) +\
                       (ADTOI(p[7])) )         /* ds day to int */

#define ISDIGIT(p)   ((p)>='0' && (p)<='9')    /* valid digit */

/* _parinfo types */
#define UNDEF        0
#define CHARACTER    1
#define NUMERIC      2
#define LOGICAL      4
#define DATE         8
#define ALIAS        16
#define MPTR         32   /* bitwise or'ed with type for pass by reference */
#define MEMO         65
#define WORD         128
#define ARRAY		   512

/* parameter check macros */
#define PCOUNT        (_parinfo(0))
#define ISCHAR(n)     (_parinfo(n) & CHARACTER)
#define ISNUM(n)      (_parinfo(n) & NUMERIC)
#define ISLOG(n)      (_parinfo(n) & LOGICAL)
#define ISDATE(n)     (_parinfo(n) & DATE)
#define ISMEMO(n)     (_parinfo(n) & MEMO)
#define ISBYREF(n)    (_parinfo(n) & MPTR)
#define ISARRAY(n)	 (_parinfo(n) & ARRAY)
#define ALENGTH(n)	 (_parinfa(n, 0))

/* internal Clipper dbf header info */
#define DBF_DATE      (_dbf[0]->data1)         /* char pointer to header */
#define REC_SIZE      (_dbf[0]->data2[0])      /* long record size */
#define DATA_OFF      (_dbf[0]->data2[1])      /* long header size */
#define DBF_OPEN      (*_dbf)

/* parameter count/type */
extern int     _parinfo(int);
extern int     _parinfa(int, int);

/* parameter values */
extern char  *_parc(int, ...);
extern int    _parcsiz(int, ...);
extern int    _parclen(int, ...);
extern int    _parni(int, ...);
extern long   _parnl(int, ...);
extern double _parnd(int, ...);
extern int    _parl(int, ...);
extern char  *_pards(int, ...);
            
/* function return values */
/* one and only one of the _ret??() functions must be used */
extern void _retc(char *);
extern void _retclen(char *, int);
extern void _retni(int);
extern void _retnl(long);
extern void _retnd(double);
extern void _retl(int);
extern void _retds(char *);

/* procedure (DO) return */
extern void _ret(void);


/* misc. */
extern unsigned strlen(unsigned char *);

typedef unsigned char byte;
typedef unsigned int  quant;
typedef int           Boolean;

/* DBF */
extern struct
{
   char data1[32];
   long data2[2];
} *_dbf[];

/* Header structure */
typedef struct
{
	byte signature;   /* 03 = dbf, 83 dbf+dbt */
	byte ymd[3];      /* y+1900 m d */
	long last_rec;
	quant data_off;
	quant rec_size;
	byte pad[20];
} DBF_HEADER;

extern DBF_HEADER *_dbfhead();
extern int _dbfopen();

/***
*	extor.h
*
*	Clipper Summer87
*	Prototypes for "Extor system" definitions.
*
*	Copyright (c) 1988 Nantucket Corp.  All rights reserved.
*
*	CAUTION -- Version dependent information.
*/

extern int cdecl _stornd(double, int, ...);
extern int cdecl _storndec(double, int, int, ...);
extern int cdecl _stornl(long, int, ...);
extern int cdecl _storni(int, int, ...);
extern int cdecl _storl(int, int, ...);
extern int cdecl _storc(char *, int, ...);
extern int cdecl _storclen(char *, int, unsigned, ...);
extern int cdecl _stords(char *, int, ...);

/* allocate memory */
/* parameter:  requested size in bytes */
/* returns:  far pointer to memory or NULL */
extern unsigned char *_exmgrab(unsigned);

/* free allocated memory */
/* parameters:  pointer from _exmgrab(), same size passed to _exmgrab() */
extern void _exmback(unsigned char *, unsigned);



/* eof */

