/***
*   examplec.c
*
*   Example "C" functions using the CLIPPER Extend interface.
*   
*   The CLIPPER callable functions are.....
*
*       STUFF()          
*       DISKSPACE()
*
*    These 2 functions are copied, from the clipper disk to avoid
*    LINKER errors, when using JPM's SOUNDEX() function.
*    
**/
#include "jpm.h"

/***
*   STUFF()
*   kevin j. shepherd, NANTUCKET Corporation.
*   09/13/87
*
*   Replace LENGTH number of characters in SOURCE starting at START
*       with the entire MODIFIER string.
*
*   target = STUFF(source, start, length, modifier)
*
*       target      -   character string.       
*       source      -   character string.
*       start       -   numeric.
*       length      -   numeric.
*       modifier    -   character string.
*
**/

CLIPPER STUFF()
{
    quant i;
    quant j;
    quant s_max;
    quant m_max;
    quant buffer_size;

    quant start;
    quant length;

    byte  *source;
    byte  *modifier;
    byte  *buffer;

    /** parameter OK? **/
    if (PCOUNT == 4 && ISCHAR(1) && ISNUM(2) && ISNUM(3) && ISCHAR(4) &&
        _parclen(1) + _parclen(4) > 0)
    {
        /** local copies **/
        source   = _parc(1);
        modifier = _parc(4);
        start    = (quant)(_parnl(2) >= 0 ? _parnl(2) : 0);
        length   = (quant)(_parnl(3) >= 0 ? _parnl(3) : 0);

        /** string sizes **/
        s_max = (quant)_parclen(1);
        m_max = (quant)_parclen(4);

        /** allocate a work buffer. **/
        buffer_size = _parclen(1) + _parclen(4) + 1;
        buffer = _exmgrab(buffer_size);

        /** adjust dBASE string base values to 'C' base, off-by-one, yea! **/
        start = (start > 0 ? start - 1 : 0);

        /** get first part of source string. **/
        j = 0;
        while (j < start && j < s_max)
        {
            buffer[j] = source[j];
            j++;
        }
        
        /** insert **/
        i = 0;
        while (i < m_max)
        {
            buffer[j] = modifier[i];
            j++;
            i++;
        }

        /** copy the rest of the source string. **/
        i = start + length;
        while (i < s_max)
        {
            buffer[j] = source[i];
            j++;
            i++;
        }

        buffer[j] = NULLC;

        _retclen(buffer, j);

        _exmback(buffer, buffer_size);
    }
    else
    {
        _retc("");
    }
}


/***
*   DISKSPACE()
*   Tom Rettig, Brian Russell
*   11/01/85
*
*   Bytes of empty space on a disk drive.  The drive is specified by the 
*       drive_code parameter.  DRIVE_CODE is a numeric from 0 to n. 
*       0 is the default if code is omitted and indicates the 
*       currently selected drive.  1 to n reference drives A to x.
*
*   count = DISKSPACE([drive_code])
*
*       count       -   numeric.
*       drive_code  -   numeric.
*
*   Placed in the public domain by Tom Rettig Associates.
*   
**/

#define DEFAULT      0

CLIPPER DISKSPACE()
{
   struct                       /* structure to hold disk info */
   {
      unsigned no_clusts;       /* number of free clusters */
      unsigned secs_clusts;     /* sectors per cluster */
      unsigned clusts_drv;      /* total clusters per drive */
   } drv_info;

   /* if there is one parameter and it is numeric */
   if (PCOUNT == 1 && ISNUM(1))
   {
      _dspace(_parni(1), &drv_info);  /* specified drive */
   }
   else
      _dspace(DEFAULT, &drv_info);    /* default drive */

   /* bytes ::= number of clusters times sectors per cluster times 512 */

   _retnl(512L * (long)drv_info.secs_clusts * (long)drv_info.no_clusts);
}

