/*********
* Author   : Jean-Pierre van Melis, Helmond, The Netherlands
* Compiled : with Microsoft C 5.1    (cl /c /AL /Zl /Oailt /FPa /Gs blank.c)
* Object   : can only be used in conjunction with Clipper summer '87
* source   : is not tested with earlier versions of Clipper

             Jean-Pierre van Melis
             Bleriotstraat 2
             5703 HT  Helmond
             The Netherlands

(this UDF was inspired by Tom Rettig's UDF with the same name.
 but only it's function was copied, NOT the code.)

*
* BLANK.C
*
*  Syntax: BLANK( <exp> )
*  Return: Empty value of parameter passed:
*          TYPE   RETURN          NOTE
*          ----   --------------- ----------------------------------
*             L   .F.             logical type
*             N   0.00            numeric type
*             D   '  /  /  '      date type
*             C   "..."           len(<exp>) blank spaces
*
*********/

#include "jpm.h"

CLIPPER blank()
{

   byte  *ret;
   quant length, i;

   if ( PCOUNT == 1 )
   {
      switch ( _parinfo(1) )
      {
         case CHARACTER:

            /* character string without defined format */
            length = (quant) (_parclen(1));
            ret    = _exmgrab(length+1);

            if ( ret )     /* this branch must be last */
            {
               for ( i=0; i<length; i++ )
                  ret[i] = SPACEC;

               ret[i] = NULLC;
               _retclen( ret, length);
               _exmback( ret,(length+1));
             }

             else
               _ret();

             break;

         case LOGICAL  : _retl( FALSE ); break;
         case NUMERIC  : _retnd( 0.0 ); break;
         case DATE     : _retds( BLANKDS ); break;
         default       : _ret();
      }
   }
   else
      _ret();

   return;
}
/* eof */

