/* Author : Jean-Pierre van Melis, Helmond, The Netherlands
*/

#include "jpm.h"

/*********************************************************************
   Syntax : ATOT( <expA> [ , <expN>] )
   Return : Total of all (or <expN> first ) numerical elements of
            Array <expA>

*/

CLIPPER atot()
{
   if (ISARRAY(1))
   {
      quant i;
      quant alength;
      double answer = 0.00;

      if (ISNUM(2) && _parnd(2) > 0)
         alength = (quant) min(ALENGTH(1), _parnd(2));
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
            answer += _parnd(1, i);
      }
      _retnd(answer);
   }
   else
      _ret();

   return;
}

/**********************************************************************
Syntax : AAVG( <expA> [ , <expN>] )
   Return : Average of all (or <expN> first ) numerical elements of
            Array <expA>

***********************************************************************/
CLIPPER aavg()
{
   if (PCOUNT == 1 && ISARRAY(1))
   {
      quant alength;
      quant i;
      quant j = 0;
      double answer = 0.00;

      if (ISNUM(2) && _parnd(2) > 0)
         alength = (quant) min(ALENGTH(1), _parnd(2));
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
         {
            answer += _parnd(1, i);
            j++;
         }
      }
      if(j)
         _retnd(answer/j);
      else
         _retnd(0);

   }
   else
      _ret();

   return;
}

/**********************************************************************
   Syntax : AMAX( <expA> [ , <expN>] )
   Return : Maximum of all (or <expN> first ) numerical elements of
            Array <expA>

***********************************************************************/

CLIPPER amax()
{
   if (ISARRAY(1))
   {
      quant i;
      quant alength;
      double answer = 0.00;
      Boolean first = TRUE;

      if (ISNUM(2) && _parnd(2) > 0)
         alength = (quant) min(ALENGTH(1), _parnd(2));
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
            if (first)
            {
               answer = _parnd(1,i);
               first  = FALSE;
            }
            else
               answer = max(answer,_parnd(1, i));
      }
      _retnd(answer);
   }
   else
      _ret();

   return;
}

/**********************************************************************
   Syntax : AMIN( <expA> [ , <expN>] )
   Return : Minimum of all (or <expN> first ) numerical elements of
            Array <expA>

***********************************************************************/

CLIPPER amin()
{
   if (ISARRAY(1))
   {
      quant   i;
      quant   alength;
      double  answer = 0.00;
      Boolean first  = TRUE;

      if (ISNUM(2) && _parnd(2) > 0)
         alength = (quant) min(ALENGTH(1), _parnd(2));
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
            if (first)
            {
               answer = _parnd(1,i);
               first  = FALSE;
            }
            else
               answer = min(answer,_parnd(1, i));
      }
      _retnd(answer);
   }
   else
      _ret();

   return;
}



